/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.tables;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;

public class TSVFile
extends FileFilter {
    public boolean accept(File file) {
        return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".csv") || file.getAbsolutePath().toLowerCase().endsWith(".tab") || file.getAbsolutePath().toLowerCase().endsWith(".tsv");
    }

    public String getDescription() {
        return "TSV - Tab Separated Values file (*.csv,*.tab,*.tsv)";
    }

    public boolean isFormat(Reader test) {
        int check = 32;
        try {
            while (check != 10 && check != 13 && check != 9) {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        return check == 9;
    }

    public static void readFile(DefaultTableModel table, File currentFile) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(currentFile));
            while ((line = reader.readLine()) != null) {
                Object[] row = line.split("\t");
                while (table.getColumnCount() < row.length) {
                    table.addColumn("" + table.getColumnCount());
                }
                table.addRow(row);
            }
        }
        catch (IOException th) {
            th.printStackTrace(System.err);
        }
    }

    public static void writeFile(File currentFile, String[][] data) {
        try {
            FileWriter writer = new FileWriter(currentFile);
            for (int y = 0; y < data.length; ++y) {
                if (data[y].length > 0) {
                    writer.append('\"');
                    writer.append(data[y][0].replaceAll("\"", "\"\""));
                    writer.append('\"');
                }
                for (int x = 1; x < data[y].length; ++x) {
                    String cell = data[y][x];
                    writer.append('\t');
                    writer.append('\"');
                    if (cell != null) {
                        writer.append(data[y][x].replaceAll("\"", "\"\""));
                    }
                    writer.append('\"');
                }
                writer.append('\n');
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

