/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class RowFormatToken
extends Token
implements ResultSetMetaData {
    public static int IMAGE_COLUMN_DISPLAY_SIZE = 1;
    protected int _numColumns;
    private int _numUserColumns;
    private int[] _userColumnMap;
    private DataFormat[] _column;
    private TdsProtocolContext _tpc = null;

    public RowFormatToken() throws SQLException {
        this._numColumns = 0;
        this._column = new DataFormat[this._numColumns];
    }

    public RowFormatToken(int n) throws SQLException {
        this._numUserColumns = this._numColumns = n;
        this._column = new DataFormat[this._numColumns];
    }

    public RowFormatToken(TdsInputStream tdsInputStream) throws IOException {
        short s = tdsInputStream.readShort();
        this._numColumns = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numColumns);
    }

    public void addDataFormats(TdsInputStream tdsInputStream, int n) throws IOException {
        this._column = new DataFormat[n];
        this._numUserColumns = 0;
        this._userColumnMap = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this._column[n2] = new DataFormat(tdsInputStream);
            if ((this._column[n2]._status & 1) == 0) {
                this._userColumnMap[this._numUserColumns] = n2;
                ++this._numUserColumns;
            }
            ++n2;
        }
    }

    public String getCatalogName(int n) throws SQLException {
        Debug.notImplemented(this, "getCatalogName(int)");
        this.mapColumn(n);
        return "";
    }

    public String getColumnClassName(int n) throws SQLException {
        return this._column[this.mapColumn((int)n)]._className;
    }

    public int getColumnCount() throws SQLException {
        return this._numUserColumns;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        int n2 = this.mapColumn(n);
        switch (this._column[n2]._datatype) {
            case 48: {
                return 3;
            }
            case 52: {
                return 6;
            }
            case 56: {
                return 11;
            }
            case 38: {
                switch (this._column[n2]._length) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 6;
                    }
                    case 4: {
                        return 11;
                    }
                    case 8: {
                        return 20;
                    }
                }
                return 11;
            }
            case 59: {
                return 46;
            }
            case 62: {
                return 85;
            }
            case 109: {
                switch (this._column[n2]._length) {
                    case 4: {
                        return 46;
                    }
                    case 8: {
                        return 85;
                    }
                }
                return 46;
            }
            case 58: 
            case 61: 
            case 111: {
                return 25;
            }
            case 122: {
                return 12;
            }
            case 60: {
                return 21;
            }
            case 110: {
                switch (this._column[n2]._length) {
                    case 4: {
                        return 12;
                    }
                    case 8: {
                        return 21;
                    }
                }
                return 21;
            }
            case 106: 
            case 108: {
                return this._column[n2]._precision + 2;
            }
            case 37: 
            case 45: 
            case 225: {
                return this._column[n2]._length * 2;
            }
            case 34: {
                return IMAGE_COLUMN_DISPLAY_SIZE;
            }
            case 35: 
            case 39: 
            case 47: 
            case 50: 
            case 103: 
            case 104: 
            case 175: {
                return this._column[n2]._length;
            }
        }
        ErrorMessage.raiseError("JZ0P4");
        return -1;
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        return this.getName(this.mapColumn(n));
    }

    public int getColumnType(int n) throws SQLException {
        return RowFormatToken.sqlTypeToJdbcType(this._column[this.mapColumn(n)], false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnTypeName(int n) throws SQLException {
        String string;
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        block12: {
            String string2;
            block10: {
                block11: {
                    resultSet = null;
                    preparedStatement = null;
                    int n2 = this.mapColumn(n);
                    int n3 = this._column[n2]._datatype;
                    try {
                        try {
                            preparedStatement = this._tpc._conn.getMDA(null).getMetaDataAccessor("COLUMNTYPENAME", this._tpc);
                            switch (n3) {
                                case 37: 
                                case 38: 
                                case 39: 
                                case 109: 
                                case 110: 
                                case 111: {
                                    n3 = RowFormatToken.sqlTypeToJdbcType(this._column[n2], true);
                                    break;
                                }
                            }
                            preparedStatement.setInt(1, n3);
                            preparedStatement.setInt(2, this._column[n2]._usertype);
                            resultSet = preparedStatement.executeQuery();
                            if (resultSet.next()) {
                                string2 = resultSet.getString(1);
                                Object var8_8 = null;
                                if (resultSet == null) break block10;
                                break block11;
                            }
                            ErrorMessage.raiseError("JZ0P8");
                            string = "";
                            break block12;
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                            throw sQLException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement == null) throw throwable;
                        preparedStatement.close();
                        throw throwable;
                    }
                }
                resultSet.close();
            }
            if (preparedStatement == null) return string2;
            preparedStatement.close();
            return string2;
        }
        Object var8_9 = null;
        if (resultSet != null) {
            resultSet.close();
        }
        if (preparedStatement == null) return string;
        preparedStatement.close();
        return string;
    }

    protected DataFormat getDataFormat(int n) throws SQLException {
        return this._column[n];
    }

    protected int getDatatype(int n) throws SQLException {
        return this._column[n]._datatype;
    }

    protected int getLength(int n) throws SQLException {
        return this._column[n]._length;
    }

    protected String getName(int n) throws SQLException {
        return this._column[n]._name;
    }

    public int getPrecision(int n) throws SQLException {
        int n2 = this.mapColumn(n);
        return this._column[n2]._precision;
    }

    public int getScale(int n) throws SQLException {
        int n2 = this.mapColumn(n);
        return this._column[n2]._scale;
    }

    public String getSchemaName(int n) throws SQLException {
        Debug.notImplemented(this, "getSchemaName(int)");
        this.mapColumn(n);
        return "";
    }

    protected int getStatus(int n) throws SQLException {
        return this._column[n]._status;
    }

    public String getTableName(int n) throws SQLException {
        int n2 = this.mapColumn(n);
        switch (this._column[n2]._datatype) {
            case 34: 
            case 35: {
                return this._column[n2]._tableName;
            }
        }
        Debug.notImplemented(this, "getTableName(" + this._column[n2]._datatype + ")");
        return "";
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return (this._column[this.mapColumn((int)n)]._status & 0x40) != 0;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        try {
            return ((SybDatabaseMetaData)this._tpc._conn.getMetaData()).isCaseSensitive();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
    }

    public boolean isCurrency(int n) throws SQLException {
        int n2 = this.mapColumn(n);
        switch (this._column[n2]._datatype) {
            case 60: 
            case 110: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.mapColumn(n);
        return false;
    }

    public int isNullable(int n) throws SQLException {
        int n2 = this.mapColumn(n);
        return (this._column[n2]._status & 0x20) == 0 ? 0 : 1;
    }

    public boolean isReadOnly(int n) throws SQLException {
        return (this._column[this.mapColumn((int)n)]._status & 0x10) == 0;
    }

    public boolean isSearchable(int n) throws SQLException {
        Debug.println(this, "isSearchable, column: " + n);
        Object var2_2 = null;
        Object var3_3 = null;
        int n2 = RowFormatToken.sqlTypeToJdbcType(this._column[--n], false);
        return ((Tds)this._tpc._protocol).isTypeSearchable(n2);
    }

    public boolean isSigned(int n) throws SQLException {
        int n2 = this.mapColumn(n);
        switch (this._column[n2]._datatype) {
            case 38: 
            case 48: 
            case 52: 
            case 56: 
            case 59: 
            case 60: 
            case 62: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        return (this._column[this.mapColumn((int)n)]._status & 0x10) != 0;
    }

    protected int mapColumn(int n) throws SQLException {
        if (n > this._numUserColumns || n < 1) {
            ErrorMessage.raiseError("JZ008", String.valueOf(n));
        }
        return this._userColumnMap[--n];
    }

    protected void setPc(TdsProtocolContext tdsProtocolContext) {
        this._tpc = tdsProtocolContext;
    }

    protected static int sqlTypeToJdbcType(DataFormat dataFormat, boolean bl) {
        switch (dataFormat._datatype) {
            case 50: {
                return -7;
            }
            case 38: {
                switch (dataFormat._length) {
                    case 1: {
                        return bl ? 48 : -6;
                    }
                    case 2: {
                        return bl ? 52 : 5;
                    }
                    case 4: {
                        return bl ? 56 : 4;
                    }
                    case 8: {
                        return bl ? 38 : -5;
                    }
                }
                return 1111;
            }
            case 48: {
                return -6;
            }
            case 52: {
                return 5;
            }
            case 56: {
                return 4;
            }
            case 109: {
                switch (dataFormat._length) {
                    case 4: {
                        return bl ? 59 : 7;
                    }
                    case 8: {
                        return bl ? 62 : 8;
                    }
                }
                return 1111;
            }
            case 59: {
                return 7;
            }
            case 62: {
                return 8;
            }
            case 60: 
            case 110: 
            case 122: {
                if (bl) {
                    return dataFormat._length == 4 ? 122 : 60;
                }
                return 3;
            }
            case 106: 
            case 108: {
                if (dataFormat._usertype == 26) {
                    return 3;
                }
                return 2;
            }
            case 39: {
                if (dataFormat._usertype == 1) {
                    return bl ? 47 : 1;
                }
                return bl ? 39 : 12;
            }
            case 47: {
                return 1;
            }
            case 35: 
            case 175: {
                return -1;
            }
            case 111: {
                switch (dataFormat._length) {
                    case 4: {
                        return bl ? 58 : 93;
                    }
                    case 8: {
                        return bl ? 61 : 93;
                    }
                }
                return 1111;
            }
            case 58: 
            case 61: {
                return 93;
            }
            case 45: {
                return -2;
            }
            case 37: {
                if (dataFormat._usertype == 3) {
                    return bl ? 45 : -2;
                }
                return bl ? 37 : -3;
            }
            case 34: 
            case 225: {
                return -4;
            }
            case 31: 
            case 103: 
            case 104: {
                return 1111;
            }
            case 36: 
            case 255: {
                switch (dataFormat._blobType) {
                    case 1: 
                    case 2: {
                        return 2000;
                    }
                    case 3: {
                        return -1;
                    }
                    case 4: {
                        return -4;
                    }
                }
            }
        }
        return 1111;
    }
}

