/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class TdsNumeric {
    private static final int[] NUME_PREC_TO_LEN = new int[]{-1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9, 9, 9, 10, 10, 11, 11, 11, 12, 12, 13, 13, 14, 14, 14, 15, 15, 16, 16, 16, 17, 17, 18, 18, 19, 19, 19, 20, 20, 21, 21, 21, 22, 22, 23, 23, 24, 24, 24, 25, 25, 26, 26, 26, 27, 27, 28, 28, 28, 29, 29, 30, 30, 31, 31, 31, 32, 32, 33, 33, 33};
    private static final int NUME_MAXPREC = NUME_PREC_TO_LEN.length - 1;
    private static final int NUME_BASEBITS = 8;
    private static final int NUME_USERPREC = 38;
    private static final int NUME_MAXLEN = 33;
    private static final int NUME_NULLSCALE = 19;
    private static final BigDecimal D_ZERO = BigDecimal.valueOf(0L, 0);
    private static final BigDecimal NEGATIVE_ONE = BigDecimal.valueOf(-1L, 0);
    private static final BigDecimal MAX_NUMERIC = new BigDecimal("99999999999999999999999999999999999999");
    private static final BigDecimal MIN_NUMERIC = new BigDecimal("-99999999999999999999999999999999999999");

    private TdsNumeric() {
    }

    public static void checkRange(BigDecimal bigDecimal) throws SQLException {
        BigDecimal bigDecimal2 = bigDecimal.movePointRight(bigDecimal.scale());
        if (MAX_NUMERIC.compareTo(bigDecimal2) < 0 || MIN_NUMERIC.compareTo(bigDecimal2) > 0) {
            ErrorMessage.raiseError("JZ00B");
        }
    }

    protected static BigDecimal numericValue(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return null;
        }
        int n3 = byArray.length;
        int n4 = NUME_PREC_TO_LEN[n];
        int n5 = byArray[0] == 0 ? 1 : -1;
        byArray[0] = 0;
        byte[] byArray2 = byArray;
        if (n3 > n4) {
            if (n4 > (n3 + 1) / 2) {
                ErrorMessage.raiseIOException("JZ00B");
            }
            boolean bl = true;
            int n6 = n3 - 1;
            while (n6 >= n4) {
                if (byArray[n6] != 0) {
                    bl = false;
                    break;
                }
                --n6;
            }
            if (bl) {
                byArray2 = new byte[n4];
                System.arraycopy(byArray, 0, byArray2, 0, n4);
            }
        }
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(n5, byArray2), n2);
        byArray[0] = (byte)(n5 != 1 ? 1 : 0);
        return bigDecimal;
    }

    protected static byte[] tdsNumeric(BigDecimal bigDecimal, int[] nArray) throws IOException {
        if (bigDecimal == null) {
            nArray[1] = 33;
            nArray[2] = 38;
            nArray[3] = 19;
            return null;
        }
        if (MAX_NUMERIC.compareTo(bigDecimal) < 0 || MIN_NUMERIC.compareTo(bigDecimal) > 0) {
            ErrorMessage.raiseIOException("JZ00B");
        }
        boolean bl = false;
        if (bigDecimal.compareTo(D_ZERO) < 0) {
            bl = true;
            bigDecimal = bigDecimal.multiply(NEGATIVE_ONE);
        }
        nArray[3] = bigDecimal.scale();
        BigInteger bigInteger = bigDecimal.movePointRight(bigDecimal.scale()).toBigInteger();
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray.length + 1;
        if (n <= 2) {
            ++n;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        byArray2[0] = (byte)(bl ? 1 : 0);
        int n2 = bigInteger.toString().length();
        if (n2 < nArray[3]) {
            n2 = nArray[3];
        }
        nArray[2] = n2;
        nArray[1] = byArray2.length;
        return byArray2;
    }
}

