/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.biolegato.gdesupport.canvas.data.Cell;

public class ClipboardWrapper
implements Transferable {
    private Cell[] cellArray;
    public static final DataFlavor sequenceArrayFlavour = new DataFlavor(Cell[].class, "Raw BioLegato sequence");
    public static final DataFlavor[] dataflavoursArray = new DataFlavor[]{sequenceArrayFlavour, DataFlavor.stringFlavor};

    public ClipboardWrapper(Cell[] cellArray) {
        this.cellArray = cellArray;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return dataflavoursArray;
    }

    public boolean isDataFlavorSupported(DataFlavor flavour) {
        boolean result = false;
        for (int count = 0; count < dataflavoursArray.length && !result; ++count) {
            result = flavour.equals(dataflavoursArray[count]);
        }
        return result;
    }

    public Object getTransferData(DataFlavor flavour) throws UnsupportedFlavorException, IOException {
        Object result = this.cellArray;
        if (!this.isDataFlavorSupported(flavour)) {
            throw new UnsupportedFlavorException(flavour);
        }
        if (DataFlavor.stringFlavor.equals(flavour)) {
            result = this.toString();
        }
        return result;
    }

    public Cell[] toArray() {
        return this.cellArray;
    }
}

