/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas.colourmask;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import org.biolegato.core.main.BLMain;
import org.biolegato.gdesupport.canvas.colourmap.ColourMap;
import org.biolegato.gdesupport.canvas.colourmap.MonochromeColourMap;
import org.biolegato.gdesupport.canvas.colourmask.CharacterColourMaskReader;
import org.biolegato.gdesupport.canvas.colourmask.ColourMaskReader;
import org.biolegato.gdesupport.canvas.colourmask.GDEColourMaskFile;

public class ImportFileAction
extends Box
implements ActionListener {
    private JDialog window;
    private JComboBox combobox = new JComboBox<Object>(colourMasks.values().toArray());
    protected static Hashtable<String, ColourMap> colourMasks = new Hashtable();
    private static final long serialVersionUID = 7526472295622777037L;
    private static final CharacterColourMaskReader characterMaskFile = new CharacterColourMaskReader();
    private static final GDEColourMaskFile gdeMaskFile = new GDEColourMaskFile();
    private static ColourMap defaultMask = new MonochromeColourMap(Color.BLACK, Color.WHITE);

    public ImportFileAction(JDialog window, Object selectedMask) {
        super(2);
        this.window = window;
        if (!colourMasks.containsKey("default")) {
            this.combobox.insertItemAt(defaultMask, 0);
        }
        if (selectedMask == null || "".equals(selectedMask) || "<default>".equals(selectedMask)) {
            this.combobox.setSelectedItem(defaultMask);
        } else {
            if (!colourMasks.containsValue(selectedMask)) {
                this.combobox.insertItemAt(selectedMask, 0);
            }
            this.combobox.setSelectedItem(selectedMask);
        }
        this.add(this.combobox);
        JButton importButton = new JButton("Import file...");
        importButton.addActionListener(this);
        this.add(importButton);
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser openDialog = new JFileChooser();
        Object importMasks = null;
        openDialog.setCurrentDirectory(BLMain.getCurrentPWD());
        openDialog.setAcceptAllFileFilterUsed(false);
        openDialog.addChoosableFileFilter(characterMaskFile);
        openDialog.addChoosableFileFilter(gdeMaskFile);
        openDialog.setFileFilter(characterMaskFile);
        if (openDialog.showOpenDialog(this.window) == 0) {
            if (openDialog.getSelectedFile() != null && openDialog.getSelectedFile().exists() && openDialog.getSelectedFile().isFile() && openDialog.getFileFilter() != null && openDialog.getFileFilter() instanceof ColourMaskReader) {
                ImportFileAction.addMasks(((ColourMaskReader)openDialog.getFileFilter()).readColourMapFile(openDialog.getSelectedFile()), this.combobox);
            }
            if (openDialog.getCurrentDirectory() != null) {
                BLMain.setCurrentPWD((File)openDialog.getCurrentDirectory());
            }
        }
    }

    public static ColourMap getDefaultMap() {
        return defaultMask;
    }

    public static void addMasks(ColourMap[] importMasks, JComboBox addCombobox) {
        int number = 0;
        for (ColourMap mask : importMasks) {
            if (colourMasks.contains(mask.getName())) {
                while (colourMasks.contains(mask.getName() + " (" + number + ")")) {
                    ++number;
                }
                mask.setName(mask.getName() + " (" + number + ")");
            }
            if (addCombobox != null) {
                addCombobox.addItem(mask);
            }
            colourMasks.put(mask.getName(), mask);
        }
    }

    public Object getSelectedItem() {
        return this.combobox.getSelectedItem();
    }

    public static void load(File location) {
        if (location.exists() && location.canRead()) {
            if (location.isDirectory()) {
                for (File file : location.listFiles()) {
                    ImportFileAction.load(file);
                }
            } else if (location.isFile() && location.getAbsolutePath().toLowerCase().endsWith(".csv")) {
                ImportFileAction.addMasks(new CharacterColourMaskReader().readColourMapFile(location), null);
            }
        }
    }

    static {
        if (colourMasks.isEmpty()) {
            if (System.getenv("BL_MASKS") != null && !"".equals(System.getenv("BL_MASKS"))) {
                ImportFileAction.load(new File(BLMain.envreplace((String)System.getenv("BL_MASKS"))));
            } else if (BLMain.getProperty((String)"seqcolourdir") != null && !"".equals(BLMain.getProperty((String)"seqcolourdir"))) {
                ImportFileAction.load(new File(BLMain.envreplace((String)BLMain.getProperty((String)"seqcolourdir"))));
            }
            if (colourMasks.containsKey("default")) {
                defaultMask = colourMasks.get("default");
            }
        }
    }
}

