/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.formats;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.formats.DataFormat;

public class FastAFile
extends DataFormat {
    public String translateTo(Cell seq) {
        StringBuffer result = new StringBuffer();
        if (seq != null) {
            result.append(">").append(seq.get("name"));
            result.append("\n").append(seq.get("sequence")).append("\n");
        }
        return result.toString();
    }

    public Cell[] translateFrom(BufferedReader data) throws IOException {
        String name = "";
        String line = "";
        String description = "";
        String prefix = "";
        LinkedList<Cell> result = new LinkedList<Cell>();
        HashMap<String, Object> sequence = new HashMap<String, Object>();
        while ((line = data.readLine()) != null) {
            if ((line = line.trim()).startsWith(">")) {
                if (!sequence.isEmpty()) {
                    result.add(new Cell((Map<String, Object>)sequence));
                    sequence.clear();
                }
                name = line.substring(1);
                description = "";
                if (name.indexOf(32) > 0) {
                    description = name.substring(name.indexOf(32) + 1);
                    name = name.substring(0, name.indexOf(32));
                }
                if (name.indexOf(124) >= 0) {
                    prefix = name.substring(0, name.indexOf(124));
                    if ((name = name.substring(name.indexOf(124) + 1)).indexOf(124) >= 0) {
                        name = name.substring(0, name.indexOf(124));
                    }
                    name = prefix + "|" + name;
                }
                sequence.put("description", description);
                sequence.put("name", name);
                continue;
            }
            if (line.startsWith("#") || line.startsWith(";")) continue;
            sequence.put("sequence", (sequence.containsKey("sequence") ? sequence.get("sequence") : "") + line.replaceAll("[^A-Za-z\\*\\-]", ""));
        }
        if (!sequence.isEmpty()) {
            result.add(new Cell((Map<String, Object>)sequence));
        }
        return result.toArray(new Cell[0]);
    }

    public boolean accept(File file) {
        return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".wrp") || file.getAbsolutePath().toLowerCase().endsWith(".fasta") || file.getAbsolutePath().toLowerCase().endsWith(".fsa");
    }

    public String getName() {
        return "fasta";
    }

    public String getDescription() {
        return "FastA file (*.wrp,*.fasta,*.fsa)";
    }

    public boolean isFormat(Reader test) {
        int check = 32;
        try {
            while (check == 32 || check == 9 || check == 10 || check == 13) {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return check == 62;
    }
}

