/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.formats;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.biolegato.gdesupport.canvas.data.Cell;
import org.biolegato.gdesupport.formats.DataFormat;

public class GDEFlatfile
extends DataFormat {
    public String translateTo(Cell seq) {
        int type = 35;
        StringBuffer result = new StringBuffer();
        if (seq != null) {
            type = GDEFlatfile.typeToFlatFile((Cell.Type)((Object)seq.get("type")));
            if (type != 37 && type != 64 && type != 34) {
                type = 35;
            }
            result.append((char)type).append(seq.get("name")).append("\n").append(seq.get("sequence")).append("\n");
        }
        return result.toString();
    }

    public Cell[] translateFrom(BufferedReader data) throws IOException {
        String line = "";
        LinkedList<Cell> result = new LinkedList<Cell>();
        HashMap<String, Object> sequence = new HashMap<String, Object>();
        while ((line = data.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("%") || line.startsWith("@") || line.startsWith("\"")) {
                if (!sequence.isEmpty()) {
                    result.add(new Cell((Map<String, Object>)sequence));
                    sequence.clear();
                }
                if (line.indexOf(32) > 0) {
                    line = line.substring(0, line.indexOf(32));
                }
                if (line.indexOf(9) > 0) {
                    line = line.substring(0, line.indexOf(9));
                }
                if (line.indexOf(10) > 0) {
                    line = line.substring(0, line.indexOf(10));
                }
                if (line.indexOf(13) > 0) {
                    line = line.substring(0, line.indexOf(13));
                }
                sequence.put("type", (Object)GDEFlatfile.flatFileToType(line.trim().charAt(0)));
                sequence.put("name", line.trim().substring(1));
                continue;
            }
            sequence.put("sequence", (sequence.containsKey("sequence") ? sequence.get("sequence") : "") + line.trim());
        }
        if (!sequence.isEmpty()) {
            result.add(new Cell((Map<String, Object>)sequence));
        }
        return result.toArray(new Cell[0]);
    }

    public boolean accept(File file) {
        return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".flat");
    }

    public String getName() {
        return "flat";
    }

    public String getDescription() {
        return "GDE Flatfile (*.flat)";
    }

    private static Cell.Type flatFileToType(char test) {
        Cell.Type result = Cell.Type.DNA;
        switch (test) {
            case '%': {
                result = Cell.Type.PROTEIN;
                break;
            }
            case '@': {
                result = Cell.Type.MASK;
                break;
            }
            case '\"': {
                result = Cell.Type.TEXT;
            }
        }
        return result;
    }

    private static char typeToFlatFile(Cell.Type t) {
        char result = '#';
        switch (t) {
            case PROTEIN: {
                result = '%';
                break;
            }
            case MASK: {
                result = '@';
                break;
            }
            case TEXT: {
                result = '\"';
            }
        }
        return result;
    }

    public boolean isFormat(Reader test) {
        int check = 32;
        try {
            while (check == 32 || check == 9 || check == 10 || check == 13) {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return check == 35 || check == 37 || check == 64 || check == 34;
    }
}

