/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.canvas;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.biolegato.gdesupport.canvas.GDECanvas;

public class GDECanvasProperties
extends JDialog
implements ActionListener,
ChangeListener {
    GDECanvas canvas;
    final SpinnerNumberModel fontSizeSP = new SpinnerNumberModel(50, 6, 94, 1);
    final JCheckBox boldCB = new JCheckBox("Bold");
    final JButton closeB = new JButton("Close");
    private static final long serialVersionUID = 7526472295622777011L;

    public GDECanvasProperties(JFrame window, GDECanvas canvas) {
        super(window);
        this.canvas = canvas;
        Box outerPane = new Box(3);
        Box mainPane = new Box(3);
        outerPane.add(mainPane);
        outerPane.add(this.closeB);
        this.closeB.addActionListener(this);
        this.add(new JLabel("Font size"));
        JSpinner sizeSP = new JSpinner(this.fontSizeSP);
        sizeSP.setValue(canvas.currentFont.getSize());
        sizeSP.addChangeListener(this);
        mainPane.add(sizeSP);
        this.boldCB.setSelected(canvas.currentFont.isBold());
        this.boldCB.addActionListener(this);
        mainPane.add(this.boldCB);
        this.add(outerPane);
        this.setLocationRelativeTo(window);
        this.pack();
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.fontSizeSP) {
            this.canvas.updateFont(this.fontSizeSP.getNumber().intValue(), this.boldCB.isSelected());
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.canvas.updateFont(this.fontSizeSP.getNumber().intValue(), this.boldCB.isSelected());
        if (e.getSource() == this.closeB) {
            this.dispose();
        }
    }
}

