/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.data;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.biolegato.gdesupport.data.Seq;

public final class ClipboardWrapper
implements Transferable {
    private Seq[] cellArray;
    public static final DataFlavor sequenceArrayFlavour = new DataFlavor(Seq[].class, "Raw BioLegato sequence array");

    public ClipboardWrapper(Seq[] cellArray) {
        this.cellArray = cellArray;
    }

    public static Seq[] getClipboard() {
        Seq[] clipboard;
        block8: {
            clipboard = null;
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            try {
                if (t != null) {
                    System.out.println("T IS NOT NULL");
                    if (t.isDataFlavorSupported(sequenceArrayFlavour)) {
                        clipboard = (Seq[])t.getTransferData(sequenceArrayFlavour);
                        System.out.println("SEQ[]! " + clipboard);
                    } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String string = (String)t.getTransferData(DataFlavor.stringFlavor);
                        clipboard = new Seq[]{new Seq(Seq.Type.DNA, "", new StringBuffer(string))};
                        System.out.println("STRING! " + string);
                    } else {
                        System.out.println("UNSUPPORTED PASTE!!!!! " + t.getTransferDataFlavors());
                    }
                    break block8;
                }
                System.out.println("T IS NULL");
                throw new IOException();
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace(System.err);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        return clipboard;
    }

    public static void setClipboard(Seq[] copy) {
        Seq[] result = new Seq[copy.length];
        for (int count = 0; count < copy.length; ++count) {
            result[count] = new Seq(copy[count]);
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ClipboardWrapper(result), null);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{sequenceArrayFlavour, DataFlavor.stringFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor flavour) {
        boolean result = false;
        DataFlavor[] test = this.getTransferDataFlavors();
        for (int count = 0; count < test.length && !result; ++count) {
            result = flavour.equals(test[count]);
        }
        return result;
    }

    public Object getTransferData(DataFlavor flavour) throws UnsupportedFlavorException, IOException {
        Object result = this.cellArray;
        if (!this.isDataFlavorSupported(flavour)) {
            throw new UnsupportedFlavorException(flavour);
        }
        if (DataFlavor.stringFlavor.equals(flavour)) {
            result = this.toString();
        }
        return result;
    }

    public Seq[] toArray() {
        return this.cellArray;
    }
}

