/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.data;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.biolegato.gdesupport.data.ColourMask;
import org.biolegato.gdesupport.data.Dataset;
import org.biolegato.gdesupport.data.Seq;
import org.biolegato.gdesupport.files.CharacterColourMaskReader;
import org.biolegato.gdesupport.files.GDEColourMaskFile;
import org.biolegato.main.BLMain;

public class GDESequenceWindow
extends JDialog
implements ActionListener,
ItemListener {
    private int[] sequences;
    private JComboBox maskbox = new JComboBox<Object>(Seq.colourMasks.toArray());
    private JTextField namebox = new JTextField();
    private JCheckBox protectAlignmentCB = new JCheckBox("Alignment gaps");
    private JCheckBox protectAmbiguousCB = new JCheckBox("Ambiguous characters");
    private JCheckBox protectUnambiguousCB = new JCheckBox("Unambiguous characters");
    private JComboBox typebox = new JComboBox<Object>(new Object[]{Seq.Type.DNA, Seq.Type.RNA, Seq.Type.PROTEIN, Seq.Type.TEXT});
    private JComboBox directionbox = new JComboBox<Object>(new Object[]{Seq.Direction.FROM5TO3, Seq.Direction.FROM3TO5});
    private JComboBox topologybox = new JComboBox<Object>(new Object[]{Seq.Topology.LINEAR, Seq.Topology.CIRCULAR});
    private JComboBox strandednessbox = new JComboBox<Object>(new Object[]{Seq.Strandedness.SINGLE, Seq.Strandedness.MIXED, Seq.Strandedness.DOUBLE});
    private Dataset datamodel;
    private static final CharacterColourMaskReader CHAR_MASK_FILE = new CharacterColourMaskReader();
    private static final GDEColourMaskFile GDE_MASK_FILE = new GDEColourMaskFile();
    public static final String MULTIPLE_SELECTED = "<multiple selected...>";
    public static final long serialVersionUID = 7526472295622777013L;

    public GDESequenceWindow(Dataset datamodel, final JFrame window, int[] sequences) {
        super((Frame)window, "Sequence properties");
        Seq current = null;
        this.datamodel = datamodel;
        this.sequences = sequences;
        if (sequences.length >= 1) {
            current = datamodel.getLine(sequences[0]);
            if (sequences.length == 1) {
                this.namebox.setText(current.name);
            }
            this.typebox.setSelectedItem((Object)current.type);
            this.directionbox.setSelectedItem((Object)current.direction);
            this.topologybox.setSelectedItem((Object)current.topology);
            this.strandednessbox.setSelectedItem((Object)current.strandedness);
            this.protectAlignmentCB.setSelected(current.protect_align);
            this.protectAmbiguousCB.setSelected(current.protect_ambig);
            this.protectUnambiguousCB.setSelected(current.protect_unambig);
            if (current.mask != null) {
                this.maskbox.setSelectedItem(Seq.DEFAULT_MASK);
            } else {
                this.maskbox.setSelectedItem(current.mask);
            }
        }
        for (int count = 1; !(this.protectAlignmentCB.isSelected() && this.protectAmbiguousCB.isSelected() && this.protectUnambiguousCB.isSelected() && this.typebox.getSelectedItem() == MULTIPLE_SELECTED && this.directionbox.getSelectedItem() == MULTIPLE_SELECTED && this.topologybox.getSelectedItem() == MULTIPLE_SELECTED && this.strandednessbox.getSelectedItem() == MULTIPLE_SELECTED || count >= sequences.length); ++count) {
            current = datamodel.getLine(sequences[count]);
            if (current == null) continue;
            if (this.typebox.getSelectedItem() != MULTIPLE_SELECTED && this.typebox.getSelectedItem() != current.type) {
                this.typebox.insertItemAt(MULTIPLE_SELECTED, 0);
                this.typebox.setSelectedItem(MULTIPLE_SELECTED);
            }
            if (this.directionbox.getSelectedItem() != MULTIPLE_SELECTED && this.directionbox.getSelectedItem() != current.direction) {
                this.directionbox.insertItemAt(MULTIPLE_SELECTED, 0);
                this.directionbox.setSelectedItem(MULTIPLE_SELECTED);
            }
            if (this.topologybox.getSelectedItem() != MULTIPLE_SELECTED && this.topologybox.getSelectedItem() != current.topology) {
                this.topologybox.insertItemAt(MULTIPLE_SELECTED, 0);
                this.topologybox.setSelectedItem(MULTIPLE_SELECTED);
            }
            if (this.strandednessbox.getSelectedItem() != MULTIPLE_SELECTED && this.strandednessbox.getSelectedItem() != current.strandedness) {
                this.strandednessbox.insertItemAt(MULTIPLE_SELECTED, 0);
                this.strandednessbox.setSelectedItem(MULTIPLE_SELECTED);
            }
            if (!this.protectAlignmentCB.isSelected() && current.protect_align) {
                this.protectAlignmentCB.setSelected(true);
            }
            if (!this.protectAmbiguousCB.isSelected() && current.protect_ambig) {
                this.protectAmbiguousCB.setSelected(true);
            }
            if (!this.protectUnambiguousCB.isSelected() && current.protect_unambig) {
                this.protectUnambiguousCB.setSelected(true);
            }
            if ((MULTIPLE_SELECTED.equals(this.maskbox.getSelectedItem()) || this.maskbox.getSelectedItem() == current.mask) && (current.mask != null || this.maskbox.getSelectedItem() != Seq.DEFAULT_MASK)) continue;
            this.maskbox.insertItemAt(MULTIPLE_SELECTED, 0);
            this.maskbox.setSelectedItem(MULTIPLE_SELECTED);
        }
        Box mainBox = new Box(3);
        Box nameBox = new Box(2);
        nameBox.add(new JLabel("Name:"));
        nameBox.add(this.namebox);
        mainBox.add(nameBox);
        Box typeBox = new Box(2);
        typeBox.add(new JLabel("Type:"));
        typeBox.add(this.typebox);
        this.typebox.addItemListener(this);
        mainBox.add(typeBox);
        Box directionBox = new Box(2);
        directionBox.add(new JLabel("Direction:"));
        directionBox.add(this.directionbox);
        mainBox.add(directionBox);
        Box topologyBox = new Box(2);
        topologyBox.add(new JLabel("Topology:"));
        topologyBox.add(this.topologybox);
        mainBox.add(topologyBox);
        Box strandednessBox = new Box(2);
        strandednessBox.add(new JLabel("Strandedness:"));
        strandednessBox.add(this.strandednessbox);
        mainBox.add(strandednessBox);
        Box protectionBox = new Box(3);
        protectionBox.add(this.protectAlignmentCB);
        protectionBox.add(this.protectAmbiguousCB);
        protectionBox.add(this.protectUnambiguousCB);
        protectionBox.setBorder(BorderFactory.createTitledBorder("Set character protections"));
        mainBox.add(protectionBox);
        Box maskPane = new Box(2);
        maskPane.add(new JLabel("Colour mask:"));
        maskPane.add(this.maskbox);
        maskPane.add(new JButton(new AbstractAction("Import file..."){

            public void actionPerformed(ActionEvent e) {
                File file = null;
                ColourMask maskadd = null;
                JFileChooser openDialog = new JFileChooser();
                openDialog.setCurrentDirectory(BLMain.getCurrentPWD());
                openDialog.setAcceptAllFileFilterUsed(false);
                openDialog.addChoosableFileFilter(CHAR_MASK_FILE);
                openDialog.addChoosableFileFilter(GDE_MASK_FILE);
                openDialog.setFileFilter(CHAR_MASK_FILE);
                if (openDialog.showOpenDialog(window) == 0) {
                    file = openDialog.getSelectedFile();
                    if (file != null && file.exists() && file.isFile() && file.canRead()) {
                        try {
                            if (openDialog.getFileFilter() == CHAR_MASK_FILE) {
                                maskadd = CharacterColourMaskReader.readColourMaskFile(file);
                            } else if (openDialog.getFileFilter() == GDE_MASK_FILE) {
                                maskadd = GDEColourMaskFile.readColourMaskFile(file);
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace(System.err);
                        }
                        if (maskadd != null) {
                            GDESequenceWindow.this.maskbox.addItem(maskadd);
                            Seq.colourMasks.add(maskadd);
                        }
                    }
                    if (openDialog.getCurrentDirectory() != null) {
                        BLMain.setCurrentPWD((File)openDialog.getCurrentDirectory());
                    }
                }
            }
        }));
        mainBox.add(maskPane);
        JButton update = new JButton("Update");
        update.setActionCommand("update");
        update.addActionListener(this);
        mainBox.add(update);
        this.itemStateChanged(new ItemEvent(this.typebox, this.typebox.getSelectedIndex(), this.typebox.getSelectedItem(), 1));
        this.add(mainBox);
        this.pack();
        this.setLocationRelativeTo(window);
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    public void actionPerformed(ActionEvent e) {
        if ("update".equals(e.getActionCommand())) {
            boolean protect_align = this.protectAlignmentCB.isSelected();
            boolean protect_ambig = this.protectAmbiguousCB.isSelected();
            boolean protect_uambig = this.protectUnambiguousCB.isSelected();
            Seq.Type type = null;
            Seq.Direction direction = null;
            Seq.Topology topology = null;
            Seq.Strandedness strandedness = null;
            ColourMask mask = null;
            if (!MULTIPLE_SELECTED.equals(this.typebox.getSelectedItem())) {
                type = (Seq.Type)((Object)this.typebox.getSelectedItem());
            }
            if (!MULTIPLE_SELECTED.equals(this.directionbox.getSelectedItem())) {
                direction = (Seq.Direction)((Object)this.directionbox.getSelectedItem());
            }
            if (!MULTIPLE_SELECTED.equals(this.topologybox.getSelectedItem())) {
                topology = (Seq.Topology)((Object)this.topologybox.getSelectedItem());
            }
            if (!MULTIPLE_SELECTED.equals(this.strandednessbox.getSelectedItem())) {
                strandedness = (Seq.Strandedness)((Object)this.strandednessbox.getSelectedItem());
            }
            if (!MULTIPLE_SELECTED.equals(this.maskbox.getSelectedItem())) {
                mask = (ColourMask)this.maskbox.getSelectedItem();
            }
            for (int y : this.sequences) {
                int[] group;
                boolean modified = false;
                Seq seq = this.datamodel.getLine(y);
                if (!"".equals(this.namebox.getText()) && !seq.name.equals(this.namebox.getText())) {
                    seq.name = this.namebox.getText();
                    modified = true;
                }
                if (type != null && type != seq.type) {
                    seq.type = type;
                    modified = true;
                }
                if (direction != null && direction != seq.direction) {
                    seq.direction = direction;
                    modified = true;
                }
                if (topology != null && topology != seq.topology) {
                    seq.topology = topology;
                    modified = true;
                }
                if (strandedness != null && strandedness != seq.strandedness) {
                    seq.strandedness = strandedness;
                    modified = true;
                }
                if (mask != null) {
                    seq.mask = mask;
                }
                seq.protect_align = protect_align;
                seq.protect_ambig = protect_ambig;
                seq.protect_unambig = protect_uambig;
                if (seq.groupID > 0 && (group = this.datamodel.getgroup(seq.groupID)) != null) {
                    for (int gln : group) {
                        Seq groupseq = this.datamodel.getLine(gln);
                        groupseq.protect_align = protect_align;
                        groupseq.protect_ambig = protect_ambig;
                        groupseq.protect_unambig = protect_uambig;
                    }
                }
                this.dispose();
                if (!modified) continue;
                seq.original = null;
                this.datamodel.sequenceChanged(y);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (Seq.Type.DNA.equals(this.typebox.getSelectedItem()) || Seq.Type.RNA.equals(this.typebox.getSelectedItem())) {
            this.directionbox.setEnabled(true);
            this.topologybox.setEnabled(true);
            this.strandednessbox.setEnabled(true);
        } else if (Seq.Type.PROTEIN.equals(this.typebox.getSelectedItem())) {
            this.directionbox.setEnabled(false);
            this.topologybox.setEnabled(false);
            this.strandednessbox.setEnabled(false);
        } else if (Seq.Type.TEXT.equals(this.typebox.getSelectedItem())) {
            this.directionbox.setEnabled(false);
            this.topologybox.setEnabled(false);
            this.strandednessbox.setEnabled(false);
        }
    }
}

