/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.data;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.biolegato.gdesupport.data.ColourMask;
import org.biolegato.gdesupport.files.CharacterColourMaskReader;
import org.biolegato.main.BLMain;

public final class Seq
implements Cloneable,
Serializable {
    transient int groupID = 0;
    Type type = Type.DNA;
    String name;
    StringBuffer sequence;
    Direction direction = Direction.FROM5TO3;
    Strandedness strandedness = Strandedness.SINGLE;
    Topology topology = Topology.LINEAR;
    transient ColourMask mask = DEFAULT_MASK;
    transient boolean protect_align = false;
    transient boolean protect_ambig = true;
    transient boolean protect_unambig = true;
    transient String description = null;
    StringBuilder original = null;
    static final List<ColourMask> colourMasks = new ArrayList<ColourMask>(){
        {
            try {
                if (System.getenv("BL_MASKS") != null && !"".equals(System.getenv("BL_MASKS"))) {
                    this.loadMasks(new File(BLMain.envreplace((String)System.getenv("BL_MASKS"))));
                } else if (BLMain.getProperty((String)"seqcolourdir") != null && !"".equals(BLMain.getProperty((String)"seqcolourdir"))) {
                    this.loadMasks(new File(BLMain.envreplace((String)BLMain.getProperty((String)"seqcolourdir"))));
                }
            }
            catch (Exception th) {
                th.printStackTrace(System.err);
            }
        }

        private void loadMasks(File location) {
            block3: {
                block4: {
                    if (!location.exists() || !location.canRead()) break block3;
                    if (!location.isDirectory()) break block4;
                    for (File file : location.listFiles()) {
                        this.loadMasks(file);
                    }
                    break block3;
                }
                if (!location.isFile() || !location.getAbsolutePath().toLowerCase().endsWith(".csv") || !location.canRead() || !location.exists()) break block3;
                try {
                    this.add(CharacterColourMaskReader.readColourMaskFile(location));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.err);
                }
            }
        }
    };
    public static final ColourMask DEFAULT_MASK = Seq.getDefaultMask();
    private static final long serialVersionUID = 7526472295622777024L;

    public Seq() {
        this(Type.DNA, "", new StringBuffer());
    }

    public Seq(Type type, String name, StringBuffer sequence) {
        this.name = name;
        this.type = type;
        this.sequence = sequence;
        if (this.sequence != null && sequence.length() == 0) {
            this.protect_align = false;
            this.protect_ambig = false;
            this.protect_unambig = false;
        }
    }

    public Seq(Type type, String name, StringBuffer sequence, Direction direction, Topology topology, Strandedness strandedness) {
        this(type, name, sequence);
        this.topology = topology;
        this.direction = direction;
        this.strandedness = strandedness;
    }

    public Seq(Type type, String name, StringBuffer sequence, Direction direction, Topology topology, Strandedness strandedness, StringBuilder original) {
        this(type, name, sequence, direction, topology, strandedness);
        this.original = original;
    }

    public Seq(Type type, String name, StringBuffer sequence, Direction direction, Topology topology, Strandedness strandedness, int groupID, String description) {
        this(type, name, sequence, direction, topology, strandedness);
        this.groupID = groupID;
        this.description = description;
    }

    public Seq(Seq data) {
        this.name = data.name;
        this.type = data.type;
        this.topology = data.topology;
        this.direction = data.direction;
        this.strandedness = data.strandedness;
        this.protect_align = data.protect_align;
        this.protect_ambig = data.protect_ambig;
        this.protect_unambig = data.protect_unambig;
        this.sequence = data.sequence;
        this.original = data.original;
    }

    public final void modified() {
        this.original = null;
    }

    public final Type getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final StringBuffer getSequence() {
        return this.sequence;
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final Topology getTopology() {
        return this.topology;
    }

    public final Strandedness getStrandedness() {
        return this.strandedness;
    }

    public final boolean getProtectAlignment() {
        return this.protect_align;
    }

    public final boolean getProtectAmbiguous() {
        return this.protect_ambig;
    }

    public final boolean getProtectUnambiguous() {
        return this.protect_unambig;
    }

    public final ColourMask getMask() {
        return this.mask;
    }

    public final int getGroupID() {
        return this.groupID;
    }

    public final StringBuilder getOriginal() {
        return this.original;
    }

    public final String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("--- SEQUENCE DATA ---");
        result.append("    type = ").append((Object)this.type).append("\n    name = ").append(this.name).append("\n    group = ").append(this.groupID).append("\n").append("\n    topology = ").append((Object)this.topology).append("\n    direction = ").append((Object)this.direction).append("\n    strandedness = ").append((Object)this.strandedness).append("\n    protect_align = ").append(this.protect_align).append("\n    protect_ambig = ").append(this.protect_ambig).append("\n    protect_unambig = ").append(this.protect_unambig).append("\n    sequence = ").append(this.sequence).append("\n").append("\n    mask = ").append(this.mask).append("\n");
        return result.toString();
    }

    public Object clone() {
        return new Seq(this);
    }

    public static Type detectType(StringBuffer data) {
        Type result = Type.DNA;
        char[] array = new char[data.length()];
        data.getChars(0, data.length(), array, 0);
        for (int count = 0; count < array.length && result == Type.DNA; ++count) {
            char test = Character.toUpperCase(array[count]);
            if (test == 'U') {
                result = Type.RNA;
                continue;
            }
            if (test != 'F' && test != 'E' && test != 'J' && test != 'L' && test != 'O' && test != 'Q' && test != 'X' && test != 'Z') continue;
            result = Type.PROTEIN;
        }
        return result;
    }

    public static ColourMask getDefaultMask() {
        ColourMask result = null;
        if (colourMasks != null) {
            System.out.println("--- reading masks ---");
            for (ColourMask c : colourMasks) {
                if (!"default".equalsIgnoreCase(c.toString())) continue;
                result = c;
                break;
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharacterClass {
        ALIGNMENT,
        AMBIGUOUS,
        UNAMBIGUOUS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strandedness {
        SINGLE{

            public String toString() {
                return "Single stranded";
            }
        }
        ,
        DOUBLE{

            public String toString() {
                return "Double stranded";
            }
        }
        ,
        MIXED{

            public String toString() {
                return "Mixed strandedness";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Topology {
        LINEAR{

            public String toString() {
                return "Linear";
            }
        }
        ,
        CIRCULAR{

            public String toString() {
                return "Circular";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        FROM3TO5{

            public String toString() {
                return "From 3' to 5'";
            }
        }
        ,
        FROM5TO3{

            public String toString() {
                return "From 5' to 3'";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DNA{

            public String toString() {
                return "DNA";
            }
        }
        ,
        RNA{

            public String toString() {
                return "RNA";
            }
        }
        ,
        PROTEIN{

            public String toString() {
                return "Protein";
            }
        }
        ,
        MASK{

            public String toString() {
                return "Colour mask";
            }
        }
        ,
        TEXT{

            public String toString() {
                return "Text";
            }
        };

    }
}

