/*
 * Decompiled with CFR 0.152.
 */
package org.biolegato.gdesupport.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.biolegato.gdesupport.data.Dataset;
import org.biolegato.gdesupport.data.Seq;
import org.biolegato.gdesupport.files.DataFormat;

public class FastAFile
extends DataFormat {
    public void translateTo(Appendable result, Seq seq, int offset, int length) throws IOException {
        if (seq != null) {
            result.append(">").append(seq.getName());
            result.append("\n").append(seq.getSequence(), offset, length).append("\n");
        }
    }

    public void translateFrom(Dataset datamodel, BufferedReader data) throws IOException {
        int y = datamodel.getSize();
        String name = "";
        String line = "";
        String description = "";
        String prefix = "";
        Seq.Type type = null;
        StringBuffer sequencebuffer = null;
        while ((line = data.readLine()) != null) {
            if ((line = line.trim()).startsWith(">")) {
                if (sequencebuffer != null) {
                    type = Seq.detectType(sequencebuffer);
                    datamodel.addSequence(y, new Seq(type, name, sequencebuffer));
                    ++y;
                }
                name = line.substring(1);
                description = "";
                if (name.indexOf(32) > 0) {
                    description = name.substring(name.indexOf(32) + 1);
                    name = name.substring(0, name.indexOf(32));
                }
                if (name.indexOf(124) >= 0) {
                    prefix = name.substring(0, name.indexOf(124));
                    if ((name = name.substring(name.indexOf(124) + 1)).indexOf(124) >= 0) {
                        name = name.substring(0, name.indexOf(124));
                    }
                    name = prefix + "|" + name;
                }
                sequencebuffer = new StringBuffer();
                continue;
            }
            if (line.startsWith("#") || line.startsWith(";")) continue;
            sequencebuffer.append(line.replaceAll("[^A-Za-z\\*\\-]", ""));
        }
        if (sequencebuffer != null) {
            datamodel.addSequence(y, new Seq(Seq.detectType(sequencebuffer), name, sequencebuffer));
            ++y;
        }
    }

    public boolean accept(File file) {
        return file.isDirectory() || file.getAbsolutePath().toLowerCase().endsWith(".wrp") || file.getAbsolutePath().toLowerCase().endsWith(".fasta") || file.getAbsolutePath().toLowerCase().endsWith(".fsa");
    }

    public String getDescription() {
        return "FastA file (*.wrp,*.fasta,*.fsa)";
    }

    public boolean isFormat(Reader test) {
        int check = 32;
        try {
            while (check == 32 || check == 9 || check == 10 || check == 13) {
                test.mark(2);
                check = test.read();
            }
            test.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return check == 62;
    }
}

