/*
 * Decompiled with CFR 0.152.
 */
package org.forester.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;
import org.forester.ws.uniprot.UniProtTaxonomy;
import org.forester.ws.uniprot.UniProtWsTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AncestralTaxonomyInference {
    private static final int MAX_CACHE_SIZE = 100000;
    private static final int MAX_TAXONOMIES_TO_RETURN = 100;
    private static final HashMap<String, UniProtTaxonomy> _sn_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _code_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _cn_up_cache_map = new HashMap();
    private static final HashMap<String, UniProtTaxonomy> _id_up_cache_map = new HashMap();

    private static synchronized void clearCachesIfTooLarge() {
        if (AncestralTaxonomyInference.getSnTaxCacheMap().size() > 100000) {
            AncestralTaxonomyInference.getSnTaxCacheMap().clear();
        }
        if (AncestralTaxonomyInference.getCnTaxCacheMap().size() > 100000) {
            AncestralTaxonomyInference.getCnTaxCacheMap().clear();
        }
        if (AncestralTaxonomyInference.getCodeTaxCacheMap().size() > 100000) {
            AncestralTaxonomyInference.getCodeTaxCacheMap().clear();
        }
        if (AncestralTaxonomyInference.getIdTaxCacheMap().size() > 100000) {
            AncestralTaxonomyInference.getIdTaxCacheMap().clear();
        }
    }

    private static synchronized HashMap<String, UniProtTaxonomy> getCnTaxCacheMap() {
        return _cn_up_cache_map;
    }

    private static synchronized HashMap<String, UniProtTaxonomy> getCodeTaxCacheMap() {
        return _code_up_cache_map;
    }

    private static synchronized HashMap<String, UniProtTaxonomy> getIdTaxCacheMap() {
        return _id_up_cache_map;
    }

    private static synchronized HashMap<String, UniProtTaxonomy> getSnTaxCacheMap() {
        return _sn_up_cache_map;
    }

    private static synchronized UniProtTaxonomy getTaxonomies(HashMap<String, UniProtTaxonomy> hashMap, String string, QUERY_TYPE qUERY_TYPE) throws IOException {
        if (hashMap.containsKey(string)) {
            return hashMap.get(string).copy();
        }
        List<UniProtTaxonomy> list = null;
        switch (qUERY_TYPE) {
            case ID: {
                list = AncestralTaxonomyInference.getTaxonomiesFromId(string);
                break;
            }
            case CODE: {
                list = AncestralTaxonomyInference.getTaxonomiesFromTaxonomyCode(string);
                break;
            }
            case SN: {
                list = AncestralTaxonomyInference.getTaxonomiesFromScientificName(string);
                break;
            }
            case CN: {
                list = AncestralTaxonomyInference.getTaxonomiesFromCommonName(string);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (list != null && list.size() == 1) {
            UniProtTaxonomy uniProtTaxonomy = list.get(0);
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getScientificName())) {
                AncestralTaxonomyInference.getSnTaxCacheMap().put(uniProtTaxonomy.getScientificName(), uniProtTaxonomy);
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getCode())) {
                AncestralTaxonomyInference.getCodeTaxCacheMap().put(uniProtTaxonomy.getCode(), uniProtTaxonomy);
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getCommonName())) {
                AncestralTaxonomyInference.getCnTaxCacheMap().put(uniProtTaxonomy.getCommonName(), uniProtTaxonomy);
            }
            if (!ForesterUtil.isEmpty(uniProtTaxonomy.getId())) {
                AncestralTaxonomyInference.getIdTaxCacheMap().put(uniProtTaxonomy.getId(), uniProtTaxonomy);
            }
            return uniProtTaxonomy;
        }
        return null;
    }

    private static synchronized List<UniProtTaxonomy> getTaxonomiesFromCommonName(String string) throws IOException {
        return UniProtWsTools.getTaxonomiesFromCommonNameStrict(string, 100);
    }

    private static synchronized List<UniProtTaxonomy> getTaxonomiesFromId(String string) throws IOException {
        return UniProtWsTools.getTaxonomiesFromId(string, 100);
    }

    private static synchronized List<UniProtTaxonomy> getTaxonomiesFromScientificName(String string) throws IOException {
        return UniProtWsTools.getTaxonomiesFromScientificNameStrict(string, 100);
    }

    private static synchronized List<UniProtTaxonomy> getTaxonomiesFromTaxonomyCode(String string) throws IOException {
        return UniProtWsTools.getTaxonomiesFromTaxonomyCode(string, 100);
    }

    public static synchronized SortedSet<String> inferTaxonomyFromDescendents(Phylogeny phylogeny) throws IOException {
        AncestralTaxonomyInference.clearCachesIfTooLarge();
        TreeSet<String> treeSet = new TreeSet<String>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal()) continue;
            AncestralTaxonomyInference.inferTaxonomyFromDescendents(phylogenyNode, treeSet);
        }
        return treeSet;
    }

    private static synchronized void inferTaxonomyFromDescendents(PhylogenyNode phylogenyNode, SortedSet<String> sortedSet) throws IOException {
        Object object;
        if (phylogenyNode.isExternal()) {
            throw new IllegalArgumentException("attempt to infer taxonomy from descendants of external node");
        }
        phylogenyNode.getNodeData().setTaxonomy(null);
        List<PhylogenyNode> list = phylogenyNode.getDescendants();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n = Integer.MAX_VALUE;
        for (PhylogenyNode phylogenyNode2 : list) {
            if (!(!phylogenyNode2.getNodeData().isHasTaxonomy() || !AncestralTaxonomyInference.isHasAppropriateId(phylogenyNode2.getNodeData().getTaxonomy()) && ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getScientificName()) && ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode()) && ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getCommonName()))) {
                object = null;
                String string = null;
                UniProtTaxonomy object2 = AncestralTaxonomyInference.obtainUniProtTaxonomy(phylogenyNode2.getNodeData().getTaxonomy(), string, (QUERY_TYPE)((Object)object));
                String[] stringArray = null;
                if (object2 != null) {
                    stringArray = AncestralTaxonomyInference.obtainLineagePlusOwnScientificName(object2);
                }
                if (stringArray == null || stringArray.length < 1) {
                    sortedSet.add(phylogenyNode2.getNodeData().getTaxonomy().asText().toString());
                    return;
                }
                if (stringArray.length < n) {
                    n = stringArray.length;
                }
                arrayList.add(stringArray);
                continue;
            }
            return;
        }
        Object object3 = null;
        if (n > 0) {
            block3: for (int i = 0; i < n; ++i) {
                object = ((String[])arrayList.get(0))[i];
                for (int j = 1; j < arrayList.size(); ++j) {
                    if (!((String)object).equals(((String[])arrayList.get(j))[i])) break block3;
                }
                object3 = object;
            }
        }
        if (object3 == null) {
            return;
        }
        Taxonomy taxonomy = new Taxonomy();
        phylogenyNode.getNodeData().setTaxonomy(taxonomy);
        taxonomy.setScientificName((String)object3);
        object = AncestralTaxonomyInference.obtainUniProtTaxonomyFromSn(object3);
        if (object != null) {
            if (!ForesterUtil.isEmpty(((UniProtTaxonomy)object).getRank())) {
                try {
                    taxonomy.setRank(((UniProtTaxonomy)object).getRank().toLowerCase());
                }
                catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                    taxonomy.setRank("");
                }
            }
            if (!ForesterUtil.isEmpty(((UniProtTaxonomy)object).getId())) {
                taxonomy.setIdentifier(new Identifier(((UniProtTaxonomy)object).getId(), "uniprot"));
            }
            if (!ForesterUtil.isEmpty(((UniProtTaxonomy)object).getCommonName())) {
                taxonomy.setCommonName(((UniProtTaxonomy)object).getCommonName());
            }
            if (!ForesterUtil.isEmpty(((UniProtTaxonomy)object).getSynonym()) && !taxonomy.getSynonyms().contains(((UniProtTaxonomy)object).getSynonym())) {
                taxonomy.getSynonyms().add(((UniProtTaxonomy)object).getSynonym());
            }
        }
        for (PhylogenyNode phylogenyNode2 : list) {
            if (phylogenyNode2.isExternal() || !phylogenyNode2.getNodeData().isHasTaxonomy() || !phylogenyNode2.getNodeData().getTaxonomy().isEqual(taxonomy)) continue;
            phylogenyNode2.getNodeData().setTaxonomy(null);
        }
    }

    private static synchronized boolean isHasAppropriateId(Taxonomy taxonomy) {
        return taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue()) && (taxonomy.getIdentifier().getProvider().equalsIgnoreCase("ncbi") || taxonomy.getIdentifier().getProvider().equalsIgnoreCase("uniprot") || taxonomy.getIdentifier().getProvider().equalsIgnoreCase("uniprotkb"));
    }

    public static synchronized SortedSet<String> obtainDetailedTaxonomicInformation(Phylogeny phylogeny) throws IOException {
        AncestralTaxonomyInference.clearCachesIfTooLarge();
        TreeSet<String> treeSet = new TreeSet<String>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            QUERY_TYPE qUERY_TYPE = null;
            Taxonomy taxonomy = null;
            if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                taxonomy = phylogenyNode.getNodeData().getTaxonomy();
            }
            UniProtTaxonomy uniProtTaxonomy = null;
            if (taxonomy == null || !AncestralTaxonomyInference.isHasAppropriateId(taxonomy) && ForesterUtil.isEmpty(taxonomy.getScientificName()) && ForesterUtil.isEmpty(taxonomy.getTaxonomyCode()) && ForesterUtil.isEmpty(taxonomy.getCommonName())) continue;
            uniProtTaxonomy = AncestralTaxonomyInference.obtainUniProtTaxonomy(taxonomy, null, qUERY_TYPE);
            if (uniProtTaxonomy != null) {
                AncestralTaxonomyInference.updateTaxonomy(qUERY_TYPE, phylogenyNode, taxonomy, uniProtTaxonomy);
                continue;
            }
            treeSet.add(taxonomy.toString());
        }
        return treeSet;
    }

    private static synchronized String[] obtainLineagePlusOwnScientificName(UniProtTaxonomy uniProtTaxonomy) {
        String[] stringArray = uniProtTaxonomy.getLineage();
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = uniProtTaxonomy.getScientificName();
        return stringArray2;
    }

    private static synchronized UniProtTaxonomy obtainUniProtTaxonomy(Taxonomy taxonomy, String string, QUERY_TYPE qUERY_TYPE) throws IOException {
        if (AncestralTaxonomyInference.isHasAppropriateId(taxonomy)) {
            string = taxonomy.getIdentifier().getValue();
            qUERY_TYPE = QUERY_TYPE.ID;
            return AncestralTaxonomyInference.getTaxonomies(AncestralTaxonomyInference.getIdTaxCacheMap(), string, qUERY_TYPE);
        }
        if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            string = taxonomy.getScientificName();
            qUERY_TYPE = QUERY_TYPE.SN;
            return AncestralTaxonomyInference.getTaxonomies(AncestralTaxonomyInference.getSnTaxCacheMap(), string, qUERY_TYPE);
        }
        if (!ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            string = taxonomy.getTaxonomyCode();
            qUERY_TYPE = QUERY_TYPE.CODE;
            return AncestralTaxonomyInference.getTaxonomies(AncestralTaxonomyInference.getCodeTaxCacheMap(), string, qUERY_TYPE);
        }
        string = taxonomy.getCommonName();
        qUERY_TYPE = QUERY_TYPE.CN;
        return AncestralTaxonomyInference.getTaxonomies(AncestralTaxonomyInference.getCnTaxCacheMap(), string, qUERY_TYPE);
    }

    private static synchronized UniProtTaxonomy obtainUniProtTaxonomyFromSn(String string) throws IOException {
        UniProtTaxonomy uniProtTaxonomy = null;
        if (AncestralTaxonomyInference.getSnTaxCacheMap().containsKey(string)) {
            uniProtTaxonomy = AncestralTaxonomyInference.getSnTaxCacheMap().get(string).copy();
        } else {
            List<UniProtTaxonomy> list = AncestralTaxonomyInference.getTaxonomiesFromScientificName(string);
            if (list != null && list.size() == 1) {
                uniProtTaxonomy = list.get(0);
                AncestralTaxonomyInference.getSnTaxCacheMap().put(string, uniProtTaxonomy);
                if (!ForesterUtil.isEmpty(uniProtTaxonomy.getCode())) {
                    AncestralTaxonomyInference.getCodeTaxCacheMap().put(uniProtTaxonomy.getCode(), uniProtTaxonomy);
                }
                if (!ForesterUtil.isEmpty(uniProtTaxonomy.getCommonName())) {
                    AncestralTaxonomyInference.getCnTaxCacheMap().put(uniProtTaxonomy.getCommonName(), uniProtTaxonomy);
                }
                if (!ForesterUtil.isEmpty(uniProtTaxonomy.getId())) {
                    AncestralTaxonomyInference.getIdTaxCacheMap().put(uniProtTaxonomy.getId(), uniProtTaxonomy);
                }
            }
        }
        return uniProtTaxonomy;
    }

    private static synchronized void updateTaxonomy(QUERY_TYPE qUERY_TYPE, PhylogenyNode phylogenyNode, Taxonomy taxonomy, UniProtTaxonomy uniProtTaxonomy) {
        if (qUERY_TYPE != QUERY_TYPE.SN && !ForesterUtil.isEmpty(uniProtTaxonomy.getScientificName()) && ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            taxonomy.setScientificName(uniProtTaxonomy.getScientificName());
        }
        if (phylogenyNode.isExternal() && qUERY_TYPE != QUERY_TYPE.CODE && !ForesterUtil.isEmpty(uniProtTaxonomy.getCode()) && ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            taxonomy.setTaxonomyCode(uniProtTaxonomy.getCode());
        }
        if (qUERY_TYPE != QUERY_TYPE.CN && !ForesterUtil.isEmpty(uniProtTaxonomy.getCommonName()) && ForesterUtil.isEmpty(taxonomy.getCommonName())) {
            taxonomy.setCommonName(uniProtTaxonomy.getCommonName());
        }
        if (!ForesterUtil.isEmpty(uniProtTaxonomy.getSynonym()) && !taxonomy.getSynonyms().contains(uniProtTaxonomy.getSynonym())) {
            taxonomy.getSynonyms().add(uniProtTaxonomy.getSynonym());
        }
        if (!ForesterUtil.isEmpty(uniProtTaxonomy.getRank()) && ForesterUtil.isEmpty(taxonomy.getRank())) {
            try {
                taxonomy.setRank(uniProtTaxonomy.getRank().toLowerCase());
            }
            catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                taxonomy.setRank("");
            }
        }
        if (qUERY_TYPE != QUERY_TYPE.ID && !ForesterUtil.isEmpty(uniProtTaxonomy.getId()) && taxonomy.getIdentifier() == null) {
            taxonomy.setIdentifier(new Identifier(uniProtTaxonomy.getId(), "uniprot"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum QUERY_TYPE {
        CODE,
        SN,
        CN,
        ID;

    }
}

