/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.tools.ConfidenceAssessor;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class confadd {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String FIRST_OPTION = "f";
    private static final String LAST_OPTION = "l";
    private static final String STRICT_OPTION = "s";
    private static final String NORMALIZE_OPTION = "n";
    private static final String PRG_NAME = "confadd";
    private static final String PRG_VERSION = "1.00 beta 1";
    private static final String PRG_DATE = "2010.05.18";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/";

    public static void main(String[] stringArray) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2) || stringArray.length == 0) {
            confadd.printHelp();
            System.exit(0);
        }
        if (stringArray.length < 4) {
            System.out.println();
            System.out.println("[confadd] incorrect number of arguments");
            System.out.println();
            confadd.printHelp();
            System.exit(-1);
        }
        if (commandLineArguments.getNumberOfNames() != 4) {
            System.out.println();
            System.out.println("[confadd] incorrect number of arguments");
            System.out.println();
            confadd.printHelp();
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(FIRST_OPTION);
        arrayList.add(LAST_OPTION);
        arrayList.add(STRICT_OPTION);
        arrayList.add(NORMALIZE_OPTION);
        String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
        }
        String string2 = commandLineArguments.getName(0);
        File file = commandLineArguments.getFile(1);
        File file2 = commandLineArguments.getFile(2);
        File file3 = commandLineArguments.getFile(3);
        if (ForesterUtil.isEmpty(string2)) {
            ForesterUtil.fatalError(PRG_NAME, "attempt to use empty confidence type");
        }
        if (file3.exists()) {
            ForesterUtil.fatalError(PRG_NAME, "[" + file3 + "] already exists");
        }
        if (!file.exists()) {
            ForesterUtil.fatalError(PRG_NAME, "target [" + file + "] does not exist");
        }
        if (!file2.exists()) {
            ForesterUtil.fatalError(PRG_NAME, "evaluators [" + file2 + "] does not exist");
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        try {
            if (commandLineArguments.isOptionSet(STRICT_OPTION)) {
                if (commandLineArguments.isOptionHasAValue(STRICT_OPTION)) {
                    ForesterUtil.fatalError(PRG_NAME, "no value allowed for -s allowed");
                }
                bl = true;
            }
            if (commandLineArguments.isOptionSet(FIRST_OPTION)) {
                n = commandLineArguments.getOptionValueAsInt(FIRST_OPTION);
            }
            if (commandLineArguments.isOptionSet(LAST_OPTION)) {
                n2 = commandLineArguments.getOptionValueAsInt(LAST_OPTION);
            }
            if (commandLineArguments.isOptionSet(NORMALIZE_OPTION)) {
                d = commandLineArguments.getOptionValueAsDouble(NORMALIZE_OPTION);
            }
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, "error in command line: " + exception.getLocalizedMessage());
        }
        if (n < 0 || n2 < 0) {
            ForesterUtil.fatalError(PRG_NAME, "attempt to set first or last evaluator topology to use to a number less than zero");
        }
        if (d < 0.0) {
            ForesterUtil.fatalError(PRG_NAME, "illegal value for normalizer [" + d + "]");
        }
        Phylogeny[] phylogenyArray = null;
        Phylogeny[] phylogenyArray2 = null;
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        try {
            phylogenyArray = phylogenyFactory.create(file, ForesterUtil.createParserDependingOnFileType(file, true));
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read target phylogenies from [" + file + "]: " + iOException.getLocalizedMessage());
        }
        if (phylogenyArray.length == 1) {
            ForesterUtil.programMessage(PRG_NAME, "read in one target");
        } else {
            ForesterUtil.programMessage(PRG_NAME, "read in a total of " + phylogenyArray.length + " targets");
        }
        try {
            phylogenyArray2 = phylogenyFactory.create(file2, ForesterUtil.createParserDependingOnFileType(file2, true));
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read evaluator topologies from [" + file2 + "]: " + iOException.getLocalizedMessage());
        }
        ForesterUtil.programMessage(PRG_NAME, "read in a total of " + phylogenyArray2.length + " evaluator topologies");
        System.gc();
        if (n2 == 0) {
            n2 = phylogenyArray2.length - 1;
        }
        if (n2 >= phylogenyArray2.length || n2 <= n) {
            ForesterUtil.fatalError(PRG_NAME, "illegal value for first or last evaluator topology to use [" + n + ", " + n2 + "]");
        }
        double d2 = 1.0;
        if (d > 0.0) {
            d2 = d / (double)(1 + n2 - n);
        }
        ForesterUtil.programMessage(PRG_NAME, "first topology to use: " + n);
        String string3 = "";
        if (n2 == phylogenyArray2.length - 1) {
            string3 = " (corresponds to last topology in file)";
        }
        ForesterUtil.programMessage(PRG_NAME, "last topology to use : " + n2 + string3);
        ForesterUtil.programMessage(PRG_NAME, "sum of topologies used as evaluators: " + (n2 - n + 1));
        if (d > 0.0) {
            ForesterUtil.programMessage(PRG_NAME, "normalizer: " + d + " (" + ForesterUtil.round(d2, 6) + ")");
        } else {
            ForesterUtil.programMessage(PRG_NAME, "normalizer: n/a");
        }
        ForesterUtil.programMessage(PRG_NAME, "strict: " + bl);
        for (Phylogeny phylogeny : phylogenyArray) {
            try {
                ConfidenceAssessor.evaluate(string2, phylogenyArray2, phylogeny, bl, d2, n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ForesterUtil.fatalError(PRG_NAME, illegalArgumentException.getLocalizedMessage());
            }
        }
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(phylogenyArray, 0, file3, ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write to [" + file3 + "]: " + iOException.getLocalizedMessage());
        }
        ForesterUtil.programMessage(PRG_NAME, "wrote output to: [" + file3 + "]");
        ForesterUtil.programMessage(PRG_NAME, "OK");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("confadd [options] <confidence type> <target tree file> <evaluators tree file> <outfile>");
        System.out.println();
        System.out.println("options:");
        System.out.println();
        System.out.println(" -s    : strict [default: non-strict]: all nodes between 'target' and 'evaluators' must match");
        System.out.println(" -n=<d>: normalize to this value (e.g. 100 for most bootstrap analyses) [default: no normalization]");
        System.out.println(" -f=<i>: first evaluator topology to use (0-based) [default: 0]");
        System.out.println(" -l=<i>: last evaluator topology to use (0-based) [default: use all until final topology]");
        System.out.println();
    }
}

