/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.forester.development.SupportCount;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class count_support {
    private static final String PRG_NAME = "count_support";
    private static final String PRG_VERSION = "1.0";
    private static final String PRG_DATE = "2008.03.04";
    private static final boolean WRITE_EVALUATORS_AS_NHX = false;

    public static void main(String[] stringArray) {
        PhylogenyWriter phylogenyWriter;
        PhylogenyParser phylogenyParser;
        PhylogenyFactory phylogenyFactory;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        if (stringArray.length < 3 || stringArray.length > 7) {
            System.out.println();
            System.out.println("count_support: wrong number of arguments");
            System.out.println();
            System.out.println("Usage: \"count_support [options] <file containing phylogeny to be evaluated> <file with phylogenies to be used for evaluation> <outfile> [outfile for evaluator phylogenies, always unstripped if -t=<d> option is used, otherwise strippedness is dependent on -s option]\"\n");
            System.out.println(" Options: -s strip external nodes from evaluator phylogenies not found in phylogeny to be evaluated");
            System.out.println("        : -t=<d> threshold for similarity (0.0 to 1.0)");
            System.out.println("        : -n no branch lengths in outfile for evaluator phylogenies");
            System.out.println();
            System.exit(-1);
        }
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("s");
        arrayList.add("t");
        arrayList.add("n");
        String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "Unknown option(s): " + string);
        }
        File file = commandLineArguments.getFile(0);
        File file2 = commandLineArguments.getFile(1);
        File file3 = commandLineArguments.getFile(2);
        File file4 = null;
        boolean bl = true;
        if (commandLineArguments.isOptionSet("n")) {
            bl = false;
        }
        if (commandLineArguments.getNumberOfNames() == 4) {
            file4 = commandLineArguments.getFile(3);
        } else if (!bl) {
            ForesterUtil.fatalError(PRG_NAME, "Cannot use -n option if no outfile for evaluators specified");
        }
        Phylogeny phylogeny = null;
        Phylogeny[] phylogenyArray = null;
        try {
            phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            phylogenyParser = ForesterUtil.createParserDependingOnFileType(file, true);
            phylogeny = phylogenyFactory.create(file, phylogenyParser)[0];
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, "Could not read \"" + file + "\" [" + exception.getMessage() + "]");
        }
        try {
            phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            phylogenyParser = ForesterUtil.createParserDependingOnFileType(file2, true);
            phylogenyArray = phylogenyFactory.create(file2, phylogenyParser);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, "Could not read \"" + file2 + "\" [" + exception.getMessage() + "]");
        }
        boolean bl2 = false;
        if (commandLineArguments.isOptionSet("s")) {
            bl2 = true;
        }
        double d = -1.0;
        if (commandLineArguments.isOptionSet("t")) {
            try {
                d = commandLineArguments.getOptionValueAsDouble("t");
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "error in command line arguments: " + exception.getMessage());
            }
            if (d < 0.0 || d > 1.0) {
                ForesterUtil.fatalError(PRG_NAME, "support threshold has to be between 0.0 and 1.0 (inclusive)");
            }
        }
        List<Phylogeny> list = null;
        try {
            if (d >= 0.0) {
                list = SupportCount.count(phylogeny, phylogenyArray, bl2, d, true);
                if (list.size() < 1) {
                    ForesterUtil.fatalError(PRG_NAME, "appears like threshold for similarity is set too high");
                }
            } else {
                SupportCount.count(phylogeny, phylogenyArray, bl2, true);
            }
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, "Failure during support counting: " + exception.getMessage());
        }
        if (d >= 0.0) {
            count_support.normalizeSupport(phylogeny, 100.0, list.size());
            System.out.println(list.size() + " out of " + phylogenyArray.length + " evaluator phylogenies are above threshold of " + d);
        }
        try {
            phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(file3, phylogeny, 1);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failure to write output [" + iOException.getMessage() + "]");
        }
        System.out.println();
        System.out.println("Wrote phylogeny with support values to: " + file3);
        if (file4 != null) {
            try {
                phylogenyWriter = new PhylogenyWriter();
                if (list != null) {
                    System.out.println("Writing " + list.size() + " evaluator phylogenies above threshold of " + d + " to: " + file4);
                    phylogenyWriter.toNewHampshire(list, true, bl, file4, ";" + ForesterUtil.getLineSeparator());
                } else {
                    System.out.println("Writing " + phylogenyArray.length + " evaluator phylogenies to :" + file4);
                    phylogenyWriter.toNewHampshire(Arrays.asList(phylogenyArray), true, bl, file4, ";" + ForesterUtil.getLineSeparator());
                }
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "Failure to write output [" + iOException.getMessage() + "]");
            }
        }
        System.out.println();
        System.out.println("Done.");
        System.out.println();
    }

    private static void normalizeSupport(Phylogeny phylogeny, double d, int n) {
        double d2;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double d5 = 0.0;
        int n2 = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isRoot() || phylogenyNode.isExternal()) continue;
            d2 = PhylogenyMethods.getConfidenceValue(phylogenyNode);
            if (d2 > d4) {
                d4 = d2;
            }
            if (d2 >= 0.0 && d2 < d3) {
                d3 = d2;
            }
            d5 += d2;
            ++n2;
        }
        double d6 = d5 / (double)n2;
        System.out.println("Max support before normalization is    : " + d4);
        System.out.println("Min support before normalization is    : " + d3);
        System.out.println("Average support before normalization is: " + d6 + " (=" + d5 + "/" + n2 + ")");
        System.out.println("Normalizing so that theoretical maximum support value is: " + d);
        System.out.println("Number of phylogenies used in support analysis: " + n);
        d2 = d / (double)n;
        d3 = Double.MAX_VALUE;
        d4 = -1.7976931348623157E308;
        d5 = 0.0;
        n2 = 0;
        PhylogenyNodeIterator phylogenyNodeIterator2 = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator2.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator2.next();
            if (phylogenyNode.isRoot() || phylogenyNode.isExternal()) {
                PhylogenyMethods.setBootstrapConfidence(phylogenyNode, -9999.0);
                continue;
            }
            double d7 = PhylogenyMethods.getConfidenceValue(phylogenyNode);
            d7 = d2 * d7;
            PhylogenyMethods.setBootstrapConfidence(phylogenyNode, d7);
            if (d7 > d4) {
                d4 = d7;
            }
            if (d7 >= 0.0 && d7 < d3) {
                d3 = d7;
            }
            d5 += d7;
            ++n2;
        }
        d6 = d5 / (double)n2;
        System.out.println("Max support after normalization is    : " + d4);
        System.out.println("Min support after normalization is    : " + d3);
        System.out.println("Average support after normalization is: " + d6 + " (=" + d5 + "/" + n2 + ")");
    }
}

