/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.pccx.BasicExternalNodeBasedCoverageExtender;
import org.forester.pccx.Coverage;
import org.forester.pccx.CoverageCalculationOptions;
import org.forester.pccx.CoverageCalculator;
import org.forester.pccx.ExternalNodeBasedCoverageMethod;
import org.forester.pccx.ExternalNodeBasedCoverageMethodOptions;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class pccx {
    private static final int EXTEND_BY_DEFAULT = -100;
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String USE_REAL_BL_OPTION = "d";
    private static final String USE_LOG_REAL_BL_OPTION = "ld";
    private static final String EXTEND_BY_OPTION = "x";
    private static final String OUTPUT_OPTION = "o";
    private static final String INPUT_OPTION = "i";
    private static final String OUTPUT_ANNOTATED_PHYLOGENIES_OPTION = "p";
    private static final String PRG_NAME = "pccx";
    private static final String PRG_VERSION = "1.0.0";
    private static final String BRANCH_LENGTH_BASED_SCORING = "org.forester.tools.modeling.BranchLengthBasedScoringMethod";
    private static final String BRANCH_COUNTING_BASED_SCORING = "org.forester.tools.modeling.BranchCountingBasedScoringMethod";
    private static final String LOG_BRANCH_LENGTH_BASED_SCORING = "org.forester.tools.modeling.LogBranchLengthBasedScoringMethod";
    private static final String PRG_DATE = "2008.03.04";
    private static final String WWW = "www.phylosoft.org/forester/applications/pccx";
    private static final String E_MAIL = "czmasek@burnham.org";

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
            System.out.println();
            pccx.printHelp();
            System.exit(0);
        }
        if (stringArray.length < 2) {
            System.out.println();
            System.out.println("Incorrect number of arguments.");
            System.out.println();
            pccx.printHelp();
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        int n = -100;
        arrayList.add(USE_REAL_BL_OPTION);
        arrayList.add(USE_LOG_REAL_BL_OPTION);
        arrayList.add(EXTEND_BY_OPTION);
        arrayList.add(INPUT_OPTION);
        arrayList.add(OUTPUT_OPTION);
        arrayList.add(OUTPUT_ANNOTATED_PHYLOGENIES_OPTION);
        String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
        }
        if (commandLineArguments.getNumberOfNames() < 1) {
            System.out.println();
            System.out.println("No phylogenies infile indicated.");
            System.out.println();
            pccx.printHelp();
            System.exit(-1);
        }
        File file = commandLineArguments.getFile(0);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (commandLineArguments.getNumberOfNames() > 1) {
            for (int i = 1; i < commandLineArguments.getNumberOfNames(); ++i) {
                arrayList2.add(commandLineArguments.getName(i));
            }
        }
        if (commandLineArguments.isOptionSet(USE_REAL_BL_OPTION)) {
            bl = true;
        }
        if (commandLineArguments.isOptionSet(USE_LOG_REAL_BL_OPTION)) {
            bl2 = true;
        }
        if (bl && bl2) {
            System.out.println();
            pccx.printHelp();
            System.exit(-1);
        }
        if (commandLineArguments.isOptionSet(EXTEND_BY_OPTION)) {
            n = 0;
            try {
                n = commandLineArguments.getOptionValueAsInt(EXTEND_BY_OPTION);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
            }
        }
        Phylogeny[] phylogenyArray = null;
        try {
            object4 = ParserBasedPhylogenyFactory.getInstance();
            object3 = ForesterUtil.createParserDependingOnFileType(file, true);
            phylogenyArray = object4.create(file, object3);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "could not read \"" + file + "\": " + iOException.getMessage());
        }
        object4 = Arrays.asList(phylogenyArray);
        object3 = null;
        PrintStream printStream = System.out;
        if (commandLineArguments.isOptionSet(OUTPUT_OPTION)) {
            try {
                object3 = new File(commandLineArguments.getOptionValue(OUTPUT_OPTION));
                object2 = ForesterUtil.isWritableFile((File)object3);
                if (!ForesterUtil.isEmpty((String)object2)) {
                    ForesterUtil.fatalError(PRG_NAME, (String)object2);
                }
                printStream = new PrintStream((File)object3);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
            }
        }
        object2 = null;
        BasicTable<String> basicTable = null;
        if (commandLineArguments.isOptionSet(INPUT_OPTION)) {
            try {
                object2 = new File(commandLineArguments.getOptionValue(INPUT_OPTION));
                String string2 = ForesterUtil.isReadableFile((File)object2);
                if (!ForesterUtil.isEmpty(string2)) {
                    ForesterUtil.fatalError(PRG_NAME, string2);
                }
                basicTable = BasicTableParser.parse(object2, " ", false);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read \"" + object2 + "\" [" + iOException.getMessage() + "]");
            }
            try {
                for (int i = 0; i < basicTable.getNumberOfRows(); ++i) {
                    System.out.println("Adding external node: " + basicTable.getValueAsString(0, i));
                    arrayList2.add(basicTable.getValueAsString(0, i));
                }
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
            }
        }
        File file2 = null;
        boolean bl3 = false;
        if (commandLineArguments.isOptionSet(OUTPUT_ANNOTATED_PHYLOGENIES_OPTION)) {
            bl3 = true;
            file2 = new File(commandLineArguments.getOptionValue(OUTPUT_ANNOTATED_PHYLOGENIES_OPTION));
            object = ForesterUtil.isWritableFile(file2);
            if (!ForesterUtil.isEmpty((String)object)) {
                ForesterUtil.fatalError(PRG_NAME, (String)object);
            }
        }
        try {
            Object object5;
            object = bl2 ? new ExternalNodeBasedCoverageMethodOptions(LOG_BRANCH_LENGTH_BASED_SCORING) : (bl ? new ExternalNodeBasedCoverageMethodOptions(BRANCH_LENGTH_BASED_SCORING) : new ExternalNodeBasedCoverageMethodOptions(BRANCH_COUNTING_BASED_SCORING));
            int n2 = ((Phylogeny)object4.get(0)).getNumberOfExternalNodes() - arrayList2.size();
            if (n > n2) {
                n = n2;
            }
            System.out.println();
            System.out.println("Options: " + object.asString());
            System.out.println();
            if (n != -100) {
                if (n > 0) {
                    System.out.println("Printing " + n + " names to extend coverage in an optimal manner:");
                } else {
                    System.out.println("Printing names to completely extend coverage in an optimal manner:");
                }
                System.out.println();
                object5 = CoverageCalculator.getInstance(new ExternalNodeBasedCoverageMethod(), (CoverageCalculationOptions)object);
                BasicExternalNodeBasedCoverageExtender basicExternalNodeBasedCoverageExtender = new BasicExternalNodeBasedCoverageExtender();
                Coverage coverage = ((CoverageCalculator)object5).calculateCoverage((List<Phylogeny>)object4, arrayList2, false);
                System.out.println(" before:");
                System.out.println(coverage.asString());
                System.out.println();
                List<String> list = basicExternalNodeBasedCoverageExtender.find((List<Phylogeny>)object4, arrayList2, n, (CoverageCalculationOptions)object, printStream);
                ArrayList<String> arrayList3 = new ArrayList<String>(arrayList2);
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3;
                    String string4 = string3 = iterator.next();
                    arrayList3.add(string4);
                }
                coverage = ((CoverageCalculator)object5).calculateCoverage((List<Phylogeny>)object4, arrayList3, bl3);
                System.out.println();
                System.out.println(" after:");
                System.out.println(coverage.asString());
            } else {
                object5 = CoverageCalculator.getInstance(new ExternalNodeBasedCoverageMethod(), (CoverageCalculationOptions)object);
                Coverage coverage = ((CoverageCalculator)object5).calculateCoverage((List<Phylogeny>)object4, arrayList2, bl3);
                System.out.println(coverage.asString());
            }
            System.out.println();
            if (bl3) {
                try {
                    object5 = new PhylogenyWriter();
                    ((PhylogenyWriter)object5).toPhyloXML(file2, (Phylogeny)object4.get(0), 1);
                    System.out.println("Wrote annotated phylogeny to \"" + file2 + "\"");
                    System.out.println();
                }
                catch (IOException iOException) {
                    ForesterUtil.fatalError(PRG_NAME, "Failed to write to \"" + file2 + "\" [" + iOException.getMessage() + "]");
                }
            }
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.toString());
        }
        System.out.println();
        System.out.println("pccx: successfully completed");
        System.out.println("If this application is useful to you, please cite:");
        System.out.println(WWW);
        System.out.println();
        printStream.flush();
        printStream.close();
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("pccx  [options] <phylogen(y|ies) infile> [external node name 1] [name 2] ... [name n]");
        System.out.println();
        System.out.println(" Options: ");
        System.out.println();
        System.out.println(" -d        : 1/distance based scoring method (instead of branch counting based)");
        System.out.println(" -ld       : -ln(distance) based scoring method (instead of branch counting based)");
        System.out.println(" -x[=<n>]  : optimally extend coverage by <n> external nodes. Use none, 0,");
        System.out.println("             or negative value for complete coverage extension.");
        System.out.println(" -o=<file> : write output to <file>");
        System.out.println(" -i=<file> : read (new-line separated) external node names from <file>");
        System.out.println(" -p=<file> : write output as annotated phylogeny to <file> (only first");
        System.out.println("             phylogeny in phylogenies infile is used)");
        System.out.println();
    }
}

