/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.CommandLineArguments;

public class perfume {
    private static final String BASE = "b_";

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.exit(-1);
        }
        try {
            Object object;
            CommandLineArguments commandLineArguments = null;
            commandLineArguments = new CommandLineArguments(stringArray);
            File file = commandLineArguments.getFile(0);
            File file2 = commandLineArguments.getFile(1);
            if (file2.exists()) {
                System.out.println(file2 + " already exists");
                System.exit(-1);
            }
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            PhyloXmlParser phyloXmlParser = new PhyloXmlParser();
            Phylogeny[] phylogenyArray = phylogenyFactory.create(file, phyloXmlParser);
            Phylogeny phylogeny = phylogenyArray[0];
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
            int n = 0;
            while (phylogenyNodeIterator.hasNext()) {
                object = phylogenyNodeIterator.next();
                perfume.processNode((PhylogenyNode)object, n);
                ++n;
            }
            object = new PhylogenyWriter();
            ((PhylogenyWriter)object).toPhyloXML(file2, phylogeny, 0);
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private static void processNode(PhylogenyNode phylogenyNode, int n) {
        phylogenyNode.setDistanceToParent(-1024.0);
        if (!phylogenyNode.isExternal() && (phylogenyNode.getNodeName() == null || phylogenyNode.getNodeName().isEmpty())) {
            phylogenyNode.setName(BASE + n);
        }
    }
}

