/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.sdi.DistanceCalculator;
import org.forester.sdi.RIO;
import org.forester.sdi.SDIR;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class rio {
    private static final String PRG_NAME = "RIO";
    private static final String PRG_VERSION = "2.03 ALPHA";
    private static final String PRG_DATE = "2010.01.15";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/";
    private static final boolean TIME = true;
    private static final boolean VERBOSE = true;
    private static final boolean MINIMIZE_COST = false;
    private static final boolean MINIMIZE_DUPS = true;
    private static final boolean MINIMIZE_HEIGHT = true;
    private static final int WARN_NO_ORTHOS_DEFAULT = 2;
    private static final int WARN_MORE_THAN_ONE_ORTHO_DEFAULT = 2;
    private static final double THRESHOLD_ULTRA_PARALOGS_DEFAULT = 50.0;
    private static final double WARN_ONE_ORTHO_DEFAULT = 2.0;

    private static double[] calculateMeanBoostrapValue(Phylogeny phylogeny) {
        double d = 0.0;
        int n = 0;
        long l = 0L;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[2];
        Vector<Double> vector = new Vector<Double>();
        PhylogenyNode phylogenyNode = null;
        PreorderTreeIterator preorderTreeIterator = null;
        preorderTreeIterator = new PreorderTreeIterator(phylogeny);
        while (preorderTreeIterator.hasNext()) {
            phylogenyNode = preorderTreeIterator.next();
            if (phylogenyNode.getParent() != null && phylogenyNode.getParent().isRoot() && PhylogenyMethods.getConfidenceValue(phylogenyNode.getParent().getChildNode1()) > 0.0 && PhylogenyMethods.getConfidenceValue(phylogenyNode.getParent().getChildNode2()) > 0.0 && phylogenyNode.getParent().getChildNode2() == phylogenyNode || !((d = PhylogenyMethods.getConfidenceValue(phylogenyNode)) > 0.0)) continue;
            l = (long)((double)l + d);
            vector.addElement(new Double(d));
            ++n;
        }
        if (n < 2) {
            return null;
        }
        d3 = (double)l / (double)n;
        l = 0L;
        for (int i = 0; i < n; ++i) {
            d = ((Double)vector.elementAt(i)).intValue();
            d2 = d - d3;
            l = (long)((double)l + d2 * d2);
        }
        dArray[0] = d3;
        dArray[1] = Math.sqrt((double)l / ((double)n - 1.0));
        return dArray;
    }

    private static final void errorInCommandLine() {
        System.out.println("\nrio: Error in command line.\n");
        rio.printHelp();
        System.exit(-1);
    }

    private static final StringBuffer getDistances(File file, File file2, Phylogeny phylogeny, String string, ArrayList<String> arrayList, HashMap<String, Integer> hashMap, HashMap<String, Integer> hashMap2, int n, int n2, double d, int n3, double d2) throws IOException {
        Phylogeny phylogeny2 = null;
        Phylogeny phylogeny3 = null;
        SDIR sDIR = new SDIR();
        ArrayList<PhylogenyNode> arrayList2 = new ArrayList<PhylogenyNode>();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = 0;
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        phylogeny2 = phylogenyFactory.create(file, new PhyloXmlParser())[0];
        PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(phylogeny, phylogeny2);
        phylogeny3 = sDIR.infer(phylogeny2, phylogeny, false, true, true, true, 1)[0];
        DistanceCalculator distanceCalculator = new DistanceCalculator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Given the threshold for distance calculations (" + ForesterUtil.roundToInt(d2) + "): ");
        if (arrayList.size() == 0) {
            distanceCalculator.setTree(phylogeny3);
            d3 = distanceCalculator.getMean();
            d4 = distanceCalculator.getStandardDeviation();
            d5 = distanceCalculator.getDistanceToRoot(string);
            n4 = distanceCalculator.getN();
            stringBuffer.append("No sequence is considered orthologous to query.\ndistance of query to root                     = " + ForesterUtil.FORMATTER_06.format(d5) + "\nmean of distances (for all sequences) to root = " + ForesterUtil.FORMATTER_06.format(d3) + "\nsd of distances (for all sequences) to root   = " + ForesterUtil.FORMATTER_06.format(d4) + "\nn (sum of sequences in alignment plus query)  = " + n4);
            if (!(d3 - (double)n2 * d4 < d5) || !(d3 + (double)n2 * d4 > d5)) {
                stringBuffer.append("\nWARNING: distance of query to root is outside of mean+/-" + n2 + "*sd!");
            }
        } else if (arrayList.size() == 1) {
            String string2 = arrayList.get(0);
            arrayList2.add(phylogeny3.getNode(string2));
            arrayList2.add(phylogeny3.getNode(string));
            distanceCalculator.setTreeAndExtNodes(phylogeny3, arrayList2);
            d5 = distanceCalculator.getDistanceToLCA(string);
            double d6 = distanceCalculator.getDistanceToLCA(string2);
            stringBuffer.append("One sequence is considered orthologous to query.\nLCA is LCA of query and its ortholog.\ndistance of query to LCA    = " + ForesterUtil.FORMATTER_06.format(d5) + "\ndistance of ortholog to LCA = " + ForesterUtil.FORMATTER_06.format(d6));
            if (d6 > 0.0 && d5 > 0.0 && (d6 >= d5 && d6 / d5 > d || d6 < d5 && d5 / d6 > d)) {
                stringBuffer.append("\nWARNING: Ratio of distances to LCA is greater than " + d + "!");
            } else if (!(d6 != 0.0 && d5 != 0.0 || d6 == 0.0 && d5 == 0.0)) {
                stringBuffer.append("\nWARNING: Ratio could not be calculated,  one distance is 0.0!");
            }
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(phylogeny3.getNodeViaSequenceName(arrayList.get(i)));
            }
            arrayList2.add(phylogeny3.getNodesViaSequenceName(string).get(0));
            distanceCalculator.setTreeAndExtNodes(phylogeny3, arrayList2);
            d3 = distanceCalculator.getMean();
            d4 = distanceCalculator.getStandardDeviation();
            d5 = distanceCalculator.getDistanceToLCA(string);
            n4 = distanceCalculator.getN();
            stringBuffer.append("More than one sequence is considered orthologous to query.\nLCA is LCA of query and its orthologs.\ndistance of query to LCA                               = " + ForesterUtil.FORMATTER_06.format(d5) + "\nmean of distances (for query and its orthologs) to LCA = " + ForesterUtil.FORMATTER_06.format(d3) + "\nsd of distances (for query and its orthologs) to LCA   = " + ForesterUtil.FORMATTER_06.format(d4) + "\nn (sum of orthologs plus query)                        = " + n4);
            if (!(d3 - (double)n * d4 < d5) || !(d3 + (double)n * d4 > d5)) {
                stringBuffer.append("\n!WARNING: distance of query to LCA is outside of mean+/-" + n + "*sd!");
            }
        }
        return stringBuffer;
    }

    public static void main(String[] stringArray) {
        Object object;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        File file = null;
        File file2 = null;
        File file3 = null;
        File file4 = null;
        File file5 = null;
        File file6 = null;
        String string = "";
        String string2 = "";
        boolean bl = false;
        ArrayList<String> arrayList = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = null;
        int n = 13;
        Phylogeny phylogeny = null;
        RIO rIO = null;
        PrintWriter printWriter = null;
        long l = 0L;
        int n2 = 2;
        int n3 = 2;
        double d4 = 2.0;
        double d5 = 50.0;
        if (stringArray.length < 2) {
            rio.printHelp();
            System.exit(0);
        } else if (stringArray.length < 3 || stringArray.length > 18) {
            rio.errorInCommandLine();
        }
        block24: for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().charAt(0) != 'p') {
                if (stringArray[i].trim().length() < 3) {
                    rio.errorInCommandLine();
                } else {
                    string2 = stringArray[i].trim().substring(2);
                }
            }
            try {
                switch (stringArray[i].trim().charAt(0)) {
                    case 'M': {
                        file2 = new File(string2);
                        break;
                    }
                    case 'N': {
                        string = string2;
                        break;
                    }
                    case 'S': {
                        file = new File(string2);
                        break;
                    }
                    case 'O': {
                        file3 = new File(string2);
                        break;
                    }
                    case 'D': {
                        file4 = new File(string2);
                        break;
                    }
                    case 'T': {
                        file5 = new File(string2);
                        break;
                    }
                    case 't': {
                        file6 = new File(string2);
                        break;
                    }
                    case 'p': {
                        bl = true;
                        break;
                    }
                    case 'P': {
                        n = Integer.parseInt(string2);
                        if (n >= 0 && n <= 17) continue block24;
                        rio.errorInCommandLine();
                        break;
                    }
                    case 'L': {
                        d = Double.parseDouble(string2);
                        break;
                    }
                    case 'B': {
                        d2 = Double.parseDouble(string2);
                        break;
                    }
                    case 'U': {
                        d3 = Double.parseDouble(string2);
                        break;
                    }
                    case 'v': {
                        d5 = Double.parseDouble(string2);
                        break;
                    }
                    case 'X': {
                        n3 = Integer.parseInt(string2);
                        break;
                    }
                    case 'Y': {
                        n2 = Integer.parseInt(string2);
                        break;
                    }
                    case 'Z': {
                        d4 = Double.parseDouble(string2);
                        break;
                    }
                    default: {
                        rio.errorInCommandLine();
                        break;
                    }
                }
                continue;
            }
            catch (Exception exception) {
                rio.errorInCommandLine();
            }
        }
        if (string == "" || file == null || file2 == null || file3 == null) {
            rio.errorInCommandLine();
        }
        if (n < 0 || n > 17) {
            rio.errorInCommandLine();
        }
        if (n > 2 && file4 == null) {
            rio.errorInCommandLine();
        }
        System.out.println("\nMultiple trees file:                          " + file2);
        System.out.println("Seq name:                                     " + string);
        System.out.println("Species tree file:                            " + file);
        System.out.println("Outfile:                                      " + file3);
        if (file4 != null) {
            System.out.println("Distance matrix file:                         " + file4);
        }
        if (file5 != null) {
            if (file6 == null) {
                System.out.println("Phy to read dists and calc mean support from: " + file5);
            } else {
                System.out.println("Phylogeny to read dist values from:                " + file5);
            }
        }
        if (file6 != null) {
            System.out.println("Phylogeny to calc mean bootstrap from:             " + file6);
        }
        System.out.println("Sort:                                         " + n);
        System.out.println("Threshold orthologs:                          " + d);
        System.out.println("Threshold subtree neighborings:               " + d2);
        System.out.println("Threshold orthologs for distance calc.:       " + d3);
        if (bl) {
            System.out.println("Threshold ultra paralogs:                     " + d5);
        }
        System.out.println("More than one ortholog  sd diff:              " + n3);
        System.out.println("No  orthologs           sd diff:              " + n2);
        System.out.println("One ortholog            factor :              " + d4 + "\n");
        l = System.currentTimeMillis();
        try {
            object = ParserBasedPhylogenyFactory.getInstance();
            phylogeny = object.create(file, new PhyloXmlParser())[0];
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        if (!phylogeny.isRooted()) {
            ForesterUtil.printErrorMessage(PRG_NAME, "Species tree is not rooted");
            System.exit(-1);
        }
        if (!phylogeny.isCompletelyBinary()) {
            ForesterUtil.printErrorMessage(PRG_NAME, "Species tree is not completely binary");
            System.exit(-1);
        }
        rIO = new RIO();
        object = new StringBuffer();
        try {
            if (file4 != null) {
                rIO.readDistanceMatrix(file4);
            }
            rIO.inferOrthologs(file2, phylogeny.copy(), string);
            ((StringBuffer)object).append(rIO.inferredOrthologsToString(string, n, d, d2));
            if (file5 != null) {
                Phylogeny phylogeny2;
                arrayList = rIO.inferredOrthologsToArrayList(string, d3);
                PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
                if (file6 != null) {
                    phylogeny2 = phylogenyFactory.create(file6, new PhyloXmlParser())[0];
                    dArray = rio.calculateMeanBoostrapValue(phylogeny2);
                } else {
                    phylogeny2 = phylogenyFactory.create(file5, new PhyloXmlParser())[0];
                    dArray = rio.calculateMeanBoostrapValue(phylogeny2);
                }
                if (dArray != null && dArray.length == 2) {
                    double d6 = dArray[0];
                    double d7 = dArray[1];
                    ((StringBuffer)object).append("\n\nMean bootstrap value of consensus tree (sd): " + ForesterUtil.roundToInt(d6 * 100.0 / (double)rIO.getBootstraps()) + "% (+/-" + ForesterUtil.roundToInt(d7 * 100.0 / (double)rIO.getBootstraps()) + "%)\n");
                }
                ((StringBuffer)object).append("\n\nDistance values:\n");
                ((StringBuffer)object).append(rio.getDistances(file5, file3, phylogeny, string, arrayList, rIO.getInferredOrthologs(string), rIO.getInferredSuperOrthologs(string), n3, n2, d4, rIO.getBootstraps(), d3));
            }
            if (bl) {
                ((StringBuffer)object).append("\n\nUltra paralogs:\n");
                ((StringBuffer)object).append(rIO.inferredUltraParalogsToString(string, n > 2, d5));
            }
            ((StringBuffer)object).append("\n\nSort priority: " + RIO.getOrder(n));
            ((StringBuffer)object).append("\nExt nodes    : " + rIO.getExtNodesOfAnalyzedGeneTrees());
            ((StringBuffer)object).append("\nSamples      : " + rIO.getBootstraps() + "\n");
            printWriter = new PrintWriter((Writer)new FileWriter(file3), true);
        }
        catch (Exception exception) {
            ForesterUtil.printErrorMessage(PRG_NAME, exception.getLocalizedMessage());
            exception.printStackTrace();
            System.exit(-1);
        }
        printWriter.println(object);
        printWriter.close();
        ForesterUtil.programMessage(PRG_NAME, "wrote results to \"" + file3 + "\"");
        l = System.currentTimeMillis() - l;
        ForesterUtil.programMessage(PRG_NAME, "time: " + l + "ms");
        ForesterUtil.programMessage(PRG_NAME, "OK.");
        System.exit(0);
    }

    private static final void printHelp() {
        System.out.println("M= (String) Multiple gene tree file (mandatory)");
        System.out.println("N= (String) Query sequence name (mandatory)");
        System.out.println("S= (String) Species tree file (mandatory)");
        System.out.println("O= (String) Output file name -- overwritten without warning! (mandatory)");
        System.out.println("D= (String) Distance matrix file for pairwise distances");
        System.out.println("T= (String) Phylogeny file for distances of query to LCA");
        System.out.println("            of orthologs and for mean bootstrap value (if t= is not used),");
        System.out.println("            must be binary )");
        System.out.println("t= (String) Phylogeny file for mean bootstrap value (if this option is used,");
        System.out.println("            the mean bootstrap value is not calculated from the tree read in");
        System.out.println("            with T=), not necessary binary");
        System.out.println("p           To output ultra paralogs");
        System.out.println("P= (int)    Sort priority");
        System.out.println("L= (double) Threshold orthologs for output");
        System.out.println("U= (double) Threshold orthologs for distance calculation");
        System.out.println("X= (int)    More than one ortholog: ");
        System.out.println("            numbers of sd the dist. to LCA has to differ from mean to generate a warning");
        System.out.println("Y= (int)    No orthologs:");
        System.out.println("            Numbers of sd the dist to root has to differ from mean to generate a warning");
        System.out.println("Z= (double) One ortholog:");
        System.out.println("            threshold for factor between the two distances to their LCA (larger/smaller)");
        System.out.println("            to generate a warning");
        System.out.println();
        System.out.println(" Sort priority (\"P=\"):");
        System.out.println(RIO.getOrderHelp().toString());
        System.out.println();
        System.out.println(" Example: \"rio M=gene_trees.xml N=bcl2_NEMVE S=species_tree.xml D=distances P=13 p O=out\"");
        System.out.println();
    }
}

