/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.sdi.GSDI;
import org.forester.sdi.SDI;
import org.forester.sdi.SDIse;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class sdi {
    private static final String STRIP_OPTION = "s";
    private static final String GSDI_OPTION = "g";
    private static final String MOST_PARSIMONIOUS_OPTION = "m";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String DEFAULT_OUTFILE = "sdi_out.xml";
    private static final String PRG_NAME = "sdi";
    private static final String PRG_VERSION = "beta 0.4";
    private static final String PRG_DATE = "2009.01.22";

    public static void main(String[] stringArray) {
        Object object;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
            System.out.println();
            sdi.print_help();
            System.exit(0);
        } else if (stringArray.length < 2 || commandLineArguments.getNumberOfNames() < 2 || commandLineArguments.getNumberOfNames() > 3) {
            System.out.println();
            System.out.println("Wrong number of arguments.");
            System.out.println();
            sdi.print_help();
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(STRIP_OPTION);
        arrayList.add(GSDI_OPTION);
        arrayList.add(MOST_PARSIMONIOUS_OPTION);
        String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (commandLineArguments.isOptionSet(STRIP_OPTION)) {
            bl2 = true;
        }
        if (commandLineArguments.isOptionSet(GSDI_OPTION)) {
            bl = false;
        }
        if (commandLineArguments.isOptionSet(MOST_PARSIMONIOUS_OPTION)) {
            if (bl) {
                ForesterUtil.fatalError(PRG_NAME, "Can only use most parsimonious duplication mode with GSDI");
            }
            bl3 = true;
        }
        Phylogeny phylogeny = null;
        Phylogeny phylogeny2 = null;
        File file = null;
        File file2 = null;
        File file3 = null;
        try {
            file = commandLineArguments.getFile(0);
            file2 = commandLineArguments.getFile(1);
            file3 = commandLineArguments.getNumberOfNames() == 3 ? commandLineArguments.getFile(2) : new File(DEFAULT_OUTFILE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ForesterUtil.fatalError(PRG_NAME, "error in command line: " + illegalArgumentException.getMessage());
        }
        if (ForesterUtil.isReadableFile(file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(file));
        }
        if (ForesterUtil.isReadableFile(file2) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(file2));
        }
        if (ForesterUtil.isWritableFile(file3) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isWritableFile(file3));
        }
        try {
            object = ParserBasedPhylogenyFactory.getInstance();
            phylogeny = object.create(file2, new PhyloXmlParser())[0];
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to read species tree from \"" + file + "\" [" + iOException.getMessage() + "]");
        }
        try {
            object = ParserBasedPhylogenyFactory.getInstance();
            phylogeny2 = object.create(file, new PhyloXmlParser())[0];
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to read gene tree from \"" + file + "\" [" + iOException.getMessage() + "]");
        }
        phylogeny2.setRooted(true);
        phylogeny.setRooted(true);
        if (!phylogeny2.isCompletelyBinary()) {
            ForesterUtil.fatalError(PRG_NAME, "gene tree (\"" + file + "\") is not completely binary.");
        }
        if (bl && !phylogeny.isCompletelyBinary()) {
            ForesterUtil.fatalError(PRG_NAME, "species tree (\"" + file2 + "\") is not completely binary.");
        }
        System.out.println();
        System.out.println("Strip species tree: " + bl2);
        object = null;
        long l = new Date().getTime();
        try {
            if (bl) {
                System.out.println();
                System.out.println("Using SDIse algorithm.");
                object = new SDIse(phylogeny2, phylogeny);
            } else {
                System.out.println();
                System.out.println("Using GSDI algorithm.");
                System.out.println();
                System.out.println("Use most parsimonous duplication model: " + bl3);
                object = new GSDI(phylogeny2, phylogeny, bl3);
            }
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getLocalizedMessage());
        }
        System.out.println();
        System.out.println("Running time (excluding I/O): " + (new Date().getTime() - l) + "ms");
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(file3, phylogeny2, 1);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write to \"" + file3 + "\" [" + iOException.getMessage() + "]");
        }
        System.out.println();
        System.out.println("Successfully wrote resulting gene tree to: " + file3);
        System.out.println();
        if (bl) {
            ((SDI)object).computeMappingCostL();
            System.out.println("Mapping cost                    : " + ((SDI)object).computeMappingCostL());
        }
        System.out.println("Number of duplications          : " + ((SDI)object).getDuplicationsSum());
        if (!bl && !bl3) {
            System.out.println("Number of potential duplications: " + ((GSDI)object).getSpeciationOrDuplicationEventsSum());
        }
        if (!bl) {
            System.out.println("Number speciations              : " + ((GSDI)object).getSpeciationsSum());
        }
        System.out.println();
    }

    private static void print_help() {
        System.out.println("Usage: \"sdi [-options] <gene tree in phyloXML format> <species tree in phyloXML format> [outfile]\"");
        System.out.println();
        System.out.println("Options:");
        System.out.println(" -s: to strip the species tree prior to duplication inference");
        System.out.println(" -g: to use GSDI algorithm instead of SDIse algorithm (under development, not recommended)");
        System.out.println(" -m: use most parimonious duplication model for GSDI: ");
        System.out.println("     assign nodes as speciations which would otherwise be assiged");
        System.out.println("     as unknown because of polytomies in the species tree");
        System.out.println();
        System.out.println("Species tree:");
        System.out.println(" In phyloXML format, with taxonomy data in appropriate fields.");
        System.out.println();
        System.out.println("Gene tree:");
        System.out.println(" In phyloXM format, with taxonomy and sequence data in appropriate fields.");
        System.out.println();
        System.out.println("!! WARNING: GSDI algorithm is under development (and possibly not correct), please use SDIse instead !!");
        System.out.println();
    }
}

