/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.sdi.Shin;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class shin {
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String DEFAULT_OUTFILE = "out";
    private static final String PRG_NAME = "shin";
    private static final String PRG_VERSION = "0.001 alpha";
    private static final String PRG_DATE = "2009.10.14";

    public static void main(String[] stringArray) {
        Object object;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        System.out.println();
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
            System.out.println();
            shin.print_help();
            System.exit(0);
        } else if (stringArray.length != 3) {
            System.out.println();
            System.out.println("wrong number of arguments");
            System.out.println();
            shin.print_help();
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
        }
        File file = null;
        File file2 = null;
        File file3 = null;
        Phylogeny[] phylogenyArray = null;
        try {
            file = commandLineArguments.getFile(0);
            file2 = commandLineArguments.getFile(1);
            file3 = commandLineArguments.getFile(2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ForesterUtil.fatalError(PRG_NAME, "error in command line: " + illegalArgumentException.getMessage());
        }
        if (ForesterUtil.isReadableFile(file2) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(file2));
        }
        if (!file.isDirectory() || !file.canRead()) {
            ForesterUtil.fatalError(PRG_NAME, "cannot read gene trees from [" + file + "]");
        }
        if (!file3.exists()) {
            boolean bl = false;
            try {
                bl = file3.mkdir();
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "failed to create [" + file3 + "] [" + exception.getMessage() + "]");
            }
            if (!bl) {
                ForesterUtil.fatalError(PRG_NAME, "failed to create [" + file3 + "]");
            }
        }
        try {
            object = ParserBasedPhylogenyFactory.getInstance();
            phylogenyArray = object.create(file2, new PhyloXmlParser());
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read species trees from [" + file2 + "] [" + iOException.getMessage() + "]");
        }
        if (phylogenyArray == null || phylogenyArray.length < 1) {
            ForesterUtil.fatalError(PRG_NAME, "failed to read species trees from [" + file2 + "]");
        }
        ForesterUtil.programMessage(PRG_NAME, "read in " + phylogenyArray.length + " species trees from [" + file2 + "]");
        object = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return !string.startsWith(".") && !string.startsWith("00_") && string.endsWith(".xml");
            }
        };
        Object[] objectArray = file.list((FilenameFilter)object);
        Arrays.sort(objectArray);
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (Object object2 : objectArray) {
            File file4 = new File(file + ForesterUtil.FILE_SEPARATOR + (String)object2);
            if (file4.isDirectory()) continue;
            arrayList2.add(file4);
        }
        ForesterUtil.programMessage(PRG_NAME, "going to analyze " + arrayList2.size() + " gene trees from [" + file + "]");
        Shin shin2 = new Shin();
        try {
            shin2.method1(arrayList2, phylogenyArray, file3);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
            iOException.printStackTrace();
        }
        ForesterUtil.programMessage(PRG_NAME, "OK");
    }

    private static void print_help() {
        System.out.println("Usage: shin [-options] <gene trees dir> <species tree file name> <outdir>");
        System.out.println();
        System.out.println("Options:");
        System.out.println();
    }
}

