/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.CommandLineArguments;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public final class support_statistics {
    private static final int PLACES = 2;
    private static final String HELP_OPTION = "help";
    private static final String OUTPUTFILE_OPTION = "o";
    private static final String PRG_NAME = "support_statistics";
    private static final String PRG_VERSION = "1.0";
    private static final String PRG_DATE = "2008.08.29";

    private static StringBuffer analyze(File[] fileArray, Phylogeny[] phylogenyArray) {
        DescriptiveStatistics[] descriptiveStatisticsArray = new DescriptiveStatistics[phylogenyArray.length];
        for (int i = 0; i < phylogenyArray.length; ++i) {
            descriptiveStatisticsArray[i] = new BasicDescriptiveStatistics();
            DescriptiveStatistics[] descriptiveStatisticsArray2 = phylogenyArray[i];
            PhylogenyNodeIterator phylogenyNodeIterator = descriptiveStatisticsArray2.iteratorPostorder();
            while (phylogenyNodeIterator.hasNext()) {
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                if (phylogenyNode.isRoot() || phylogenyNode.isExternal()) continue;
                double d = PhylogenyMethods.getConfidenceValue(phylogenyNode);
                if (d < 0.0) {
                    d = 0.0;
                }
                descriptiveStatisticsArray[i].addValue(d);
            }
        }
        BasicDescriptiveStatistics basicDescriptiveStatistics = null;
        if (descriptiveStatisticsArray.length > 2) {
            basicDescriptiveStatistics = new BasicDescriptiveStatistics();
            for (DescriptiveStatistics descriptiveStatistics : descriptiveStatisticsArray) {
                basicDescriptiveStatistics.addValue(descriptiveStatistics.arithmeticMean());
            }
        }
        int n = 30;
        for (int i = 0; i < phylogenyArray.length; ++i) {
            int n2 = fileArray[i].getName().length();
            if (n2 <= n) continue;
            n = n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t" + ForesterUtil.normalizeString("name:", n, true, ' ') + "\t");
        stringBuffer.append("median:\t");
        stringBuffer.append("mean:\t");
        stringBuffer.append("sd:\t");
        stringBuffer.append("min:\t");
        stringBuffer.append("max:\t");
        stringBuffer.append("n:\t");
        if (basicDescriptiveStatistics != null) {
            stringBuffer.append("\"z-score\":");
        }
        stringBuffer.append(ForesterUtil.getLineSeparator());
        for (int i = 0; i < phylogenyArray.length; ++i) {
            stringBuffer.append(i + 1 + ":\t" + ForesterUtil.normalizeString(fileArray[i].getName(), n, true, ' ') + "\t");
            stringBuffer.append(ForesterUtil.round(descriptiveStatisticsArray[i].median(), 2) + "\t");
            stringBuffer.append(ForesterUtil.round(descriptiveStatisticsArray[i].arithmeticMean(), 2) + "\t");
            try {
                stringBuffer.append(ForesterUtil.round(descriptiveStatisticsArray[i].sampleStandardDeviation(), 2) + "\t");
            }
            catch (ArithmeticException arithmeticException) {
                stringBuffer.append("n/a\t");
            }
            stringBuffer.append(ForesterUtil.round(descriptiveStatisticsArray[i].getMin(), 2) + "\t");
            stringBuffer.append(ForesterUtil.round(descriptiveStatisticsArray[i].getMax(), 2) + "\t");
            stringBuffer.append(descriptiveStatisticsArray[i].getN() + "\t");
            if (basicDescriptiveStatistics != null) {
                double d = basicDescriptiveStatistics.sampleStandardUnit(descriptiveStatisticsArray[i].arithmeticMean());
                stringBuffer.append(ForesterUtil.round(d, 2) + "\t");
            }
            stringBuffer.append(ForesterUtil.getLineSeparator());
        }
        if (basicDescriptiveStatistics != null) {
            stringBuffer.append(ForesterUtil.getLineSeparator());
            stringBuffer.append("\t" + ForesterUtil.normalizeString("values for support means:", n, true, ' ') + "\t\t");
            stringBuffer.append(ForesterUtil.round(basicDescriptiveStatistics.arithmeticMean(), 2) + "\t");
            stringBuffer.append(ForesterUtil.round(basicDescriptiveStatistics.sampleStandardDeviation(), 2) + "\t");
            stringBuffer.append(ForesterUtil.round(basicDescriptiveStatistics.getMin(), 2) + "\t");
            stringBuffer.append(ForesterUtil.round(basicDescriptiveStatistics.getMax(), 2) + "\t");
        }
        return stringBuffer;
    }

    public static void main(String[] stringArray) {
        Object object;
        Phylogeny[] phylogenyArray;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        if (stringArray.length < 1) {
            System.out.println();
            System.out.println("wrong number of arguments");
            System.out.println();
            support_statistics.printHelp();
            System.exit(-1);
        }
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION)) {
            System.out.println();
            support_statistics.printHelp();
            System.exit(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(OUTPUTFILE_OPTION);
        String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
        }
        File[] fileArray = new File[commandLineArguments.getNumberOfNames()];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = commandLineArguments.getFile(i);
        }
        File file = null;
        if (commandLineArguments.isOptionSet(OUTPUTFILE_OPTION)) {
            try {
                file = new File(commandLineArguments.getOptionValue(OUTPUTFILE_OPTION));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ForesterUtil.fatalError(PRG_NAME, "error in command line: " + illegalArgumentException.getMessage());
            }
            phylogenyArray = ForesterUtil.isWritableFile(file);
            if (phylogenyArray != null) {
                ForesterUtil.fatalError(PRG_NAME, (String)phylogenyArray);
            }
        }
        phylogenyArray = new Phylogeny[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                object = ParserBasedPhylogenyFactory.getInstance();
                PhylogenyParser phylogenyParser = ForesterUtil.createParserDependingOnFileType(fileArray[i], true);
                phylogenyArray[i] = object.create(fileArray[i], phylogenyParser)[0];
                continue;
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "could not read \"" + fileArray[i] + "\": " + iOException.getMessage());
            }
        }
        StringBuffer stringBuffer = support_statistics.analyze(fileArray, phylogenyArray);
        System.out.println();
        System.out.println(stringBuffer);
        System.out.println();
        if (file != null) {
            try {
                object = new PrintWriter(file);
                ((PrintWriter)object).println(stringBuffer);
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
                System.out.println("wrote file: " + file);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "failed to write output: " + iOException.getMessage());
            }
        }
        System.out.println("support_statistics: successfully completed");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println("usage:");
        System.out.println();
        System.out.println("support_statistics [-o=<outfile>] <phylogeny infile 1> <phylogeny infile 2> <phylogeny infile 3> ...");
        System.out.println();
        System.out.println(" options: ");
        System.out.println();
        System.out.println(" -o=<outfile> : write output to file");
        System.out.println();
    }
}

