/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.forester.io.parsers.nexus.NexusCharactersParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nexus.PaupLogParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class surf_paup {
    private static final String PRG_VERSION = "0.90";
    private static final String PRG_DATE = "2008.03.28";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/applications/surfacing";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String PRG_NAME = "surf_paup";

    public static void main(String[] stringArray) {
        Phylogeny phylogeny;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(HELP_OPTION_1);
        arrayList.add(HELP_OPTION_2);
        if (stringArray.length < 2) {
            surf_paup.printHelp();
            System.exit(-1);
        }
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
            surf_paup.printHelp();
            System.exit(0);
        }
        if (commandLineArguments.getNumberOfNames() != 3) {
            surf_paup.printHelp();
            System.exit(-1);
        }
        File file = commandLineArguments.getFile(0);
        File file2 = commandLineArguments.getFile(1);
        String string = commandLineArguments.getFile(2).toString();
        NexusCharactersParser nexusCharactersParser = new NexusCharactersParser();
        try {
            nexusCharactersParser.setSource(file);
            nexusCharactersParser.parse();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "problem with parsing character labels from  [" + file + "]: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        String[] stringArray2 = nexusCharactersParser.getCharStateLabels();
        ForesterUtil.programMessage(PRG_NAME, "read in " + stringArray2.length + " character labels");
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        NexusPhylogeniesParser nexusPhylogeniesParser = new NexusPhylogeniesParser();
        Phylogeny[] phylogenyArray = null;
        try {
            phylogenyArray = phylogenyFactory.create(file, nexusPhylogeniesParser);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "problem with parsing phylogeny [" + file + "]: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        if (phylogenyArray.length != 1) {
            ForesterUtil.fatalError(PRG_NAME, "failed to parse one phylogeny from [" + file + "], got " + phylogenyArray.length + " instead");
        }
        if (!(phylogeny = phylogenyArray[0]).isRooted()) {
            ForesterUtil.fatalError(PRG_NAME, "phylogeny from [" + file + "] is not rooted");
        }
        ForesterUtil.postOrderRelabelInternalNodes(phylogeny, phylogeny.getNumberOfExternalNodes() + 1);
        CharacterStateMatrix<CharacterStateMatrix.BinaryStates> characterStateMatrix = null;
        PaupLogParser paupLogParser = new PaupLogParser();
        try {
            paupLogParser.setSource(file2);
            characterStateMatrix = paupLogParser.parse();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to parse matrix from  [" + file2 + "]: " + iOException.getMessage());
        }
        ForesterUtil.programMessage(PRG_NAME, "read in character state matrix of size " + characterStateMatrix.getNumberOfIdentifiers() + "x" + characterStateMatrix.getNumberOfCharacters());
        DomainParsimonyCalculator domainParsimonyCalculator = DomainParsimonyCalculator.createInstance(phylogeny);
        domainParsimonyCalculator.executeOnGivenBinaryStatesMatrix(characterStateMatrix, stringArray2);
        String string2 = ForesterUtil.LINE_SEPARATOR + "###################" + ForesterUtil.LINE_SEPARATOR;
        SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossMatrix(), string + "_paup_gl", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeMatrixToFile(domainParsimonyCalculator.getGainLossCountsMatrix(), string + "_paup_glc", CharacterStateMatrix.Format.FORESTER);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.GAIN, string + "_paup_gains", string2, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), CharacterStateMatrix.GainLossStates.LOSS, string + "_paup_losses", string2, ForesterUtil.LINE_SEPARATOR, null);
        SurfacingUtil.writeBinaryStatesMatrixAsListToFile(domainParsimonyCalculator.getGainLossMatrix(), null, string + "_paup_present", string2, ForesterUtil.LINE_SEPARATOR, null);
        String string3 = ForesterUtil.getCurrentDateTime();
        SurfacingUtil.preparePhylogeny(phylogeny, domainParsimonyCalculator, string3, "parsimony (paup)", "paup_" + string, "");
        SurfacingUtil.writePhylogenyToFile(phylogeny, string + "_paup.xml");
        ForesterUtil.programMessage(PRG_NAME, "OK");
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println();
        System.out.println("% java  -cp forester.jar org.forester.applications.surf_paup <surfacing nexus outfile with character labels and tree> <paup log file with reconstructed states matrix> <outfile name base>");
        System.out.println();
    }
}

