/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.OBOparser;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.io.parsers.HmmscanPerDomainTableParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogenyinference.CharacterStateMatrix;
import org.forester.phylogenyinference.DistanceMatrix;
import org.forester.phylogenyinference.NeighborJoining;
import org.forester.surfacing.BasicDomainSimilarityCalculator;
import org.forester.surfacing.BasicGenomeWideCombinableDomains;
import org.forester.surfacing.BasicSpecies;
import org.forester.surfacing.BinaryDomainCombination;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.DomainCountsBasedPairwiseSimilarityCalculator;
import org.forester.surfacing.DomainCountsDifferenceUtil;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.DomainLengthsTable;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.MappingResults;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;
import org.forester.surfacing.PairwiseGenomeComparator;
import org.forester.surfacing.PrintableDomainSimilarity;
import org.forester.surfacing.Protein;
import org.forester.surfacing.ProteinCountsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.Species;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class surfacing {
    public static final String DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS = "graph_analysis_out";
    public static final String DOMAIN_COMBINITONS_OUTPUTFILE_SUFFIX_FOR_GRAPH_ANALYSIS = "_dc.dot";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_BC_OUTPUTFILE_SUFFIX_FOR_GRAPH_ANALYSIS = "_fitch_present_dc.dot";
    public static final String DOMAIN_COMBINITON_COUNTS_OUTPUTFILE_SUFFIX = ".dcc";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_DOMAINS = "_dollo_gl_d";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_BINARY_COMBINATIONS = "_dollo_gl_dc";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_FITCH_DOMAINS = "_fitch_gl_d";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_FITCH_BINARY_COMBINATIONS = "_fitch_gl_dc";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_DOMAINS = "_dollo_glc_d";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_BINARY_COMBINATIONS = "_dollo_glc_dc";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_FITCH_DOMAINS = "_fitch_glc_d";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_FITCH_BINARY_COMBINATIONS = "_fitch_glc_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_GAINS_BC = "_fitch_gains_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_GAINS_HTML_BC = "_fitch_gains_dc.html";
    public static final String PARSIMONY_OUTPUT_FITCH_LOSSES_BC = "_fitch_losses_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_LOSSES_HTML_BC = "_fitch_losses_dc.html";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_BC = "_fitch_present_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_HTML_BC = "_fitch_present_dc.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_D = "_dollo_gains_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_GOID_D = "_dollo_gains_goid_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_HTML_D = "_dollo_gains_d.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_D = "_dollo_losses_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_HTML_D = "_dollo_losses_d.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_D = "_dollo_present_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_GOID_D = "_dollo_present_goid_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_HTML_D = "_dollo_present_d.html";
    public static final String DOMAINS_PRESENT_NEXUS = "_dom.nex";
    public static final String BDC_PRESENT_NEXUS = "_dc.nex";
    public static final String PRG_NAME = "surfacing";
    public static final String DOMAINS_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_d_dollo.xml";
    public static final String DOMAINS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH = "_d_fitch.xml";
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_dc_dollo.xml";
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH = "_dc_fitch.xml";
    public static final String NEXUS_EXTERNAL_DOMAINS = "_dom.nex";
    public static final String NEXUS_EXTERNAL_DOMAIN_COMBINATIONS = "_dc.nex";
    public static final String NEXUS_SECONDARY_FEATURES = "_secondary_features.nex";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_SECONDARY_FEATURES = "_dollo_gl_secondary_features";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_SECONDARY_FEATURES = "_dollo_glc_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_SECONDARY_FEATURES = "_dollo_gains_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_SECONDARY_FEATURES = "_dollo_losses_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_SECONDARY_FEATURES = "_dollo_present_secondary_features";
    public static final String SECONDARY_FEATURES_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_secondary_features_dollo.xml";
    public static final String PARSIMONY_OUTPUT_DOLLO_ALL_GOID_D_BIOLOGICAL_PROCESS = "_dollo_biol_proc_goid_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_ALL_GOID_D_CELLULAR_COMPONENT = "_dollo_cell_comp_goid_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_ALL_GOID_D_MOLECULAR_FUNCTION = "_dollo_mol_funct_goid_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_ALL_GOID_D_ALL_NAMESPACES = "_dollo_goid_d";
    public static final String PARSIMONY_OUTPUT_FITCH_ALL_GOID_BC_BIOLOGICAL_PROCESS = "_fitch_biol_proc_goid_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_ALL_GOID_BC_CELLULAR_COMPONENT = "_fitch_cell_comp_goid_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_ALL_GOID_BC_MOLECULAR_FUNCTION = "_fitch_mol_funct_goid_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_ALL_GOID_BC_ALL_NAMESPACES = "_fitch_goid_dc";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String OUTPUT_DIR_OPTION = "out_dir";
    private static final String SCORING_OPTION = "scoring";
    private static final DomainSimilarity.DomainSimilarityScoring SCORING_DEFAULT = DomainSimilarity.DomainSimilarityScoring.COMBINATIONS;
    private static final String SCORING_DOMAIN_COUNT_BASED = "domains";
    private static final String SCORING_PROTEIN_COUNT_BASED = "proteins";
    private static final String SCORING_COMBINATION_BASED = "combinations";
    private static final String DETAILEDNESS_OPTION = "detail";
    private static final DomainSimilarityCalculator.Detailedness DETAILEDNESS_DEFAULT = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
    private static final String SPECIES_MATRIX_OPTION = "smatrix";
    private static final String DETAILEDNESS_BASIC = "basic";
    private static final String DETAILEDNESS_LIST_IDS = "list_ids";
    private static final String DETAILEDNESS_PUNCTILIOUS = "punctilious";
    private static final String DOMAIN_SIMILARITY_SORT_OPTION = "sort";
    private static final DomainSimilarity.DomainSimilaritySortField DOMAIN_SORT_FILD_DEFAULT = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
    private static final String DOMAIN_SIMILARITY_SORT_MIN = "min";
    private static final String DOMAIN_SIMILARITY_SORT_MAX = "max";
    private static final String DOMAIN_SIMILARITY_SORT_SD = "sd";
    private static final String DOMAIN_SIMILARITY_SORT_MEAN = "mean";
    private static final String DOMAIN_SIMILARITY_SORT_DIFF = "diff";
    private static final String DOMAIN_SIMILARITY_SORT_COUNTS_DIFF = "count_diff";
    private static final String DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF = "abs_count_diff";
    private static final String DOMAIN_SIMILARITY_SORT_SPECIES_COUNT = "species";
    private static final String DOMAIN_SIMILARITY_SORT_ALPHA = "alpha";
    private static final String DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION = "species_first";
    private static final String DOMAIN_COUNT_SORT_OPTION = "dc_sort";
    private static final GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder DOMAINS_SORT_ORDER_DEFAULT = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID;
    private static final String DOMAIN_COUNT_SORT_ALPHA = "alpha";
    private static final String DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT = "dom";
    private static final String DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT = "prot";
    private static final String DOMAIN_COUNT_SORT_COMBINATIONS_COUNT = "comb";
    private static final String CUTOFF_SCORE_FILE_OPTION = "cos";
    private static final String NOT_IGNORE_DUFS_OPTION = "dufs";
    private static final String MAX_E_VALUE_OPTION = "e";
    private static final String MAX_ALLOWED_OVERLAP_OPTION = "mo";
    private static final String NO_ENGULFING_OVERLAP_OPTION = "no_eo";
    private static final String IGNORE_COMBINATION_WITH_SAME_OPTION = "ignore_self_comb";
    private static final String PAIRWISE_DOMAIN_COMPARISONS_PREFIX = "pwc_";
    private static final String PAIRWISE_DOMAIN_COMPARISONS_OPTION = "pwc";
    private static final String OUTPUT_FILE_OPTION = "o";
    private static final String PFAM_TO_GO_FILE_USE_OPTION = "p2g";
    private static final String GO_OBO_FILE_USE_OPTION = "obo";
    private static final String GO_NAMESPACE_LIMIT_OPTION = "go_namespace";
    private static final String GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION = "molecular_function";
    private static final String GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS = "biological_process";
    private static final String GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT = "cellular_component";
    private static final String SECONDARY_FEATURES_PARSIMONY_MAP_FILE = "secondary";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED = "simple_tab";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML = "simple_html";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML = "detailed_html";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION = "ds_output";
    private static final PrintableDomainSimilarity.PRINT_OPTION DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT = PrintableDomainSimilarity.PRINT_OPTION.HTML;
    private static final String IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION = "ignore_singlet_domains";
    private static final String IGNORE_VIRAL_IDS = "ignore_viral_ids";
    private static final boolean IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_DEFAULT = false;
    private static final String IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION = "ignore_species_specific_domains";
    private static final boolean IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION_DEFAULT = false;
    private static final String MATRIX_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX = "_mean_score.pwd";
    private static final String MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX = "_domains.pwd";
    private static final String MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX = "_bin_combinations.pwd";
    private static final String NJ_TREE_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX = "_mean_score_NJ.xml";
    private static final String NJ_TREE_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX = "_domains_NJ.xml";
    private static final String NJ_TREE_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX = "_bin_combinations_NJ.xml";
    private static final String DISPLAY_M_HISTOGRAMS_OPTION = "mhisto";
    private static final String JACKNIFE_OPTION = "jack";
    private static final String JACKNIFE_RANDOM_SEED_OPTION = "seed";
    private static final String JACKNIFE_RATIO_OPTION = "jack_ratio";
    private static final int JACKNIFE_NUMBER_OF_RESAMPLINGS_DEFAULT = 100;
    private static final long JACKNIFE_RANDOM_SEED_DEFAULT = 19L;
    private static final double JACKNIFE_RATIO_DEFAULT = 0.5;
    private static final String INFERRED_SD_BASED_NJ_SPECIES_TREE_SUFFIX = "_sd_nj.nh";
    private static final String INFERRED_SBC_BASED_NJ_SPECIES_TREE_SUFFIX = "_sbc_nj.nh";
    private static final String FILTER_POSITIVE_OPTION = "pos_filter";
    private static final String FILTER_NEGATIVE_OPTION = "neg_filter";
    private static final String FILTER_NEGATIVE_DOMAINS_OPTION = "neg_dom_filter";
    private static final String INPUT_FILES_FROM_FILE_OPTION = "input";
    private static final String INPUT_SPECIES_TREE_OPTION = "species_tree";
    private static final String SEQ_EXTRACT_OPTION = "prot_extract";
    private static final char SEPARATOR_FOR_INPUT_VALUES = '#';
    private static final String PRG_VERSION = "2.002";
    private static final String PRG_DATE = "2010.07.27";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org/forester/applications/surfacing";
    private static final boolean IGNORE_DUFS_DEFAULT = true;
    private static final boolean IGNORE_COMBINATION_WITH_SAME_DEFAULLT = false;
    private static final double MAX_E_VALUE_DEFAULT = -1.0;
    private static final int MAX_ALLOWED_OVERLAP_DEFAULT = -1;
    private static final String DEFAULT_SEARCH_PARAMETER = "ls";
    private static final boolean VERBOSE_DEFAULT = true;
    private static final String RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION = "random_seed";
    private static final String CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS = "consider_bdc_direction";
    private static final String CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY = "consider_bdc_adj";
    private static final String SEQ_EXTRACT_SUFFIX = ".prot";
    private static final String PLUS_MINUS_ANALYSIS_OPTION = "plus_minus";
    private static final String PLUS_MINUS_DOM_SUFFIX = "_plus_minus_dom.txt";
    private static final String PLUS_MINUS_DOM_SUFFIX_HTML = "_plus_minus_dom.html";
    private static final String PLUS_MINUS_DC_SUFFIX_HTML = "_plus_minus_dc.html";
    private static final int PLUS_MINUS_ANALYSIS_MIN_DIFF_DEFAULT = 0;
    private static final double PLUS_MINUS_ANALYSIS_FACTOR_DEFAULT = 1.0;
    private static final String PLUS_MINUS_ALL_GO_IDS_DOM_SUFFIX = "_plus_minus_go_ids_all.txt";
    private static final String PLUS_MINUS_PASSING_GO_IDS_DOM_SUFFIX = "_plus_minus_go_ids_passing.txt";
    private static final String OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS = "all_prot";
    private static final boolean VERBOSE = false;
    private static final String OUTPUT_DOMAIN_COMBINATIONS_GAINED_MORE_THAN_ONCE_ANALYSIS_SUFFIX = "_fitch_dc_gains_counts";
    private static final String OUTPUT_DOMAIN_COMBINATIONS_LOST_MORE_THAN_ONCE_ANALYSIS_SUFFIX = "_fitch_dc_losses_counts";
    private static final String DOMAIN_LENGTHS_ANALYSIS_SUFFIX = "_domain_lengths_analysis";
    private static final boolean PERFORM_DOMAIN_LENGTH_ANALYSIS = true;
    public static final String ALL_PFAMS_ENCOUNTERED_SUFFIX = "_all_encountered_pfams";
    public static final String ALL_PFAMS_ENCOUNTERED_WITH_GO_ANNOTATION_SUFFIX = "_all_encountered_pfams_with_go_annotation";
    public static final String ENCOUNTERED_PFAMS_SUMMARY_SUFFIX = "_encountered_pfams_summary";
    public static final String ALL_PFAMS_GAINED_AS_DOMAINS_SUFFIX = "_all_pfams_gained_as_domains";
    public static final String ALL_PFAMS_LOST_AS_DOMAINS_SUFFIX = "_all_pfams_lost_as_domains";
    public static final String ALL_PFAMS_GAINED_AS_DC_SUFFIX = "_all_pfams_gained_as_dc";
    public static final String ALL_PFAMS_LOST_AS_DC_SUFFIX = "_all_pfams_lost_as_dc";
    public static final String BASE_DIRECTORY_PER_NODE_DOMAIN_GAIN_LOSS_FILES = "PER_NODE_EVENTS";
    public static final String BASE_DIRECTORY_PER_SUBTREE_DOMAIN_GAIN_LOSS_FILES = "PER_SUBTREE_EVENTS";
    public static final String D_PROMISCUITY_FILE_SUFFIX = "_domain_promiscuities";
    private static final String LOG_FILE_SUFFIX = "_log.txt";
    private static final String DATA_FILE_SUFFIX = "_domain_combination_data.txt";
    private static final String DATA_FILE_DESC = "#SPECIES\tPRTEIN_ID\tN_TERM_DOMAIN\tC_TERM_DOMAIN\tN_TERM_DOMAIN_PER_DOMAIN_E_VALUE\tC_TERM_DOMAIN_PER_DOMAIN_E_VALUE\tN_TERM_DOMAIN_COUNTS_PER_PROTEIN\tC_TERM_DOMAIN_COUNTS_PER_PROTEIN";
    private static final HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF INDIVIDUAL_SCORE_CUTOFF_DEFAULT = HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF.FULL_SEQUENCE;

    private static void checkWriteabilityForPairwiseComparisons(PrintableDomainSimilarity.PRINT_OPTION pRINT_OPTION, String[][] stringArray, String string, File file) {
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < i; ++j) {
                String string2 = stringArray[i][1];
                String string3 = stringArray[j][1];
                String string4 = PAIRWISE_DOMAIN_COMPARISONS_PREFIX + string2 + "_" + string3 + string;
                switch (pRINT_OPTION) {
                    case HTML: {
                        if (string4.endsWith(".html")) break;
                        string4 = string4 + ".html";
                    }
                }
                String string5 = ForesterUtil.isWritableFile(new File(file == null ? string4 : file + ForesterUtil.FILE_SEPARATOR + string4));
                if (ForesterUtil.isEmpty(string5)) continue;
                ForesterUtil.fatalError(PRG_NAME, string5);
            }
        }
    }

    private static StringBuilder createParametersAsString(boolean bl, double d, int n, boolean bl2, File file, BinaryDomainCombination.DomainCombinationType domainCombinationType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("E-value: " + d);
        if (file != null) {
            stringBuilder.append(", Cutoff-scores-file: " + file);
        } else {
            stringBuilder.append(", Cutoff-scores-file: not-set");
        }
        if (n != -1) {
            stringBuilder.append(", Max-overlap: " + n);
        } else {
            stringBuilder.append(", Max-overlap: not-set");
        }
        if (bl2) {
            stringBuilder.append(", Engulfing-overlaps: not-allowed");
        } else {
            stringBuilder.append(", Engulfing-overlaps: allowed");
        }
        if (bl) {
            stringBuilder.append(", Ignore-dufs: true");
        } else {
            stringBuilder.append(", Ignore-dufs: false");
        }
        stringBuilder.append(", DC type (if applicable): " + (Object)((Object)domainCombinationType));
        return stringBuilder;
    }

    private static void executeFitchGainsAnalysis(File file, List<BinaryDomainCombination> list, int n, SortedSet<BinaryDomainCombination> sortedSet, boolean bl) throws IOException {
        SurfacingUtil.checkForOutputFileWriteability(file);
        BufferedWriter bufferedWriter = ForesterUtil.createBufferedWriter(file);
        SortedMap<Object, Integer> sortedMap = ForesterUtil.listToSortedCountsMap(list);
        TreeSet<DomainId> treeSet = new TreeSet<DomainId>();
        TreeSet<DomainId> treeSet2 = new TreeSet<DomainId>();
        int n2 = 0;
        int n3 = 0;
        for (Object object : sortedMap.keySet()) {
            BinaryDomainCombination binaryDomainCombination = (BinaryDomainCombination)object;
            int n4 = (Integer)sortedMap.get(object);
            if (n4 < 1) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "count < 1 ");
            }
            bufferedWriter.write(binaryDomainCombination + "\t" + n4 + ForesterUtil.LINE_SEPARATOR);
            if (n4 > 1) {
                treeSet.add(binaryDomainCombination.getId0());
                treeSet.add(binaryDomainCombination.getId1());
                ++n2;
                continue;
            }
            if (n4 != 1) continue;
            treeSet2.add(binaryDomainCombination.getId0());
            treeSet2.add(binaryDomainCombination.getId1());
            ++n3;
        }
        int n5 = sortedSet.size();
        int n6 = -1;
        if (!bl) {
            sortedSet.removeAll(list);
            n6 = sortedSet.size();
            for (BinaryDomainCombination binaryDomainCombination : sortedSet) {
                bufferedWriter.write(binaryDomainCombination + "\t" + "0" + ForesterUtil.LINE_SEPARATOR);
            }
        }
        if (bl) {
            bufferedWriter.write("Sum of all distinct domain combinations appearing once               : " + n3 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domain combinations appearing more than once     : " + n2 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domains in combinations apppearing only once     : " + treeSet2.size() + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domains in combinations apppearing more than once: " + treeSet.size() + ForesterUtil.LINE_SEPARATOR);
        } else {
            bufferedWriter.write("Sum of all distinct domain combinations never lost                   : " + n6 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domain combinations lost once                    : " + n3 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domain combinations lost more than once          : " + n2 + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domains in combinations lost only once           : " + treeSet2.size() + ForesterUtil.LINE_SEPARATOR);
            bufferedWriter.write("Sum of all distinct domains in combinations lost more than once: " + treeSet.size() + ForesterUtil.LINE_SEPARATOR);
        }
        bufferedWriter.write("All binary combinations                                              : " + n5 + ForesterUtil.LINE_SEPARATOR);
        bufferedWriter.write("All domains                                                          : " + n);
        ((Writer)bufferedWriter).close();
        ForesterUtil.programMessage(PRG_NAME, "Wrote fitch domain combination dynamics counts analysis to \"" + file + "\"");
    }

    private static void executePlusMinusAnalysis(File file, List<String> list, List<String> list2, List<String> list3, List<GenomeWideCombinableDomains> list4, SortedMap<Species, List<Protein>> sortedMap, Map<DomainId, List<GoId>> map, Map<GoId, GoTerm> map2, List<Object> list5) {
        HashSet<String> hashSet = new HashSet<String>();
        for (GenomeWideCombinableDomains object2 : list4) {
            hashSet.add(object2.getSpecies().getSpeciesId());
        }
        File file2 = new File(file + PLUS_MINUS_DOM_SUFFIX_HTML);
        File file3 = new File(file + PLUS_MINUS_DOM_SUFFIX);
        File file4 = new File(file + PLUS_MINUS_DC_SUFFIX_HTML);
        File file5 = new File(file + PLUS_MINUS_ALL_GO_IDS_DOM_SUFFIX);
        File file6 = new File(file + PLUS_MINUS_PASSING_GO_IDS_DOM_SUFFIX);
        File file7 = new File(file + "");
        int n = (Integer)list5.get(0);
        double d = (Double)list5.get(1);
        try {
            DomainCountsDifferenceUtil.calculateCopyNumberDifferences(list4, sortedMap, list, list2, list3, n, d, file3, file2, file4, map, map2, file5, file6, file7);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
        }
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis results to \"" + file2 + "\"");
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis results to \"" + file3 + "\"");
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis results to \"" + file4 + "\"");
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis based passing GO ids to \"" + file6 + "\"");
        ForesterUtil.programMessage(PRG_NAME, "Wrote plus minus domain analysis based all GO ids to \"" + file5 + "\"");
    }

    private static Phylogeny[] getIntrees(File[] fileArray, int n, String[][] stringArray) {
        Phylogeny[] phylogenyArray = new Phylogeny[fileArray.length];
        int n2 = 0;
        for (File file : fileArray) {
            int n3;
            Object object;
            Phylogeny phylogeny = null;
            String string = ForesterUtil.isReadableFile(file);
            if (!ForesterUtil.isEmpty(string)) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read input tree file [" + file + "]: " + string);
            }
            try {
                object = ParserBasedPhylogenyFactory.getInstance().create(file, ForesterUtil.createParserDependingOnFileType(file, true));
                if (((Phylogeny[])object).length < 1) {
                    ForesterUtil.fatalError(PRG_NAME, "file [" + file + "] does not contain any phylogeny in phyloXML format");
                } else if (((Phylogeny[])object).length > 1) {
                    ForesterUtil.fatalError(PRG_NAME, "file [" + file + "] contains more than one phylogeny in phyloXML format");
                }
                phylogeny = object[0];
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read input tree from file [" + file + "]: " + string);
            }
            if (phylogeny == null || phylogeny.isEmpty()) {
                ForesterUtil.fatalError(PRG_NAME, "input tree [" + file + "] is empty");
            }
            if (!phylogeny.isRooted()) {
                ForesterUtil.fatalError(PRG_NAME, "input tree [" + file + "] is not rooted");
            }
            if (phylogeny.getNumberOfExternalNodes() < n) {
                ForesterUtil.fatalError(PRG_NAME, "number of external nodes [" + phylogeny.getNumberOfExternalNodes() + "] of input tree [" + file + "] is smaller than the number of genomes the be analyzed [" + n + "]");
            }
            if ((n3 = SurfacingUtil.getNumberOfNodesLackingName(phylogeny, (StringBuilder)(object = new StringBuilder()))) > 0) {
                ForesterUtil.fatalError(PRG_NAME, "input tree [" + file + "] has " + n3 + " node(s) lacking a name [parent names:" + object + "]");
            }
            surfacing.preparePhylogenyForParsimonyAnalyses(phylogeny, stringArray);
            if (!phylogeny.isCompletelyBinary()) {
                ForesterUtil.printWarningMessage(PRG_NAME, "input tree [" + file + "] is not completely binary");
            }
            phylogenyArray[n2++] = phylogeny;
        }
        return phylogenyArray;
    }

    private static List<Phylogeny> inferSpeciesTrees(File file, List<DistanceMatrix> list) {
        NeighborJoining neighborJoining = NeighborJoining.createInstance();
        List<Phylogeny> list2 = neighborJoining.execute(list);
        PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
        try {
            phylogenyWriter.toNewHampshire(list2, true, true, file, ";");
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "failed to write to outfile [" + file + "]: " + iOException.getMessage());
        }
        return list2;
    }

    private static void log(String string, Writer writer) {
        try {
            writer.write(string);
            writer.write(ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        void var78_122;
        Object object;
        Species[] speciesArray;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl;
        AbstractCollection abstractCollection;
        String[] stringArray2;
        Object object6;
        int string8;
        boolean bl2;
        Object object10;
        Object object11;
        List<GoTerm> list;
        Object object12;
        Object object13;
        Object object14;
        Object object15;
        Object object16;
        String string;
        Object object17;
        Object object18;
        Object object19;
        Object object20;
        long l = new Date().getTime();
        StringBuilder stringBuilder = new StringBuilder();
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        String string2 = ForesterUtil.LINE_SEPARATOR;
        stringBuilder.append("<table>" + string2);
        stringBuilder.append("<tr><td>Produced by:</td><td>surfacing</td></tr>" + string2);
        stringBuilder.append("<tr><td>Version:</td><td>2.002</td></tr>" + string2);
        stringBuilder.append("<tr><td>Release Date:</td><td>2010.07.27</td></tr>" + string2);
        stringBuilder.append("<tr><td>Contact:</td><td>czmasek@burnham.org</td></tr>" + string2);
        stringBuilder.append("<tr><td>WWW:</td><td>www.phylosoft.org/forester/applications/surfacing</td></tr>" + string2);
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
            surfacing.printHelp();
            System.exit(0);
        }
        if (stringArray.length < 1) {
            surfacing.printHelp();
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(NOT_IGNORE_DUFS_OPTION);
        arrayList.add(MAX_E_VALUE_OPTION);
        arrayList.add(DETAILEDNESS_OPTION);
        arrayList.add(OUTPUT_FILE_OPTION);
        arrayList.add(DOMAIN_SIMILARITY_SORT_OPTION);
        arrayList.add(SPECIES_MATRIX_OPTION);
        arrayList.add(SCORING_OPTION);
        arrayList.add(MAX_ALLOWED_OVERLAP_OPTION);
        arrayList.add(NO_ENGULFING_OVERLAP_OPTION);
        arrayList.add(DOMAIN_COUNT_SORT_OPTION);
        arrayList.add(CUTOFF_SCORE_FILE_OPTION);
        arrayList.add(DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION);
        arrayList.add(OUTPUT_DIR_OPTION);
        arrayList.add(IGNORE_COMBINATION_WITH_SAME_OPTION);
        arrayList.add(PFAM_TO_GO_FILE_USE_OPTION);
        arrayList.add(GO_OBO_FILE_USE_OPTION);
        arrayList.add(DOMAIN_SIMILARITY_PRINT_OPTION);
        arrayList.add(GO_NAMESPACE_LIMIT_OPTION);
        arrayList.add(PAIRWISE_DOMAIN_COMPARISONS_OPTION);
        arrayList.add(IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION);
        arrayList.add(DISPLAY_M_HISTOGRAMS_OPTION);
        arrayList.add(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS);
        arrayList.add(JACKNIFE_OPTION);
        arrayList.add(JACKNIFE_RANDOM_SEED_OPTION);
        arrayList.add(JACKNIFE_RATIO_OPTION);
        arrayList.add(INPUT_SPECIES_TREE_OPTION);
        arrayList.add(FILTER_POSITIVE_OPTION);
        arrayList.add(FILTER_NEGATIVE_OPTION);
        arrayList.add(INPUT_FILES_FROM_FILE_OPTION);
        arrayList.add(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION);
        arrayList.add(FILTER_NEGATIVE_DOMAINS_OPTION);
        arrayList.add(IGNORE_VIRAL_IDS);
        arrayList.add(SEQ_EXTRACT_OPTION);
        arrayList.add(SECONDARY_FEATURES_PARSIMONY_MAP_FILE);
        arrayList.add(PLUS_MINUS_ANALYSIS_OPTION);
        arrayList.add(DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS);
        arrayList.add(OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS);
        arrayList.add(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY);
        boolean bl22 = true;
        boolean bl3 = false;
        double d = -1.0;
        int n2 = -1;
        String string3 = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string3.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string3);
        }
        boolean bl4 = false;
        if (commandLineArguments.isOptionSet(DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS)) {
            bl4 = true;
        }
        if (commandLineArguments.isOptionSet(MAX_E_VALUE_OPTION)) {
            try {
                d = commandLineArguments.getOptionValueAsDouble(MAX_E_VALUE_OPTION);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for E-value maximum");
            }
        }
        if (commandLineArguments.isOptionSet(MAX_ALLOWED_OVERLAP_OPTION)) {
            try {
                n2 = commandLineArguments.getOptionValueAsInt(MAX_ALLOWED_OVERLAP_OPTION);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for maximal allowed domain overlap");
            }
        }
        boolean bl5 = false;
        if (commandLineArguments.isOptionSet(NO_ENGULFING_OVERLAP_OPTION)) {
            bl5 = true;
        }
        boolean bl6 = false;
        if (commandLineArguments.isOptionSet(IGNORE_VIRAL_IDS)) {
            bl6 = true;
        }
        if (commandLineArguments.isOptionSet(NOT_IGNORE_DUFS_OPTION)) {
            bl22 = false;
        }
        if (commandLineArguments.isOptionSet(IGNORE_COMBINATION_WITH_SAME_OPTION)) {
            bl3 = true;
        }
        boolean bl7 = false;
        if (commandLineArguments.isOptionSet(IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION)) {
            bl7 = true;
        }
        boolean bl8 = false;
        if (commandLineArguments.isOptionSet(IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION)) {
            bl8 = true;
        }
        File file = null;
        if (commandLineArguments.isOptionSet(OUTPUT_FILE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(OUTPUT_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for domain combinations similarities output file: -o=<file>");
            }
            file = new File(commandLineArguments.getOptionValue(OUTPUT_FILE_OPTION));
            SurfacingUtil.checkForOutputFileWriteability(file);
        }
        File file2 = null;
        Map<String, Double> map = null;
        if (commandLineArguments.isOptionSet(CUTOFF_SCORE_FILE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(CUTOFF_SCORE_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for individual domain score cutoffs file: -cos=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object20 = ForesterUtil.isReadableFile(file2 = new File(commandLineArguments.getOptionValue(CUTOFF_SCORE_FILE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read individual domain score cutoffs file: " + (String)object20);
            }
            try {
                object19 = BasicTableParser.parse(file2, " ");
                map = ((BasicTable)object19).getColumnsAsMapDouble(0, 1);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read from individual score cutoffs file: " + iOException);
            }
        }
        object20 = BinaryDomainCombination.DomainCombinationType.BASIC;
        if (commandLineArguments.isOptionSet(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS)) {
            object20 = BinaryDomainCombination.DomainCombinationType.DIRECTED;
        }
        if (commandLineArguments.isOptionSet(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY)) {
            object20 = BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT;
        }
        object19 = null;
        if (commandLineArguments.isOptionSet(OUTPUT_DIR_OPTION)) {
            boolean bl9;
            if (!commandLineArguments.isOptionValueSet(OUTPUT_DIR_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for output directory: -out_dir=<dir>");
            }
            if (((File)(object19 = new File(commandLineArguments.getOptionValue(OUTPUT_DIR_OPTION)))).exists() && ((File)object19).listFiles().length > 0) {
                ForesterUtil.fatalError(PRG_NAME, "\"" + object19 + "\" aready exists and is not empty");
            }
            if (!(((File)object19).exists() || (bl9 = ((File)object19).mkdir()) && ((File)object19).exists())) {
                ForesterUtil.fatalError(PRG_NAME, "failed to create \"" + object19 + "\"");
            }
            if (!((File)object19).canWrite()) {
                ForesterUtil.fatalError(PRG_NAME, "cannot write to \"" + object19 + "\"");
            }
        }
        File file3 = null;
        File file4 = null;
        File file5 = null;
        if (commandLineArguments.isOptionSet(FILTER_NEGATIVE_OPTION) && commandLineArguments.isOptionSet(FILTER_POSITIVE_OPTION)) {
            ForesterUtil.fatalError(PRG_NAME, "attempt to use both negative and positive protein filter");
        }
        if (commandLineArguments.isOptionSet(FILTER_NEGATIVE_DOMAINS_OPTION) && (commandLineArguments.isOptionSet(FILTER_NEGATIVE_OPTION) || commandLineArguments.isOptionSet(FILTER_POSITIVE_OPTION))) {
            ForesterUtil.fatalError(PRG_NAME, "attempt to use both negative or positive protein filter together wirh a negative domains filter");
        }
        if (commandLineArguments.isOptionSet(FILTER_NEGATIVE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(FILTER_NEGATIVE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for negative filter: -neg_filter=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object18 = ForesterUtil.isReadableFile(file4 = new File(commandLineArguments.getOptionValue(FILTER_NEGATIVE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file4 + "\": " + (String)object18);
            }
        } else if (commandLineArguments.isOptionSet(FILTER_POSITIVE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(FILTER_POSITIVE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for positive filter: -pos_filter=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object18 = ForesterUtil.isReadableFile(file3 = new File(commandLineArguments.getOptionValue(FILTER_POSITIVE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file3 + "\": " + (String)object18);
            }
        } else if (commandLineArguments.isOptionSet(FILTER_NEGATIVE_DOMAINS_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(FILTER_NEGATIVE_DOMAINS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for negative domains filter: -neg_dom_filter=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object18 = ForesterUtil.isReadableFile(file5 = new File(commandLineArguments.getOptionValue(FILTER_NEGATIVE_DOMAINS_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file5 + "\": " + (String)object18);
            }
        }
        object18 = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        surfacing.processPlusMinusAnalysisOption(commandLineArguments, (List<String>)object18, arrayList2, arrayList3, arrayList4);
        File file6 = null;
        String[] stringArray3 = null;
        if (commandLineArguments.isOptionSet(INPUT_FILES_FROM_FILE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(INPUT_FILES_FROM_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for input files file: -input=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object17 = ForesterUtil.isReadableFile(file6 = new File(commandLineArguments.getOptionValue(INPUT_FILES_FROM_FILE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file6 + "\": " + (String)object17);
            }
            try {
                stringArray3 = ForesterUtil.file2array(file6);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "failed to read from \"" + file6 + "\": " + iOException);
            }
        }
        if (commandLineArguments.getNumberOfNames() < 1 && (stringArray3 == null || stringArray3.length < 1)) {
            ForesterUtil.fatalError(PRG_NAME, "No hmmpfam output file indicated is input: use comand line directly or input=<file>");
        }
        object17 = SCORING_DEFAULT;
        if (commandLineArguments.isOptionSet(SCORING_OPTION)) {
            String string4;
            if (!commandLineArguments.isOptionValueSet(SCORING_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for scoring method for domain combinations similarity calculation: -scoring=<domains|proteins|combinations>\"");
            }
            if ((string4 = commandLineArguments.getOptionValue(SCORING_OPTION)).equals(SCORING_DOMAIN_COUNT_BASED)) {
                object17 = DomainSimilarity.DomainSimilarityScoring.DOMAINS;
            } else if (string4.equals(SCORING_COMBINATION_BASED)) {
                object17 = DomainSimilarity.DomainSimilarityScoring.COMBINATIONS;
            } else if (string4.equals(SCORING_PROTEIN_COUNT_BASED)) {
                object17 = DomainSimilarity.DomainSimilarityScoring.PROTEINS;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + string4 + "\" for scoring method for domain combinations similarity calculation: \"-" + SCORING_OPTION + "=<" + SCORING_DOMAIN_COUNT_BASED + "|" + SCORING_PROTEIN_COUNT_BASED + "|" + SCORING_COMBINATION_BASED + ">\"");
            }
        }
        boolean bl10 = false;
        if (commandLineArguments.isOptionSet(DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION)) {
            bl10 = true;
        }
        boolean bl11 = false;
        if (commandLineArguments.isOptionSet(SPECIES_MATRIX_OPTION)) {
            bl11 = true;
        }
        boolean bl12 = false;
        if (commandLineArguments.isOptionSet(OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS)) {
            bl12 = true;
        }
        DomainSimilarityCalculator.Detailedness detailedness = DETAILEDNESS_DEFAULT;
        if (commandLineArguments.isOptionSet(DETAILEDNESS_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(DETAILEDNESS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for -detail=<basic|list_ids|punctilious>\"");
            }
            if ((string = commandLineArguments.getOptionValue(DETAILEDNESS_OPTION).toLowerCase()).equals(DETAILEDNESS_BASIC)) {
                detailedness = DomainSimilarityCalculator.Detailedness.BASIC;
            } else if (string.equals(DETAILEDNESS_LIST_IDS)) {
                detailedness = DomainSimilarityCalculator.Detailedness.LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES;
            } else if (string.equals(DETAILEDNESS_PUNCTILIOUS)) {
                detailedness = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + string + "\" for detailedness: \"-" + DETAILEDNESS_OPTION + "=<" + DETAILEDNESS_BASIC + "|" + DETAILEDNESS_LIST_IDS + "|" + DETAILEDNESS_PUNCTILIOUS + ">\"");
            }
        }
        string = null;
        boolean bl13 = false;
        boolean bl14 = false;
        if (commandLineArguments.isOptionSet(PAIRWISE_DOMAIN_COMPARISONS_OPTION)) {
            bl13 = true;
            if (!commandLineArguments.isOptionValueSet(PAIRWISE_DOMAIN_COMPARISONS_OPTION)) {
                bl14 = false;
            } else {
                bl14 = true;
                string = "_" + commandLineArguments.getOptionValue(PAIRWISE_DOMAIN_COMPARISONS_OPTION);
            }
        }
        String string5 = null;
        if (commandLineArguments.isOptionSet(SEQ_EXTRACT_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(SEQ_EXTRACT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no domain ids given for sequences with given domains to be extracted : -prot_extract=<ordered domain sequences, domain ids separated by '~', sequences separated by '#'>");
            }
            string5 = commandLineArguments.getOptionValue(SEQ_EXTRACT_OPTION);
        }
        DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField = DOMAIN_SORT_FILD_DEFAULT;
        DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField2 = DOMAIN_SORT_FILD_DEFAULT;
        if (commandLineArguments.isOptionSet(DOMAIN_SIMILARITY_SORT_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(DOMAIN_SIMILARITY_SORT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for domain combinations similarities sorting: -sort=<alpha|max|min|mean|diff|abs_count_diff|count_diff|species|sd>\"");
            }
            if (((String)(object16 = commandLineArguments.getOptionValue(DOMAIN_SIMILARITY_SORT_OPTION).toLowerCase())).equals("alpha")) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object16).equals(DOMAIN_SIMILARITY_SORT_MAX)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MAX;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object16).equals(DOMAIN_SIMILARITY_SORT_MIN)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MIN;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object16).equals(DOMAIN_SIMILARITY_SORT_MEAN)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MEAN;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.MEAN;
            } else if (((String)object16).equals(DOMAIN_SIMILARITY_SORT_SPECIES_COUNT)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.SPECIES_COUNT;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object16).equals(DOMAIN_SIMILARITY_SORT_SD)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.SD;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object16).equals(DOMAIN_SIMILARITY_SORT_DIFF)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE;
            } else if (((String)object16).equals(DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
            } else if (((String)object16).equals(DOMAIN_SIMILARITY_SORT_COUNTS_DIFF)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + (String)object16 + "\" for domain combinations similarities sorting: \"-" + DOMAIN_SIMILARITY_SORT_OPTION + "=<" + "alpha" + "|" + DOMAIN_SIMILARITY_SORT_MAX + "|" + DOMAIN_SIMILARITY_SORT_MIN + "|" + DOMAIN_SIMILARITY_SORT_MEAN + "|" + DOMAIN_SIMILARITY_SORT_DIFF + "|" + DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF + "|" + DOMAIN_SIMILARITY_SORT_COUNTS_DIFF + "|" + "|" + DOMAIN_SIMILARITY_SORT_SPECIES_COUNT + "|" + DOMAIN_SIMILARITY_SORT_SD + ">\"");
            }
        }
        object16 = DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT;
        if (commandLineArguments.isOptionSet(DOMAIN_SIMILARITY_PRINT_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(DOMAIN_SIMILARITY_PRINT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for print option: -detailed_html|simple_html|simple_tab>\"");
            }
            if (((String)(object15 = commandLineArguments.getOptionValue(DOMAIN_SIMILARITY_PRINT_OPTION).toLowerCase())).equals(DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML)) {
                object16 = PrintableDomainSimilarity.PRINT_OPTION.HTML;
            } else if (((String)object15).equals(DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML)) {
                ForesterUtil.fatalError(PRG_NAME, "simple HTML output not implemented yet :(");
            } else if (((String)object15).equals(DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED)) {
                object16 = PrintableDomainSimilarity.PRINT_OPTION.SIMPLE_TAB_DELIMITED;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + (String)object15 + "\" for print option: -" + DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML + "|" + DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML + "|" + DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED + ">\"");
            }
        }
        object15 = DOMAINS_SORT_ORDER_DEFAULT;
        if (commandLineArguments.isOptionSet(DOMAIN_COUNT_SORT_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(DOMAIN_COUNT_SORT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for sorting of domain counts: -dc_sort=<alpha|dom|prot|comb>\"");
            }
            if (((String)(object14 = commandLineArguments.getOptionValue(DOMAIN_COUNT_SORT_OPTION).toLowerCase())).equals("alpha")) {
                object15 = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID;
            } else if (((String)object14).equals(DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT)) {
                object15 = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_COUNT;
            } else if (((String)object14).equals(DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT)) {
                object15 = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_PROTEINS_COUNT;
            } else if (((String)object14).equals(DOMAIN_COUNT_SORT_COMBINATIONS_COUNT)) {
                object15 = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.COMBINATIONS_COUNT;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + (String)object14 + "\" for sorting of domain counts: \"-" + DOMAIN_COUNT_SORT_OPTION + "=<" + "alpha" + "|" + DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT + "|" + DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT + "|" + DOMAIN_COUNT_SORT_COMBINATIONS_COUNT + ">\"");
            }
        }
        object14 = null;
        object14 = stringArray3 != null ? surfacing.processInputFileNames(stringArray3) : surfacing.processInputFileNames(commandLineArguments.getNames());
        int n3 = ((String[][])object14).length;
        if (n3 < 2) {
            ForesterUtil.fatalError(PRG_NAME, "cannot analyze less than two files");
        }
        if (n3 < 3 && bl13) {
            ForesterUtil.fatalError(PRG_NAME, "cannot use : -pwc=<suffix> to turn on pairwise analyses with less than three input files");
        }
        surfacing.checkWriteabilityForPairwiseComparisons((PrintableDomainSimilarity.PRINT_OPTION)((Object)object16), (String[][])object14, string, (File)object19);
        for (int i = 0; i < n3; ++i) {
            object13 = new File((String)object14[i][0] + DOMAIN_COMBINITON_COUNTS_OUTPUTFILE_SUFFIX);
            if (object19 != null) {
                object13 = new File(object19 + ForesterUtil.FILE_SEPARATOR + object13);
            }
            SurfacingUtil.checkForOutputFileWriteability((File)object13);
        }
        File file7 = null;
        object13 = null;
        int n4 = 0;
        if (commandLineArguments.isOptionSet(PFAM_TO_GO_FILE_USE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(PFAM_TO_GO_FILE_USE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for Pfam to GO mapping file: -p2g=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object12 = ForesterUtil.isReadableFile(file7 = new File(commandLineArguments.getOptionValue(PFAM_TO_GO_FILE_USE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read Pfam to GO mapping file: " + (String)object12);
            }
            try {
                list = new PfamToGoParser(file7);
                object11 = ((PfamToGoParser)((Object)list)).parse();
                object13 = SurfacingUtil.createDomainIdToGoIdMap((List<PfamToGoMapping>)object11);
                if (((PfamToGoParser)((Object)list)).getMappingCount() < object13.size()) {
                    ForesterUtil.unexpectedFatalError(PRG_NAME, "parser.getMappingCount() < domain_id_to_go_ids_map.size()");
                }
                n4 = ((PfamToGoParser)((Object)list)).getMappingCount();
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read from Pfam to GO mapping file: " + iOException);
            }
        }
        object12 = null;
        list = null;
        if (commandLineArguments.isOptionSet(GO_OBO_FILE_USE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(GO_OBO_FILE_USE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for GO OBO file: -obo=<file>");
            }
            if (object13 == null || object13.size() < 1) {
                ForesterUtil.fatalError(PRG_NAME, "cannot use GO OBO file (-obo=<file>) without Pfam to GO mapping file (p2g=<file>)");
            }
            if (!ForesterUtil.isEmpty((String)(object11 = ForesterUtil.isReadableFile((File)(object12 = new File(commandLineArguments.getOptionValue(GO_OBO_FILE_USE_OPTION))))))) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read GO OBO file: " + (String)object11);
            }
            try {
                object10 = new OBOparser((File)object12, OBOparser.ReturnType.BASIC_GO_TERM);
                list = ((OBOparser)object10).parse();
                if (((OBOparser)object10).getGoTermCount() != list.size()) {
                    ForesterUtil.unexpectedFatalError(PRG_NAME, "parser.getGoTermCount() != go_terms.size()");
                }
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read from GO OBO file: " + iOException);
            }
        }
        object11 = null;
        if (object13 != null && object13.size() > 0 && list != null && list.size() > 0) {
            object11 = GoUtils.createGoIdToGoTermMap(list);
        }
        object10 = null;
        if (commandLineArguments.isOptionSet(GO_NAMESPACE_LIMIT_OPTION)) {
            String string6;
            if (object11 == null || object11.isEmpty()) {
                ForesterUtil.fatalError(PRG_NAME, "cannot use GO namespace limit (-go_namespace=<namespace>) without Pfam to GO mapping file (p2g=<file>) and GO OBO file (-obo=<file>)");
            }
            if (!commandLineArguments.isOptionValueSet(GO_NAMESPACE_LIMIT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for GO namespace limit: \"-go_namespace=<molecular_function|biological_process|cellular_component>\"");
            }
            if ((string6 = commandLineArguments.getOptionValue(GO_NAMESPACE_LIMIT_OPTION).toLowerCase()).equals(GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION)) {
                object10 = GoNameSpace.createMolecularFunction();
            } else if (string6.equals(GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS)) {
                object10 = GoNameSpace.createBiologicalProcess();
            } else if (string6.equals(GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT)) {
                object10 = GoNameSpace.createCellularComponent();
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + string6 + "\" for GO namespace limit: \"-" + GO_NAMESPACE_LIMIT_OPTION + "=<" + GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION + "|" + GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS + "|" + GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT + ">\"");
            }
        }
        if (domainSimilaritySortField == DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE && n3 > 2) {
            domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
        }
        boolean bl15 = false;
        int n5 = 100;
        double d2 = 0.5;
        long l2 = 19L;
        if (commandLineArguments.isOptionSet(JACKNIFE_OPTION)) {
            if (n3 < 3 || !bl13) {
                ForesterUtil.fatalError(PRG_NAME, "cannot use jacknife resampling analysis (-jack[=<number of resamplings>]) without pairwise analyses (pwc=<suffix for pairwise comparison output files>)");
            }
            bl15 = true;
            if (commandLineArguments.isOptionHasAValue(JACKNIFE_OPTION)) {
                try {
                    n5 = commandLineArguments.getOptionValueAsInt(JACKNIFE_OPTION);
                }
                catch (IOException iOException) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal format for number of resamplings");
                }
                if (n5 < 2) {
                    ForesterUtil.fatalError(PRG_NAME, "attempt to use less than 2 resamplings");
                }
            }
            if (commandLineArguments.isOptionSet(JACKNIFE_RATIO_OPTION) && commandLineArguments.isOptionHasAValue(JACKNIFE_RATIO_OPTION)) {
                try {
                    d2 = commandLineArguments.getOptionValueAsDouble(JACKNIFE_RATIO_OPTION);
                }
                catch (IOException iOException) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal format for jacknife ratio");
                }
                if (d2 <= 0.0 || d2 >= 1.0) {
                    ForesterUtil.fatalError(PRG_NAME, "attempt to use illegal value for jacknife ratio: " + d2);
                }
            }
            if (commandLineArguments.isOptionSet(JACKNIFE_RANDOM_SEED_OPTION) && commandLineArguments.isOptionHasAValue(JACKNIFE_RANDOM_SEED_OPTION)) {
                try {
                    l2 = commandLineArguments.getOptionValueAsLong(JACKNIFE_RANDOM_SEED_OPTION);
                }
                catch (IOException iOException) {
                    ForesterUtil.fatalError(PRG_NAME, "illegal format for random generator seed");
                }
            }
        }
        File[] fileArray = null;
        Phylogeny[] phylogenyArray = null;
        if (commandLineArguments.isOptionSet(INPUT_SPECIES_TREE_OPTION)) {
            String string7;
            if (n3 < 3) {
                ForesterUtil.fatalError(PRG_NAME, "cannot infer gains and losses on input species trees (-species_tree without pairwise analyses (pwc=<suffix for pairwise comparison output files>)");
            }
            if (!commandLineArguments.isOptionValueSet(INPUT_SPECIES_TREE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for input tree: -species_tree=<tree file in phyloXML format>");
            }
            if ((string7 = commandLineArguments.getOptionValue(INPUT_SPECIES_TREE_OPTION)).indexOf("#") > 0) {
                String[] stringArray4 = string7.split("#");
                fileArray = new File[stringArray4.length];
                bl2 = false;
                for (String object92 : stringArray4) {
                    fileArray[bl2++] = new File(object92.trim());
                }
            } else {
                fileArray = new File[]{new File(string7)};
            }
            phylogenyArray = surfacing.getIntrees(fileArray, n3, (String[][])object14);
        }
        long l3 = 0L;
        bl2 = false;
        if (commandLineArguments.isOptionSet(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for random number seed: -random_seed=<seed>");
            }
            try {
                l3 = commandLineArguments.getOptionValueAsLong(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
            }
            bl2 = true;
        }
        String[] stringArray5 = null;
        if (file3 != null || file4 != null || file5 != null) {
            stringArray5 = new TreeSet();
            if (file3 != null) {
                surfacing.processFilter(file3, stringArray5);
            } else if (file4 != null) {
                surfacing.processFilter(file4, stringArray5);
            } else if (file5 != null) {
                surfacing.processFilter(file5, stringArray5);
            }
        }
        Map[] mapArray = null;
        File[] fileArray2 = null;
        File file8 = new File(object19 + ForesterUtil.FILE_SEPARATOR + file + DOMAIN_LENGTHS_ANALYSIS_SUFFIX);
        SurfacingUtil.checkForOutputFileWriteability(file8);
        if (commandLineArguments.isOptionSet(SECONDARY_FEATURES_PARSIMONY_MAP_FILE)) {
            if (!commandLineArguments.isOptionValueSet(SECONDARY_FEATURES_PARSIMONY_MAP_FILE)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for secondary features map file: -secondary=<file>");
            }
            String[] bl16 = commandLineArguments.getOptionValue(SECONDARY_FEATURES_PARSIMONY_MAP_FILE).split("#");
            fileArray2 = new File[bl16.length];
            mapArray = new Map[bl16.length];
            string8 = 0;
            for (String i : bl16) {
                fileArray2[string8] = new File(i);
                object6 = ForesterUtil.isReadableFile(fileArray2[string8]);
                if (!ForesterUtil.isEmpty((String)object6)) {
                    ForesterUtil.fatalError(PRG_NAME, "cannot read secondary features map file: " + (String)object6);
                }
                try {
                    mapArray[string8] = SurfacingUtil.createDomainIdToSecondaryFeaturesMap(fileArray2[string8]);
                }
                catch (IOException iOException) {
                    ForesterUtil.fatalError(PRG_NAME, "cannot read secondary features map file: " + iOException.getMessage());
                }
                catch (Exception exception) {
                    ForesterUtil.fatalError(PRG_NAME, "problem with contents of features map file [" + fileArray2[string8] + "]: " + exception.getMessage());
                }
                ++string8;
            }
        }
        if (object19 == null) {
            ForesterUtil.fatalError(PRG_NAME, "no output directory indicated (-out_dir=<dir>)");
        }
        if (file == null) {
            ForesterUtil.fatalError(PRG_NAME, "no name for (main) output file indicated (-o=<file>)");
        }
        if (object13 == null || object13.isEmpty()) {
            ForesterUtil.fatalError(PRG_NAME, "no (acceptable) Pfam to GO id mapping file provided ('pfam2go file') (-p2g=<file>)");
        }
        if (object11 == null || object11.isEmpty()) {
            ForesterUtil.fatalError(PRG_NAME, "no (acceptable) go id to term mapping file provided ('GO OBO file') (-obo=<file>)");
        }
        boolean bl9 = false;
        if (commandLineArguments.isOptionSet(DISPLAY_M_HISTOGRAMS_OPTION)) {
            bl9 = true;
        }
        System.out.println("Output directory            : " + object19);
        if (stringArray3 != null) {
            System.out.println("Input files names from      : " + file6 + " [" + stringArray3.length + " input files]");
            stringBuilder.append("<tr><td>Input files names from:</td><td>" + file6 + " [" + stringArray3.length + " input files]</td></tr>" + string2);
        }
        if (file3 != null) {
            string8 = stringArray5.size();
            System.out.println("Positive protein filter     : " + file3 + " [" + string8 + " domain ids]");
            stringBuilder.append("<tr><td>Positive protein filter:</td><td>" + file3 + " [" + string8 + " domain ids]</td></tr>" + string2);
        }
        if (file4 != null) {
            string8 = stringArray5.size();
            System.out.println("Negative protein filter     : " + file4 + " [" + string8 + " domain ids]");
            stringBuilder.append("<tr><td>Negative protein filter:</td><td>" + file4 + " [" + string8 + " domain ids]</td></tr>" + string2);
        }
        if (file5 != null) {
            string8 = stringArray5.size();
            System.out.println("Negative domain filter      : " + file5 + " [" + string8 + " domain ids]");
            stringBuilder.append("<tr><td>Negative domain filter:</td><td>" + file5 + " [" + string8 + " domain ids]</td></tr>" + string2);
        }
        if (object18.size() > 0) {
            String file82 = "";
            Object i = object18.iterator();
            while (i.hasNext()) {
                String object23 = (String)i.next();
                file82 = file82 + "+" + object23 + " ";
            }
            i = "";
            for (String string4 : arrayList2) {
                i = (String)i + "*" + string4 + " ";
            }
            Object arrayListArray = "";
            for (String string6 : arrayList3) {
                arrayListArray = (String)arrayListArray + "-" + string6 + " ";
            }
            System.out.println("Plus-minus analysis         : " + (String)i + "&& " + file82 + "&& " + (String)arrayListArray);
            stringBuilder.append("<tr><td>Plus-minus analysis:</td><td>" + (String)i + "&& " + file82 + "&& " + (String)arrayListArray + "</td></tr>" + string2);
        }
        if (file2 != null) {
            System.out.println("Cutoff scores file          : " + file2);
            stringBuilder.append("<tr><td>Cutoff scores file:</td><td>" + file2 + "</td></tr>" + string2);
        }
        if (d >= 0.0) {
            System.out.println("E-value maximum (inclusive) : " + d);
            stringBuilder.append("<tr><td>E-value maximum (inclusive):</td><td>" + d + "</td></tr>" + string2);
        }
        System.out.println("Ignore DUFs                 : " + bl22);
        if (bl6) {
            System.out.println("Ignore virus like ids       : " + bl6);
            stringBuilder.append("<tr><td>Ignore virus, phage, transposition related ids:</td><td>" + bl6 + "</td></tr>" + string2);
        }
        stringBuilder.append("<tr><td>Ignore DUFs:</td><td>" + bl22 + "</td></tr>" + string2);
        if (n2 != -1) {
            System.out.println("Max allowed domain overlap  : " + n2);
            stringBuilder.append("<tr><td>Max allowed domain overlap:</td><td>" + n2 + "</td></tr>" + string2);
        }
        if (bl5) {
            System.out.println("Ignore engulfed domains     : " + bl5);
            stringBuilder.append("<tr><td>Ignore (lower confidence) engulfed domains:</td><td>" + bl5 + "</td></tr>" + string2);
        }
        System.out.println("Ignore singlet domains      : " + bl7);
        stringBuilder.append("<tr><td>Ignore singlet domains for domain combination similarity analyses (not for parsimony analyses):</td><td>" + bl7 + "</td></tr>" + string2);
        System.out.println("Ignore species specific doms: " + bl8);
        stringBuilder.append("<tr><td>Ignore species specific domains for domain combination similarity analyses (not for parsimony analyses):</td><td>" + bl8 + "</td></tr>" + string2);
        System.out.println("Ignore combination with self: " + bl3);
        stringBuilder.append("<tr><td>Ignore combination with self for domain combination similarity analyses:</td><td>" + bl3 + "</td></tr>" + string2);
        System.out.println("Consider directedness       : " + (object20 != BinaryDomainCombination.DomainCombinationType.BASIC));
        stringBuilder.append("<tr><td>Consider directedness of binary domain combinations:</td><td>" + (object20 != BinaryDomainCombination.DomainCombinationType.BASIC) + "</td></tr>" + string2);
        if (object20 != BinaryDomainCombination.DomainCombinationType.BASIC) {
            System.out.println("Consider adjacency          : " + (object20 == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT));
            stringBuilder.append("<tr><td>Consider djacency of binary domain combinations:</td><td>" + (object20 == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) + "</td></tr>" + string2);
        }
        System.out.print("Domain counts sort order    : ");
        switch (1.$SwitchMap$org$forester$surfacing$GenomeWideCombinableDomains$GenomeWideCombinableDomainsSortOrder[((Enum)object15).ordinal()]) {
            case 1: {
                System.out.println("alphabetical");
                break;
            }
            case 2: {
                System.out.println("domain count");
                break;
            }
            case 3: {
                System.out.println("domain proteins count");
                break;
            }
            case 4: {
                System.out.println("domain combinations count");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for dc sort order");
            }
        }
        if (object13 != null) {
            System.out.println("Pfam to GO mappings from    : " + file7 + " [" + n4 + " mappings]");
            stringBuilder.append("<tr><td>Pfam to GO mappings from:</td><td>" + file7 + " [" + n4 + " mappings]" + "</td></tr>" + string2);
        }
        if (list != null) {
            System.out.println("GO terms from               : " + object12 + " [" + list.size() + " terms]");
            stringBuilder.append("<tr><td>GO terms from:</td><td>" + object12 + " [" + list.size() + " terms]" + "</td></tr>" + string2);
        }
        if (object10 != null) {
            System.out.println("Limit GO terms to           : " + ((GoNameSpace)object10).toString());
            stringBuilder.append("<tr><td>Limit GO terms to</td><td>" + object10 + "</td></tr>" + string2);
        }
        if (bl13) {
            System.out.println("Suffix for PWC files        : " + string);
            stringBuilder.append("<tr><td>Suffix for PWC files</td><td>" + string + "</td></tr>" + string2);
        }
        if (object19 != null) {
            System.out.println("Output directory            : " + object19);
        }
        if (string5 != null) {
            System.out.println("Query domains (ordered)     : " + string5);
            stringBuilder.append("<tr><td></td><td>" + string5 + "</td></tr>" + string2);
        }
        System.out.println("Write similarities to       : " + file);
        System.out.print("  Scoring method            : ");
        stringBuilder.append("<tr><td>Scoring method:</td><td>");
        switch (1.$SwitchMap$org$forester$surfacing$DomainSimilarity$DomainSimilarityScoring[((Enum)object17).ordinal()]) {
            case 1: {
                System.out.println("domain combinations based");
                stringBuilder.append("domain combinations based</td></tr>" + string2);
                break;
            }
            case 2: {
                System.out.println("domain counts based");
                stringBuilder.append("domain counts based</td></tr>" + string2);
                break;
            }
            case 3: {
                System.out.println("domain proteins counts based");
                stringBuilder.append("domain proteins counts based</td></tr>" + string2);
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for scoring");
            }
        }
        System.out.print("  Sort by                   : ");
        stringBuilder.append("<tr><td>Sort by:</td><td>");
        switch (domainSimilaritySortField) {
            case MIN: {
                System.out.print("score minimum");
                stringBuilder.append("score minimum");
                break;
            }
            case MAX: {
                System.out.print("score maximum");
                stringBuilder.append("score maximum");
                break;
            }
            case MEAN: {
                System.out.print("score mean");
                stringBuilder.append("score mean");
                break;
            }
            case SD: {
                System.out.print("score standard deviation");
                stringBuilder.append("score standard deviation");
                break;
            }
            case SPECIES_COUNT: {
                System.out.print("species number");
                stringBuilder.append("species number");
                break;
            }
            case DOMAIN_ID: {
                System.out.print("alphabetical domain identifier");
                stringBuilder.append("alphabetical domain identifier");
                break;
            }
            case MAX_DIFFERENCE: {
                System.out.print("(maximal) difference");
                stringBuilder.append("(maximal) difference");
                break;
            }
            case ABS_MAX_COUNTS_DIFFERENCE: {
                System.out.print("absolute (maximal) counts difference");
                stringBuilder.append("absolute (maximal) counts difference");
                break;
            }
            case MAX_COUNTS_DIFFERENCE: {
                System.out.print("(maximal) counts difference");
                stringBuilder.append("(maximal) counts  difference");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for similarities");
            }
        }
        if (bl10) {
            System.out.println(" (sort by species count first)");
            stringBuilder.append(" (sort by species count first)");
        } else {
            System.out.println();
        }
        stringBuilder.append("</td></tr>" + string2);
        System.out.print("  Detailedness              : ");
        switch (detailedness) {
            case BASIC: {
                System.out.println(DETAILEDNESS_BASIC);
                break;
            }
            case LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES: {
                System.out.println("list combining domains for each species");
                break;
            }
            case PUNCTILIOUS: {
                System.out.println(DETAILEDNESS_PUNCTILIOUS);
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for detailedness");
            }
        }
        System.out.print("  Print option              : ");
        switch (1.$SwitchMap$org$forester$surfacing$PrintableDomainSimilarity$PRINT_OPTION[((Enum)object16).ordinal()]) {
            case 1: {
                System.out.println("HTML");
                break;
            }
            case 2: {
                System.out.println("simple tab delimited");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for print option");
            }
        }
        System.out.print("  Species matrix            : " + bl11);
        System.out.println();
        File file9 = new File(object19 + ForesterUtil.FILE_SEPARATOR + file + DATA_FILE_SUFFIX);
        System.out.println("Domain comb data output     : " + file9);
        stringBuilder.append("<tr><td>Domain combination data output:</td><td> " + file9 + " </td></tr>");
        System.out.println();
        if (bl13) {
            System.out.println("Pairwise comparisons: ");
            stringBuilder.append("<tr><td>Pairwise comparisons:</td><td></td></tr>");
            System.out.print("  Sort by                   : ");
            stringBuilder.append("<tr><td>Sort by:</td><td>");
            switch (domainSimilaritySortField2) {
                case MEAN: {
                    System.out.print("score mean");
                    stringBuilder.append("score mean");
                    break;
                }
                case DOMAIN_ID: {
                    System.out.print("alphabetical domain identifier");
                    stringBuilder.append("alphabetical domain identifier");
                    break;
                }
                case MAX_DIFFERENCE: {
                    System.out.print("difference");
                    stringBuilder.append("difference");
                    break;
                }
                case ABS_MAX_COUNTS_DIFFERENCE: {
                    System.out.print("absolute counts difference");
                    stringBuilder.append("absolute counts difference");
                    break;
                }
                case MAX_COUNTS_DIFFERENCE: {
                    System.out.print("counts difference");
                    stringBuilder.append("counts difference");
                    break;
                }
                default: {
                    ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for similarities");
                }
            }
            System.out.println();
            stringBuilder.append("</td></tr>" + string2);
            if (bl15) {
                stringBuilder.append("<tr><td>Jacknife:</td><td>" + n5 + " resamplings</td></tr>" + string2);
                stringBuilder.append("<tr><td>Jacknife ratio:</td><td>" + ForesterUtil.round(d2, 2) + "</td></tr>" + string2);
                stringBuilder.append("<tr><td>Jacknife random number seed:</td><td>" + l2 + "</td></tr>" + string2);
                System.out.println("  Jacknife                  : " + n5 + " resamplings");
                System.out.println("    Ratio                   : " + ForesterUtil.round(d2, 2));
                System.out.println("    Random number seed      : " + l2);
            }
            if (phylogenyArray != null && phylogenyArray.length > 0) {
                for (File file10 : fileArray) {
                    stringBuilder.append("<tr><td>Intree for gain/loss parsimony analysis:</td><td>" + file10 + "</td></tr>" + string2);
                    System.out.println("  Intree for gain/loss pars.: " + file10);
                }
            }
            if (bl2) {
                stringBuilder.append("<tr><td>    Random number seed for Fitch parsimony analysis:</td><td>" + l3 + "</td></tr>" + string2);
                System.out.println("    Random number seed      : " + l3);
            }
            if (mapArray != null && mapArray.length > 0) {
                for (int bufferedWriterArray = 0; bufferedWriterArray < fileArray2.length; ++bufferedWriterArray) {
                    stringBuilder.append("<tr><td>Secondary features map file:</td><td>" + fileArray2[bufferedWriterArray] + "</td></tr>" + string2);
                    System.out.println("Secondary features map file : " + fileArray2[bufferedWriterArray] + " [mappings for " + mapArray[bufferedWriterArray].size() + " domain ids]");
                }
            }
        }
        System.out.println();
        stringBuilder.append("<tr><td>Command line:</td><td>" + commandLineArguments.getCommandLineArgsAsString() + "</td></tr>" + string2);
        System.out.println("Command line                : " + commandLineArguments.getCommandLineArgsAsString());
        BufferedWriter[] bufferedWriterArray = null;
        ArrayList[] arrayListArray = null;
        if (string5 != null) {
            void var74_108;
            String[] treeMap = string5.split("#");
            arrayListArray = new ArrayList[treeMap.length];
            bufferedWriterArray = new BufferedWriter[treeMap.length];
            boolean bl16 = false;
            while (var74_108 < treeMap.length) {
                void var78_116;
                object6 = treeMap[var74_108];
                stringArray2 = ((String)object6).split("~");
                abstractCollection = new ArrayList();
                for (String string7 : stringArray2) {
                    abstractCollection.add((DomainId)new DomainId(string7));
                }
                arrayListArray[var74_108] = abstractCollection;
                object6 = ((String)object6).replace('~', '_');
                String string9 = (String)object6 + SEQ_EXTRACT_SUFFIX;
                if (object19 != null) {
                    String string10 = object19 + ForesterUtil.FILE_SEPARATOR + string9;
                }
                try {
                    bufferedWriterArray[var74_108] = new BufferedWriter(new FileWriter((String)var78_116));
                }
                catch (IOException iOException) {
                    ForesterUtil.fatalError(PRG_NAME, "Could not open [" + (String)var78_116 + "]: " + iOException.getLocalizedMessage());
                }
                ++var74_108;
            }
        }
        TreeMap<Species, List<Protein>> treeMap = null;
        boolean bl17 = false;
        if (object18.size() > 0 || bl12) {
            bl = true;
        }
        if (bl) {
            treeMap = new TreeMap<Species, List<Protein>>();
        }
        object6 = new ArrayList(n3);
        stringArray2 = new TreeSet();
        abstractCollection = new TreeSet();
        Object var78_120 = null;
        ArrayList<BinaryDomainCombination> arrayList5 = null;
        if (phylogenyArray != null && phylogenyArray.length == 1) {
            ArrayList arrayList6 = new ArrayList();
            arrayList5 = new ArrayList<BinaryDomainCombination>();
        }
        DomainLengthsTable domainLengthsTable = new DomainLengthsTable();
        File file11 = new File(object19 + ForesterUtil.FILE_SEPARATOR + file + D_PROMISCUITY_FILE_SUFFIX);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file11));
            bufferedWriter.write("Species:\t");
            bufferedWriter.write("Mean:\t");
            bufferedWriter.write("SD:\t");
            bufferedWriter.write("Median:\t");
            bufferedWriter.write("Min:\t");
            bufferedWriter.write("Max:\t");
            bufferedWriter.write("N:\t");
            bufferedWriter.write("Max Promiscuous Domains:" + ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        File file12 = new File(object19 + ForesterUtil.FILE_SEPARATOR + file + LOG_FILE_SUFFIX);
        BufferedWriter bufferedWriter2 = null;
        try {
            bufferedWriter2 = new BufferedWriter(new FileWriter(file12));
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        BufferedWriter bufferedWriter3 = null;
        try {
            bufferedWriter3 = new BufferedWriter(new FileWriter(file9));
            bufferedWriter3.write(DATA_FILE_DESC);
            bufferedWriter3.write(ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        for (int i = 0; i < n3; ++i) {
            System.out.println();
            System.out.println(i + 1 + "/" + n3);
            surfacing.log(i + 1 + "/" + n3, bufferedWriter2);
            System.out.println("Processing                                     : " + (String)object14[i][0]);
            surfacing.log("Genome                                         : " + (String)object14[i][0], bufferedWriter2);
            HmmscanPerDomainTableParser hmmscanPerDomainTableParser = null;
            object5 = HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF.NONE;
            if (map != null) {
                object5 = INDIVIDUAL_SCORE_CUTOFF_DEFAULT;
            }
            if (file3 != null || file4 != null || file5 != null) {
                object4 = HmmscanPerDomainTableParser.FilterType.NONE;
                if (file3 != null) {
                    object4 = HmmscanPerDomainTableParser.FilterType.POSITIVE_PROTEIN;
                } else if (file4 != null) {
                    object4 = HmmscanPerDomainTableParser.FilterType.NEGATIVE_PROTEIN;
                } else if (file5 != null) {
                    object4 = HmmscanPerDomainTableParser.FilterType.NEGATIVE_DOMAIN;
                }
                hmmscanPerDomainTableParser = new HmmscanPerDomainTableParser(new File((String)object14[i][0]), (String)object14[i][1], (Set<DomainId>)stringArray5, (HmmscanPerDomainTableParser.FilterType)((Object)object4), (HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF)((Object)object5));
            } else {
                hmmscanPerDomainTableParser = new HmmscanPerDomainTableParser(new File((String)object14[i][0]), (String)object14[i][1], (HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF)((Object)object5));
            }
            if (d >= 0.0) {
                hmmscanPerDomainTableParser.setEValueMaximum(d);
            }
            hmmscanPerDomainTableParser.setIgnoreDufs(bl22);
            hmmscanPerDomainTableParser.setIgnoreVirusLikeIds(bl6);
            hmmscanPerDomainTableParser.setIgnoreEngulfedDomains(bl5);
            if (n2 != -1) {
                hmmscanPerDomainTableParser.setMaxAllowedOverlap(n2);
            }
            hmmscanPerDomainTableParser.setReturnType(HmmscanPerDomainTableParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            if (map != null) {
                hmmscanPerDomainTableParser.setIndividualScoreCutoffs(map);
            }
            object4 = null;
            try {
                object4 = hmmscanPerDomainTableParser.parse();
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
            }
            catch (Exception exception) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, exception.getMessage(), exception);
            }
            System.out.println("Number of proteins encountered                 : " + hmmscanPerDomainTableParser.getProteinsEncountered());
            surfacing.log("Number of proteins encountered                 : " + hmmscanPerDomainTableParser.getProteinsEncountered(), bufferedWriter2);
            System.out.println("Number of proteins stored                      : " + object4.size());
            surfacing.log("Number of proteins stored                      : " + object4.size(), bufferedWriter2);
            System.out.println("Domains encountered                            : " + hmmscanPerDomainTableParser.getDomainsEncountered());
            surfacing.log("Domains encountered                            : " + hmmscanPerDomainTableParser.getDomainsEncountered(), bufferedWriter2);
            System.out.println("Domains stored                                 : " + hmmscanPerDomainTableParser.getDomainsStored());
            surfacing.log("Domains stored                                 : " + hmmscanPerDomainTableParser.getDomainsStored(), bufferedWriter2);
            System.out.println("Distinct domains stored                        : " + hmmscanPerDomainTableParser.getDomainsStoredSet().size());
            surfacing.log("Distinct domains stored                        : " + hmmscanPerDomainTableParser.getDomainsStoredSet().size(), bufferedWriter2);
            System.out.println("Domains ignored due to individual score cutoffs: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToIndividualScoreCutoff());
            surfacing.log("Domains ignored due to individual score cutoffs: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToIndividualScoreCutoff(), bufferedWriter2);
            System.out.println("Domains ignored due to E-value                 : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToEval());
            surfacing.log("Domains ignored due to E-value                 : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToEval(), bufferedWriter2);
            System.out.println("Domains ignored due to DUF designation         : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToDuf());
            surfacing.log("Domains ignored due to DUF designation         : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToDuf(), bufferedWriter2);
            if (bl6) {
                System.out.println("Domains ignored due virus like ids             : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToVirusLikeIds());
                surfacing.log("Domains ignored due virus like ids             : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToVirusLikeIds(), bufferedWriter2);
            }
            System.out.println("Domains ignored due negative domain filter     : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToNegativeDomainFilter());
            surfacing.log("Domains ignored due negative domain filter     : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToNegativeDomainFilter(), bufferedWriter2);
            System.out.println("Domains ignored due to overlap                 : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToOverlap());
            surfacing.log("Domains ignored due to overlap                 : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToOverlap(), bufferedWriter2);
            if (file4 != null) {
                System.out.println("Proteins ignored due to negative filter        : " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter());
                surfacing.log("Proteins ignored due to negative filter        : " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter(), bufferedWriter2);
            }
            if (file3 != null) {
                System.out.println("Proteins ignored due to positive filter        : " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter());
                surfacing.log("Proteins ignored due to positive filter        : " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter(), bufferedWriter2);
            }
            System.out.println("Time for processing                            : " + hmmscanPerDomainTableParser.getTime() + "ms");
            surfacing.log("", bufferedWriter2);
            stringBuilder.append("<tr><td>" + (String)object14[i][0] + " [species: " + (String)object14[i][1] + "]" + ":</td><td>domains analyzed: " + hmmscanPerDomainTableParser.getDomainsStored() + "; domains ignored: [ind score cutoffs: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToIndividualScoreCutoff() + "] [E-value cutoff: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToEval() + "] [DUF: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToDuf() + "] [virus like ids: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToVirusLikeIds() + "] [negative domain filter: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToNegativeDomainFilter() + "] [overlap: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToOverlap() + "]");
            if (file4 != null) {
                stringBuilder.append("; proteins ignored due to negative filter: " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter());
            }
            if (file3 != null) {
                stringBuilder.append("; proteins ignored due to positive filter: " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter());
            }
            stringBuilder.append("</td></tr>" + string2);
            try {
                int n = 0;
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (Protein)object3.next();
                    bufferedWriter3.write(SurfacingUtil.proteinToDomainCombinations((Protein)object2, n + "", "\t").toString());
                    ++n;
                }
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.toString());
            }
            object6.add(BasicGenomeWideCombinableDomains.createInstance((List<Protein>)object4, bl3, new BasicSpecies((String)object14[i][1]), (Map<DomainId, List<GoId>>)object13, object20));
            domainLengthsTable.addLengths((List<Protein>)object4);
            if (((GenomeWideCombinableDomains)object6.get(i)).getSize() > 0) {
                SurfacingUtil.writeDomainCombinationsCountsFile((String[][])object14, (File)object19, bufferedWriter, (GenomeWideCombinableDomains)object6.get(i), i, (GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder)((Object)object15));
                if (bl4) {
                    SurfacingUtil.writeBinaryDomainCombinationsFileForGraphAnalysis((String[][])object14, (File)object19, (GenomeWideCombinableDomains)object6.get(i), i, (GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder)((Object)object15));
                }
                SurfacingUtil.addAllDomainIdsToSet((GenomeWideCombinableDomains)object6.get(i), (SortedSet<DomainId>)stringArray2);
                SurfacingUtil.addAllBinaryDomainCombinationToSet((GenomeWideCombinableDomains)object6.get(i), (SortedSet<BinaryDomainCombination>)((Object)abstractCollection));
            }
            if (bufferedWriterArray != null) {
                for (int j = 0; j < arrayListArray.length; ++j) {
                    try {
                        SurfacingUtil.extractProteinNames((List<Protein>)object4, arrayListArray[j], (Writer)bufferedWriterArray[j], "\t");
                        bufferedWriterArray[j].flush();
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            if (bl) {
                treeMap.put(new BasicSpecies((String)object14[i][1]), (List<Protein>)object4);
            }
            try {
                bufferedWriter2.flush();
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
            }
            System.gc();
        }
        try {
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedWriter3.flush();
            bufferedWriter3.close();
            bufferedWriter2.flush();
            bufferedWriter2.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
        }
        ForesterUtil.programMessage(PRG_NAME, "Wrote domain promiscuities to: " + file11);
        if (bufferedWriterArray != null) {
            for (int i = 0; i < arrayListArray.length; ++i) {
                try {
                    bufferedWriterArray[i].close();
                    continue;
                }
                catch (IOException iOException) {
                    ForesterUtil.fatalError(PRG_NAME, iOException.toString());
                }
            }
        }
        try {
            SurfacingUtil.executeDomainLengthAnalysis((String[][])object14, n3, domainLengthsTable, file8);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.toString());
        }
        System.out.println();
        ForesterUtil.programMessage(PRG_NAME, "Wrote domain length data to: " + file8);
        System.out.println();
        long l4 = new Date().getTime();
        object5 = null;
        object4 = new BasicDomainSimilarityCalculator(domainSimilaritySortField, bl10, n3 == 2);
        switch (1.$SwitchMap$org$forester$surfacing$DomainSimilarity$DomainSimilarityScoring[((Enum)object17).ordinal()]) {
            case 1: {
                object5 = new CombinationsBasedPairwiseDomainSimilarityCalculator();
                break;
            }
            case 2: {
                object5 = new DomainCountsBasedPairwiseSimilarityCalculator();
                break;
            }
            case 3: {
                object5 = new ProteinCountsBasedPairwiseDomainSimilarityCalculator();
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for scoring");
            }
        }
        DomainSimilarityCalculator.GoAnnotationOutput goAnnotationOutput = DomainSimilarityCalculator.GoAnnotationOutput.NONE;
        if (object13 != null) {
            goAnnotationOutput = DomainSimilarityCalculator.GoAnnotationOutput.ALL;
        }
        object3 = object4.calculateSimilarities((PairwiseDomainSimilarityCalculator)object5, (List<GenomeWideCombinableDomains>)object6, bl7, bl8);
        SurfacingUtil.decoratePrintableDomainSimilarities(object3, detailedness, goAnnotationOutput, (Map<GoId, GoTerm>)object11, (GoNameSpace)object10);
        object2 = null;
        try {
            speciesArray = file.toString();
            if (!speciesArray.endsWith(".html")) {
                speciesArray = (String)speciesArray + ".html";
            }
            BufferedWriter bufferedWriter4 = new BufferedWriter(new FileWriter((String)(object19 == null ? speciesArray : object19 + ForesterUtil.FILE_SEPARATOR + (String)speciesArray)));
            object = null;
            if (bl11) {
                object = new ArrayList<BasicSpecies>();
                for (int i = 0; i < n3; ++i) {
                    object.add(new BasicSpecies((String)object14[i][1]));
                }
            }
            stringBuilder.append("<tr><td>Sum of all distinct binary combinations:</td><td>" + abstractCollection.size() + "</td></tr>" + string2);
            stringBuilder.append("<tr><td>Sum of all distinct domains:</td><td>" + stringArray2.size() + "</td></tr>" + string2);
            stringBuilder.append("<tr><td>Analysis date/time:</td><td>" + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(new Date()) + "</td></tr>" + string2);
            stringBuilder.append("</table>" + string2);
            object2 = SurfacingUtil.writeDomainSimilaritiesToFile(stringBuilder, new StringBuilder(n3 + " genomes"), bufferedWriter4, object3, n3 == 2, (List<Species>)object, (PrintableDomainSimilarity.PRINT_OPTION)((Object)object16), domainSimilaritySortField, (DomainSimilarity.DomainSimilarityScoring)((Object)object17), true);
            ForesterUtil.programMessage(PRG_NAME, "Wrote main output (includes domain similarities) to: \"" + (String)(object19 == null ? speciesArray : object19 + ForesterUtil.FILE_SEPARATOR + (String)speciesArray) + "\"");
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write similarites to: \"" + file + "\" [" + iOException.getMessage() + "]");
        }
        System.out.println();
        speciesArray = new Species[n3];
        for (int i = 0; i < n3; ++i) {
            speciesArray[i] = new BasicSpecies((String)object14[i][1]);
        }
        ArrayList<Phylogeny> arrayList7 = null;
        if (n3 > 2 && bl13) {
            object = new PairwiseGenomeComparator();
            ((PairwiseGenomeComparator)object).performPairwiseComparisons(stringBuilder, bl10, detailedness, bl7, bl8, domainSimilaritySortField2, (PrintableDomainSimilarity.PRINT_OPTION)((Object)object16), (DomainSimilarity.DomainSimilarityScoring)((Object)object17), (Map<DomainId, List<GoId>>)object13, (Map<GoId, GoTerm>)object11, (GoNameSpace)object10, speciesArray, n3, (List<GenomeWideCombinableDomains>)object6, (PairwiseDomainSimilarityCalculator)object5, string, true, PAIRWISE_DOMAIN_COMPARISONS_PREFIX, PRG_NAME, bl9, (File)object19, bl14);
            String string11 = new String(file.toString());
            if (string11.indexOf(46) > 1) {
                string11 = string11.substring(0, string11.indexOf(46));
            }
            if (object19 != null) {
                string11 = object19 + ForesterUtil.FILE_SEPARATOR + string11;
                file = new File(object19 + ForesterUtil.FILE_SEPARATOR + file);
            }
            SurfacingUtil.writeMatrixToFile(new File(string11 + MATRIX_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)object).getDomainDistanceScoresMeans());
            SurfacingUtil.writeMatrixToFile(new File(string11 + MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)object).getSharedBinaryCombinationsBasedDistances());
            SurfacingUtil.writeMatrixToFile(new File(string11 + MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)object).getSharedDomainsBasedDistances());
            Phylogeny phylogeny = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File(string11 + NJ_TREE_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)object).getDomainDistanceScoresMeans().get(0));
            Phylogeny phylogeny2 = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File(string11 + NJ_TREE_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)object).getSharedBinaryCombinationsBasedDistances().get(0));
            Phylogeny phylogeny3 = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File(string11 + NJ_TREE_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)object).getSharedDomainsBasedDistances().get(0));
            arrayList7 = new ArrayList<Phylogeny>();
            arrayList7.add(phylogeny);
            arrayList7.add(phylogeny2);
            arrayList7.add(phylogeny3);
            if (bl15) {
                ((PairwiseGenomeComparator)object).performPairwiseComparisonsJacknifed(speciesArray, n3, (List<GenomeWideCombinableDomains>)object6, true, n5, d2, l2);
                SurfacingUtil.writeMatrixToFile(new File(string11 + "_" + ForesterUtil.round(d2, 2) + "_" + n5 + MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)object).getSharedBinaryCombinationsBasedDistances());
                SurfacingUtil.writeMatrixToFile(new File(string11 + "_" + ForesterUtil.round(d2, 2) + "_" + n5 + MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)object).getSharedDomainsBasedDistances());
            }
            if (bl9) {
                // empty if block
            }
        }
        if (object19 != null && !bl13) {
            file = new File(object19 + ForesterUtil.FILE_SEPARATOR + file);
        }
        surfacing.writePresentToNexus(file, file3, (SortedSet<DomainId>)stringArray5, (List<GenomeWideCombinableDomains>)object6);
        if (phylogenyArray != null && phylogenyArray.length > 0 && n3 > 2) {
            object = surfacing.createParametersAsString(bl22, d, n2, bl5, file2, object20);
            String string12 = "_";
            if (bl2) {
                string12 = string12 + l3 + "_";
            }
            int n = 0;
            for (Phylogeny phylogeny : phylogenyArray) {
                String string13 = ForesterUtil.removeSuffix(file.toString()) + string12 + ForesterUtil.removeSuffix(fileArray[n].toString());
                DomainParsimonyCalculator domainParsimonyCalculator = DomainParsimonyCalculator.createInstance(phylogeny, (List<GenomeWideCombinableDomains>)object6);
                SurfacingUtil.executeParsimonyAnalysis(l3, bl2, string13, domainParsimonyCalculator, phylogeny, (Map<DomainId, List<GoId>>)object13, (Map<GoId, GoTerm>)object11, (GoNameSpace)object10, ((StringBuilder)object).toString(), mapArray, (SortedSet<DomainId>)(file3 == null ? null : stringArray5), bl4, (List<BinaryDomainCombination>)var78_122, arrayList5, object20);
                if (mapArray != null && mapArray.length > 0) {
                    int n6 = 0;
                    for (Map map2 : mapArray) {
                        TreeMap<Species, MappingResults> treeMap2 = new TreeMap<Species, MappingResults>();
                        DomainParsimonyCalculator domainParsimonyCalculator2 = DomainParsimonyCalculator.createInstance(phylogeny, (List<GenomeWideCombinableDomains>)object6, map2);
                        SurfacingUtil.executeParsimonyAnalysisForSecondaryFeatures(string13 + "_" + fileArray2[n6++], domainParsimonyCalculator2, phylogeny, ((StringBuilder)object).toString(), treeMap2);
                        if (n != 0) continue;
                        System.out.println();
                        System.out.println("Mapping to secondary features:");
                        for (Species species : treeMap2.keySet()) {
                            MappingResults mappingResults = (MappingResults)treeMap2.get(species);
                            int n7 = mappingResults.getSumOfFailures() + mappingResults.getSumOfSuccesses();
                            System.out.print(species + ":");
                            System.out.print(" mapped domains = " + mappingResults.getSumOfSuccesses());
                            System.out.print(", not mapped domains = " + mappingResults.getSumOfFailures());
                            if (n7 > 0) {
                                System.out.println(", mapped ratio = " + 100 * mappingResults.getSumOfSuccesses() / n7 + "%");
                                continue;
                            }
                            System.out.println(", mapped ratio = n/a (total domains = 0 )");
                        }
                    }
                }
                ++n;
            }
        }
        if (object18.size() > 0) {
            surfacing.executePlusMinusAnalysis(file, (List<String>)object18, arrayList2, arrayList3, (List<GenomeWideCombinableDomains>)object6, treeMap, (Map<DomainId, List<GoId>>)object13, (Map<GoId, GoTerm>)object11, arrayList4);
        }
        if (bl12) {
            surfacing.writeProteinListsForAllSpecies((File)object19, treeMap, (List<GenomeWideCombinableDomains>)object6);
        }
        if (var78_122 != null) {
            try {
                surfacing.executeFitchGainsAnalysis(new File(file + OUTPUT_DOMAIN_COMBINATIONS_GAINED_MORE_THAN_ONCE_ANALYSIS_SUFFIX), (List<BinaryDomainCombination>)var78_122, stringArray2.size(), (SortedSet<BinaryDomainCombination>)((Object)abstractCollection), true);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
            }
        }
        if (arrayList5 != null) {
            try {
                surfacing.executeFitchGainsAnalysis(new File(file + OUTPUT_DOMAIN_COMBINATIONS_LOST_MORE_THAN_ONCE_ANALYSIS_SUFFIX), arrayList5, stringArray2.size(), (SortedSet<BinaryDomainCombination>)((Object)abstractCollection), false);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
            }
        }
        object = Runtime.getRuntime();
        long l5 = ((Runtime)object).freeMemory() / 1000000L;
        long l6 = ((Runtime)object).totalMemory() / 1000000L;
        System.out.println();
        System.out.println("Time for analysis : " + (new Date().getTime() - l4) + "ms");
        System.out.println("Total running time: " + (new Date().getTime() - l) + "ms ");
        System.out.println("Free memory       : " + l5 + "MB, total memory: " + l6 + "MB");
        System.out.println();
        System.out.println("If this application is useful to you, please cite:");
        System.out.println(WWW);
        System.out.println();
        ForesterUtil.programMessage(PRG_NAME, "OK");
        System.out.println();
    }

    private static void preparePhylogenyForParsimonyAnalyses(Phylogeny phylogeny, String[][] stringArray) {
        int n;
        String[] stringArray2 = new String[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            if (phylogeny.getNodes(stringArray[n][1]).size() > 1) {
                ForesterUtil.fatalError(PRG_NAME, "node named [" + stringArray[n][1] + "] is not unique in input tree " + phylogeny.getName());
            }
            stringArray2[n] = stringArray[n][1];
        }
        PhylogenyMethods.deleteExternalNodesPositiveSelection(stringArray2, phylogeny);
        for (n = 0; n < stringArray.length; ++n) {
            try {
                phylogeny.getNode(stringArray[n][1]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ForesterUtil.fatalError(PRG_NAME, "node named [" + stringArray[n][1] + "] not present/not unique in input tree");
            }
        }
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println();
        System.out.println("% java -Xms256m -Xmx512m -cp forester.jar org.forester.applications.surfacing [options] <phylogen(y|ies) infile> [external node name 1] [name 2] ... [name n]");
        System.out.println();
        System.out.println(" Note: This software might need a significant amount of memory (heap space);");
        System.out.println("       hence use \"-Xms128m -Xmx512m\" (or more) to prevent a \"java.lang.OutOfMemoryError\".");
        System.out.println();
        System.out.println(" Options: ");
        System.out.println("detail: level of detail for similarities output file (default:" + (Object)((Object)DETAILEDNESS_DEFAULT) + ")");
        System.out.println("ignore_self_comb: to ignore combinations with self (default: not to ignore)");
        System.out.println("ignore_singlet_domains: to ignore domains without combinations in any species (for similarity calc purposes, not for parsimony analyses) (default: not to ignore)");
        System.out.println("ignore_species_specific_domains: to ignore domains specific to one species (for similarity calc purposes, not for parsimony analyses) (default: not to ignore)");
        System.out.println("dufs: to _not_ ignore DUFs (domains with unknown function) (default: ignore DUFs)");
        System.out.println("ignore_viral_ids: to ignore domains with ids containing 'vir', 'retro', 'transpos', 'phage', or starting with 'rv' or 'gag_'");
        System.out.println("sort: sorting for similarities (default: " + (Object)((Object)DOMAIN_SORT_FILD_DEFAULT) + ")");
        System.out.println("o: name for (main) output file (mandatory)");
        System.out.println("e: max (inclusive) E-value");
        System.out.println("mo: maximal allowed domain overlap");
        System.out.println("no_eo: to ignore engulfed lower confidence domains");
        System.out.println("smatrix: species matrix");
        System.out.println("scoring: scoring (default:" + (Object)((Object)SCORING_DEFAULT) + ")");
        System.out.println("dc_sort: sorting for domain counts (default:" + (Object)((Object)DOMAINS_SORT_ORDER_DEFAULT) + ")");
        System.out.println("ds_output: domain similarity print option (default:" + (Object)((Object)DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT) + ")");
        System.out.println("cos: cutoff score file");
        System.out.println("species_first: sort by species count first");
        System.out.println("out_dir: output directory");
        System.out.println("p2g: Pfam to GO mapping file");
        System.out.println("obo: GO terms file (OBO format)");
        System.out.println("go_namespace: limit GO term to one GO namespace");
        System.out.println("pwc[=<suffix for pairwise comparison output files>]: to perform pairwise comparison based analyses");
        System.out.println("species_tree: species tree, to perform (Dollo, Fitch) parismony analyses");
        System.out.println("mhisto: to display multiple histograms (using fluorite)");
        System.out.println("jack: perform jacknife resampling for domain and binary domain combination based distance matrices [default resamplings: 100]");
        System.out.println("jack_ratio: ratio for jacknife resampling [default: 0.5]");
        System.out.println("seed: seed for random number generator for jacknife resampling [default: 19]");
        System.out.println("species_tree=<treefiles in phyloXML format, separated by #>: to infer domain/binary domain combination gains/losses on given species trees");
        System.out.println("pos_filter=<file>: to filter out proteins not containing at least one domain listed in <file>");
        System.out.println("neg_filter=<file>: to filter out proteins containing at least one domain listed in <file>");
        System.out.println("neg_dom_filter=<file>: to filter out (ignore) domains listed in <file>");
        System.out.println("input=<file>: to read input files from <file>");
        System.out.println("random_seed=<seed>: seed for random number generator for Fitch Parsimony analysis (type: long, default: no randomization - given a choice, prefer absence");
        System.out.println("consider_bdc_direction: to consider directedness in binary combinations: e.g. A-B != B-A");
        System.out.println("consider_bdc_adj: to consider directedness and adjacency in binary combinations");
        System.out.println("prot_extract=<domain ids (Pfam names)>: to extract sequence names of sequences containing matching domains and/or domain-sequences (order N to C) (domain separator: '~', domain sequences speparator: '#', e.g. 'NACHT#BIR~CARD')");
        System.out.println("secondary=<file>: to perfom parsimony analysis on secondary features");
        System.out.println("plus_minus=<file>: to presence/absence genome analysis");
        System.out.println("graph_analysis_out: to output binary domain combinations for (downstream) graph analysis");
        System.out.println("all_prot: to output all proteins per domain");
        System.out.println();
        System.out.println();
        System.out.println("Example: java -Xms128m -Xmx512m -cp path/to/forester.jarorg.forester.application.surfacing -detail=punctilious -o=TEST.html -pwc=TEST -cos=Pfam_ls_22_TC2 -p2g=pfam2go -obo=gene_ontology_edit.obo -dc_sort=dom -ignore_with_self -no_singles -e=0.001 -mo=1 -no_eo -ds_output=detailed_html -scoring=domains -sort=alpha -jack=50 human mouse brafl strpu");
        System.out.println();
    }

    private static void processFilter(File file, SortedSet<DomainId> sortedSet) {
        SortedSet<String> sortedSet2 = null;
        try {
            sortedSet2 = ForesterUtil.file2set(file);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        if (sortedSet2 != null) {
            for (String string : sortedSet2) {
                sortedSet.add(new DomainId(string));
            }
        }
    }

    private static String[][] processInputFileNames(String[] stringArray) {
        String[][] stringArray2 = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(35) < 0) {
                stringArray2[i] = new String[2];
                stringArray2[i][0] = stringArray[i];
                stringArray2[i][1] = stringArray[i];
            } else {
                stringArray2[i] = stringArray[i].split("#");
                if (stringArray2[i].length != 3) {
                    ForesterUtil.fatalError(PRG_NAME, "properties for the input files (hmmpfam output) are expected to be in the following format \"<hmmpfam output file>#<species>\" (or just one word, which is both the filename and the species id), instead received \"" + stringArray[i] + "\"");
                }
            }
            String string = ForesterUtil.isReadableFile(new File(stringArray2[i][0]));
            if (ForesterUtil.isEmpty(string)) continue;
            ForesterUtil.fatalError(PRG_NAME, string);
        }
        return stringArray2;
    }

    private static void processPlusMinusAnalysisOption(CommandLineArguments commandLineArguments, List<String> list, List<String> list2, List<String> list3, List<Object> list4) {
        if (commandLineArguments.isOptionSet(PLUS_MINUS_ANALYSIS_OPTION)) {
            File file;
            String string;
            if (!commandLineArguments.isOptionValueSet(PLUS_MINUS_ANALYSIS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for 'plus-minus' file: -plus_minus=<file>");
            }
            if (!ForesterUtil.isEmpty(string = ForesterUtil.isReadableFile(file = new File(commandLineArguments.getOptionValue(PLUS_MINUS_ANALYSIS_OPTION))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file + "\": " + string);
            }
            surfacing.processPlusMinusFile(file, list, list2, list3, list4);
        }
    }

    private static void processPlusMinusFile(File file, List<String> list, List<String> list2, List<String> list3, List<Object> list4) {
        SortedSet<String> sortedSet = null;
        int n = 0;
        double d = 1.0;
        try {
            sortedSet = ForesterUtil.file2set(file);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        if (sortedSet != null) {
            for (String string : sortedSet) {
                String string2 = string.substring(1);
                if (string.startsWith("+")) {
                    if (list3.contains(string2)) {
                        ForesterUtil.fatalError(PRG_NAME, "species/genome names can not appear with both '+' and '-' suffix, as appears the case for: \"" + string2 + "\"");
                    }
                    list.add(string2);
                } else if (string.startsWith("*")) {
                    if (list3.contains(string2)) {
                        ForesterUtil.fatalError(PRG_NAME, "species/genome names can not appear with both '*' and '-' suffix, as appears the case for: \"" + string2 + "\"");
                    }
                    list2.add(string2);
                } else if (string.startsWith("-")) {
                    if (list.contains(string2) || list2.contains(string2)) {
                        ForesterUtil.fatalError(PRG_NAME, "species/genome names can not appear with both '+' or '*' and '-' suffix, as appears the case for: \"" + string2 + "\"");
                    }
                    list3.add(string2);
                } else if (string.startsWith("$D")) {
                    try {
                        n = Integer.parseInt(string.substring(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ForesterUtil.fatalError(PRG_NAME, "could not parse integer value for minimal difference from: \"" + string.substring(3) + "\"");
                    }
                } else if (string.startsWith("$F")) {
                    try {
                        d = Double.parseDouble(string.substring(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ForesterUtil.fatalError(PRG_NAME, "could not parse double value for factor from: \"" + string.substring(3) + "\"");
                    }
                } else if (!string.startsWith("#")) {
                    ForesterUtil.fatalError(PRG_NAME, "species/genome names in 'plus minus' file must begin with '*' (high copy target genome), '+' (high copy base genomes), '-' (low copy genomes), '$D=<integer>' minimal Difference (default is 1), '$F=<double>' factor (default is 1.0), double), or '#' (ignore) suffix, encountered: \"" + string + "\"");
                }
                list4.add(new Integer(n + ""));
                list4.add(new Double(d + ""));
            }
        } else {
            ForesterUtil.fatalError(PRG_NAME, "'plus minus' file [" + file + "] appears empty");
        }
    }

    private static void writePresentToNexus(File file, File file2, SortedSet<DomainId> sortedSet, List<GenomeWideCombinableDomains> list) {
        try {
            SurfacingUtil.writeMatrixToFile(DomainParsimonyCalculator.createMatrixOfDomainPresenceOrAbsence(list, file2 == null ? null : sortedSet), file + "_dom.nex", CharacterStateMatrix.Format.NEXUS_BINARY);
            SurfacingUtil.writeMatrixToFile(DomainParsimonyCalculator.createMatrixOfBinaryDomainCombinationPresenceOrAbsence(list), file + "_dc.nex", CharacterStateMatrix.Format.NEXUS_BINARY);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getLocalizedMessage());
        }
    }

    private static void writeProteinListsForAllSpecies(File file, SortedMap<Species, List<Protein>> sortedMap, List<GenomeWideCombinableDomains> list) {
        TreeSet<DomainId> treeSet = new TreeSet<DomainId>();
        for (GenomeWideCombinableDomains object : list) {
            treeSet.addAll(object.getAllDomainIds());
        }
        for (DomainId domainId : treeSet) {
            File file2 = new File(file + ForesterUtil.FILE_SEPARATOR + domainId + SEQ_EXTRACT_SUFFIX);
            SurfacingUtil.checkForOutputFileWriteability(file2);
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                SurfacingUtil.extractProteinNames(sortedMap, domainId, (Writer)bufferedWriter, "\t");
                ((Writer)bufferedWriter).close();
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
            }
            ForesterUtil.programMessage(PRG_NAME, "Wrote proteins list to \"" + file2 + "\"");
        }
    }
}

