/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.sdi.GSDI;
import org.forester.sdi.SDIse;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class ta {
    private static final String STRIP_OPTION = "s";
    private static final String SDISE_OPTION = "b";
    private static final String MOST_PARSIMONIOUS_OPTION = "m";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String DEFAULT_OUTFILE = "sdi_out.xml";
    private static final String PRG_NAME = "sdi";
    private static final String PRG_VERSION = "alpha 0.3";
    private static final String PRG_DATE = "2008.03.04";

    public static void main(String[] stringArray) {
        PhylogenyParser phylogenyParser;
        Object object;
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
            System.out.println();
            ta.print_help();
            System.exit(0);
        } else if (stringArray.length < 2 || commandLineArguments.getNumberOfNames() < 2 || commandLineArguments.getNumberOfNames() > 3) {
            System.out.println();
            System.out.println("Wrong number of arguments.");
            System.out.println();
            ta.print_help();
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(STRIP_OPTION);
        arrayList.add(SDISE_OPTION);
        arrayList.add(MOST_PARSIMONIOUS_OPTION);
        String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (commandLineArguments.isOptionSet(STRIP_OPTION)) {
            bl2 = true;
        }
        if (commandLineArguments.isOptionSet(SDISE_OPTION)) {
            bl = true;
        }
        if (commandLineArguments.isOptionSet(MOST_PARSIMONIOUS_OPTION)) {
            if (bl) {
                ForesterUtil.fatalError(PRG_NAME, "Can only use most parsimonious duplication mode with GSDI");
            }
            bl3 = true;
        }
        Phylogeny phylogeny = null;
        Phylogeny phylogeny2 = null;
        File file = null;
        File file2 = null;
        File file3 = null;
        try {
            file = commandLineArguments.getFile(0);
            file2 = commandLineArguments.getFile(1);
            file3 = commandLineArguments.getNumberOfNames() == 3 ? commandLineArguments.getFile(2) : new File(DEFAULT_OUTFILE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ForesterUtil.fatalError(PRG_NAME, "error in command line: " + illegalArgumentException.getMessage());
        }
        if (ForesterUtil.isReadableFile(file) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(file));
        }
        if (ForesterUtil.isReadableFile(file2) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isReadableFile(file2));
        }
        if (ForesterUtil.isWritableFile(file3) != null) {
            ForesterUtil.fatalError(PRG_NAME, ForesterUtil.isWritableFile(file3));
        }
        try {
            object = ParserBasedPhylogenyFactory.getInstance();
            phylogenyParser = ForesterUtil.createParserDependingOnFileType(file2, true);
            phylogeny = object.create(file2, phylogenyParser)[0];
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to read species tree from \"" + file + "\" [" + iOException.getMessage() + "]");
        }
        try {
            object = ParserBasedPhylogenyFactory.getInstance();
            phylogenyParser = ForesterUtil.createParserDependingOnFileType(file, true);
            phylogeny2 = object.create(file, phylogenyParser)[0];
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to read gene tree from \"" + file + "\" [" + iOException.getMessage() + "]");
        }
        phylogeny2.setRooted(true);
        phylogeny.setRooted(true);
        if (!phylogeny2.isCompletelyBinary()) {
            ForesterUtil.fatalError(PRG_NAME, "gene tree is not completely binary.");
        }
        if (bl && !phylogeny.isCompletelyBinary()) {
            ForesterUtil.fatalError(PRG_NAME, "species tree is not completely binary.");
        }
        System.out.println();
        System.out.println("Strip species tree: " + bl2);
        object = null;
        long l = new Date().getTime();
        try {
            if (bl) {
                System.out.println();
                System.out.println("Using SDIse algorithm.");
                object = new SDIse(phylogeny2, phylogeny);
            } else {
                System.out.println();
                System.out.println("Using GSDI algorithm.");
                System.out.println();
                System.out.println("Use most parsimonous duplication model: " + bl3);
                object = new GSDI(phylogeny2, phylogeny, bl3);
            }
        }
        catch (Exception exception) {
            ForesterUtil.unexpectedFatalError(PRG_NAME, exception);
        }
        System.out.println();
        System.out.println("Running time (excluding I/O): " + (new Date().getTime() - l) + "ms");
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(file3, phylogeny2, 1);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write to \"" + file3 + "\" [" + iOException.getMessage() + "]");
        }
        System.out.println();
        System.out.println("Successfully wrote resulting gene tree to: " + file3);
        System.out.println();
        if (!bl && !bl3) {
            System.out.println("Number of potential duplications: " + ((GSDI)object).getSpeciationOrDuplicationEventsSum());
        }
        if (!bl) {
            System.out.println("Number speciations              : " + ((GSDI)object).getSpeciationsSum());
        }
        System.out.println();
    }

    private static void print_help() {
        System.out.println("Usage: \"sdi [-options] <gene tree file name> <species tree file name>  [outfile name]\"");
        System.out.println();
        System.out.println("Options:");
        System.out.println(" -s: to strip the species tree prior to duplication inference");
        System.out.println(" -b: to use SDIse algorithm instead of GSDI algorithm (for binary trees only, faster)");
        System.out.println(" -m: use most parimonious duplication model for GSDI: ");
        System.out.println("     assign nodes as speciations which would otherwise be assiged");
        System.out.println("     as unknown because of polytomies in the species tree");
        System.out.println();
        System.out.println("Species tree file");
        System.out.println(" In NHX format, with species names in species name fields unless -n option");
        System.out.println(" is used.");
        System.out.println();
        System.out.println("Gene tree file");
        System.out.println(" In NHX format, with species names in species name fields and sequence names");
        System.out.println(" in sequence name fields.");
        System.out.println();
        System.out.println("!! WARNING: GSDI algorithm is under development, please use SDIse (-b) instead  !!");
        System.out.println();
    }
}

