/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.io.IOException;
import java.util.SortedSet;
import javax.swing.JOptionPane;
import org.forester.analysis.AncestralTaxonomyInference;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;

public class AncestralTaxonomyInferrer
implements Runnable {
    private final Phylogeny _phy;
    private final MainFrameApplication _mf;
    private final TreePanel _treepanel;

    AncestralTaxonomyInferrer(MainFrameApplication mainFrameApplication, TreePanel treePanel, Phylogeny phylogeny) {
        this._phy = phylogeny;
        this._mf = mainFrameApplication;
        this._treepanel = treePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inferTaxonomies() {
        this._mf.getMainPanel().getCurrentTreePanel().setWaitCursor();
        SortedSet<String> sortedSet = null;
        try {
            sortedSet = AncestralTaxonomyInference.inferTaxonomyFromDescendents(this._phy);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this._mf, iOException.toString(), "Error during ancestral taxonomy inference", 0);
        }
        finally {
            this._mf.getMainPanel().getCurrentTreePanel().setArrowCursor();
        }
        this._phy.setRerootable(false);
        this._treepanel.setTree(this._phy);
        this._mf.showWhole();
        this._treepanel.setEdited(true);
        if (sortedSet != null && sortedSet.size() > 0) {
            int n = sortedSet.size();
            boolean bl = false;
            if (n > 20) {
                bl = true;
                n = 20;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Not all taxonomies could be resolved.\n");
            stringBuffer.append("The result is incomplete, and, possibly, misleading.\n");
            if (sortedSet.size() == 1) {
                stringBuffer.append("The following taxonomy was not found:\n");
            } else {
                stringBuffer.append("The following taxonomies were not found (total: " + sortedSet.size() + "):\n");
            }
            int n2 = 0;
            for (String string : sortedSet) {
                if (n2 > 19) break;
                stringBuffer.append(string);
                stringBuffer.append("\n");
                ++n2;
            }
            if (bl) {
                stringBuffer.append("...");
            }
            try {
                JOptionPane.showMessageDialog(this._mf, stringBuffer.toString(), "Ancestral Taxonomy Inference Completed", 2);
            }
            catch (Exception exception) {}
        } else {
            try {
                JOptionPane.showMessageDialog(this._mf, "Ancestral taxonomy inference successfully completed", "Ancestral Taxonomy Inference Completed", 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void run() {
        this.inferTaxonomies();
    }
}

