/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.io.File;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainFrameApplication;
import org.forester.archaeopteryx.Util;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;

public final class Archaeopteryx {
    private static final boolean TEST = false;

    public static MainFrame createApplication(Phylogeny phylogeny) {
        Phylogeny[] phylogenyArray = new Phylogeny[]{phylogeny};
        return Archaeopteryx.createApplication(phylogenyArray, "", "");
    }

    public static MainFrame createApplication(Phylogeny[] phylogenyArray) {
        return Archaeopteryx.createApplication(phylogenyArray, "", "");
    }

    public static MainFrame createApplication(Phylogeny[] phylogenyArray, String string, String string2) {
        return MainFrameApplication.createInstance(phylogenyArray, string, string2);
    }

    public static void main(String[] stringArray) {
        String string;
        Phylogeny[] phylogenyArray = null;
        String string2 = null;
        Configuration configuration = null;
        File file = null;
        try {
            int n = 0;
            if (stringArray.length == 0) {
                configuration = new Configuration(null, false, false);
            } else if (stringArray.length > 0) {
                if (stringArray[0].startsWith("-c")) {
                    string2 = stringArray[1];
                    n += 2;
                }
                configuration = new Configuration(string2, false, false);
                if (stringArray.length > n) {
                    PhylogenyParser phylogenyParser;
                    file = new File(stringArray[n]);
                    string = ForesterUtil.isReadableFile(file);
                    if (!ForesterUtil.isEmpty(string)) {
                        ForesterUtil.fatalError("Archaeopteryx", string);
                    }
                    boolean bl = false;
                    PhylogenyParser phylogenyParser2 = ForesterUtil.createParserDependingOnFileType(file, configuration.isValidatePhyloXmlAgainstSchema());
                    if (phylogenyParser2 instanceof NHXParser) {
                        bl = true;
                        phylogenyParser = (NHXParser)phylogenyParser2;
                        ((NHXParser)phylogenyParser).setReplaceUnderscores(configuration.isReplaceUnderscoresInNhParsing());
                        ((NHXParser)phylogenyParser).setIgnoreQuotes(configuration.isNhParsingIgnoreQuotes());
                        ForesterUtil.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION = ForesterUtil.TAXONOMY_EXTRACTION.NO;
                        if (configuration.isExtractPfamTaxonomyCodesInNhParsing()) {
                            tAXONOMY_EXTRACTION = ForesterUtil.TAXONOMY_EXTRACTION.PFAM_STYLE_ONLY;
                        }
                        ((NHXParser)phylogenyParser).setTaxonomyExtraction(tAXONOMY_EXTRACTION);
                    } else if (phylogenyParser2 instanceof NexusPhylogeniesParser) {
                        bl = true;
                        phylogenyParser = (NexusPhylogeniesParser)phylogenyParser2;
                        ((NexusPhylogeniesParser)phylogenyParser).setReplaceUnderscores(configuration.isReplaceUnderscoresInNhParsing());
                        ((NexusPhylogeniesParser)phylogenyParser).setIgnoreQuotes(configuration.isNhParsingIgnoreQuotes());
                    } else if (phylogenyParser2 instanceof PhyloXmlParser) {
                        MainFrameApplication.warnIfNotPhyloXmlValidation(configuration);
                    }
                    phylogenyArray = Util.readPhylogenies(phylogenyParser2, file);
                    if (bl && configuration.isInternalNumberAreConfidenceForNhParsing()) {
                        for (PhylogenyParser phylogenyParser3 : phylogenyArray) {
                            ForesterUtil.transferInternalNodeNamesToConfidence((Phylogeny)((Object)phylogenyParser3));
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            ForesterUtil.fatalError("Archaeopteryx", "failed to start: " + exception.getLocalizedMessage());
        }
        String string3 = "";
        if (file != null) {
            string3 = file.getName();
        }
        try {
            string = "";
            MainFrameApplication.createInstance(phylogenyArray, configuration, string3);
        }
        catch (Exception exception) {
            Util.unexpectedException(exception);
        }
        catch (Error error) {
            Util.unexpectedError(error);
        }
    }
}

