/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.io.File;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.UIManager;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.MainFrameApplet;
import org.forester.archaeopteryx.Util;
import org.forester.util.ForesterUtil;

public class ArchaeopteryxA
extends JApplet {
    private static final long serialVersionUID = 2314899014580484146L;
    private static final Color background_color = new Color(0, 0, 0);
    private static final Color font_color = new Color(0, 255, 0);
    private static final Color ex_background_color = new Color(0, 0, 0);
    private static final Color ex_font_color = new Color(255, 0, 0);
    private static final Font font = new Font(Configuration.getDefaultFontFamilyName(), 1, 9);
    private MainFrameApplet _mainframe_applet;
    private String _url_string = "";
    private String _message_1 = "";
    private String _message_2 = "";
    public static final String NAME = "ArchaeopteryxA";

    public void destroy() {
        Util.printAppletMessage(NAME, "going to be destroyed");
        if (this.getMainFrameApplet() != null) {
            this.getMainFrameApplet().close();
        }
    }

    private MainFrameApplet getMainFrameApplet() {
        return this._mainframe_applet;
    }

    private String getMessage1() {
        return this._message_1;
    }

    private String getMessage2() {
        return this._message_2;
    }

    public String getUrlString() {
        return this._url_string;
    }

    public void init() {
        Object object;
        Object object2;
        boolean bl = false;
        this.setName(NAME);
        this.setUrlString(this.getParameter("url_of_tree_to_load"));
        Util.printAppletMessage(NAME, "URL of phylogenies to load: \"" + this.getUrlString() + "\"");
        this.setBackground(background_color);
        this.setForeground(font_color);
        this.setFont(font);
        this.repaint();
        String string = null;
        try {
            string = System.getProperty("java.version");
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage(NAME, "minor error: " + exception.getLocalizedMessage());
        }
        if (string != null && string.length() > 0) {
            this.setMessage2("[Your Java version: " + string + "]");
            this.repaint();
        }
        String string2 = this.getParameter("config_file");
        Util.printAppletMessage(NAME, "URL for configuration file is: " + string2);
        Configuration configuration = new Configuration(string2, true, true);
        try {
            if (configuration.isUseNativeUI()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            this.setVisible(false);
            this._mainframe_applet = new MainFrameApplet(this, configuration);
            object2 = null;
            object2 = new URL(this.getUrlString());
            object = Util.readPhylogeniesFromUrl((URL)object2, configuration.isValidatePhyloXmlAgainstSchema());
            Util.addPhylogeniesToTabs(object, new File(((URL)object2).getFile()).getName(), this.getUrlString(), this.getMainFrameApplet().getConfiguration(), this.getMainFrameApplet().getMainPanel());
            this.getMainFrameApplet().getMainPanel().getControlPanel().showWholeAll();
            this.getMainFrameApplet().getMainPanel().getControlPanel().showWhole();
            this.setVisible(true);
        }
        catch (Exception exception) {
            ForesterUtil.printErrorMessage(NAME, exception.toString());
            this.setBackground(ex_background_color);
            this.setForeground(ex_font_color);
            bl = true;
            this.setMessage1("Exception: " + exception);
            exception.printStackTrace();
            this.repaint();
        }
        if (!bl) {
            this.setMessage1("ArchaeopteryxA is now ready!");
            this.repaint();
            Util.printAppletMessage(NAME, "successfully initialized");
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        this.getMainFrameApplet().requestFocus();
        this.getMainFrameApplet().requestFocusInWindow();
        this.getMainFrameApplet().requestFocus();
        object2 = this.getParameter("homology_type_analysis_initial_relation_type");
        if (object2 != null) {
            this.getMainFrameApplet().getMainPanel().getControlPanel().getSequenceRelationTypeBox().setSelectedItem(object2);
        }
        if ((object = this.getParameter("homology_type_analysis_query_sequence")) != null) {
            this.getMainFrameApplet().getMainPanel().getControlPanel().getSequenceRelationBox().setSelectedItem(object);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(background_color);
        graphics.fillRect(0, 0, 300, 60);
        graphics.setColor(font_color);
        graphics.drawString(this.getMessage2(), 10, 20);
        graphics.drawString(this.getMessage1(), 10, 40);
    }

    private void setMessage1(String string) {
        this._message_1 = string;
    }

    private void setMessage2(String string) {
        this._message_2 = string;
    }

    private void setUrlString(String string) {
        this._url_string = string;
    }

    public void start() {
        this.getMainFrameApplet().getMainPanel().validate();
        this.getMainFrameApplet().requestFocus();
        this.getMainFrameApplet().requestFocusInWindow();
        this.getMainFrameApplet().requestFocus();
        Util.printAppletMessage(NAME, "started");
    }
}

