/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.forester.archaeopteryx.AncestralTaxonomyInferrer;
import org.forester.archaeopteryx.ArchaeopteryxE;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.DefaultFilter;
import org.forester.archaeopteryx.GraphicsFileFilter;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MainPanelApplets;
import org.forester.archaeopteryx.NHFilter;
import org.forester.archaeopteryx.NHXFilter;
import org.forester.archaeopteryx.NexusFilter;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.PdfExporter;
import org.forester.archaeopteryx.PdfFilter;
import org.forester.archaeopteryx.Printer;
import org.forester.archaeopteryx.TaxonomyDataObtainer;
import org.forester.archaeopteryx.TolFilter;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.Util;
import org.forester.archaeopteryx.XMLFilter;
import org.forester.archaeopteryx.webservices.PhylogeniesWebserviceClient;
import org.forester.archaeopteryx.webservices.WebservicesManager;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlParser;
import org.forester.io.parsers.tol.TolParser;
import org.forester.io.writers.PhylogenyWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sdi.GSDI;
import org.forester.sdi.SDIR;
import org.forester.sdi.SDIse;
import org.forester.util.ForesterUtil;
import org.forester.util.WindowsUtils;

public final class MainFrameApplication
extends MainFrame {
    private static final int FRAME_X_SIZE = 800;
    private static final int FRAME_Y_SIZE = 800;
    private static final NHFilter nhfilter = new NHFilter();
    private static final NHXFilter nhxfilter = new NHXFilter();
    private static final XMLFilter xmlfilter = new XMLFilter();
    private static final TolFilter tolfilter = new TolFilter();
    private static final NexusFilter nexusfilter = new NexusFilter();
    private static final PdfFilter pdffilter = new PdfFilter();
    private static final GraphicsFileFilter graphicsfilefilter = new GraphicsFileFilter();
    private static final DefaultFilter defaultfilter = new DefaultFilter();
    private static final long serialVersionUID = -799735726778865234L;
    private final JFileChooser _open_filechooser;
    private final JFileChooser _open_filechooser_for_species_tree;
    private final JFileChooser _save_filechooser;
    private final JFileChooser _writetopdf_filechooser;
    private final JFileChooser _writetographics_filechooser;
    private JMenu _analysis_menu;
    private JMenuItem _load_species_tree_item;
    private JMenuItem _sdi_item;
    private JMenuItem _gsdi_item;
    private JMenuItem _root_min_dups_item;
    private JMenuItem _root_min_cost_l_item;
    private JMenuItem _lineage_inference;
    private JMenuItem _print_item;
    private JMenuItem _write_to_pdf_item;
    private JMenuItem _write_to_jpg_item;
    private JMenuItem _write_to_gif_item;
    private JMenuItem _write_to_tif_item;
    private JMenuItem _write_to_png_item;
    private JMenuItem _write_to_bmp_item;
    private Phylogeny _species_tree;
    private File _current_dir;
    private ButtonGroup _radio_group_1;
    double _min_not_collapse = 50.0;

    private MainFrameApplication(Phylogeny[] phylogenyArray, Configuration configuration, String string) {
        this._configuration = configuration;
        if (this._configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        try {
            if (this._configuration.isUseNativeUI()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            Util.dieWithSystemError("UnsupportedLookAndFeelException: " + unsupportedLookAndFeelException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Util.dieWithSystemError("ClassNotFoundException: " + classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            Util.dieWithSystemError("InstantiationException: " + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            Util.dieWithSystemError("IllegalAccessException: " + illegalAccessException.toString());
        }
        catch (Exception exception) {
            Util.dieWithSystemError(exception.toString());
        }
        this.setVisible(false);
        this.setOptions(Options.createInstance(this._configuration));
        this._textframe = null;
        this._species_tree = null;
        this.setTitle("Archaeopteryx 0.957 beta (2010.09.06)");
        this._mainpanel = new MainPanel(this._configuration, this);
        this._open_filechooser = new JFileChooser();
        this._open_filechooser.setCurrentDirectory(new File("."));
        this._open_filechooser.setMultiSelectionEnabled(false);
        this._open_filechooser.addChoosableFileFilter(xmlfilter);
        this._open_filechooser.addChoosableFileFilter(nhxfilter);
        this._open_filechooser.addChoosableFileFilter(nhfilter);
        this._open_filechooser.addChoosableFileFilter(nexusfilter);
        this._open_filechooser.addChoosableFileFilter(tolfilter);
        this._open_filechooser.addChoosableFileFilter(this._open_filechooser.getAcceptAllFileFilter());
        this._open_filechooser.setFileFilter(defaultfilter);
        this._open_filechooser_for_species_tree = new JFileChooser();
        this._open_filechooser_for_species_tree.setCurrentDirectory(new File("."));
        this._open_filechooser_for_species_tree.setMultiSelectionEnabled(false);
        this._open_filechooser_for_species_tree.addChoosableFileFilter(xmlfilter);
        this._open_filechooser_for_species_tree.addChoosableFileFilter(tolfilter);
        this._open_filechooser_for_species_tree.setFileFilter(xmlfilter);
        this._save_filechooser = new JFileChooser();
        this._save_filechooser.setCurrentDirectory(new File("."));
        this._save_filechooser.setMultiSelectionEnabled(false);
        this._save_filechooser.setFileFilter(xmlfilter);
        this._save_filechooser.addChoosableFileFilter(nhxfilter);
        this._save_filechooser.addChoosableFileFilter(nhfilter);
        this._save_filechooser.addChoosableFileFilter(nexusfilter);
        this._save_filechooser.addChoosableFileFilter(this._save_filechooser.getAcceptAllFileFilter());
        this._writetopdf_filechooser = new JFileChooser();
        this._writetopdf_filechooser.addChoosableFileFilter(pdffilter);
        this._writetographics_filechooser = new JFileChooser();
        this._writetographics_filechooser.addChoosableFileFilter(graphicsfilefilter);
        this._jmenubar = new JMenuBar();
        if (!this._configuration.isUseNativeUI()) {
            this._jmenubar.setBackground(this.getConfiguration().getGuiMenuBackgroundColor());
        }
        this.buildFileMenu();
        this.buildToolsMenu();
        this.buildViewMenu();
        this.buildFontSizeMenu();
        this.buildOptionsMenu();
        this.buildTypeMenu();
        this.buildAnalysisMenu();
        this.buildHelpMenu();
        this.setJMenuBar(this._jmenubar);
        this._jmenubar.add(this._help_jmenu);
        this._contentpane = this.getContentPane();
        this._contentpane.setLayout(new BorderLayout());
        this._contentpane.add((Component)this._mainpanel, "Center");
        this.setSize(800, 800);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                int n;
                int n2;
                if (MainFrameApplication.this.isUnsavedDataPresent() ? (n2 = JOptionPane.showConfirmDialog(null, "Exit despite potentially unsaved changes?", "Exit?", 0)) != 0 : (n = JOptionPane.showConfirmDialog(null, "Exit Archaeopteryx?", "Exit?", 0)) != 0) {
                    return;
                }
                MainFrameApplication.this.exit();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (MainFrameApplication.this._mainpanel.getCurrentTreePanel() != null) {
                    MainFrameApplication.this._mainpanel.getCurrentTreePanel().setParametersForPainting(MainFrameApplication.this._mainpanel.getCurrentTreePanel().getWidth(), MainFrameApplication.this._mainpanel.getCurrentTreePanel().getHeight(), false);
                }
            }
        });
        this.requestFocusInWindow();
        this.setVisible(true);
        if (phylogenyArray != null && phylogenyArray.length > 0) {
            Util.addPhylogeniesToTabs(phylogenyArray, string, null, this._configuration, this._mainpanel);
            this.validate();
            this.getMainPanel().getControlPanel().showWholeAll();
            this.getMainPanel().getControlPanel().showWhole();
        }
        this.activateSaveAllIfNeeded();
        this._contentpane.repaint();
        System.gc();
    }

    private MainFrameApplication(Phylogeny[] phylogenyArray, String string, String string2) {
        this(phylogenyArray, new Configuration(string, false, false), string2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            super.actionPerformed(actionEvent);
            Object object = actionEvent.getSource();
            if (object == this._open_item) {
                this.readPhylogeniesFromFile();
            } else if (object == this._save_item) {
                this.writeToFile(this._mainpanel.getCurrentPhylogeny());
            } else if (object == this._new_item) {
                this.newTree();
            } else if (object == this._save_all_item) {
                this.writeAllToFile();
            } else if (object == this._close_item) {
                this.closeCurrentPane();
            } else if (object == this._write_to_pdf_item) {
                this.writeToPdf(this._mainpanel.getCurrentPhylogeny());
            } else if (object == this._write_to_jpg_item) {
                this.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), Util.GraphicsExportType.JPG);
            } else if (object == this._write_to_png_item) {
                this.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), Util.GraphicsExportType.PNG);
            } else if (object == this._write_to_gif_item) {
                this.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), Util.GraphicsExportType.GIF);
            } else if (object == this._write_to_tif_item) {
                this.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), Util.GraphicsExportType.TIFF);
            } else if (object == this._write_to_bmp_item) {
                this.writeToGraphicsFile(this._mainpanel.getCurrentPhylogeny(), Util.GraphicsExportType.BMP);
            } else if (object == this._print_item) {
                this.print();
            } else if (object == this._load_species_tree_item) {
                this.readSpeciesTreeFromFile();
            } else if (object == this._sdi_item) {
                this.executeSDI();
            } else if (object == this._lineage_inference) {
                this.executeLineageInference();
            } else if (object == this._obtain_detailed_taxonomic_information_jmi) {
                this.obtainDetailedTaxonomicInformation();
            } else if (object == this._move_node_names_to_tax_sn_jmi) {
                this.moveNodeNamesToTaxSn();
            } else if (object == this._move_node_names_to_seq_names_jmi) {
                this.moveNodeNamesToSeqNames();
            } else if (object == this._extract_tax_code_from_node_names_jmi) {
                this.extractTaxCodeFromNodeNames();
            } else if (object == this._gsdi_item) {
                this.executeGSDI();
            } else if (object == this._root_min_dups_item) {
                this.executeSDIR(false);
            } else if (object == this._root_min_cost_l_item) {
                this.executeSDIR(true);
            } else if (object == this._graphics_export_visible_only_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (object == this._antialias_print_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (object == this._print_black_and_white_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (object == this._print_using_actual_size_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (object == this._graphics_export_using_actual_size_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (object == this._print_size_mi) {
                this.choosePrintSize();
            } else if (object == this._choose_pdf_width_mi) {
                this.choosePdfWidth();
            } else if (object == this._internal_number_are_confidence_for_nh_parsing_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (object == this._ignore_quotes_in_nh_parsing_cbmi) {
                this.updateOptions(this.getOptions());
            } else if (object == this._replace_underscores_cbmi) {
                if (this._extract_pfam_style_tax_codes_cbmi != null && this._replace_underscores_cbmi.isSelected()) {
                    this._extract_pfam_style_tax_codes_cbmi.setSelected(false);
                }
                this.updateOptions(this.getOptions());
            } else if (object == this._collapse_below_threshold) {
                this.collapseBelowThreshold();
            } else if (object == this._extract_pfam_style_tax_codes_cbmi) {
                if (this._replace_underscores_cbmi != null && this._extract_pfam_style_tax_codes_cbmi.isSelected()) {
                    this._replace_underscores_cbmi.setSelected(false);
                }
                this.updateOptions(this.getOptions());
            }
            this._contentpane.repaint();
        }
        catch (Exception exception) {
            Util.unexpectedException(exception);
        }
        catch (Error error) {
            Util.unexpectedError(error);
        }
    }

    void buildAnalysisMenu() {
        this._analysis_menu = MainFrame.createMenu("Analysis", this.getConfiguration());
        this._sdi_item = new JMenuItem("SDI (Speciation Duplication Inference)");
        this._analysis_menu.add(this._sdi_item);
        this._analysis_menu.addSeparator();
        this._root_min_dups_item = new JMenuItem("Root by Minimizing Duplications | Height (SDI)");
        this._analysis_menu.add(this._root_min_dups_item);
        this._root_min_cost_l_item = new JMenuItem("Root by Minimizing Cost L | Height (SDI)");
        this._analysis_menu.add(this._root_min_cost_l_item);
        this._analysis_menu.addSeparator();
        this._load_species_tree_item = new JMenuItem("Load Species Tree...");
        this._analysis_menu.add(this._load_species_tree_item);
        this.customizeJMenuItem(this._sdi_item);
        this.customizeJMenuItem(this._gsdi_item);
        this.customizeJMenuItem(this._root_min_dups_item);
        this.customizeJMenuItem(this._root_min_cost_l_item);
        this.customizeJMenuItem(this._load_species_tree_item);
        this._analysis_menu.addSeparator();
        this._lineage_inference = new JMenuItem("Infer Ancestor Taxonomies");
        this._analysis_menu.add(this._lineage_inference);
        this.customizeJMenuItem(this._lineage_inference);
        this._lineage_inference.setToolTipText("use Web API for Biology (WABI) at DDBJ to infer ancestor taxonomies/lineages");
        this._jmenubar.add(this._analysis_menu);
    }

    void buildFileMenu() {
        int n;
        this._file_jmenu = MainFrame.createMenu("File", this.getConfiguration());
        this._open_item = new JMenuItem("Read Tree from File...");
        this._file_jmenu.add(this._open_item);
        this._file_jmenu.addSeparator();
        this._open_url_item = new JMenuItem("Read Tree from URL/Webservice...");
        this._file_jmenu.add(this._open_url_item);
        this._file_jmenu.addSeparator();
        WebservicesManager webservicesManager = WebservicesManager.getInstance();
        this._load_phylogeny_from_webservice_menu_items = new JMenuItem[webservicesManager.getAvailablePhylogeniesWebserviceClients().size()];
        for (n = 0; n < webservicesManager.getAvailablePhylogeniesWebserviceClients().size(); ++n) {
            PhylogeniesWebserviceClient phylogeniesWebserviceClient = webservicesManager.getAvailablePhylogeniesWebserviceClient(n);
            this._load_phylogeny_from_webservice_menu_items[n] = new JMenuItem(phylogeniesWebserviceClient.getMenuName());
            this._file_jmenu.add(this._load_phylogeny_from_webservice_menu_items[n]);
        }
        if (this.getConfiguration().isEditable()) {
            this._file_jmenu.addSeparator();
            this._new_item = new JMenuItem("New");
            this._file_jmenu.add(this._new_item);
            this._new_item.setToolTipText("to create a new tree with one node, as source for manual tree construction");
        }
        this._file_jmenu.addSeparator();
        this._save_item = new JMenuItem("Save Tree As...");
        this._file_jmenu.add(this._save_item);
        this._save_all_item = new JMenuItem("Save All Trees As...");
        this._file_jmenu.add(this._save_all_item);
        this._save_all_item.setToolTipText("Write all phylogenies to one file.");
        this._save_all_item.setEnabled(false);
        this._file_jmenu.addSeparator();
        this._write_to_pdf_item = new JMenuItem("Export to PDF file ...");
        this._file_jmenu.add(this._write_to_pdf_item);
        if (Util.canWriteFormat("tif") || Util.canWriteFormat("tiff") || Util.canWriteFormat("TIF")) {
            this._write_to_tif_item = new JMenuItem("Export to TIFF file...");
            this._file_jmenu.add(this._write_to_tif_item);
        }
        this._write_to_png_item = new JMenuItem("Export to PNG file...");
        this._file_jmenu.add(this._write_to_png_item);
        this._write_to_jpg_item = new JMenuItem("Export to JPG file...");
        this._file_jmenu.add(this._write_to_jpg_item);
        if (Util.canWriteFormat("gif")) {
            this._write_to_gif_item = new JMenuItem("Export to GIF file...");
            this._file_jmenu.add(this._write_to_gif_item);
        }
        if (Util.canWriteFormat("bmp")) {
            this._write_to_bmp_item = new JMenuItem("Export to BMP file...");
            this._file_jmenu.add(this._write_to_bmp_item);
        }
        this._file_jmenu.addSeparator();
        this._print_item = new JMenuItem("Print...");
        this._file_jmenu.add(this._print_item);
        this._file_jmenu.addSeparator();
        this._close_item = new JMenuItem("Close Tab");
        this._file_jmenu.add(this._close_item);
        this._close_item.setToolTipText("To close the current pane.");
        this._close_item.setEnabled(true);
        this._file_jmenu.addSeparator();
        this._exit_item = new JMenuItem("Exit");
        this._file_jmenu.add(this._exit_item);
        this.customizeJMenuItem(this._open_item);
        this._open_item.setFont(new Font(this._open_item.getFont().getFontName(), 1, this._open_item.getFont().getSize() + 4));
        this.customizeJMenuItem(this._open_url_item);
        for (n = 0; n < webservicesManager.getAvailablePhylogeniesWebserviceClients().size(); ++n) {
            this.customizeJMenuItem(this._load_phylogeny_from_webservice_menu_items[n]);
        }
        this.customizeJMenuItem(this._save_item);
        if (this.getConfiguration().isEditable()) {
            this.customizeJMenuItem(this._new_item);
        }
        this.customizeJMenuItem(this._close_item);
        this.customizeJMenuItem(this._save_all_item);
        this.customizeJMenuItem(this._write_to_pdf_item);
        this.customizeJMenuItem(this._write_to_png_item);
        this.customizeJMenuItem(this._write_to_jpg_item);
        this.customizeJMenuItem(this._write_to_gif_item);
        this.customizeJMenuItem(this._write_to_tif_item);
        this.customizeJMenuItem(this._write_to_bmp_item);
        this.customizeJMenuItem(this._print_item);
        this.customizeJMenuItem(this._exit_item);
        this._jmenubar.add(this._file_jmenu);
    }

    void buildOptionsMenu() {
        this._options_jmenu = MainFrame.createMenu("Options", this.getConfiguration());
        this._options_jmenu.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MainFrame.setOvPlacementColorChooseMenuItem(MainFrameApplication.this._overview_placment_mi, MainFrameApplication.this.getCurrentTreePanel());
                MainFrame.setTextColorChooseMenuItem(MainFrameApplication.this._switch_colors_mi, MainFrameApplication.this.getCurrentTreePanel());
                MainFrame.setTextMinSupportMenuItem(MainFrameApplication.this._choose_minimal_confidence_mi, MainFrameApplication.this.getOptions(), MainFrameApplication.this.getCurrentTreePanel());
                MainFrame.setTextForFontChooserMenuItem(MainFrameApplication.this._choose_font_mi, MainFrame.createCurrentFontDesc(MainFrameApplication.this.getMainPanel().getTreeFontSet()));
                MainFrameApplication.setTextForGraphicsSizeChooserMenuItem(MainFrameApplication.this._print_size_mi, MainFrameApplication.this.getOptions());
                MainFrameApplication.setTextForPdfLineWidthChooserMenuItem(MainFrameApplication.this._choose_pdf_width_mi, MainFrameApplication.this.getOptions());
                MainFrame.updateOptionsMenuDependingOnPhylogenyType(MainFrameApplication.this.getMainPanel(), MainFrameApplication.this._show_scale_cbmi, MainFrameApplication.this._show_branch_length_values_cbmi, MainFrameApplication.this._non_lined_up_cladograms_rbmi, MainFrameApplication.this._uniform_cladograms_rbmi, MainFrameApplication.this._ext_node_dependent_cladogram_rbmi, MainFrameApplication.this._label_direction_cbmi);
            }
        });
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Display:"), this.getConfiguration()));
        this._ext_node_dependent_cladogram_rbmi = new JRadioButtonMenuItem("External Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._ext_node_dependent_cladogram_rbmi);
        this._uniform_cladograms_rbmi = new JRadioButtonMenuItem("Total Node Sum Dependent Cladograms");
        this._options_jmenu.add(this._uniform_cladograms_rbmi);
        this._non_lined_up_cladograms_rbmi = new JRadioButtonMenuItem("Non-Lined Up Cladograms");
        this._options_jmenu.add(this._non_lined_up_cladograms_rbmi);
        this._radio_group_1 = new ButtonGroup();
        this._radio_group_1.add(this._ext_node_dependent_cladogram_rbmi);
        this._radio_group_1.add(this._uniform_cladograms_rbmi);
        this._radio_group_1.add(this._non_lined_up_cladograms_rbmi);
        this._show_node_boxes_cbmi = new JCheckBoxMenuItem("Display Node Boxes");
        this._options_jmenu.add(this._show_node_boxes_cbmi);
        this._show_scale_cbmi = new JCheckBoxMenuItem("Display Scale");
        this._options_jmenu.add(this._show_scale_cbmi);
        this._show_branch_length_values_cbmi = new JCheckBoxMenuItem("Display Branch Length Values");
        this._options_jmenu.add(this._show_branch_length_values_cbmi);
        this._show_overview_cbmi = new JCheckBoxMenuItem("Show Overview");
        this._options_jmenu.add(this._show_overview_cbmi);
        this._label_direction_cbmi = new JCheckBoxMenuItem("Radial Labels");
        this._options_jmenu.add(this._label_direction_cbmi);
        this._label_direction_cbmi.setToolTipText("To use radial node labels in radial and unrooted display types");
        this._screen_antialias_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._screen_antialias_cbmi);
        this._background_gradient_cbmi = new JCheckBoxMenuItem("Background Color Gradient");
        this._options_jmenu.add(this._background_gradient_cbmi);
        this._choose_minimal_confidence_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_minimal_confidence_mi);
        this._overview_placment_mi = new JMenuItem("");
        this._options_jmenu.add(this._overview_placment_mi);
        this._switch_colors_mi = new JMenuItem("");
        this._options_jmenu.add(this._switch_colors_mi);
        this._choose_font_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_font_mi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Search:"), this.getConfiguration()));
        this._search_case_senstive_cbmi = new JCheckBoxMenuItem("Case Sensitive");
        this._options_jmenu.add(this._search_case_senstive_cbmi);
        this._search_whole_words_only_cbmi = new JCheckBoxMenuItem("Match Complete Terms Only");
        this._options_jmenu.add(this._search_whole_words_only_cbmi);
        this._inverse_search_result_cbmi = new JCheckBoxMenuItem("Negate Result");
        this._options_jmenu.add(this._inverse_search_result_cbmi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Graphics Export & Printing:"), this.getConfiguration()));
        this._antialias_print_cbmi = new JCheckBoxMenuItem("Antialias");
        this._options_jmenu.add(this._antialias_print_cbmi);
        this._print_black_and_white_cbmi = new JCheckBoxMenuItem("Export in Black and White");
        this._options_jmenu.add(this._print_black_and_white_cbmi);
        this._print_using_actual_size_cbmi = new JCheckBoxMenuItem("Use Current Image Size for PDF export and Printing");
        this._options_jmenu.add(this._print_using_actual_size_cbmi);
        this._graphics_export_using_actual_size_cbmi = new JCheckBoxMenuItem("Use Current Image Size for PNG, JPG, and GIF export");
        this._options_jmenu.add(this._graphics_export_using_actual_size_cbmi);
        this._graphics_export_visible_only_cbmi = new JCheckBoxMenuItem("Limit to Visible ('Screenshot') for PNG, JPG, and GIF export");
        this._options_jmenu.add(this._graphics_export_visible_only_cbmi);
        this._print_size_mi = new JMenuItem("");
        this._options_jmenu.add(this._print_size_mi);
        this._choose_pdf_width_mi = new JMenuItem("");
        this._options_jmenu.add(this._choose_pdf_width_mi);
        this._options_jmenu.addSeparator();
        this._options_jmenu.add(MainFrameApplication.customizeMenuItemAsLabel(new JMenuItem("Newick/NHX/Nexus Parsing:"), this.getConfiguration()));
        this._internal_number_are_confidence_for_nh_parsing_cbmi = new JCheckBoxMenuItem("Internal Numbers Are Confidence Values");
        this._options_jmenu.add(this._internal_number_are_confidence_for_nh_parsing_cbmi);
        this._replace_underscores_cbmi = new JCheckBoxMenuItem("Replace Underscores with Spaces");
        this._options_jmenu.add(this._replace_underscores_cbmi);
        this._ignore_quotes_in_nh_parsing_cbmi = new JCheckBoxMenuItem("Ignore Quotation Marks and Spaces in Labels");
        this._options_jmenu.add(this._ignore_quotes_in_nh_parsing_cbmi);
        this._extract_pfam_style_tax_codes_cbmi = new JCheckBoxMenuItem("Extract Taxonomy Codes from Pfam-style Labels");
        this._options_jmenu.add(this._extract_pfam_style_tax_codes_cbmi);
        this.customizeJMenuItem(this._choose_font_mi);
        this.customizeJMenuItem(this._choose_minimal_confidence_mi);
        this.customizeJMenuItem(this._switch_colors_mi);
        this.customizeJMenuItem(this._print_size_mi);
        this.customizeJMenuItem(this._choose_pdf_width_mi);
        this.customizeJMenuItem(this._overview_placment_mi);
        this.customizeCheckBoxMenuItem(this._show_node_boxes_cbmi, this.getOptions().isShowNodeBoxes());
        this.customizeCheckBoxMenuItem(this._screen_antialias_cbmi, this.getOptions().isAntialiasScreen());
        this.customizeCheckBoxMenuItem(this._background_gradient_cbmi, this.getOptions().isBackgroundColorGradient());
        this.customizeCheckBoxMenuItem(this._search_case_senstive_cbmi, this.getOptions().isSearchCaseSensitive());
        this.customizeCheckBoxMenuItem(this._show_scale_cbmi, this.getOptions().isShowScale());
        this.customizeRadioButtonMenuItem(this._non_lined_up_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP);
        this.customizeRadioButtonMenuItem(this._uniform_cladograms_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.TOTAL_NODE_SUM_DEP);
        this.customizeRadioButtonMenuItem(this._ext_node_dependent_cladogram_rbmi, this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.EXT_NODE_SUM_DEP);
        this.customizeCheckBoxMenuItem(this._show_branch_length_values_cbmi, this.getOptions().isShowBranchLengthValues());
        this.customizeCheckBoxMenuItem(this._show_overview_cbmi, this.getOptions().isShowOverview());
        this.customizeCheckBoxMenuItem(this._label_direction_cbmi, this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL);
        this.customizeCheckBoxMenuItem(this._antialias_print_cbmi, this.getOptions().isAntialiasPrint());
        this.customizeCheckBoxMenuItem(this._print_black_and_white_cbmi, this.getOptions().isPrintBlackAndWhite());
        this.customizeCheckBoxMenuItem(this._internal_number_are_confidence_for_nh_parsing_cbmi, this.getOptions().isInternalNumberAreConfidenceForNhParsing());
        this.customizeCheckBoxMenuItem(this._extract_pfam_style_tax_codes_cbmi, this.getOptions().isExtractPfamTaxonomyCodesInNhParsing());
        this.customizeCheckBoxMenuItem(this._replace_underscores_cbmi, this.getOptions().isReplaceUnderscoresInNhParsing());
        this.customizeCheckBoxMenuItem(this._ignore_quotes_in_nh_parsing_cbmi, this.getOptions().isNhParsingIgnoreQuotes());
        this.customizeCheckBoxMenuItem(this._search_whole_words_only_cbmi, this.getOptions().isMatchWholeTermsOnly());
        this.customizeCheckBoxMenuItem(this._inverse_search_result_cbmi, this.getOptions().isInverseSearchResult());
        this.customizeCheckBoxMenuItem(this._graphics_export_visible_only_cbmi, this.getOptions().isGraphicsExportVisibleOnly());
        this.customizeCheckBoxMenuItem(this._print_using_actual_size_cbmi, this.getOptions().isPrintUsingActualSize());
        this.customizeCheckBoxMenuItem(this._graphics_export_using_actual_size_cbmi, this.getOptions().isGraphicsExportUsingActualSize());
        this._jmenubar.add(this._options_jmenu);
    }

    void buildToolsMenu() {
        this._tools_menu = MainFrameApplication.createMenu("Tools", this.getConfiguration());
        this._confcolor_item = new JMenuItem("Colorize Branches Depending on Confidence");
        this._tools_menu.add(this._confcolor_item);
        this.customizeJMenuItem(this._confcolor_item);
        this._taxcolor_item = new JMenuItem("Taxonomy Colorize Branches");
        this._tools_menu.add(this._taxcolor_item);
        this.customizeJMenuItem(this._taxcolor_item);
        this._remove_branch_color_item = new JMenuItem("Delete Branch Colors");
        this._tools_menu.add(this._remove_branch_color_item);
        this._remove_branch_color_item.setToolTipText("To delete branch color values from the current phylogeny");
        this.customizeJMenuItem(this._remove_branch_color_item);
        this._tools_menu.addSeparator();
        this._midpoint_root_item = new JMenuItem("Midpoint-Root");
        this._tools_menu.add(this._midpoint_root_item);
        this.customizeJMenuItem(this._midpoint_root_item);
        this._tools_menu.addSeparator();
        this._collapse_species_specific_subtrees = new JMenuItem("Collapse Species-Specific Subtrees");
        this._tools_menu.add(this._collapse_species_specific_subtrees);
        this.customizeJMenuItem(this._collapse_species_specific_subtrees);
        this._collapse_below_threshold = new JMenuItem("Collapse Branches with Confidence Below Threshold");
        this._tools_menu.add(this._collapse_below_threshold);
        this.customizeJMenuItem(this._collapse_below_threshold);
        this._collapse_below_threshold.setToolTipText("To permanently collapse branches without at least one support value above a given threshold");
        this._tools_menu.addSeparator();
        this._move_node_names_to_tax_sn_jmi = new JMenuItem("Transfer Node Names to Taxonomic Scientific Names");
        this._tools_menu.add(this._move_node_names_to_tax_sn_jmi);
        this.customizeJMenuItem(this._move_node_names_to_tax_sn_jmi);
        this._move_node_names_to_tax_sn_jmi.setToolTipText("To interpret node names as taxonomic scientific names");
        this._move_node_names_to_seq_names_jmi = new JMenuItem("Transfer Node Names to Sequence Names");
        this._tools_menu.add(this._move_node_names_to_seq_names_jmi);
        this.customizeJMenuItem(this._move_node_names_to_seq_names_jmi);
        this._move_node_names_to_seq_names_jmi.setToolTipText("To interpret node names as sequence (protein, gene) names");
        this._extract_tax_code_from_node_names_jmi = new JMenuItem("Extract Taxonomic Codes from Node Names");
        this._tools_menu.add(this._extract_tax_code_from_node_names_jmi);
        this.customizeJMenuItem(this._extract_tax_code_from_node_names_jmi);
        this._extract_tax_code_from_node_names_jmi.setToolTipText("To extract taxonomic codes (mnemonics) from nodes names in the form of 'xyz_ECOLI'");
        this._tools_menu.addSeparator();
        this._infer_common_sn_names_item = new JMenuItem("Infer Common Parts of Internal Scientific Names");
        this._tools_menu.add(this._infer_common_sn_names_item);
        this.customizeJMenuItem(this._infer_common_sn_names_item);
        this._tools_menu.addSeparator();
        this._obtain_detailed_taxonomic_information_jmi = new JMenuItem("Obtain Detailed Taxonomic Information");
        this._tools_menu.add(this._obtain_detailed_taxonomic_information_jmi);
        this.customizeJMenuItem(this._obtain_detailed_taxonomic_information_jmi);
        this._obtain_detailed_taxonomic_information_jmi.setToolTipText("To add additional taxonomic information (from UniProt Taxonomy)");
        this._jmenubar.add(this._tools_menu);
    }

    private void choosePdfWidth() {
        String string = (String)JOptionPane.showInputDialog(this, "Please enter the default line width for PDF export.\n[current value: " + this.getOptions().getPrintLineWidth() + "]\n", "Line Width for PDF Export", 3, null, null, Float.valueOf(this.getOptions().getPrintLineWidth()));
        if (!ForesterUtil.isEmpty(string)) {
            boolean bl = true;
            float f = 0.0f;
            String string2 = string.trim();
            if (!ForesterUtil.isEmpty(string2)) {
                try {
                    f = Float.parseFloat(string2);
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl && (double)f > 0.0) {
                this.getOptions().setPrintLineWidth(f);
            }
        }
    }

    private void choosePrintSize() {
        String string = (String)JOptionPane.showInputDialog(this, "Please enter values for width and height,\nseparated by a comma.\n[current values: " + this.getOptions().getPrintSizeX() + ", " + this.getOptions().getPrintSizeY() + "]\n" + "[A4: " + 595 + ", " + 845 + "]\n" + "[US Letter: " + 612 + ", " + 792 + "]", "Default Size for Graphics Export", 3, null, null, this.getOptions().getPrintSizeX() + ", " + this.getOptions().getPrintSizeY());
        if (!ForesterUtil.isEmpty(string) && string.indexOf(44) > 0) {
            boolean bl = true;
            int n = 0;
            int n2 = 0;
            String[] stringArray = string.split(",");
            if (stringArray.length == 2) {
                String string2 = stringArray[0].trim();
                String string3 = stringArray[1].trim();
                if (!ForesterUtil.isEmpty(string2) && !ForesterUtil.isEmpty(string3)) {
                    try {
                        n = Integer.parseInt(string2);
                        n2 = Integer.parseInt(string3);
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl && n > 1 && n2 > 1) {
                this.getOptions().setPrintSizeX(n);
                this.getOptions().setPrintSizeY(n2);
            }
        }
    }

    void close() {
        int n;
        if (this.isUnsavedDataPresent() && (n = JOptionPane.showConfirmDialog(this, "Exit despite potentially unsaved changes?", "Exit?", 0)) != 0) {
            return;
        }
        this.exit();
    }

    private void closeCurrentPane() {
        if (this.getMainPanel().getCurrentTreePanel() != null) {
            int n;
            if (this.getMainPanel().getCurrentTreePanel().isEdited() && (n = JOptionPane.showConfirmDialog(this, "Close tab despite potentially unsaved changes?", "Close Tab?", 0)) != 0) {
                return;
            }
            this.getMainPanel().closeCurrentPane();
            this.activateSaveAllIfNeeded();
        }
    }

    private void collapse(Phylogeny phylogeny, double d) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        double d2 = Double.MAX_VALUE;
        boolean bl = false;
        while (phylogenyNodeIterator.hasNext()) {
            Object object;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.isRoot() || (object = phylogenyNode.getBranchData().getConfidences()) == null || object.size() <= 0) continue;
            bl = true;
            double d3 = 0.0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Confidence confidence = (Confidence)iterator.next();
                if (!(confidence.getValue() > d3)) continue;
                d3 = confidence.getValue();
            }
            if (d3 < this.getMinNotCollapseConfidenceValue()) {
                arrayList.add(phylogenyNode);
            }
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        if (bl) {
            for (Object object : arrayList) {
                PhylogenyMethods.removeNode((PhylogenyNode)object, phylogeny);
            }
            if (arrayList.size() > 0) {
                phylogeny.externalNodesHaveChanged();
                phylogeny.hashIDs();
                phylogeny.recalculateNumberOfExternalDescendants(true);
                this.getCurrentTreePanel().resetNodeIdToDistToLeafMap();
                this.getCurrentTreePanel().setEdited(true);
                this.getCurrentTreePanel().repaint();
            }
            if (arrayList.size() > 0) {
                JOptionPane.showMessageDialog(this, "Collapsed " + arrayList.size() + " branches with\nconfidence values below " + this.getMinNotCollapseConfidenceValue(), "Collapsed " + arrayList.size() + " branches", 1);
            } else {
                JOptionPane.showMessageDialog(this, "No branch collapsed,\nminimum confidence value per branch is " + d2, "No branch collapsed", 1);
            }
        } else {
            JOptionPane.showMessageDialog(this, "No branch collapsed because no confidence values present", "No confidence values present", 1);
        }
    }

    private void collapseBelowThreshold() {
        String string;
        Phylogeny phylogeny;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty() && !ForesterUtil.isEmpty(string = (String)JOptionPane.showInputDialog(this, "Please enter the minimum confidence value\n", "Minimal Confidence Value", 3, null, null, this.getMinNotCollapseConfidenceValue()))) {
            boolean bl = true;
            double d = 0.0;
            String string2 = string.trim();
            if (!ForesterUtil.isEmpty(string2)) {
                try {
                    d = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl && d >= 0.0) {
                this.setMinNotCollapseConfidenceValue(d);
                this.collapse(phylogeny, d);
            }
        }
    }

    private PhyloXmlParser createPhyloXmlParser() {
        PhyloXmlParser phyloXmlParser = null;
        if (this.getConfiguration().isValidatePhyloXmlAgainstSchema()) {
            try {
                phyloXmlParser = PhyloXmlParser.createPhyloXmlParserXsdValidating();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), "failed to create validating XML parser", 2);
            }
        }
        if (phyloXmlParser == null) {
            phyloXmlParser = new PhyloXmlParser();
        }
        return phyloXmlParser;
    }

    void executeGSDI() {
        if (!this.isOKforSDI(false, true)) {
            return;
        }
        if (!this._mainpanel.getCurrentPhylogeny().isRooted()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not rooted.", "Cannot execute GSDI", 0);
            return;
        }
        Phylogeny phylogeny = this._mainpanel.getCurrentPhylogeny().copy();
        phylogeny.setAllNodesToNotCollapse();
        phylogeny.recalculateNumberOfExternalDescendants(false);
        GSDI gSDI = null;
        int n = -1;
        try {
            gSDI = new GSDI(phylogeny, this._species_tree.copy(), true);
            n = gSDI.getDuplicationsSum();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "Error during GSDI", 0);
        }
        phylogeny.setRerootable(false);
        this._mainpanel.getCurrentTreePanel().setTree(phylogeny);
        this.getControlPanel().setShowEvents(true);
        this.showWhole();
        this._mainpanel.getCurrentTreePanel().setEdited(true);
        JOptionPane.showMessageDialog(this, "Number of duplications: " + n, "GSDI successfully completed", 1);
    }

    void executeLineageInference() {
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            return;
        }
        if (!this._mainpanel.getCurrentPhylogeny().isRooted()) {
            JOptionPane.showMessageDialog(this, "Phylogeny is not rooted.", "Cannot infer ancestral taxonomies", 0);
            return;
        }
        Phylogeny phylogeny = this._mainpanel.getCurrentPhylogeny().copy();
        AncestralTaxonomyInferrer ancestralTaxonomyInferrer = new AncestralTaxonomyInferrer(this, this._mainpanel.getCurrentTreePanel(), phylogeny);
        new Thread(ancestralTaxonomyInferrer).start();
    }

    void executeSDI() {
        if (!this.isOKforSDI(true, true)) {
            return;
        }
        if (!this._mainpanel.getCurrentPhylogeny().isRooted()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not rooted", "Cannot execute SDI", 0);
            return;
        }
        Phylogeny phylogeny = this._mainpanel.getCurrentPhylogeny().copy();
        phylogeny.setAllNodesToNotCollapse();
        phylogeny.recalculateNumberOfExternalDescendants(false);
        SDIse sDIse = null;
        int n = -1;
        try {
            sDIse = new SDIse(phylogeny, this._species_tree.copy());
            n = sDIse.getDuplicationsSum();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "Error during SDI", 0);
        }
        phylogeny.setRerootable(false);
        this._mainpanel.getCurrentTreePanel().setTree(phylogeny);
        this.getControlPanel().setShowEvents(true);
        this.showWhole();
        this._mainpanel.getCurrentTreePanel().setEdited(true);
        JOptionPane.showMessageDialog(this, "Number of duplications: " + n, "SDI successfully completed", 1);
    }

    void executeSDIR(boolean bl) {
        if (!this.isOKforSDI(true, true)) {
            return;
        }
        Phylogeny phylogeny = this._mainpanel.getCurrentPhylogeny().copy();
        SDIR sDIR = new SDIR();
        phylogeny.setAllNodesToNotCollapse();
        phylogeny.recalculateNumberOfExternalDescendants(false);
        try {
            phylogeny = sDIR.infer(phylogeny, this._species_tree, bl, !bl, true, true, 1)[0];
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.toString(), "Error during SDIR", 0);
            return;
        }
        int n = sDIR.getMinimalDuplications();
        phylogeny.setRerootable(false);
        this._mainpanel.getCurrentTreePanel().setTree(phylogeny);
        this.getControlPanel().setShowEvents(true);
        this.showWhole();
        this._mainpanel.getCurrentTreePanel().setEdited(true);
        JOptionPane.showMessageDialog(this, "Number of duplications: " + n, "SDIR successfully completed", 1);
    }

    void exit() {
        this.removeTextFrame();
        this._mainpanel.terminate();
        this._contentpane.removeAll();
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    private void extractTaxCodeFromNodeNames() {
        Phylogeny phylogeny;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty()) {
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
            while (phylogenyNodeIterator.hasNext()) {
                String string;
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                String string2 = phylogenyNode.getNodeName().trim();
                if (ForesterUtil.isEmpty(string2) || ForesterUtil.isEmpty(string = ForesterUtil.extractTaxonomyCodeFromNodeName(string2, false, ForesterUtil.TAXONOMY_EXTRACTION.YES))) continue;
                PhylogenyMethods.setTaxonomyCode(phylogenyNode, string);
            }
        }
    }

    private ControlPanel getControlPanel() {
        return this.getMainPanel().getControlPanel();
    }

    private File getCurrentDir() {
        if (!(this._current_dir != null && this._current_dir.canRead() || ForesterUtil.OS_NAME.toLowerCase().indexOf("win") <= -1)) {
            try {
                this._current_dir = new File(WindowsUtils.getCurrentUserDesktopPath());
            }
            catch (Exception exception) {
                this._current_dir = null;
            }
        }
        if (this._current_dir == null || !this._current_dir.canRead()) {
            if (System.getProperty("user.home") != null) {
                this._current_dir = new File(System.getProperty("user.home"));
            } else if (System.getProperty("user.dir") != null) {
                this._current_dir = new File(System.getProperty("user.dir"));
            }
        }
        return this._current_dir;
    }

    MainPanel getMainPanel() {
        return this._mainpanel;
    }

    private double getMinNotCollapseConfidenceValue() {
        return this._min_not_collapse;
    }

    boolean isOKforSDI(boolean bl, boolean bl2) {
        if (this._mainpanel.getCurrentPhylogeny() == null || this._mainpanel.getCurrentPhylogeny().isEmpty()) {
            return false;
        }
        if (this._species_tree == null || this._species_tree.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No species tree loaded", "Cannot execute SDI", 0);
            return false;
        }
        if (bl && !this._species_tree.isCompletelyBinary()) {
            JOptionPane.showMessageDialog(this, "Species tree is not completely binary", "Cannot execute SDI", 0);
            return false;
        }
        if (bl2 && !this._mainpanel.getCurrentPhylogeny().isCompletelyBinary()) {
            JOptionPane.showMessageDialog(this, "Gene tree is not completely binary", "Cannot execute SDI", 0);
            return false;
        }
        return true;
    }

    private boolean isUnsavedDataPresent() {
        List<TreePanel> list = this.getMainPanel().getTreePanels();
        for (TreePanel treePanel : list) {
            if (!treePanel.isEdited()) continue;
            return true;
        }
        return false;
    }

    private void moveNodeNamesToSeqNames() {
        Phylogeny phylogeny;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty()) {
            ForesterUtil.transferNodeNameToField(phylogeny, ForesterUtil.PhylogenyNodeField.SEQUENCE_NAME);
        }
    }

    private void moveNodeNamesToTaxSn() {
        Phylogeny phylogeny;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty()) {
            ForesterUtil.transferNodeNameToField(phylogeny, ForesterUtil.PhylogenyNodeField.TAXONOMY_SCIENTIFIC_NAME);
        }
    }

    private void newTree() {
        Phylogeny[] phylogenyArray = new Phylogeny[1];
        Phylogeny phylogeny = new Phylogeny();
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        phylogeny.setRoot(phylogenyNode);
        phylogeny.setRooted(true);
        phylogenyArray[0] = phylogeny;
        Util.addPhylogeniesToTabs(phylogenyArray, "", "", this.getConfiguration(), this.getMainPanel());
        this._mainpanel.getControlPanel().showWhole();
        this._mainpanel.getCurrentTreePanel().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        this._mainpanel.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        if (this.getMainPanel().getMainFrame() == null) {
            ((ArchaeopteryxE)((MainPanelApplets)this.getMainPanel()).getApplet()).setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        } else {
            this.getMainPanel().getMainFrame().setSelectedTypeInTypeMenu(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
        }
        this.activateSaveAllIfNeeded();
        System.gc();
    }

    private void obtainDetailedTaxonomicInformation() {
        Phylogeny phylogeny;
        if (this.getCurrentTreePanel() != null && (phylogeny = this.getCurrentTreePanel().getPhylogeny()) != null && !phylogeny.isEmpty()) {
            TaxonomyDataObtainer taxonomyDataObtainer = new TaxonomyDataObtainer(this, this._mainpanel.getCurrentTreePanel(), phylogeny.copy());
            new Thread(taxonomyDataObtainer).start();
        }
    }

    private void print() {
        if (this.getCurrentTreePanel() == null || this.getCurrentTreePanel().getPhylogeny() == null || this.getCurrentTreePanel().getPhylogeny().isEmpty()) {
            return;
        }
        if (!this.getOptions().isPrintUsingActualSize()) {
            this.getCurrentTreePanel().setParametersForPainting(this.getOptions().getPrintSizeX() - 80, this.getOptions().getPrintSizeY() - 140, true);
            this.getCurrentTreePanel().resetPreferredSize();
            this.getCurrentTreePanel().repaint();
        }
        boolean bl = false;
        String string = null;
        try {
            string = Printer.print(this.getCurrentTreePanel(), "Archaeopteryx");
        }
        catch (Exception exception) {
            bl = true;
            JOptionPane.showMessageDialog(this, exception.getMessage(), "Printing Error", 0);
        }
        if (!bl && string != null) {
            String string2 = "Printing data sent to printer";
            if (string.length() > 1) {
                string2 = string2 + " [" + string + "]";
            }
            JOptionPane.showMessageDialog(this, string2, "Printing...", 1);
        }
        if (!this.getOptions().isPrintUsingActualSize()) {
            this.getControlPanel().showWhole();
        }
    }

    private void printPhylogenyToPdf(String string) {
        if (!this.getOptions().isPrintUsingActualSize()) {
            this.getCurrentTreePanel().setParametersForPainting(this.getOptions().getPrintSizeX(), this.getOptions().getPrintSizeY(), true);
            this.getCurrentTreePanel().resetPreferredSize();
            this.getCurrentTreePanel().repaint();
        }
        String string2 = "";
        boolean bl = false;
        try {
            string2 = this.getOptions().isPrintUsingActualSize() ? PdfExporter.writePhylogenyToPdf(string, this.getCurrentTreePanel(), this.getCurrentTreePanel().getWidth(), this.getCurrentTreePanel().getHeight()) : PdfExporter.writePhylogenyToPdf(string, this.getCurrentTreePanel(), this.getOptions().getPrintSizeX(), this.getOptions().getPrintSizeY());
        }
        catch (IOException iOException) {
            bl = true;
            JOptionPane.showMessageDialog(this, iOException.getMessage(), "Error", 0);
        }
        if (!bl) {
            if (!ForesterUtil.isEmpty(string2)) {
                JOptionPane.showMessageDialog(this, "Wrote PDF to: " + string2, "Information", 1);
            } else {
                JOptionPane.showMessageDialog(this, "There was an unknown problem when attempting to write to PDF file: \"" + string + "\"", "Error", 0);
            }
        }
        if (!this.getOptions().isPrintUsingActualSize()) {
            this.getControlPanel().showWhole();
        }
    }

    private void readPhylogeniesFromFile() {
        boolean bl = false;
        Phylogeny[] phylogenyArray = null;
        File file = this.getCurrentDir();
        this._open_filechooser.setMultiSelectionEnabled(true);
        if (file != null) {
            this._open_filechooser.setCurrentDirectory(file);
        }
        int n = this._open_filechooser.showOpenDialog(this._contentpane);
        File[] fileArray = this._open_filechooser.getSelectedFiles();
        this.setCurrentDir(this._open_filechooser.getCurrentDirectory());
        boolean bl2 = false;
        if (fileArray != null && fileArray.length > 0 && n == 0) {
            for (File file2 : fileArray) {
                Phylogeny[] phylogenyArray2;
                if (file2 == null || file2.isDirectory()) continue;
                if (this._mainpanel.getCurrentTreePanel() != null) {
                    this._mainpanel.getCurrentTreePanel().setWaitCursor();
                } else {
                    this._mainpanel.setWaitCursor();
                }
                if (this._open_filechooser.getFileFilter() == nhfilter || this._open_filechooser.getFileFilter() == nhxfilter) {
                    try {
                        phylogenyArray2 = new NHXParser();
                        this.setSpecialOptionsForNhxParser((NHXParser)phylogenyArray2);
                        phylogenyArray = Util.readPhylogenies((PhylogenyParser)phylogenyArray2, file2);
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        bl = true;
                        this.exceptionOccuredDuringOpenFile(exception);
                    }
                } else if (this._open_filechooser.getFileFilter() == xmlfilter) {
                    MainFrameApplication.warnIfNotPhyloXmlValidation(this.getConfiguration());
                    try {
                        phylogenyArray2 = this.createPhyloXmlParser();
                        phylogenyArray = Util.readPhylogenies((PhylogenyParser)phylogenyArray2, file2);
                    }
                    catch (Exception exception) {
                        bl = true;
                        this.exceptionOccuredDuringOpenFile(exception);
                    }
                } else if (this._open_filechooser.getFileFilter() == tolfilter) {
                    try {
                        phylogenyArray = Util.readPhylogenies(new TolParser(), file2);
                    }
                    catch (Exception exception) {
                        bl = true;
                        this.exceptionOccuredDuringOpenFile(exception);
                    }
                } else if (this._open_filechooser.getFileFilter() == nexusfilter) {
                    try {
                        phylogenyArray2 = new NexusPhylogeniesParser();
                        this.setSpecialOptionsForNexParser((NexusPhylogeniesParser)phylogenyArray2);
                        phylogenyArray = Util.readPhylogenies((PhylogenyParser)phylogenyArray2, file2);
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        bl = true;
                        this.exceptionOccuredDuringOpenFile(exception);
                    }
                } else {
                    try {
                        phylogenyArray2 = ForesterUtil.createParserDependingOnFileType(file2, this.getConfiguration().isValidatePhyloXmlAgainstSchema());
                        if (phylogenyArray2 instanceof NexusPhylogeniesParser) {
                            NexusPhylogeniesParser nexusPhylogeniesParser = (NexusPhylogeniesParser)phylogenyArray2;
                            this.setSpecialOptionsForNexParser(nexusPhylogeniesParser);
                            bl2 = true;
                        } else if (phylogenyArray2 instanceof NHXParser) {
                            NHXParser nHXParser = (NHXParser)phylogenyArray2;
                            this.setSpecialOptionsForNhxParser(nHXParser);
                            bl2 = true;
                        } else if (phylogenyArray2 instanceof PhyloXmlParser) {
                            MainFrameApplication.warnIfNotPhyloXmlValidation(this.getConfiguration());
                        }
                        phylogenyArray = Util.readPhylogenies((PhylogenyParser)phylogenyArray2, file2);
                    }
                    catch (Exception exception) {
                        bl = true;
                        this.exceptionOccuredDuringOpenFile(exception);
                    }
                }
                if (this._mainpanel.getCurrentTreePanel() != null) {
                    this._mainpanel.getCurrentTreePanel().setArrowCursor();
                } else {
                    this._mainpanel.setArrowCursor();
                }
                if (bl || phylogenyArray == null || phylogenyArray.length <= 0) continue;
                if (bl2 && this.getOptions().isInternalNumberAreConfidenceForNhParsing()) {
                    for (Phylogeny phylogeny : phylogenyArray) {
                        ForesterUtil.transferInternalNodeNamesToConfidence(phylogeny);
                    }
                }
                Util.addPhylogeniesToTabs(phylogenyArray, file2.getName(), file2.getAbsolutePath(), this.getConfiguration(), this.getMainPanel());
                this._mainpanel.getControlPanel().showWhole();
            }
        }
        this.activateSaveAllIfNeeded();
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void readPhylogeniesFromURL() {
        URL uRL = null;
        Phylogeny[] phylogenyArray = null;
        String string = JOptionPane.showInputDialog(this, "Please enter a complete URL, for example \"http://www.phyloxml.org/examples/apaf.xml\"", "Use URL/webservice to obtain a phylogeny", 3);
        boolean bl = false;
        if (string != null && string.length() > 0) {
            try {
                void exception;
                uRL = new URL(string);
                Object phylogenyParser = null;
                if (uRL.getHost().toLowerCase().indexOf("tolweb") >= 0) {
                    TolParser malformedURLException = new TolParser();
                } else {
                    PhylogenyParser iOException = ForesterUtil.createParserDependingOnUrlContents(uRL, this.getConfiguration().isValidatePhyloXmlAgainstSchema());
                }
                if (exception instanceof NexusPhylogeniesParser) {
                    bl = true;
                } else if (exception instanceof NHXParser) {
                    bl = true;
                }
                if (this._mainpanel.getCurrentTreePanel() != null) {
                    this._mainpanel.getCurrentTreePanel().setWaitCursor();
                } else {
                    this._mainpanel.setWaitCursor();
                }
                PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
                phylogenyArray = phylogenyFactory.create(uRL.openStream(), exception);
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, "Malformed URL: " + uRL + "\n" + malformedURLException.getLocalizedMessage(), "Malformed URL", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Could not read from " + uRL + "\n" + ForesterUtil.wordWrap(iOException.getLocalizedMessage(), 80), "Failed to read URL", 0);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, ForesterUtil.wordWrap(exception.getLocalizedMessage(), 80), "Unexpected Exception", 0);
            }
            finally {
                if (this._mainpanel.getCurrentTreePanel() != null) {
                    this._mainpanel.getCurrentTreePanel().setArrowCursor();
                } else {
                    this._mainpanel.setArrowCursor();
                }
            }
            if (phylogenyArray != null && phylogenyArray.length > 0) {
                if (bl && this.getOptions().isInternalNumberAreConfidenceForNhParsing()) {
                    for (Phylogeny phylogeny : phylogenyArray) {
                        ForesterUtil.transferInternalNodeNamesToConfidence(phylogeny);
                    }
                }
                Util.addPhylogeniesToTabs(phylogenyArray, new File(uRL.getFile()).getName(), new File(uRL.getFile()).toString(), this.getConfiguration(), this.getMainPanel());
                this._mainpanel.getControlPanel().showWhole();
            }
        }
        this.activateSaveAllIfNeeded();
        System.gc();
    }

    private void readSpeciesTreeFromFile() {
        Phylogeny phylogeny = null;
        boolean bl = false;
        File file = this.getCurrentDir();
        this._open_filechooser_for_species_tree.setSelectedFile(new File(""));
        if (file != null) {
            this._open_filechooser_for_species_tree.setCurrentDirectory(file);
        }
        int n = this._open_filechooser_for_species_tree.showOpenDialog(this._contentpane);
        File file2 = this._open_filechooser_for_species_tree.getSelectedFile();
        if (file2 != null && n == 0) {
            Object object;
            if (this._open_filechooser_for_species_tree.getFileFilter() == xmlfilter) {
                try {
                    object = Util.readPhylogenies(new PhyloXmlParser(), file2);
                    phylogeny = object[0];
                }
                catch (Exception exception) {
                    bl = true;
                    this.exceptionOccuredDuringOpenFile(exception);
                }
            } else if (this._open_filechooser_for_species_tree.getFileFilter() == tolfilter) {
                try {
                    object = Util.readPhylogenies(new TolParser(), file2);
                    phylogeny = object[0];
                }
                catch (Exception exception) {
                    bl = true;
                    this.exceptionOccuredDuringOpenFile(exception);
                }
            } else {
                try {
                    object = Util.readPhylogenies(new PhyloXmlParser(), file2);
                    phylogeny = object[0];
                }
                catch (Exception exception) {
                    bl = true;
                    this.exceptionOccuredDuringOpenFile(exception);
                }
            }
            if (!bl && phylogeny != null && !phylogeny.isRooted()) {
                bl = true;
                phylogeny = null;
                JOptionPane.showMessageDialog(this, "Species tree is not rooted", "Species tree not loaded", 0);
            }
            if (!bl && phylogeny != null) {
                object = new HashSet();
                PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
                while (phylogenyNodeIterator.hasNext()) {
                    PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        bl = true;
                        phylogeny = null;
                        JOptionPane.showMessageDialog(this, "Species tree contains external node(s) without taxonomy information", "Species tree not loaded", 0);
                        break;
                    }
                    if (object.contains(phylogenyNode.getNodeData().getTaxonomy())) {
                        bl = true;
                        phylogeny = null;
                        JOptionPane.showMessageDialog(this, "Taxonomy [" + phylogenyNode.getNodeData().getTaxonomy().asSimpleText() + "] is not unique in species tree", "Species tree not loaded", 0);
                        break;
                    }
                    object.add(phylogenyNode.getNodeData().getTaxonomy());
                }
            }
            if (!bl && phylogeny != null) {
                this._species_tree = phylogeny;
                JOptionPane.showMessageDialog(this, "Species tree successfully loaded", "Species tree loaded", 1);
            }
            this._contentpane.repaint();
            System.gc();
        }
    }

    private void setCurrentDir(File file) {
        this._current_dir = file;
    }

    private void setMinNotCollapseConfidenceValue(double d) {
        this._min_not_collapse = d;
    }

    private void setSpecialOptionsForNexParser(NexusPhylogeniesParser nexusPhylogeniesParser) {
        nexusPhylogeniesParser.setReplaceUnderscores(this.getOptions().isReplaceUnderscoresInNhParsing());
        nexusPhylogeniesParser.setIgnoreQuotes(this.getOptions().isNhParsingIgnoreQuotes());
    }

    private void setSpecialOptionsForNhxParser(NHXParser nHXParser) {
        nHXParser.setReplaceUnderscores(this.getOptions().isReplaceUnderscoresInNhParsing());
        nHXParser.setIgnoreQuotes(this.getOptions().isNhParsingIgnoreQuotes());
        ForesterUtil.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION = ForesterUtil.TAXONOMY_EXTRACTION.NO;
        if (this.getOptions().isExtractPfamTaxonomyCodesInNhParsing()) {
            tAXONOMY_EXTRACTION = ForesterUtil.TAXONOMY_EXTRACTION.YES;
        }
        nHXParser.setTaxonomyExtraction(tAXONOMY_EXTRACTION);
    }

    private void writeAllToFile() {
        if (this.getMainPanel().getTabbedPane() == null || this.getMainPanel().getTabbedPane().getTabCount() < 1) {
            return;
        }
        File file = this.getCurrentDir();
        if (file != null) {
            this._save_filechooser.setCurrentDirectory(file);
        }
        this._save_filechooser.setSelectedFile(new File(""));
        int n = this._save_filechooser.showSaveDialog(this._contentpane);
        File file2 = this._save_filechooser.getSelectedFile();
        this.setCurrentDir(this._save_filechooser.getCurrentDirectory());
        if (file2 != null && n == 0) {
            int n2;
            if (file2.exists()) {
                n2 = JOptionPane.showConfirmDialog(this, file2 + " already exists. Overwrite?", "Warning", 2, 2);
                if (n2 != 0) {
                    return;
                }
                try {
                    file2.delete();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Failed to delete: " + file2, "Error", 2);
                }
            }
            n2 = this.getMainPanel().getTabbedPane().getTabCount();
            ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
            for (int i = 0; i < n2; ++i) {
                arrayList.add(this.getMainPanel().getPhylogeny(i));
                this.getMainPanel().getTreePanels().get(i).setEdited(false);
            }
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            try {
                phylogenyWriter.toPhyloXML(file2, arrayList, 0, ForesterUtil.LINE_SEPARATOR);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Failed to write to: " + file2, "Error", 2);
            }
        }
    }

    private boolean writeAsNewHampshire(Phylogeny phylogeny, boolean bl, File file) {
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toNewHampshire(phylogeny, false, true, file);
        }
        catch (Exception exception) {
            bl = true;
            this.exceptionOccuredDuringSaveAs(exception);
        }
        return bl;
    }

    private boolean writeAsNexus(Phylogeny phylogeny, boolean bl, File file) {
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toNexus(file, phylogeny);
        }
        catch (Exception exception) {
            bl = true;
            this.exceptionOccuredDuringSaveAs(exception);
        }
        return bl;
    }

    private boolean writeAsNHX(Phylogeny phylogeny, boolean bl, File file) {
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toNewHampshireX(phylogeny, file);
        }
        catch (Exception exception) {
            bl = true;
            this.exceptionOccuredDuringSaveAs(exception);
        }
        return bl;
    }

    private boolean writeAsPhyloXml(Phylogeny phylogeny, boolean bl, File file) {
        try {
            PhylogenyWriter phylogenyWriter = new PhylogenyWriter();
            phylogenyWriter.toPhyloXML(file, phylogeny, 0);
        }
        catch (Exception exception) {
            bl = true;
            this.exceptionOccuredDuringSaveAs(exception);
        }
        return bl;
    }

    private void writePhylogenyToGraphicsFile(String string, Util.GraphicsExportType graphicsExportType) {
        this._mainpanel.getCurrentTreePanel().setParametersForPainting(this._mainpanel.getCurrentTreePanel().getWidth(), this._mainpanel.getCurrentTreePanel().getHeight(), true);
        String string2 = "";
        boolean bl = false;
        try {
            string2 = Util.writePhylogenyToGraphicsFile(string, this._mainpanel.getCurrentTreePanel().getWidth(), this._mainpanel.getCurrentTreePanel().getHeight(), this._mainpanel.getCurrentTreePanel(), this._mainpanel.getControlPanel(), graphicsExportType, this.getOptions());
        }
        catch (IOException iOException) {
            bl = true;
            JOptionPane.showMessageDialog(this, iOException.getMessage(), "Error", 0);
        }
        if (!bl) {
            if (string2 != null && string2.length() > 0) {
                JOptionPane.showMessageDialog(this, "Wrote image to: " + string2, "Graphics Export", 1);
            } else {
                JOptionPane.showMessageDialog(this, "There was an unknown problem when attempting to write to an image file: \"" + string + "\"", "Error", 0);
            }
        }
        this._contentpane.repaint();
    }

    private void writeToFile(Phylogeny phylogeny) {
        if (phylogeny == null) {
            return;
        }
        String string = null;
        if (this.getMainPanel().getCurrentTreePanel().getTreeFile() != null) {
            try {
                string = this.getMainPanel().getCurrentTreePanel().getTreeFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                string = null;
            }
        }
        if (!ForesterUtil.isEmpty(string)) {
            this._save_filechooser.setSelectedFile(new File(string));
        } else {
            this._save_filechooser.setSelectedFile(new File(""));
        }
        File file = this.getCurrentDir();
        if (file != null) {
            this._save_filechooser.setCurrentDirectory(file);
        }
        int n = this._save_filechooser.showSaveDialog(this._contentpane);
        File file2 = this._save_filechooser.getSelectedFile();
        this.setCurrentDir(this._save_filechooser.getCurrentDirectory());
        boolean bl = false;
        if (file2 != null && n == 0) {
            String string2;
            if (file2.exists()) {
                int n2 = JOptionPane.showConfirmDialog(this, file2 + " already exists.\nOverwrite?", "Overwrite?", 2, 3);
                if (n2 != 0) {
                    return;
                }
                File file3 = new File(file2.getAbsoluteFile().toString() + ".BAK");
                try {
                    ForesterUtil.copyFile(file2, file3);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Failed to create backup copy " + file3, "Failed to Create Backup Copy", 2);
                }
                try {
                    file2.delete();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Failed to delete: " + file2, "Failed to Delete", 2);
                }
            }
            if (!(bl = this._save_filechooser.getFileFilter() == nhfilter ? this.writeAsNewHampshire(phylogeny, bl, file2) : (this._save_filechooser.getFileFilter() == nhxfilter ? this.writeAsNHX(phylogeny, bl, file2) : (this._save_filechooser.getFileFilter() == xmlfilter ? this.writeAsPhyloXml(phylogeny, bl, file2) : (this._save_filechooser.getFileFilter() == nexusfilter ? this.writeAsNexus(phylogeny, bl, file2) : ((string2 = file2.getName().trim().toLowerCase()).endsWith(".nh") || string2.endsWith(".newick") || string2.endsWith(".phy") || string2.endsWith(".tree") ? this.writeAsNewHampshire(phylogeny, bl, file2) : (string2.endsWith(".nhx") ? this.writeAsNHX(phylogeny, bl, file2) : (string2.endsWith(".nex") || string2.endsWith(".nexus") ? this.writeAsNexus(phylogeny, bl, file2) : this.writeAsPhyloXml(phylogeny, bl, file2))))))))) {
                this.getMainPanel().getCurrentTreePanel().setTreeFile(file2);
                this.getMainPanel().getCurrentTreePanel().setEdited(false);
            }
        }
    }

    private void writeToGraphicsFile(Phylogeny phylogeny, Util.GraphicsExportType graphicsExportType) {
        if (phylogeny == null || phylogeny.isEmpty()) {
            return;
        }
        String string = "";
        if (this.getMainPanel().getCurrentTreePanel().getTreeFile() != null) {
            string = this.getMainPanel().getCurrentTreePanel().getTreeFile().toString();
        }
        if (string.indexOf(46) > 0) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        string = string + "." + (Object)((Object)graphicsExportType);
        this._writetographics_filechooser.setSelectedFile(new File(string));
        File file = this.getCurrentDir();
        if (file != null) {
            this._writetographics_filechooser.setCurrentDirectory(file);
        }
        int n = this._writetographics_filechooser.showSaveDialog(this._contentpane);
        File file2 = this._writetographics_filechooser.getSelectedFile();
        this.setCurrentDir(this._writetographics_filechooser.getCurrentDirectory());
        if (file2 != null && n == 0) {
            if (!file2.toString().toLowerCase().endsWith(graphicsExportType.toString())) {
                file2 = new File(file2.toString() + "." + (Object)((Object)graphicsExportType));
            }
            if (file2.exists()) {
                int n2 = JOptionPane.showConfirmDialog(this, file2 + " already exists. Overwrite?", "Warning", 2, 2);
                if (n2 != 0) {
                    return;
                }
                try {
                    file2.delete();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "Failed to delete: " + file2, "Error", 2);
                }
            }
            this.writePhylogenyToGraphicsFile(file2.toString(), graphicsExportType);
        }
    }

    private void writeToPdf(Phylogeny phylogeny) {
        if (phylogeny == null || phylogeny.isEmpty()) {
            return;
        }
        String string = "";
        if (this.getMainPanel().getCurrentTreePanel().getTreeFile() != null) {
            string = this.getMainPanel().getCurrentTreePanel().getTreeFile().toString();
        }
        if (string.indexOf(46) > 0) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        string = string + ".pdf";
        this._writetopdf_filechooser.setSelectedFile(new File(string));
        File file = this.getCurrentDir();
        if (file != null) {
            this._writetopdf_filechooser.setCurrentDirectory(file);
        }
        int n = this._writetopdf_filechooser.showSaveDialog(this._contentpane);
        File file2 = this._writetopdf_filechooser.getSelectedFile();
        this.setCurrentDir(this._writetopdf_filechooser.getCurrentDirectory());
        if (file2 != null && n == 0) {
            int n2;
            if (!file2.toString().toLowerCase().endsWith(".pdf")) {
                file2 = new File(file2.toString() + ".pdf");
            }
            if (file2.exists() && (n2 = JOptionPane.showConfirmDialog(this, file2 + " already exists. Overwrite?", "WARNING", 2, 2)) != 0) {
                return;
            }
            this.printPhylogenyToPdf(file2.toString());
        }
    }

    static MainFrame createInstance(Phylogeny[] phylogenyArray, Configuration configuration, String string) {
        return new MainFrameApplication(phylogenyArray, configuration, string);
    }

    static MainFrame createInstance(Phylogeny[] phylogenyArray, String string, String string2) {
        return new MainFrameApplication(phylogenyArray, string, string2);
    }

    static void setTextForGraphicsSizeChooserMenuItem(JMenuItem jMenuItem, Options options) {
        jMenuItem.setText("Enter Default Size for Graphics Export... (current: " + options.getPrintSizeX() + ", " + options.getPrintSizeY() + ")");
    }

    static void setTextForPdfLineWidthChooserMenuItem(JMenuItem jMenuItem, Options options) {
        jMenuItem.setText("Enter Default Line Width for PDF Export... (current: " + options.getPrintLineWidth() + ")");
    }

    static void warnIfNotPhyloXmlValidation(Configuration configuration) {
        if (!configuration.isValidatePhyloXmlAgainstSchema()) {
            JOptionPane.showMessageDialog(null, ForesterUtil.wordWrap("phyloXML XSD-based validation is turned off [enable with line 'validate_against_phyloxml_xsd_schem: true' in configuration file]", 80), "Warning", 2);
        }
    }
}

