/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.Util;
import org.forester.archaeopteryx.phylogeny.data.RenderableDomainArchitecture;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainPanel
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = -2682765312661416435L;
    MainFrame _mainframe;
    List<TreePanel> _treepanels;
    ControlPanel _control_panel;
    private List<JScrollPane> _treegraphic_scroll_panes;
    private List<JPanel> _treegraphic_scroll_pane_panels;
    Configuration _configuration;
    private JTabbedPane _tabbed_pane;
    private TreeColorSet _colorset;
    private TreeFontSet _fontset;
    private Phylogeny _cut_or_copied_tree;
    private Set<PhylogenyNode> _copied_and_pasted_nodes;

    MainPanel() {
    }

    MainPanel(Configuration configuration, MainFrame mainFrame) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is null");
        }
        this.addComponentListener(this);
        this._configuration = configuration;
        this._mainframe = mainFrame;
        this._treepanels = new ArrayList<TreePanel>();
        this.initialize();
        this._control_panel = new ControlPanel(this, configuration);
        this.add((Component)this._control_panel, "West");
        this.setupTreeGraphic(configuration, this.getControlPanel());
        this.getControlPanel().showWhole();
    }

    void addPhylogenyInNewTab(Phylogeny phylogeny, Configuration configuration, String string, String string2) {
        final TreePanel treePanel = new TreePanel(phylogeny, configuration, this);
        this.getControlPanel().phylogenyAdded(configuration);
        treePanel.setControlPanel(this.getControlPanel());
        this._treepanels.add(treePanel);
        String string3 = "";
        string3 = !ForesterUtil.isEmpty(phylogeny.getName()) ? phylogeny.getName() : (phylogeny.getIdentifier() != null ? phylogeny.getIdentifier().toString() : (!ForesterUtil.isEmpty(string) ? string : "[" + (this.getTabbedPane().getTabCount() + 1) + "]"));
        JScrollPane jScrollPane = new JScrollPane(treePanel);
        jScrollPane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (treePanel.isOvOn() || MainPanel.this.getOptions().isShowScale()) {
                    treePanel.repaint();
                }
            }
        });
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (treePanel.isOvOn() || MainPanel.this.getOptions().isShowScale()) {
                    treePanel.repaint();
                }
            }
        });
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setBlockIncrement(200);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getVerticalScrollBar().setBlockIncrement(200);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        this._treegraphic_scroll_pane_panels.add(jPanel);
        this._treegraphic_scroll_panes.add(jScrollPane);
        this.getTabbedPane().addTab(string3, null, jPanel, Util.createDescriptionForTab(phylogeny, string2));
        this.getTabbedPane().setSelectedIndex(this.getTabbedPane().getTabCount() - 1);
        this.getControlPanel().showWhole();
    }

    void addPhylogenyInPanel(Phylogeny phylogeny, Configuration configuration) {
        TreePanel treePanel = new TreePanel(phylogeny, configuration, this);
        this.getControlPanel().phylogenyAdded(configuration);
        treePanel.setControlPanel(this.getControlPanel());
        this._treepanels.add(treePanel);
        JScrollPane jScrollPane = new JScrollPane(treePanel);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        jScrollPane.getHorizontalScrollBar().setBlockIncrement(50);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.getVerticalScrollBar().setBlockIncrement(50);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        this._treegraphic_scroll_pane_panels.add(jPanel);
        this._treegraphic_scroll_panes.add(jScrollPane);
        this.add((Component)jPanel, "Center");
    }

    void adjustJScrollPane() {
        if (this.getTabbedPane() != null) {
            this.getCurrentScrollPanePanel().remove(this.getCurrentScrollPane());
            this.getCurrentScrollPanePanel().add((Component)this.getCurrentScrollPane(), "Center");
        }
        this.getCurrentScrollPane().revalidate();
    }

    void closeCurrentPane() {
        int n = this.getCurrentTabIndex();
        if (n >= 0 && this.getTabbedPane().getTabCount() > 0) {
            this.getTabbedPane().remove(n);
            this.getTreePanels().remove(n);
            this._treegraphic_scroll_panes.remove(n);
            this._treegraphic_scroll_pane_panels.remove(n);
            this.getControlPanel().phylogenyRemoved(n);
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.getCurrentTreePanel() != null) {
            this.getCurrentTreePanel().updateOvSettings();
            this.getCurrentTreePanel().updateOvSizes();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    private Configuration getConfiguration() {
        return this._configuration;
    }

    ControlPanel getControlPanel() {
        return this._control_panel;
    }

    public Set<PhylogenyNode> getCopiedAndPastedNodes() {
        return this._copied_and_pasted_nodes;
    }

    Phylogeny getCurrentPhylogeny() {
        if (this.getCurrentTreePanel() == null) {
            return null;
        }
        return this.getCurrentTreePanel().getPhylogeny();
    }

    JScrollPane getCurrentScrollPane() {
        if (this._treegraphic_scroll_panes.size() > 0) {
            int n = this._tabbed_pane.getSelectedIndex();
            if (n >= 0) {
                return this._treegraphic_scroll_panes.get(n);
            }
            return this._treegraphic_scroll_panes.get(0);
        }
        return null;
    }

    JPanel getCurrentScrollPanePanel() {
        int n = this._tabbed_pane.getSelectedIndex();
        if (n >= 0) {
            return this._treegraphic_scroll_pane_panels.get(n);
        }
        return this._treegraphic_scroll_pane_panels.get(0);
    }

    int getCurrentTabIndex() {
        int n = this._tabbed_pane.getSelectedIndex();
        if (n >= 0) {
            return n;
        }
        return 0;
    }

    TreePanel getCurrentTreePanel() {
        int n = this.getTabbedPane().getSelectedIndex();
        if (n >= 0) {
            return this._treepanels.get(n);
        }
        if (this._treepanels.size() == 1) {
            return this._treepanels.get(0);
        }
        return null;
    }

    Phylogeny getCutOrCopiedTree() {
        return this._cut_or_copied_tree;
    }

    MainFrame getMainFrame() {
        return this._mainframe;
    }

    Options getOptions() {
        return this._mainframe.getOptions();
    }

    Phylogeny getPhylogeny(int n) {
        if (this.getCurrentTreePanel() == null) {
            return null;
        }
        return this._treepanels.get(n).getPhylogeny();
    }

    Dimension getSizeOfViewport() {
        return this.getCurrentScrollPane().getViewport().getExtentSize();
    }

    JTabbedPane getTabbedPane() {
        return this._tabbed_pane;
    }

    TreeColorSet getTreeColorSet() {
        return this._colorset;
    }

    public TreeFontSet getTreeFontSet() {
        return this._fontset;
    }

    List<TreePanel> getTreePanels() {
        return this._treepanels;
    }

    void initialize() {
        if (!this.getConfiguration().isUseNativeUI()) {
            this.setBackground(this.getConfiguration().getGuiBackgroundColor());
        }
        this.setTreeFontSet(new TreeFontSet(this));
        this.getTreeFontSet().setBaseFont(this.getOptions().getBaseFont());
        this.setLayout(new BorderLayout());
        this.setTreeColorSet(TreeColorSet.createInstance(this.getConfiguration()));
        this._treegraphic_scroll_panes = new ArrayList<JScrollPane>();
        this._treegraphic_scroll_pane_panels = new ArrayList<JPanel>();
        this._tabbed_pane = new JTabbedPane(1);
        if (!this.getConfiguration().isUseNativeUI()) {
            this._tabbed_pane.setBackground(this.getConfiguration().getGuiBackgroundColor());
            this._tabbed_pane.setForeground(this.getConfiguration().getGuiBackgroundColor());
        }
        this._tabbed_pane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                MainPanel.this.getControlPanel().tabChanged();
                int n = jTabbedPane.getSelectedIndex();
                if (n >= 0 && !MainPanel.this.getConfiguration().isUseNativeUI() && MainPanel.this._tabbed_pane.getTabCount() > 0) {
                    MainPanel.this._tabbed_pane.setForegroundAt(n, Constants.TAB_LABEL_FOREGROUND_COLOR_SELECTED);
                    for (int i = 0; i < MainPanel.this._tabbed_pane.getTabCount(); ++i) {
                        if (i == n) continue;
                        MainPanel.this._tabbed_pane.setBackgroundAt(i, MainPanel.this.getConfiguration().getGuiBackgroundColor());
                        MainPanel.this._tabbed_pane.setForegroundAt(i, MainPanel.this.getConfiguration().getGuiCheckboxTextColor());
                    }
                }
            }
        });
        if (!this.getConfiguration().isUseNativeUI()) {
            this._tabbed_pane.setFont(ControlPanel.jcb_font);
        }
        this._tabbed_pane.setTabLayoutPolicy(1);
        this.add((Component)this._tabbed_pane, "Center");
    }

    public void setArrowCursor() {
        this.setCursor(TreePanel.ARROW_CURSOR);
        this.repaint();
    }

    public void setCopiedAndPastedNodes(Set<PhylogenyNode> set) {
        this._copied_and_pasted_nodes = set;
    }

    void setCutOrCopiedTree(Phylogeny phylogeny) {
        this._cut_or_copied_tree = phylogeny;
    }

    void setTreeColorSet(TreeColorSet treeColorSet) {
        this._colorset = treeColorSet;
        for (TreePanel treePanel : this.getTreePanels()) {
            treePanel.setBackground(treeColorSet.getBackgroundColor());
        }
    }

    void setTreeFontSet(TreeFontSet treeFontSet) {
        this._fontset = treeFontSet;
    }

    void setupTreeGraphic(Configuration configuration, ControlPanel controlPanel) {
        controlPanel.setSpeciesColors(configuration.getSpeciesColors());
        controlPanel.setAnnotationColors(configuration.getAnnotationColors());
        RenderableDomainArchitecture.setColorMap(configuration.getDomainColors());
    }

    public void setWaitCursor() {
        this.setCursor(TreePanel.WAIT_CURSOR);
        this.repaint();
    }

    void terminate() {
        for (TreePanel treePanel : this._treepanels) {
            treePanel.removeAllEditNodeJFrames();
        }
    }
}

