/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.forester.archaeopteryx.Constants;
import org.forester.archaeopteryx.NodeEditPanel;
import org.forester.archaeopteryx.NodePanel;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.util.ForesterUtil;

final class NodeFrame
extends JFrame {
    private static final long serialVersionUID = -6943510233968557246L;
    private final TreePanel _reepanel;
    private int _index = -1;

    NodeFrame(PhylogenyNode phylogenyNode, Phylogeny phylogeny, TreePanel treePanel, int n) {
        super("Node " + (ForesterUtil.isEmpty(phylogenyNode.getNodeName()) ? Integer.valueOf(phylogenyNode.getNodeId()) : phylogenyNode.getNodeName()));
        this._reepanel = treePanel;
        this.setSize(Constants.NODE_FRAME_SIZE);
        this._index = n;
        Container container = this.getContentPane();
        NodePanel nodePanel = new NodePanel(phylogenyNode);
        container.add((Component)nodePanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NodeFrame.this.remove();
                NodeFrame.this.dispose();
            }
        });
        this.setResizable(false);
        nodePanel.setVisible(true);
        this.setVisible(true);
    }

    NodeFrame(PhylogenyNode phylogenyNode, Phylogeny phylogeny, TreePanel treePanel, int n, String string) {
        super("Editable Node " + (ForesterUtil.isEmpty(phylogenyNode.getNodeName()) ? Integer.valueOf(phylogenyNode.getNodeId()) : phylogenyNode.getNodeName()));
        this._reepanel = treePanel;
        this.setSize(Constants.NODE_FRAME_SIZE);
        this._index = n;
        Container container = this.getContentPane();
        final NodeEditPanel nodeEditPanel = new NodeEditPanel(phylogenyNode, treePanel);
        container.add((Component)nodeEditPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                try {
                    nodeEditPanel.writeAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                NodeFrame.this.remove();
                NodeFrame.this.dispose();
            }
        });
        this.setResizable(false);
        nodeEditPanel.setVisible(true);
        this.setVisible(true);
    }

    TreePanel getTreePanel() {
        return this._reepanel;
    }

    void remove() {
        if (this._index > -1) {
            this._reepanel.removeEditNodeFrame(this._index);
        }
    }
}

