/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.util.List;
import java.util.SortedMap;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.forester.archaeopteryx.Constants;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.Point;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Reference;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodePanel
extends JPanel
implements TreeSelectionListener {
    static final String DIST_ALTITUDE = "Altitude";
    static final String DIST_ALT_UNIT = "Altitude unit";
    static final String DIST_LONGITUDE = "Longitude";
    static final String DIST_LATITUDE = "Latitude";
    static final String DIST_GEODETIC_DATUM = "Geodetic datum";
    static final String DIST_DESCRIPTION = "Description";
    static final String DATE_UNIT = "Unit";
    static final String DATE_MAX = "Max";
    static final String DATE_MIN = "Min";
    static final String DATE_VALUE = "Value";
    static final String DATE_DESCRIPTION = "Description";
    static final String TAXONOMY_IDENTIFIER = "Identifier";
    static final String SEQ_ACCESSION = "Accession";
    static final String CONFIDENCE = "Confidence";
    static final String PROP = "Properties";
    static final String BINARY_CHARACTERS = "Binary characters";
    static final String REFERENCE = "Reference";
    static final String LIT_REFERENCE = "Reference";
    static final String LIT_REFERENCE_DESC = "Description";
    static final String LIT_REFERENCE_DOI = "DOI";
    static final String DISTRIBUTION = "Distribution";
    static final String DATE = "Date";
    static final String EVENTS = "Events";
    static final String SEQUENCE = "Sequence";
    static final String TAXONOMY = "Taxonomy";
    static final String BASIC = "Basic";
    static final String TAXONOMY_SCIENTIFIC_NAME = "Scientific name";
    static final String SEQ_MOL_SEQ = "Mol seq";
    static final String SEQ_TYPE = "Type";
    static final String SEQ_LOCATION = "Location";
    static final String SEQ_SYMBOL = "Symbol";
    static final String SEQ_URI = "URI";
    static final String NODE_BRANCH_LENGTH = "Branch length";
    static final String NODE_NAME = "Name";
    static final String TAXONOMY_URI = "URI";
    static final String TAXONOMY_RANK = "Rank";
    static final String TAXONOMY_SYNONYM = "Synonym";
    static final String TAXONOMY_COMMON_NAME = "Common name";
    static final String TAXONOMY_AUTHORITY = "Authority";
    static final String TAXONOMY_CODE = "Code";
    static final String SEQ_NAME = "Name";
    static final String EVENTS_GENE_LOSSES = "Gene losses";
    static final String EVENTS_SPECIATIONS = "Speciations";
    static final String EVENTS_DUPLICATIONS = "Duplications";
    private static final long serialVersionUID = 5120159904388100771L;
    static final String CONFIDENCE_TYPE = "type";
    private final JTree _tree;
    private final JEditorPane _pane;

    public NodePanel(PhylogenyNode phylogenyNode) {
        String string = "";
        if (!ForesterUtil.isEmpty(phylogenyNode.getNodeName())) {
            string = phylogenyNode.getNodeName() + " ";
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Node " + string);
        NodePanel.createNodes(defaultMutableTreeNode, phylogenyNode);
        this._tree = new JTree(defaultMutableTreeNode);
        this._tree.setEditable(false);
        this.getJTree().setToggleClickCount(1);
        this.expandPath(BASIC);
        this.expandPath(TAXONOMY);
        this.expandPath(SEQUENCE);
        this.expandPath(EVENTS);
        JScrollPane jScrollPane = new JScrollPane(this.getJTree());
        this._pane = new JEditorPane();
        this._pane.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this._pane);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(jScrollPane);
        jSplitPane.setBottomComponent(jScrollPane2);
        jScrollPane2.setMinimumSize(Constants.NODE_PANEL_SPLIT_MINIMUM_SIZE);
        jScrollPane.setMinimumSize(Constants.NODE_PANEL_SPLIT_MINIMUM_SIZE);
        jSplitPane.setDividerLocation(400);
        jSplitPane.setPreferredSize(Constants.NODE_PANEL_SIZE);
        this.add(jSplitPane);
    }

    private void expandPath(String string) {
        TreePath treePath = this.getJTree().getNextMatch(string, 0, Position.Bias.Forward);
        if (treePath != null) {
            this.getJTree().expandPath(treePath);
        }
    }

    private JTree getJTree() {
        return this._tree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    private static void addAnnotation(DefaultMutableTreeNode defaultMutableTreeNode, Annotation annotation, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        NodePanel.addSubelement(defaultMutableTreeNode2, "Reference", annotation.getRef());
        NodePanel.addSubelement(defaultMutableTreeNode2, "Description", annotation.getDesc());
        NodePanel.addSubelement(defaultMutableTreeNode2, "Source", annotation.getSource());
        NodePanel.addSubelement(defaultMutableTreeNode2, SEQ_TYPE, annotation.getType());
        NodePanel.addSubelement(defaultMutableTreeNode2, "Evidence", annotation.getEvidence());
        if (annotation.getConfidence() != null) {
            NodePanel.addSubelement(defaultMutableTreeNode2, CONFIDENCE, annotation.getConfidence().asText().toString());
        }
        if (annotation.getProperties() != null) {
            NodePanel.addProperties(defaultMutableTreeNode2, annotation.getProperties(), PROP);
        }
    }

    private static void addAnnotations(DefaultMutableTreeNode defaultMutableTreeNode, List<PhylogenyData> list, DefaultMutableTreeNode defaultMutableTreeNode2) {
        if (list != null && list.size() > 0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Annotations"));
            DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode.getLastLeaf();
            int n = 0;
            for (PhylogenyData phylogenyData : list) {
                NodePanel.addAnnotation(defaultMutableTreeNode3, (Annotation)phylogenyData, "Annotation " + n++);
            }
        }
    }

    private static void addBasics(DefaultMutableTreeNode defaultMutableTreeNode, PhylogenyNode phylogenyNode, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        NodePanel.addSubelement(defaultMutableTreeNode2, "Name", phylogenyNode.getNodeName());
        if (phylogenyNode.getDistanceToParent() != -1024.0) {
            NodePanel.addSubelement(defaultMutableTreeNode2, NODE_BRANCH_LENGTH, ForesterUtil.FORMATTER_6.format(phylogenyNode.getDistanceToParent()));
        }
        if (phylogenyNode.getBranchData().isHasConfidences()) {
            for (Confidence confidence : phylogenyNode.getBranchData().getConfidences()) {
                NodePanel.addSubelement(defaultMutableTreeNode2, CONFIDENCE, confidence.asText().toString());
            }
        }
        if (!phylogenyNode.isExternal()) {
            NodePanel.addSubelement(defaultMutableTreeNode2, "Children", String.valueOf(phylogenyNode.getNumberOfDescendants()));
            NodePanel.addSubelement(defaultMutableTreeNode2, "External children", String.valueOf(phylogenyNode.getAllExternalDescendants().size()));
            int n = PhylogenyMethods.calculateSumOfDistinctTaxonomies(phylogenyNode);
            if (n > 0) {
                NodePanel.addSubelement(defaultMutableTreeNode2, "Distinct external taxonomies", String.valueOf(n));
            }
        }
        if (!phylogenyNode.isRoot()) {
            NodePanel.addSubelement(defaultMutableTreeNode2, "Depth", String.valueOf(PhylogenyMethods.calculateDepth(phylogenyNode)));
            double d = PhylogenyMethods.calculateDistanceToRoot(phylogenyNode);
            if (d > 0.0) {
                NodePanel.addSubelement(defaultMutableTreeNode2, "Distance to root", String.valueOf(ForesterUtil.FORMATTER_6.format(d)));
            }
        }
    }

    private static void addBinaryCharacters(DefaultMutableTreeNode defaultMutableTreeNode, BinaryCharacters binaryCharacters, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        NodePanel.addSubelement(defaultMutableTreeNode2, "Gained", String.valueOf(binaryCharacters.getGainedCount()));
        NodePanel.addSubelement(defaultMutableTreeNode2, "Lost", String.valueOf(binaryCharacters.getLostCount()));
        NodePanel.addSubelement(defaultMutableTreeNode2, "Present", String.valueOf(binaryCharacters.getPresentCount()));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Lists");
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        NodePanel.addSubelement(defaultMutableTreeNode3, "Gained", binaryCharacters.getGainedCharactersAsStringBuffer().toString());
        NodePanel.addSubelement(defaultMutableTreeNode3, "Lost", binaryCharacters.getLostCharactersAsStringBuffer().toString());
        NodePanel.addSubelement(defaultMutableTreeNode3, "Present", binaryCharacters.getPresentCharactersAsStringBuffer().toString());
    }

    private static void addDate(DefaultMutableTreeNode defaultMutableTreeNode, Date date, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        NodePanel.addSubelement(defaultMutableTreeNode2, "Description", date.getDesc());
        NodePanel.addSubelement(defaultMutableTreeNode2, DATE_VALUE, String.valueOf(date.getValue()));
        NodePanel.addSubelement(defaultMutableTreeNode2, DATE_MIN, String.valueOf(date.getMin()));
        NodePanel.addSubelement(defaultMutableTreeNode2, DATE_MAX, String.valueOf(date.getMax()));
        NodePanel.addSubelement(defaultMutableTreeNode2, DATE_UNIT, date.getUnit());
    }

    private static void addDistribution(DefaultMutableTreeNode defaultMutableTreeNode, Distribution distribution, String string) {
        Point point;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        NodePanel.addSubelement(defaultMutableTreeNode2, "Description", distribution.getDesc());
        if (distribution.getPoints() != null && distribution.getPoints().size() > 0 && (point = distribution.getPoints().get(0)) != null) {
            NodePanel.addSubelement(defaultMutableTreeNode2, DIST_GEODETIC_DATUM, point.getGeodeticDatum());
            NodePanel.addSubelement(defaultMutableTreeNode2, DIST_LATITUDE, String.valueOf(point.getLatitude()));
            NodePanel.addSubelement(defaultMutableTreeNode2, DIST_LONGITUDE, String.valueOf(point.getLongitude()));
            String string2 = point.getAltiudeUnit();
            if (ForesterUtil.isEmpty(string2)) {
                string2 = "?";
            }
            NodePanel.addSubelement(defaultMutableTreeNode2, DIST_ALTITUDE, String.valueOf(point.getAltitude()) + string2);
        }
    }

    private static void addEvents(DefaultMutableTreeNode defaultMutableTreeNode, Event event, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        if (event.getNumberOfDuplications() > 0) {
            NodePanel.addSubelement(defaultMutableTreeNode2, EVENTS_DUPLICATIONS, String.valueOf(event.getNumberOfDuplications()));
        }
        if (event.getNumberOfSpeciations() > 0) {
            NodePanel.addSubelement(defaultMutableTreeNode2, EVENTS_SPECIATIONS, String.valueOf(event.getNumberOfSpeciations()));
        }
        if (event.getNumberOfGeneLosses() > 0) {
            NodePanel.addSubelement(defaultMutableTreeNode2, EVENTS_GENE_LOSSES, String.valueOf(event.getNumberOfGeneLosses()));
        }
        NodePanel.addSubelement(defaultMutableTreeNode2, SEQ_TYPE, event.getEventType().toString());
        if (event.getConfidence() != null) {
            NodePanel.addSubelement(defaultMutableTreeNode2, CONFIDENCE, event.getConfidence().asText().toString());
        }
    }

    private static void addProperties(DefaultMutableTreeNode defaultMutableTreeNode, PropertiesMap propertiesMap, String string) {
        SortedMap<String, Property> sortedMap = propertiesMap.getProperties();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Properties ");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (String string2 : sortedMap.keySet()) {
            Property property = (Property)sortedMap.get(string2);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(property.getRef() + " " + property.getValue() + " " + property.getUnit() + " [" + property.getAppliesTo().toString() + "]"));
        }
    }

    private static void addReference(DefaultMutableTreeNode defaultMutableTreeNode, Reference reference, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        NodePanel.addSubelement(defaultMutableTreeNode2, LIT_REFERENCE_DOI, reference.getDoi());
        NodePanel.addSubelement(defaultMutableTreeNode2, "Description", reference.getValue());
    }

    private static void addSequence(DefaultMutableTreeNode defaultMutableTreeNode, Sequence sequence, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        NodePanel.addSubelement(defaultMutableTreeNode2, "Name", sequence.getName());
        NodePanel.addSubelement(defaultMutableTreeNode2, SEQ_SYMBOL, sequence.getSymbol());
        if (sequence.getAccession() != null) {
            NodePanel.addSubelement(defaultMutableTreeNode2, SEQ_ACCESSION, sequence.getAccession().asText().toString());
        }
        NodePanel.addSubelement(defaultMutableTreeNode2, SEQ_LOCATION, sequence.getLocation());
        NodePanel.addSubelement(defaultMutableTreeNode2, SEQ_TYPE, sequence.getType());
        NodePanel.addSubelement(defaultMutableTreeNode2, SEQ_MOL_SEQ, sequence.getMolecularSequence());
        if (sequence.getUri() != null) {
            NodePanel.addSubelement(defaultMutableTreeNode2, "URI", sequence.getUri().getValue().toString());
        }
        NodePanel.addAnnotations(defaultMutableTreeNode, sequence.getAnnotations(), defaultMutableTreeNode2);
    }

    private static void addSubelement(DefaultMutableTreeNode defaultMutableTreeNode, String string, String string2) {
        if (!ForesterUtil.isEmpty(string2)) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(string + ": " + string2));
        }
    }

    private static void addTaxonomy(DefaultMutableTreeNode defaultMutableTreeNode, Taxonomy taxonomy, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        if (taxonomy.getIdentifier() != null) {
            NodePanel.addSubelement(defaultMutableTreeNode2, TAXONOMY_IDENTIFIER, taxonomy.getIdentifier().asText().toString());
        }
        NodePanel.addSubelement(defaultMutableTreeNode2, TAXONOMY_CODE, taxonomy.getTaxonomyCode());
        NodePanel.addSubelement(defaultMutableTreeNode2, TAXONOMY_SCIENTIFIC_NAME, taxonomy.getScientificName());
        NodePanel.addSubelement(defaultMutableTreeNode2, TAXONOMY_AUTHORITY, taxonomy.getAuthority());
        NodePanel.addSubelement(defaultMutableTreeNode2, TAXONOMY_COMMON_NAME, taxonomy.getCommonName());
        for (String string2 : taxonomy.getSynonyms()) {
            NodePanel.addSubelement(defaultMutableTreeNode2, TAXONOMY_SYNONYM, string2);
        }
        NodePanel.addSubelement(defaultMutableTreeNode2, TAXONOMY_RANK, taxonomy.getRank());
        if (taxonomy.getUri() != null) {
            NodePanel.addSubelement(defaultMutableTreeNode2, "URI", taxonomy.getUri().getValue().toString());
        }
    }

    private static void createNodes(DefaultMutableTreeNode defaultMutableTreeNode, PhylogenyNode phylogenyNode) {
        NodePanel.addBasics(defaultMutableTreeNode, phylogenyNode, BASIC);
        if (phylogenyNode.getNodeData().isHasTaxonomy()) {
            NodePanel.addTaxonomy(defaultMutableTreeNode, phylogenyNode.getNodeData().getTaxonomy(), TAXONOMY);
        }
        if (phylogenyNode.getNodeData().isHasSequence()) {
            NodePanel.addSequence(defaultMutableTreeNode, phylogenyNode.getNodeData().getSequence(), SEQUENCE);
        }
        if (phylogenyNode.getNodeData().isHasEvent()) {
            NodePanel.addEvents(defaultMutableTreeNode, phylogenyNode.getNodeData().getEvent(), EVENTS);
        }
        if (phylogenyNode.getNodeData().isHasDate()) {
            NodePanel.addDate(defaultMutableTreeNode, phylogenyNode.getNodeData().getDate(), DATE);
        }
        if (phylogenyNode.getNodeData().isHasDistribution()) {
            NodePanel.addDistribution(defaultMutableTreeNode, phylogenyNode.getNodeData().getDistribution(), DISTRIBUTION);
        }
        if (phylogenyNode.getNodeData().isHasReference()) {
            NodePanel.addReference(defaultMutableTreeNode, phylogenyNode.getNodeData().getReference(), "Reference");
        }
        if (phylogenyNode.getNodeData().isHasBinaryCharacters()) {
            NodePanel.addBinaryCharacters(defaultMutableTreeNode, phylogenyNode.getNodeData().getBinaryCharacters(), BINARY_CHARACTERS);
        }
        if (phylogenyNode.getNodeData().isHasProperties()) {
            NodePanel.addProperties(defaultMutableTreeNode, phylogenyNode.getNodeData().getProperties(), PROP);
        }
    }
}

