/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Color;
import java.util.SortedMap;
import org.forester.archaeopteryx.Configuration;
import org.forester.util.ForesterUtil;

final class TreeColorSet {
    static final String[] SCHEME_NAMES = new String[]{"Default", "Black", "Black & White", "Silver", "The Matrix", "White & Blue", "Cyan", "Clockwork", "Blue", "Blue & White", "Neon"};
    static final String[] COLOR_FIELDS = new String[]{"Background", "Background Gradient Bottom", "Sequence", "Taxonomy", "Confidence", "Branch Length", "Branch", "Node Box", "Collapsed", "Matching Nodes", "Duplication", "Speciation", "Duplication or Specation", "Domains", "Binary Domain Combinations", "Annotation", "Overview"};
    private final Color[][] _color_schemes = new Color[][]{{new Color(0, 0, 0), new Color(0, 100, 100), new Color(220, 220, 220), new Color(180, 180, 180), new Color(56, 176, 222), new Color(140, 140, 140), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 0), new Color(0, 255, 0), new Color(255, 0, 0), new Color(0, 255, 0), new Color(255, 255, 0), new Color(123, 104, 238), new Color(65, 105, 255), new Color(173, 255, 47), new Color(130, 130, 130)}, {new Color(0, 0, 0), new Color(0, 255, 255), new Color(220, 220, 220), new Color(180, 180, 180), new Color(56, 176, 222), new Color(140, 140, 140), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 0), new Color(0, 255, 0), new Color(255, 0, 0), new Color(0, 255, 0), new Color(255, 255, 0), new Color(123, 104, 238), new Color(65, 105, 255), new Color(173, 255, 47), new Color(130, 130, 130)}, {new Color(255, 255, 255), new Color(0, 255, 255), new Color(0, 0, 0), new Color(0, 0, 0), new Color(0, 0, 0), new Color(0, 0, 0), new Color(0, 0, 0), new Color(0, 0, 0), new Color(0, 0, 0), new Color(255, 0, 0), new Color(0, 0, 0), new Color(200, 200, 200), new Color(0, 0, 0), new Color(0, 0, 0), new Color(0, 0, 0), new Color(0, 0, 0), new Color(220, 220, 220)}, {new Color(0, 0, 0), new Color(0, 255, 255), new Color(220, 220, 220), new Color(180, 180, 180), new Color(140, 140, 140), new Color(140, 140, 140), new Color(240, 240, 240), new Color(140, 140, 140), new Color(140, 140, 140), new Color(255, 0, 0), new Color(255, 0, 0), new Color(200, 200, 200), new Color(140, 140, 140), new Color(180, 180, 180), new Color(180, 180, 180), new Color(140, 140, 140), new Color(40, 40, 40)}, {new Color(0, 10, 0), new Color(0, 255, 255), new Color(0, 255, 0), new Color(30, 200, 30), new Color(0, 155, 0), new Color(0, 100, 0), new Color(0, 155, 0), new Color(0, 255, 0), new Color(0, 255, 0), new Color(255, 255, 255), new Color(255, 255, 255), new Color(0, 255, 0), new Color(120, 120, 120), new Color(0, 235, 0), new Color(0, 235, 0), new Color(0, 235, 0), new Color(40, 40, 40)}, {new Color(255, 255, 255), new Color(0, 255, 255), new Color(0, 0, 0), new Color(40, 40, 40), new Color(0, 125, 0), new Color(70, 70, 0), new Color(0, 20, 200), new Color(0, 20, 200), new Color(255, 255, 0), new Color(0, 255, 0), new Color(255, 0, 0), new Color(0, 255, 0), new Color(255, 255, 0), new Color(123, 104, 238), new Color(65, 105, 225), new Color(173, 255, 47), new Color(220, 220, 220)}, {new Color(0, 0, 0), new Color(0, 255, 255), new Color(255, 255, 255), new Color(200, 200, 200), new Color(255, 255, 255), new Color(200, 200, 200), new Color(0, 255, 255), new Color(0, 255, 255), new Color(255, 255, 0), new Color(0, 255, 0), new Color(255, 0, 0), new Color(0, 255, 0), new Color(255, 255, 0), new Color(123, 104, 238), new Color(65, 105, 225), new Color(173, 255, 47), new Color(0, 120, 120)}, {new Color(0, 0, 0), new Color(0, 255, 255), new Color(255, 200, 0), new Color(255, 200, 0), new Color(255, 200, 0), new Color(255, 200, 0), new Color(255, 200, 0), new Color(255, 200, 0), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 0, 0), new Color(0, 255, 0), new Color(255, 255, 0), new Color(150, 150, 150), new Color(150, 150, 150), new Color(150, 150, 150), new Color(150, 150, 150)}, {new Color(0, 0, 100), new Color(0, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 0, 0), new Color(255, 0, 0), new Color(255, 0, 0), new Color(255, 0, 0), new Color(0, 0, 0), new Color(0, 255, 0), new Color(255, 0, 255), new Color(255, 255, 255), new Color(100, 100, 100), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255), new Color(77, 77, 255)}, {new Color(0, 0, 0), new Color(0, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255), new Color(0, 191, 255), new Color(0, 191, 255), new Color(0, 191, 255), new Color(255, 255, 255), new Color(255, 0, 0), new Color(255, 0, 0), new Color(0, 255, 0), new Color(255, 255, 0), new Color(255, 255, 255), new Color(255, 255, 255), new Color(255, 255, 255), new Color(170, 187, 204)}, {new Color(0, 0, 0), new Color(255, 255, 0), new Color(127, 255, 0), new Color(255, 110, 199), new Color(234, 173, 234), new Color(77, 77, 255), new Color(234, 173, 234), new Color(77, 77, 255), new Color(77, 77, 255), new Color(243, 243, 21), new Color(255, 0, 0), new Color(0, 255, 0), new Color(255, 255, 0), new Color(27, 255, 0), new Color(27, 255, 0), new Color(27, 255, 0), new Color(77, 77, 255)}};
    private int _color_scheme;
    private Color seq_color;
    private Color taxonomy_color;
    private Color bootstrap_color;
    private Color branch_length_color;
    private Color branch_color;
    private Color box_color;
    private Color background_color;
    private Color background_color_gradient_bottom;
    private Color dup_box_color;
    private Color spec_box_color;
    private Color collapse_fill_color;
    private Color found_color;
    private Color duplication_or_specation_color;
    private Color domains_color;
    private Color binary_domain_combinations_color;
    private Color annotation_color;
    private Color ov_color;

    private TreeColorSet() {
    }

    void cycleColorScheme() {
        if (this.getCurrentColorScheme() >= this._color_schemes.length - 1) {
            this.setColorSchema(0);
        } else {
            this.setColorSchema(this.getCurrentColorScheme() + 1);
        }
    }

    Color getAnnotationColor() {
        return this.annotation_color;
    }

    Color getBackgroundColor() {
        return this.background_color;
    }

    Color getBackgroundColorGradientBottom() {
        return this.background_color_gradient_bottom;
    }

    Color getBinaryDomainCombinationsColor() {
        return this.binary_domain_combinations_color;
    }

    Color getBoxColor() {
        return this.box_color;
    }

    Color getBranchColor() {
        return this.branch_color;
    }

    Color getBranchColorForPdf() {
        return Color.BLACK;
    }

    Color getBranchLengthColor() {
        return this.branch_length_color;
    }

    Color getCollapseFillColor() {
        return this.collapse_fill_color;
    }

    Color[][] getColorSchemes() {
        return this._color_schemes;
    }

    Color getConfidenceColor() {
        return this.bootstrap_color;
    }

    int getCurrentColorScheme() {
        return this._color_scheme;
    }

    String getCurrentColorSchemeName() {
        return SCHEME_NAMES[this.getCurrentColorScheme()];
    }

    Color getDomainsColor() {
        return this.domains_color;
    }

    Color getDuplicationBoxColor() {
        return this.dup_box_color;
    }

    Color getDuplicationOrSpeciationColor() {
        return this.duplication_or_specation_color;
    }

    Color getFoundColor() {
        return this.found_color;
    }

    Color getGainedCharactersColor() {
        return Color.GREEN;
    }

    Color getLostCharactersColor() {
        return Color.RED;
    }

    Color getOvColor() {
        return this.ov_color;
    }

    Color getSequenceColor() {
        return this.seq_color;
    }

    Color getSpecBoxColor() {
        return this.spec_box_color;
    }

    Color getTaxonomyColor() {
        return this.taxonomy_color;
    }

    void setColorforDefault(String string, Color color) {
        String string2 = string.trim().replace('_', ' ');
        boolean bl = false;
        int n = 0;
        for (String string3 : COLOR_FIELDS) {
            if (string2.equalsIgnoreCase(string3)) {
                bl = true;
                this.setColorForDefault(n, color);
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new IllegalArgumentException("unknown color field name [" + string + "]");
        }
    }

    private void setColorForDefault(int n, Color color) {
        this._color_schemes[0][n] = color;
    }

    void setColorSchema(int n) {
        this._color_scheme = n;
        this.background_color = this._color_schemes[n][0];
        this.background_color_gradient_bottom = this._color_schemes[n][1];
        this.seq_color = this._color_schemes[n][2];
        this.taxonomy_color = this._color_schemes[n][3];
        this.bootstrap_color = this._color_schemes[n][4];
        this.branch_length_color = this._color_schemes[n][5];
        this.branch_color = this._color_schemes[n][6];
        this.box_color = this._color_schemes[n][7];
        this.collapse_fill_color = this._color_schemes[n][8];
        this.found_color = this._color_schemes[n][9];
        this.dup_box_color = this._color_schemes[n][10];
        this.spec_box_color = this._color_schemes[n][11];
        this.duplication_or_specation_color = this._color_schemes[n][12];
        this.domains_color = this._color_schemes[n][13];
        this.binary_domain_combinations_color = this._color_schemes[n][14];
        this.annotation_color = this._color_schemes[n][15];
        this.ov_color = this._color_schemes[n][16];
    }

    void setCurrentColorScheme(int n) {
        this._color_scheme = n;
    }

    static TreeColorSet createInstance() {
        TreeColorSet treeColorSet = new TreeColorSet();
        treeColorSet.setColorSchema(0);
        return treeColorSet;
    }

    static TreeColorSet createInstance(Configuration configuration) {
        TreeColorSet treeColorSet = new TreeColorSet();
        if (configuration != null && configuration.getDisplayColors() != null && configuration.getDisplayColors().size() > 0) {
            SortedMap<String, Color> sortedMap = configuration.getDisplayColors();
            for (String string : sortedMap.keySet()) {
                Color color = (Color)sortedMap.get(string);
                try {
                    treeColorSet.setColorforDefault(string, color);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ForesterUtil.printWarningMessage("Archaeopteryx", illegalArgumentException.getMessage());
                }
            }
        }
        treeColorSet.setColorSchema(0);
        return treeColorSet;
    }
}

