/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;

public final class TreeFontSet {
    private static final String DEFAULT_FONT = "Verdana";
    private static final float FONT_SIZE_CHANGE_STEP = 1.0f;
    static final int BOLD_AND_ITALIC = 3;
    private final Component _owner;
    private Font _small_font;
    private Font _large_font;
    private Font _small_italic_font;
    private Font _large_italic_font;
    private Font _base_font;
    public FontMetrics _fm_small;
    FontMetrics _fm_large;
    FontMetrics _fm_small_italic;
    FontMetrics _fm_small_italic_bold;
    FontMetrics _fm_large_italic;
    FontMetrics _fm_large_italic_bold;
    int _small_max_descent = 0;
    int _small_max_ascent = 0;

    TreeFontSet(Component component) {
        this._owner = component;
        this.setBaseFont(new Font(DEFAULT_FONT, 0, 10));
    }

    void decreaseFontSize() {
        if (this._large_font.getSize() > 0) {
            this._small_font = this._small_font.deriveFont((float)this._small_font.getSize() - 1.0f);
            this._large_font = this._large_font.deriveFont((float)this._large_font.getSize() - 1.0f);
            this._small_italic_font = this._small_italic_font.deriveFont((float)this._small_italic_font.getSize() - 1.0f);
            this._large_italic_font = this._large_italic_font.deriveFont((float)this._large_italic_font.getSize() - 1.0f);
            this.setupFontMetrics();
        }
    }

    Font getBaseFont() {
        return this._base_font;
    }

    Font getLargeFont() {
        return this._large_font;
    }

    Font getLargeItalicFont() {
        return this._large_italic_font;
    }

    public Font getSmallFont() {
        return this._small_font;
    }

    Font getSmallItalicFont() {
        return this._small_italic_font;
    }

    void increaseFontSize() {
        this._small_font = this._small_font.deriveFont((float)this._small_font.getSize() + 1.0f);
        this._large_font = this._large_font.deriveFont((float)this._large_font.getSize() + 1.0f);
        this._small_italic_font = this._small_italic_font.deriveFont((float)this._small_italic_font.getSize() + 1.0f);
        this._large_italic_font = this._large_italic_font.deriveFont((float)this._large_italic_font.getSize() + 1.0f);
        this.setupFontMetrics();
    }

    private void intializeFonts() {
        int n = this.getBaseFont().getSize() - 1;
        int n2 = 2;
        if (this.getBaseFont().getStyle() == 1) {
            ++n2;
        }
        this._small_font = new Font(this.getBaseFont().getFontName(), this.getBaseFont().getStyle(), n);
        this._large_font = new Font(this.getBaseFont().getFontName(), this.getBaseFont().getStyle(), this.getBaseFont().getSize());
        this._small_italic_font = new Font(this.getBaseFont().getFontName(), n2, n);
        this._large_italic_font = new Font(this.getBaseFont().getFontName(), n2, this.getBaseFont().getSize());
        this.setupFontMetrics();
    }

    void largeFonts() {
        this._small_font = this._small_font.deriveFont(12.0f);
        this._large_font = this._large_font.deriveFont(14.0f);
        this._small_italic_font = this._small_italic_font.deriveFont(12.0f);
        this._large_italic_font = this._large_italic_font.deriveFont(14.0f);
        this.setupFontMetrics();
    }

    void mediumFonts() {
        this._small_font = this._small_font.deriveFont(8.0f);
        this._large_font = this._large_font.deriveFont(10.0f);
        this._small_italic_font = this._small_italic_font.deriveFont(8.0f);
        this._large_italic_font = this._large_italic_font.deriveFont(10.0f);
        this.setupFontMetrics();
    }

    void setBaseFont(Font font) {
        this._base_font = font;
        this.intializeFonts();
    }

    private void setupFontMetrics() {
        this._fm_small = this._owner.getFontMetrics(this._small_font);
        this._fm_large = this._owner.getFontMetrics(this._large_font);
        this._fm_small_italic = this._owner.getFontMetrics(this._small_italic_font);
        this._fm_small_italic_bold = this._owner.getFontMetrics(this._small_italic_font.deriveFont(1));
        this._fm_large_italic = this._owner.getFontMetrics(this._large_italic_font);
        this._fm_large_italic_bold = this._owner.getFontMetrics(this._large_italic_font.deriveFont(1));
        this._small_max_descent = this._fm_small.getMaxDescent();
        this._small_max_ascent = this._fm_small.getMaxAscent() + 1;
    }

    void smallFonts() {
        this._small_font = this._small_font.deriveFont(7.0f);
        this._large_font = this._large_font.deriveFont(8.0f);
        this._small_italic_font = this._small_italic_font.deriveFont(7.0f);
        this._large_italic_font = this._large_italic_font.deriveFont(8.0f);
        this.setupFontMetrics();
    }

    void superTinyFonts() {
        this._small_font = this._small_font.deriveFont(2.0f);
        this._large_font = this._large_font.deriveFont(3.0f);
        this._small_italic_font = this._small_italic_font.deriveFont(2.0f);
        this._large_italic_font = this._large_italic_font.deriveFont(3.0f);
        this.setupFontMetrics();
    }

    void tinyFonts() {
        this._small_font = this._small_font.deriveFont(5.0f);
        this._large_font = this._large_font.deriveFont(6.0f);
        this._small_italic_font = this._small_italic_font.deriveFont(5.0f);
        this._large_italic_font = this._large_italic_font.deriveFont(6.0f);
        this.setupFontMetrics();
    }
}

