/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx.phylogeny.data;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.SortedMap;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.TreePanel;
import org.forester.archaeopteryx.phylogeny.data.RenderablePhylogenyData;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.ProteinDomain;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RenderableDomainArchitecture
extends DomainArchitecture
implements RenderablePhylogenyData {
    private static Map<String, Color> Domain_colors;
    private static final int BRIGHTEN_COLOR_BY = 200;
    private static final int E_VALUE_THRESHOLD_EXP_DEFAULT = 0;
    private static int _Next_default_domain_color;
    private static final String[] DEFAULT_DOMAINS_COLORS;
    private int _e_value_threshold_exp = 0;
    private boolean _display_domain_names = true;
    private double _rendering_factor_width = 1.0;
    private double _rendering_height = 0.0;
    private final DomainArchitecture _domain_structure;
    private final Rectangle2D _rectangle = new Rectangle2D.Float();
    private final Configuration _configuration;

    public RenderableDomainArchitecture(DomainArchitecture domainArchitecture, Configuration configuration) {
        this._domain_structure = domainArchitecture;
        this._configuration = configuration;
    }

    private Configuration getConfiguration() {
        return this._configuration;
    }

    @Override
    public StringBuffer asSimpleText() {
        return this._domain_structure.asSimpleText();
    }

    @Override
    public StringBuffer asText() {
        return this._domain_structure.asText();
    }

    @Override
    public PhylogenyData copy() {
        return this._domain_structure.copy();
    }

    private final void drawDomain(double d, double d2, double d3, double d4, String string, Graphics2D graphics2D, boolean bl) {
        double d5 = d4 / 2.0;
        Color color = this.getColorOne(string);
        Color color2 = this.getColorTwo(color);
        double d6 = 1.0;
        if (bl) {
            d6 = 0.1;
        }
        for (double d7 = 0.0; d7 < d4; d7 += d6) {
            graphics2D.setColor(ForesterUtil.calcColor(d7 >= d5 ? d4 - d7 : d7, 0.0, d5, color, color2));
            this._rectangle.setFrame(d, d7 + d2, d3, d6);
            graphics2D.fill(this._rectangle);
        }
    }

    private Color getColorOne(String string) {
        Color color = this.getConfiguration().getDomainStructureBaseColor();
        if (Domain_colors != null && (color = Domain_colors.get(string)) == null) {
            if (_Next_default_domain_color < DEFAULT_DOMAINS_COLORS.length) {
                color = Color.decode(DEFAULT_DOMAINS_COLORS[_Next_default_domain_color++]);
                Domain_colors.put(string, color);
            } else {
                color = this.getConfiguration().getDomainStructureBaseColor();
            }
        }
        return color;
    }

    private Color getColorTwo(Color color) {
        int n = color.getRed() + 200;
        int n2 = color.getGreen() + 200;
        int n3 = color.getBlue() + 200;
        return new Color(n > 255 ? 255 : n, n2 > 255 ? 255 : n2, n3 > 255 ? 255 : n3);
    }

    @Override
    public ProteinDomain getDomain(int n) {
        return this._domain_structure.getDomain(n);
    }

    @Override
    public SortedMap<Double, ProteinDomain> getDomains() {
        return this._domain_structure.getDomains();
    }

    @Override
    public int getNumberOfDomains() {
        return this._domain_structure.getNumberOfDomains();
    }

    @Override
    public Dimension getOriginalSize() {
        return new Dimension(this._domain_structure.getTotalLength(), ForesterUtil.roundToInt(this._rendering_height));
    }

    @Override
    public Object getParameter() {
        return new Integer(this._e_value_threshold_exp);
    }

    public double getRenderingFactorWidth() {
        return this._rendering_factor_width;
    }

    @Override
    public Dimension getRenderingSize() {
        return new Dimension(ForesterUtil.roundToInt((double)this._domain_structure.getTotalLength() * this._rendering_factor_width), ForesterUtil.roundToInt(this._rendering_height));
    }

    @Override
    public int getTotalLength() {
        return this._domain_structure.getTotalLength();
    }

    public boolean isDisplayDomainNames() {
        return this._display_domain_names;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        return this._domain_structure.isEqual(phylogenyData);
    }

    @Override
    public void render(double d, double d2, Graphics2D graphics2D, TreePanel treePanel, boolean bl) {
        double d3 = this.getRenderingFactorWidth();
        double d4 = d2 + this._rendering_height / 2.0;
        double d5 = d + 20.0;
        graphics2D.setColor(this.getConfiguration().getDomainStructureFontColor());
        this._rectangle.setFrame(d5, d4 - 0.5, (double)this._domain_structure.getTotalLength() * d3, 1.0);
        graphics2D.fill(this._rectangle);
        for (int i = 0; i < this._domain_structure.getDomains().size(); ++i) {
            ProteinDomain proteinDomain = this._domain_structure.getDomain(i);
            if (!(proteinDomain.getConfidence() <= Math.pow(10.0, this._e_value_threshold_exp))) continue;
            double d6 = d5 + (double)proteinDomain.getFrom() * d3;
            double d7 = d6 + (double)proteinDomain.getLength() * d3;
            if (this.isDisplayDomainNames()) {
                graphics2D.setFont(treePanel.getMainPanel().getTreeFontSet().getSmallFont());
                graphics2D.setColor(this.getConfiguration().getDomainStructureFontColor());
                PhylogenyDataUtil.drawString(proteinDomain.getName(), d6, d2 + (double)treePanel.getMainPanel().getTreeFontSet()._fm_small.getAscent() + 6.0, graphics2D);
            }
            this.drawDomain(d6, d2, d7 - d6, this._rendering_height, proteinDomain.getName(), graphics2D, bl);
        }
    }

    public void setDisplayDomainNames(boolean bl) {
        this._display_domain_names = bl;
    }

    @Override
    public void setParameter(double d) {
        this._e_value_threshold_exp = (int)d;
    }

    public void setRenderingFactorWidth(double d) {
        this._rendering_factor_width = d;
    }

    @Override
    public void setRenderingHeight(double d) {
        this._rendering_height = d;
    }

    @Override
    public StringBuffer toNHX() {
        return this._domain_structure.toNHX();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        this._domain_structure.toPhyloXML(writer, n, string);
    }

    public static void setColorMap(Map<String, Color> map) {
        Domain_colors = map;
    }

    static {
        _Next_default_domain_color = 0;
        DEFAULT_DOMAINS_COLORS = new String[]{"0xFF0000", "0x0000FF", "0xAAAA00", "0xFF00FF", "0x00FFFF", "0x800000", "0x000080", "0x808000", "0x800080", "0x008080", "0xE1B694"};
    }
}

