/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.util.List;
import org.forester.development.Msa;
import org.forester.development.Sequence;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMsa
implements Msa {
    final char[][] _data;
    final Object[] _identifiers;
    final Sequence.TYPE _type;

    private BasicMsa(int n, int n2, Sequence.TYPE tYPE) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("basic MSA of size zero are illegal");
        }
        this._data = new char[n][n2];
        this._identifiers = new Object[n];
        this._type = tYPE;
    }

    private int determineMaxIdLength() {
        int n = 0;
        for (int i = 0; i < this._data.length; ++i) {
            int n2 = this._identifiers[i].toString().length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public Object getIdentifier(int n) {
        return this._identifiers[n];
    }

    @Override
    public int getLength() {
        return this._data[0].length;
    }

    @Override
    public int getNumberOfSequences() {
        return this._identifiers.length;
    }

    @Override
    public char getResidueAt(int n, int n2) {
        return this._data[n][n2];
    }

    @Override
    public Sequence getSequence(int n) {
        return null;
    }

    @Override
    public Sequence.TYPE getType() {
        return this._type;
    }

    private void setIdentifier(int n, Object object) {
        this._identifiers[n] = object;
    }

    private void setResidueAt(int n, int n2, char c) {
        this._data[n][n2] = c;
    }

    public String toString() {
        int n = this.determineMaxIdLength() + 1;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._data.length; ++i) {
            stringBuffer.append(ForesterUtil.pad(this._identifiers[i].toString(), n, ' ', false));
            for (int j = 0; j < this._data[0].length; ++j) {
                stringBuffer.append(this._data[i][j]);
            }
            stringBuffer.append(ForesterUtil.LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public static Msa createInstance(List<Sequence> list) {
        if (list.size() < 1) {
            throw new IllegalArgumentException("basic MSA of size zero are illegal");
        }
        int n = list.get(0).getLength();
        BasicMsa basicMsa = new BasicMsa(list.size(), n, list.get(0).getType());
        for (int i = 0; i < list.size(); ++i) {
            Sequence sequence = list.get(i);
            if (sequence.getLength() != n) {
                throw new IllegalArgumentException("illegal attempt to build MSA from sequences of unequal length");
            }
            if (sequence.getType() != basicMsa.getType()) {
                throw new IllegalArgumentException("illegal attempt to build MSA from sequences of different type");
            }
            basicMsa.setIdentifier(i, sequence.getIdentifier());
            for (int j = 0; j < n; ++j) {
                basicMsa.setResidueAt(i, j, sequence.getResidueAt(j));
            }
        }
        return basicMsa;
    }
}

