/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import org.forester.development.Sequence;

public class BasicSequence
implements Sequence {
    public static final char UNSPECIFIED_AA = 'X';
    public static final char UNSPECIFIED_NUC = 'N';
    public static final char GAP = '-';
    public static final char TERMINATE = '*';
    private static final String AA_REGEXP = "[^ARNDBCQEZGHILKMFPSTWYVX\\-\\*]";
    private static final String DNA_REGEXP = "[^ACGTRYMKWSN\\-\\*]";
    private static final String RNA_REGEXP = "[^ACGURYMKWSN\\-\\*]";
    private final char[] _mol_sequence;
    private final Object _identifier;
    private final Sequence.TYPE _type;

    private BasicSequence(Object object, String string, Sequence.TYPE tYPE) {
        this._mol_sequence = string.toCharArray();
        this._identifier = object;
        this._type = tYPE;
    }

    public Object getIdentifier() {
        return this._identifier;
    }

    public int getLength() {
        return this._mol_sequence.length;
    }

    public char[] getMolecularSequence() {
        return this._mol_sequence;
    }

    public char getResidueAt(int n) {
        return this._mol_sequence[n];
    }

    public Sequence.TYPE getType() {
        return this._type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._identifier.toString());
        stringBuffer.append(" ");
        stringBuffer.append(new String(this._mol_sequence));
        return stringBuffer.toString();
    }

    public static Sequence createAaSequence(Object object, String string) {
        return new BasicSequence(object, string.toUpperCase().replaceAll("\\.", "-").replaceAll(AA_REGEXP, Character.toString('X')), Sequence.TYPE.AA);
    }

    public static Sequence createDnaSequence(Object object, String string) {
        return new BasicSequence(object, string.toUpperCase().replaceAll("\\.", "-").replaceAll(DNA_REGEXP, Character.toString('N')), Sequence.TYPE.DNA);
    }

    public static Sequence createRnaSequence(Object object, String string) {
        return new BasicSequence(object, string.toUpperCase().replaceAll("\\.", "-").replaceAll(RNA_REGEXP, Character.toString('N')), Sequence.TYPE.RNA);
    }
}

