/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.util.Random;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;

public final class DevelopmentTools {
    private DevelopmentTools() {
    }

    public static Phylogeny createBalancedPhylogeny(int n, int n2) {
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        Phylogeny phylogeny = new Phylogeny();
        phylogeny.setRoot(phylogenyNode);
        phylogeny.setRooted(true);
        DevelopmentTools.createBalancedPhylogenyRecursion(n, n2, phylogenyNode);
        return phylogeny;
    }

    private static void createBalancedPhylogenyRecursion(int n, int n2, PhylogenyNode phylogenyNode) {
        if (n > 0) {
            --n;
            for (int i = 0; i < n2; ++i) {
                PhylogenyNode phylogenyNode2 = new PhylogenyNode();
                phylogenyNode.addAsChild(phylogenyNode2);
                DevelopmentTools.createBalancedPhylogenyRecursion(n, n2, phylogenyNode2);
            }
        }
    }

    public static void intervalNumberSpecies(Phylogeny phylogeny, int n) {
        if (phylogeny == null || phylogeny.isEmpty()) {
            return;
        }
        int n2 = 1;
        boolean bl = true;
        for (PhylogenyNode phylogenyNode = phylogeny.getFirstExternalNode(); phylogenyNode != null; phylogenyNode = phylogenyNode.getNextExternalNode()) {
            if (bl) {
                PhylogenyMethods.setScientificName(phylogenyNode, n2 + "");
            } else {
                PhylogenyMethods.setScientificName(phylogenyNode, n2 + n + "");
                ++n2;
            }
            bl = !bl;
        }
    }

    public static void numberSpeciesInDescOrder(Phylogeny phylogeny) {
        if (phylogeny == null || phylogeny.isEmpty()) {
            return;
        }
        int n = phylogeny.getRoot().getNumberOfExternalNodes();
        for (PhylogenyNode phylogenyNode = phylogeny.getFirstExternalNode(); phylogenyNode != null; phylogenyNode = phylogenyNode.getNextExternalNode()) {
            PhylogenyMethods.setTaxonomyCode(phylogenyNode, n + "");
            --n;
        }
    }

    public static void numberSpeciesInOrder(Phylogeny phylogeny) {
        if (phylogeny == null || phylogeny.isEmpty()) {
            return;
        }
        int n = 1;
        for (PhylogenyNode phylogenyNode = phylogeny.getFirstExternalNode(); phylogenyNode != null; phylogenyNode = phylogenyNode.getNextExternalNode()) {
            PhylogenyMethods.setScientificName(phylogenyNode, n + "");
            ++n;
        }
    }

    public static void randomizeSpecies(int n, int n2, Phylogeny phylogeny) {
        if (phylogeny == null || phylogeny.isEmpty()) {
            return;
        }
        int n3 = Math.abs(n);
        int n4 = Math.abs(n2);
        Random random = new Random();
        for (PhylogenyNode phylogenyNode = phylogeny.getFirstExternalNode(); phylogenyNode != null; phylogenyNode = phylogenyNode.getNextExternalNode()) {
            String string = Math.abs(random.nextInt()) % (n4 - n3 + 1) + n3 + "";
            PhylogenyMethods.setTaxonomyCode(phylogenyNode, string);
        }
    }
}

