/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.development.BasicMsa;
import org.forester.development.BasicSequence;
import org.forester.development.Msa;
import org.forester.development.Sequence;

public class GeneralMsaParser {
    private static final Pattern NAME_SEQ_PATTERN = Pattern.compile("^(\\S+)\\s+(.+?)\\s*$");
    private static final Pattern INDENTED_SEQ_PATTERN = Pattern.compile("^\\s+(.+?)\\s*$");
    private static final Pattern NON_INDENTED_SEQ_PATTERN = Pattern.compile("^(\\S+)\\s*$");
    private static final String PROBCONS_REGEX = "^CLUSTAL\\s";
    private static final String MUSCLE_REGEX = "^MUSCLE\\s\\(";
    private static final String CLUSTAL_REGEX = "^PROBCONS\\s";
    private static final String ANYTHING_REGEX = ".*[A-Za-z\\-?\\*_\\.]";
    private static final String SELEX_SPECIAL_LINES_REGEX = "^\\s+[*\\.:]+";
    private static final String SPECIAL_LINES_REGEX = "^\\s*(#|%|//|!!).*";

    private static boolean canIgnore(String string) {
        if (!string.matches(ANYTHING_REGEX)) {
            return true;
        }
        return string.matches(SELEX_SPECIAL_LINES_REGEX) || string.matches(SPECIAL_LINES_REGEX);
    }

    private static boolean isProgramNameLine(String string) {
        return string.matches(PROBCONS_REGEX) || string.matches(CLUSTAL_REGEX) || string.matches(MUSCLE_REGEX);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Msa parse(InputStream inputStream) throws IOException {
        Object object;
        int n = -1;
        int n2 = -1;
        String string = null;
        boolean bl = true;
        boolean bl2 = true;
        HashMap<String, StringBuilder> hashMap = new HashMap<String, StringBuilder>();
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string2 = null;
        int n3 = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3;
            ++n3;
            if (GeneralMsaParser.canIgnore(string2)) {
                bl = true;
                continue;
            }
            if (bl2 && GeneralMsaParser.isProgramNameLine(string2)) continue;
            object = NAME_SEQ_PATTERN.matcher(string2);
            Matcher matcher = INDENTED_SEQ_PATTERN.matcher(string2);
            Matcher matcher2 = NON_INDENTED_SEQ_PATTERN.matcher(string2);
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = ((Matcher)object).matches();
            if (!bl5 && !(bl3 = matcher.matches())) {
                bl4 = matcher2.matches();
            }
            if (!bl5 && !bl3) {
                if (!bl4) throw new IOException("illegal MSA format (line: " + n3 + " ): " + string2);
            }
            if (bl) {
                ++n;
                n2 = -1;
                bl = false;
            }
            ++n2;
            if (bl5) {
                string3 = ((Matcher)object).group(1);
                String string4 = ((Matcher)object).group(2);
                if (hashMap.containsKey(string3)) {
                    ((StringBuilder)hashMap.get(string3)).append(string4);
                } else {
                    hashMap.put(string3, new StringBuilder(string4));
                    arrayList.add(string3);
                }
                string = string3;
            } else if (bl3) {
                if (!hashMap.containsKey(string)) throw new IOException("illegal MSA format (line: " + n3 + " ): " + string2);
                ((StringBuilder)hashMap.get(string)).append(matcher.group(1));
            } else if (bl4) {
                if (n == 0) {
                    throw new IOException("first block cannot contain un-named sequence (line: " + n3 + " ): " + string2);
                }
                string3 = (String)arrayList.get(n2);
                if (!hashMap.containsKey(string3)) throw new IOException("illegal MSA format (line: " + n3 + " ):" + string2);
                ((StringBuilder)hashMap.get(string3)).append(matcher2.group(1));
                string = null;
            }
            if (!bl2) continue;
            bl2 = false;
        }
        object = new ArrayList();
        int n4 = 0;
        while (n4 < arrayList.size()) {
            object.add(BasicSequence.createAaSequence(arrayList.get(n4), ((StringBuilder)hashMap.get(arrayList.get(n4))).toString()));
            ++n4;
        }
        return BasicMsa.createInstance((List<Sequence>)object);
    }
}

