/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoId
implements Comparable<GoId> {
    private static final int SIZE = 10;
    private static final String GO_PREFIX = "GO:";
    private static final String GO_FORMAT = "GO:\\d{7}";
    private static final Pattern GO_PATTERN = Pattern.compile("GO:\\d{7}");
    private final String _id;

    public GoId(String string) {
        if (string.length() != 10) {
            throw new IllegalArgumentException("unexpected format for GO id: " + string);
        }
        Matcher matcher = GO_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("unexpected format for GO id: " + string);
        }
        this._id = string.substring(3);
    }

    @Override
    public int compareTo(GoId goId) {
        return this.getId().compareTo(goId.getId());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            throw new IllegalArgumentException("attempt to check go id equality to null");
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check go id equality to " + object + " [" + object.getClass() + "]");
        }
        return this.getId().equals(((GoId)object).getId());
    }

    public String getId() {
        return GO_PREFIX + this._id;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }
}

