/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.go.GoId;
import org.forester.go.GoTerm;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GoUtils {
    private GoUtils() {
    }

    public static LinkedHashMap<GoId, Integer> countCategories(List<GoTerm> list, List<GoTerm> list2, Map<GoId, GoTerm> map) {
        LinkedHashMap<GoId, Integer> linkedHashMap = new LinkedHashMap<GoId, Integer>();
        for (GoTerm goTerm : list2) {
            SortedSet<GoTerm> sortedSet = GoUtils.getAllSuperGoTerms(goTerm.getGoId(), map);
            sortedSet.add(goTerm);
            for (GoTerm goTerm2 : list) {
                if (!linkedHashMap.containsKey(goTerm2.getGoId())) {
                    linkedHashMap.put(goTerm2.getGoId(), 0);
                }
                if (!sortedSet.contains(goTerm2)) continue;
                linkedHashMap.put(goTerm2.getGoId(), 1 + linkedHashMap.get(goTerm2.getGoId()));
            }
        }
        return linkedHashMap;
    }

    public static LinkedHashMap<GoId, Integer> countCategoriesId(List<GoId> list, List<GoId> list2, Map<GoId, GoTerm> map) {
        LinkedHashMap<GoId, Integer> linkedHashMap = new LinkedHashMap<GoId, Integer>();
        for (GoId goId : list2) {
            HashSet<GoId> hashSet = new HashSet<GoId>();
            for (GoTerm goTerm : GoUtils.getAllSuperGoTerms(goId, map)) {
                hashSet.add(goTerm.getGoId());
            }
            hashSet.add(goId);
            for (GoId goId2 : list) {
                if (!linkedHashMap.containsKey(goId2)) {
                    linkedHashMap.put(goId2, 0);
                }
                if (!hashSet.contains(goId2)) continue;
                linkedHashMap.put(goId2, 1 + linkedHashMap.get(goId2));
            }
        }
        return linkedHashMap;
    }

    public static Map<GoId, GoTerm> createGoIdToGoTermMap(List<GoTerm> list) {
        HashMap<GoId, GoTerm> hashMap = new HashMap<GoId, GoTerm>();
        for (GoTerm goTerm : list) {
            hashMap.put(goTerm.getGoId(), goTerm);
            for (GoId goId : goTerm.getAltIds()) {
                hashMap.put(goId, goTerm);
            }
        }
        return hashMap;
    }

    public static SortedSet<GoId> getAllSuperGoIds(GoId goId, Map<GoId, GoTerm> map) {
        TreeSet<GoId> treeSet = new TreeSet<GoId>();
        SortedSet<GoTerm> sortedSet = GoUtils.getAllSuperGoTerms(goId, map);
        for (GoTerm goTerm : sortedSet) {
            treeSet.add(goTerm.getGoId());
        }
        return treeSet;
    }

    public static SortedSet<GoTerm> getAllSuperGoTerms(GoId goId, List<GoTerm> list) {
        Map<GoId, GoTerm> map = GoUtils.createGoIdToGoTermMap(list);
        return GoUtils.getAllSuperGoTerms(goId, map);
    }

    public static SortedSet<GoTerm> getAllSuperGoTerms(GoId goId, Map<GoId, GoTerm> map) {
        if (!map.containsKey(goId)) {
            throw new IllegalArgumentException("GO id [" + goId + "] not found in GO id to term map");
        }
        GoTerm goTerm = map.get(goId);
        return GoUtils.getAllSuperGoTerms(goTerm, map);
    }

    public static SortedSet<GoTerm> getAllSuperGoTerms(GoTerm goTerm, Map<GoId, GoTerm> map) {
        TreeSet<GoTerm> treeSet = new TreeSet<GoTerm>();
        GoUtils.getAllSuperGoTerms(goTerm, map, treeSet);
        return treeSet;
    }

    private static void getAllSuperGoTerms(GoTerm goTerm, Map<GoId, GoTerm> map, Set<GoTerm> set) {
        if (goTerm.getSuperGoIds() != null && goTerm.getSuperGoIds().size() > 0) {
            for (GoId goId : goTerm.getSuperGoIds()) {
                if (!map.containsKey(goId)) {
                    throw new IllegalArgumentException("GO id [" + goId + "] not found in GO id to term map");
                }
                GoTerm goTerm2 = map.get(goId);
                set.add(goTerm2);
                GoUtils.getAllSuperGoTerms(goTerm2, map, set);
            }
        }
    }

    public static GoTerm getPenultimateGoTerm(GoTerm goTerm, Map<GoId, GoTerm> map) {
        GoTerm goTerm2;
        GoTerm goTerm3 = goTerm2 = goTerm;
        while (goTerm2.getSuperGoIds() != null && goTerm2.getSuperGoIds().size() > 0) {
            goTerm3 = goTerm2;
            if (!map.containsKey(goTerm2.getSuperGoIds().get(0))) {
                throw new IllegalArgumentException("GO-id [" + goTerm2.getSuperGoIds().get(0) + "] not found in map");
            }
            goTerm2 = map.get(goTerm2.getSuperGoIds().get(0));
        }
        return goTerm3;
    }

    public static GoTerm getUltimateGoTerm(GoTerm goTerm, Map<GoId, GoTerm> map) {
        GoTerm goTerm2 = goTerm;
        while (goTerm2.getSuperGoIds() != null && goTerm2.getSuperGoIds().size() > 0) {
            if (!map.containsKey(goTerm2.getSuperGoIds().get(0))) {
                throw new IllegalArgumentException("GO-id [" + goTerm2.getSuperGoIds().get(0) + "] not found in map");
            }
            goTerm2 = map.get(goTerm2.getSuperGoIds().get(0));
        }
        return goTerm2;
    }

    public static SortedMap<String, List<GoId>> parseGoIds(Object object, String string, String string2) throws IOException {
        Pattern pattern = Pattern.compile(string2 + "\\s*(.+?)");
        BufferedReader bufferedReader = ForesterUtil.obtainReader(object);
        TreeMap<String, List<GoId>> treeMap = new TreeMap<String, List<GoId>>();
        String string3 = "";
        String string4 = "";
        boolean bl = !ForesterUtil.isEmpty(string2);
        boolean bl2 = !ForesterUtil.isEmpty(string);
        ArrayList<GoId> arrayList = new ArrayList<GoId>();
        while ((string3 = bufferedReader.readLine()) != null) {
            Object object2;
            if (ForesterUtil.isEmpty(string3 = string3.trim()) || bl2 && string3.startsWith(string)) continue;
            if (bl && string3.startsWith(string2)) {
                object2 = pattern.matcher(string3);
                if (!((Matcher)object2).matches()) continue;
                if (!ForesterUtil.isEmpty(string4)) {
                    treeMap.put(string4, arrayList);
                    arrayList = new ArrayList();
                }
                string4 = ((Matcher)object2).group(1);
                continue;
            }
            object2 = string3.split("\\s+");
            GoId goId = new GoId(object2[0]);
            arrayList.add(goId);
        }
        if (ForesterUtil.isEmpty(string4)) {
            string4 = "";
        }
        treeMap.put(string4, arrayList);
        bufferedReader.close();
        return treeMap;
    }
}

