/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.forester.go.BasicGoRelationship;
import org.forester.go.BasicGoSubset;
import org.forester.go.BasicGoTerm;
import org.forester.go.BasicGoXRef;
import org.forester.go.GoId;
import org.forester.go.GoRelationship;
import org.forester.go.GoSubset;
import org.forester.go.GoTerm;
import org.forester.go.GoXRef;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBOparser {
    private final File _input_file;
    private final ReturnType _return_type;
    private int _go_term_count;

    public OBOparser(File file, ReturnType returnType) {
        switch (returnType) {
            case BASIC_GO_TERM: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown return type: " + (Object)((Object)returnType));
            }
        }
        this._input_file = file;
        this._return_type = returnType;
        this.init();
    }

    private GoTerm createNewBasicGoTerm(String string, String string2, String string3, String string4, String string5, String string6, Set<String> set, List<GoXRef> list, List<GoId> list2, List<GoRelationship> list3, List<GoSubset> list4) {
        BasicGoTerm basicGoTerm = new BasicGoTerm(string, string2, string3, string4.trim().toLowerCase().equals("true"));
        basicGoTerm.setComment(string5);
        basicGoTerm.setDefinition(string6);
        for (GoXRef object : list) {
            basicGoTerm.getGoXRefs().add(object);
        }
        for (GoId goId : list2) {
            basicGoTerm.getSuperGoIds().add(goId);
        }
        for (GoRelationship goRelationship : list3) {
            basicGoTerm.getGoRelationships().add(goRelationship);
        }
        for (GoSubset goSubset : list4) {
            basicGoTerm.getGoSubsets().add(goSubset);
        }
        for (String string7 : set) {
            basicGoTerm.getAltIds().add(new GoId(string7));
        }
        ++this._go_term_count;
        return basicGoTerm;
    }

    private void createNewGoTerm(List<GoTerm> list, String string, String string2, String string3, String string4, String string5, String string6, Set<String> set, List<GoXRef> list2, List<GoId> list3, List<GoRelationship> list4, List<GoSubset> list5) {
        GoTerm goTerm;
        switch (this.getReturnType()) {
            case BASIC_GO_TERM: {
                goTerm = this.createNewBasicGoTerm(string, string2, string3, string4, string5, string6, set, list2, list3, list4, list5);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown return type: " + (Object)((Object)this.getReturnType())));
            }
        }
        list.add(goTerm);
    }

    public int getGoTermCount() {
        return this._go_term_count;
    }

    private File getInputFile() {
        return this._input_file;
    }

    private ReturnType getReturnType() {
        return this._return_type;
    }

    private void init() {
        this.setGoTermCount(0);
    }

    public List<GoTerm> parse() throws IOException {
        String string = ForesterUtil.isReadableFile(this.getInputFile());
        if (!ForesterUtil.isEmpty(string)) {
            throw new IOException(string);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getInputFile()));
        ArrayList<GoTerm> arrayList = new ArrayList<GoTerm>();
        int n = 0;
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<GoId> arrayList2 = new ArrayList<GoId>();
        ArrayList<GoXRef> arrayList3 = new ArrayList<GoXRef>();
        ArrayList<GoRelationship> arrayList4 = new ArrayList<GoRelationship>();
        ArrayList<GoSubset> arrayList5 = new ArrayList<GoSubset>();
        try {
            String string8;
            while ((string8 = bufferedReader.readLine()) != null) {
                String string9;
                ++n;
                if ((string8 = string8.trim()).length() < 1) {
                    if (!bl) continue;
                    bl = false;
                    continue;
                }
                if (string8.startsWith("[Term]")) {
                    bl = true;
                    if (string2.length() > 0) {
                        this.createNewGoTerm(arrayList, string2, string3, string4, string7, string6, string5, hashSet, arrayList3, arrayList2, arrayList4, arrayList5);
                    }
                    string2 = "";
                    string3 = "";
                    string4 = "";
                    hashSet = new HashSet();
                    string5 = "";
                    string6 = "";
                    string7 = "";
                    arrayList2 = new ArrayList();
                    arrayList3 = new ArrayList();
                    arrayList4 = new ArrayList();
                    arrayList5 = new ArrayList();
                    continue;
                }
                if (bl && string8.startsWith("id:")) {
                    string2 = string8.substring(3).trim();
                    continue;
                }
                if (bl && string8.startsWith("name:")) {
                    string3 = string8.substring(5).trim();
                    continue;
                }
                if (bl && string8.startsWith("namespace:")) {
                    string4 = string8.substring(10).trim();
                    continue;
                }
                if (bl && string8.startsWith("alt_id:")) {
                    hashSet.add(string8.substring(7).trim());
                    continue;
                }
                if (bl && string8.startsWith("def:")) {
                    string5 = string8.substring(4).trim();
                    continue;
                }
                if (bl && string8.startsWith("is_obsolete:")) {
                    string7 = string8.substring(12).trim();
                    continue;
                }
                if (bl && string8.startsWith("comment:")) {
                    string6 = string8.substring(8).trim();
                    continue;
                }
                if (bl && string8.startsWith("xref:")) {
                    string9 = this.trimOffComment(string8.substring(5).trim());
                    arrayList3.add(new BasicGoXRef(string9));
                    continue;
                }
                if (bl && string8.startsWith("is_a:")) {
                    string9 = this.trimOffComment(string8.substring(5).trim());
                    arrayList2.add(new GoId(string9));
                    continue;
                }
                if (bl && string8.startsWith("relationship:")) {
                    string9 = this.trimOffComment(string8.substring(13).trim());
                    arrayList4.add(new BasicGoRelationship(string9));
                    continue;
                }
                if (!bl || !string8.startsWith("subset:")) continue;
                string9 = string8.substring(8).trim();
                arrayList5.add(new BasicGoSubset(string9));
            }
        }
        catch (Exception exception) {
            throw new IOException("parsing problem: " + exception.getMessage() + " [at line " + n + "]");
        }
        if (string2.length() > 0) {
            this.createNewGoTerm(arrayList, string2, string3, string4, string7, string6, string5, hashSet, arrayList3, arrayList2, arrayList4, arrayList5);
        }
        return arrayList;
    }

    private void setGoTermCount(int n) {
        this._go_term_count = n;
    }

    private String trimOffComment(String string) {
        int n = string.indexOf(33);
        if (n > 0) {
            string = string.substring(0, string.indexOf(33)).trim();
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReturnType {
        BASIC_GO_TERM;

    }
}

