/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go.etc;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.OBOparser;
import org.forester.go.PfamToGoMapping;
import org.forester.go.etc.OntologizerResult;
import org.forester.surfacing.BasicSpecies;
import org.forester.surfacing.DomainId;
import org.forester.surfacing.Species;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaOntologizer {
    private static final NumberFormat FORMATER = new DecimalFormat("0.00E0");
    private static final Color MIN_COLOR = new Color(0, 200, 50);
    private static final Color MAX_COLOR = new Color(0, 0, 0);
    private static final String PRG_NAME = "meta_ontologizer";
    private static final boolean VERBOSE = true;
    private static final Pattern PATTERN_ONTOLOGIZER_TABLE_OUTPUT = Pattern.compile(".*table-(.+?)_.*", 2);

    private static boolean hasResultsForSpecies(Map<GoId, GoTerm> map, SortedMap<String, SortedSet<OntologizerResult>> sortedMap, String string, GoNameSpace.GoNamespaceType goNamespaceType) {
        for (OntologizerResult ontologizerResult : (SortedSet)sortedMap.get(string)) {
            if (map.get(ontologizerResult.getGoId()).getGoNameSpace().getType() != goNamespaceType) continue;
            return true;
        }
        return false;
    }

    private static StringBuilder obtainDomainsForGoId(List<PfamToGoMapping> list, SortedSet<DomainId> sortedSet, Map<GoId, GoTerm> map, GoId goId, Set<DomainId> set) {
        StringBuilder stringBuilder = new StringBuilder();
        block0: for (DomainId domainId : sortedSet) {
            for (PfamToGoMapping pfamToGoMapping : list) {
                if (!pfamToGoMapping.getKey().equals(domainId)) continue;
                GoId goId2 = pfamToGoMapping.getValue();
                HashSet<GoId> hashSet = new HashSet<GoId>();
                for (GoTerm goTerm : GoUtils.getAllSuperGoTerms(goId2, map)) {
                    hashSet.add(goTerm.getGoId());
                }
                hashSet.add(goId2);
                if (!hashSet.contains(goId)) continue;
                stringBuilder.append("[<a href=\"http://pfam.sanger.ac.uk/family?id=" + domainId + "\">" + domainId + "</a>] ");
                set.add(domainId);
                continue block0;
            }
        }
        return stringBuilder;
    }

    private static String obtainSpecies(File file) {
        Matcher matcher = PATTERN_ONTOLOGIZER_TABLE_OUTPUT.matcher(file.getName());
        String string = null;
        if (!matcher.matches()) {
            throw new IllegalStateException("pattern [" + PATTERN_ONTOLOGIZER_TABLE_OUTPUT + "] did not match [" + file.getName() + "]");
        }
        string = matcher.group(1);
        ForesterUtil.programMessage(PRG_NAME, "species for [" + file + "] is [" + string + "]");
        return string;
    }

    private static SortedMap<Species, SortedSet<DomainId>> parseDomainGainLossFile(File file) throws IOException {
        String string = ForesterUtil.isReadableFile(file);
        if (!ForesterUtil.isEmpty(string)) {
            throw new IOException(string);
        }
        TreeMap<Species, SortedSet<DomainId>> treeMap = new TreeMap<Species, SortedSet<DomainId>>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n = 0;
        BasicSpecies basicSpecies = null;
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                if (ForesterUtil.isEmpty(string2 = string2.trim()) || string2.startsWith("##")) continue;
                if (string2.startsWith("#")) {
                    basicSpecies = new BasicSpecies(string2.substring(1));
                    treeMap.put(basicSpecies, new TreeSet());
                    continue;
                }
                if (basicSpecies == null) {
                    throw new IOException("parsing problem [at line " + n + "] in [" + file + "]");
                }
                ((SortedSet)treeMap.get(basicSpecies)).add(new DomainId(string2));
            }
        }
        catch (Exception exception) {
            throw new IOException("parsing problem [at line " + n + "] in [" + file + "]: " + exception.getMessage());
        }
        return treeMap;
    }

    private static void processOneSpecies(Map<GoId, GoTerm> map, Writer writer, Writer writer2, Writer writer3, Writer writer4, Writer writer5, Writer writer6, SortedMap<String, SortedSet<OntologizerResult>> sortedMap, String string, double d, SortedSet<DomainId> sortedSet, List<PfamToGoMapping> list, Set<DomainId> set) throws IOException {
        SortedSet sortedSet2 = (SortedSet)sortedMap.get(string);
        for (OntologizerResult ontologizerResult : sortedSet2) {
            GoTerm goTerm = map.get(ontologizerResult.getGoId());
            Writer writer7 = writer;
            Writer writer8 = writer2;
            switch (goTerm.getGoNameSpace().getType()) {
                case CELLULAR_COMPONENT: {
                    writer7 = writer3;
                    writer8 = writer4;
                    break;
                }
                case MOLECULAR_FUNCTION: {
                    writer7 = writer5;
                    writer8 = writer6;
                }
            }
            MetaOntologizer.writeValuesToTabWriter(string, ontologizerResult, goTerm, writer8);
            MetaOntologizer.writeValuesToHtmlWriter(ontologizerResult, goTerm, writer7, d, string, map, sortedSet, list, set);
        }
    }

    public static void reformat(File file, String string, File file2, String string2, File file3, double d, String string3, List<PfamToGoMapping> list) throws IOException {
        TreeSet<DomainId> treeSet;
        SequencedCollection<OntologizerResult> sequencedCollection;
        String string422;
        if (!file.exists()) {
            throw new IllegalArgumentException("[" + file + "] does not exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("[" + file + "] is not a directory");
        }
        if (!file3.exists()) {
            throw new IllegalArgumentException("[" + file3 + "] does not exist");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("adjusted P values limit [" + d + "] is out of range");
        }
        SortedMap<Species, SortedSet<DomainId>> sortedMap = null;
        if (file2 != null) {
            if (!file2.exists()) {
                throw new IllegalArgumentException("[" + file2 + "] does not exist");
            }
            sortedMap = MetaOntologizer.parseDomainGainLossFile(file2);
            ForesterUtil.programMessage(PRG_NAME, "parsed gain/loss domains for " + sortedMap.size() + " species from [" + file2 + "]");
        }
        String[] stringArray = file.list();
        ArrayList<File> arrayList = new ArrayList<File>();
        if (stringArray == null) {
            throw new IllegalArgumentException("problem with [" + file + "]");
        }
        for (String string422 : stringArray) {
            if (!string422.startsWith(string)) continue;
            arrayList.add(new File(string422));
        }
        ForesterUtil.programMessage(PRG_NAME, "need to analyze " + arrayList.size() + " Ontologizer outfiles from [" + file + "]");
        OBOparser oBOparser = new OBOparser(file3, OBOparser.ReturnType.BASIC_GO_TERM);
        List<GoTerm> list2 = oBOparser.parse();
        ForesterUtil.programMessage(PRG_NAME, "parsed " + list2.size() + " GO terms from [" + file3 + "]");
        Map<GoId, GoTerm> map = GoUtils.createGoIdToGoTermMap(list2);
        string422 = string2 + "_B.html";
        String string5 = string2 + "_B.txt";
        String string6 = string2 + "_C.html";
        String string7 = string2 + "_C.txt";
        String string8 = string2 + "_M.html";
        String string9 = string2 + "_M.txt";
        BufferedWriter bufferedWriter = ForesterUtil.createBufferedWriter(string422);
        BufferedWriter bufferedWriter2 = ForesterUtil.createBufferedWriter(string5);
        BufferedWriter bufferedWriter3 = ForesterUtil.createBufferedWriter(string6);
        BufferedWriter bufferedWriter4 = ForesterUtil.createBufferedWriter(string7);
        BufferedWriter bufferedWriter5 = ForesterUtil.createBufferedWriter(string8);
        BufferedWriter bufferedWriter6 = ForesterUtil.createBufferedWriter(string9);
        TreeMap<String, SortedSet<OntologizerResult>> treeMap = new TreeMap<String, SortedSet<OntologizerResult>>();
        for (File object : arrayList) {
            String string4 = MetaOntologizer.obtainSpecies(object);
            sequencedCollection = OntologizerResult.parse(new File(file + ForesterUtil.FILE_SEPARATOR + object));
            treeSet = new TreeSet<OntologizerResult>();
            for (OntologizerResult ontologizerResult : sequencedCollection) {
                if (!(ontologizerResult.getPAdjusted() <= d)) continue;
                treeSet.add((DomainId)((Object)ontologizerResult));
            }
            treeMap.put(string4, treeSet);
        }
        MetaOntologizer.writeLabelsToTabWriter(bufferedWriter2);
        MetaOntologizer.writeLabelsToTabWriter(bufferedWriter4);
        MetaOntologizer.writeLabelsToTabWriter(bufferedWriter6);
        Object object = null;
        if (file2 != null) {
            object = file2.getAbsolutePath();
        }
        MetaOntologizer.writeHtmlHeader(bufferedWriter, GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS.toString() + " | Pmax = " + d + " | " + string3, file.getAbsolutePath(), (String)object);
        MetaOntologizer.writeHtmlHeader(bufferedWriter3, GoNameSpace.GoNamespaceType.CELLULAR_COMPONENT.toString() + " | Pmax = " + d + " | " + string3, file.getAbsolutePath(), (String)object);
        MetaOntologizer.writeHtmlHeader(bufferedWriter5, GoNameSpace.GoNamespaceType.MOLECULAR_FUNCTION.toString() + " | Pmax = " + d + " | " + string3, file.getAbsolutePath(), (String)object);
        for (String string4 : treeMap.keySet()) {
            if (MetaOntologizer.hasResultsForSpecies(map, treeMap, string4, GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS)) {
                MetaOntologizer.writeHtmlSpecies(bufferedWriter, string4);
            }
            if (MetaOntologizer.hasResultsForSpecies(map, treeMap, string4, GoNameSpace.GoNamespaceType.CELLULAR_COMPONENT)) {
                MetaOntologizer.writeHtmlSpecies(bufferedWriter3, string4);
            }
            if (MetaOntologizer.hasResultsForSpecies(map, treeMap, string4, GoNameSpace.GoNamespaceType.MOLECULAR_FUNCTION)) {
                MetaOntologizer.writeHtmlSpecies(bufferedWriter5, string4);
            }
            sequencedCollection = null;
            if (sortedMap != null && sortedMap.size() > 0) {
                sequencedCollection = (SortedSet)sortedMap.get(new BasicSpecies(string4));
            }
            treeSet = new HashSet();
            MetaOntologizer.processOneSpecies(map, bufferedWriter, bufferedWriter2, bufferedWriter3, bufferedWriter4, bufferedWriter5, bufferedWriter6, treeMap, string4, d, sequencedCollection, list, treeSet);
            if (sortedMap == null || sortedMap.size() <= 0) continue;
            if (MetaOntologizer.hasResultsForSpecies(map, treeMap, string4, GoNameSpace.GoNamespaceType.BIOLOGICAL_PROCESS)) {
                MetaOntologizer.writeHtmlDomains(bufferedWriter, sequencedCollection, treeSet);
            }
            if (MetaOntologizer.hasResultsForSpecies(map, treeMap, string4, GoNameSpace.GoNamespaceType.CELLULAR_COMPONENT)) {
                MetaOntologizer.writeHtmlDomains(bufferedWriter3, sequencedCollection, treeSet);
            }
            if (!MetaOntologizer.hasResultsForSpecies(map, treeMap, string4, GoNameSpace.GoNamespaceType.MOLECULAR_FUNCTION)) continue;
            MetaOntologizer.writeHtmlDomains(bufferedWriter5, sequencedCollection, treeSet);
        }
        MetaOntologizer.writeHtmlEnd(bufferedWriter);
        MetaOntologizer.writeHtmlEnd(bufferedWriter3);
        MetaOntologizer.writeHtmlEnd(bufferedWriter5);
        ((Writer)bufferedWriter).close();
        ((Writer)bufferedWriter2).close();
        ((Writer)bufferedWriter3).close();
        ((Writer)bufferedWriter4).close();
        ((Writer)bufferedWriter5).close();
        ((Writer)bufferedWriter6).close();
        ForesterUtil.programMessage(PRG_NAME, "successfully wrote biological process summary to [" + string422 + "]");
        ForesterUtil.programMessage(PRG_NAME, "successfully wrote biological process summary to [" + string5 + "]");
        ForesterUtil.programMessage(PRG_NAME, "successfully wrote molecular function summary to [" + string6 + "]");
        ForesterUtil.programMessage(PRG_NAME, "successfully wrote molecular function summary to [" + string7 + "]");
        ForesterUtil.programMessage(PRG_NAME, "successfully wrote cellular component summary to [" + string8 + "]");
        ForesterUtil.programMessage(PRG_NAME, "successfully wrote cellular component summary to [" + string9 + "]");
    }

    private static void writeHtmlDomains(Writer writer, SortedSet<DomainId> sortedSet, Set<DomainId> set) throws IOException {
        writer.write("<tr>");
        writer.write("<td colspan=\"10\">");
        for (DomainId domainId : sortedSet) {
            if (set.contains(domainId)) continue;
            writer.write("[<a class=\"new_type\" href=\"http://pfam.sanger.ac.uk/family?id=" + domainId + "\">" + domainId + "</a>] ");
        }
        writer.write("</td>");
        writer.write("</tr>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    private static void writeHtmlEnd(Writer writer) throws IOException {
        writer.write("</table>");
        writer.write("</body>");
        writer.write("</html>");
    }

    private static void writeHtmlHeader(Writer writer, String string, String string2, String string3) throws IOException {
        writer.write("<head>");
        writer.write("<title>");
        writer.write(string);
        writer.write("</title>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("<style>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("a:visited { color : #F87217; text-decoration : none; }");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("a:link { color : #F87217; text-decoration : none; }");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("a:hover { color : #FFFFFF; background-color : #00FF00; text-decoration : none; }");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("a:hover { color : #FFFFFF; background-color : #00FF00; text-decoration : none; }");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("a.new_type:visited { font-size: 7pt; color : #808080; text-decoration : none; }");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("a.new_type:link { font-size: 7pt; color : #505050; text-decoration : none; }");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("a.new_type:hover { font-size: 7pt; color : #000000; background-color : #FFFF00; text-decoration : none; }");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("a.new_type:hover { font-size: 7pt; color : #000000; background-color : #FFFF00; text-decoration : none; }");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("td { text-align: left; vertical-align: top; font-family: Verdana, Arial, Helvetica; font-size: 8pt}");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("th { text-align: left; vertical-align: top; font-family: Verdana, Arial, Helvetica; font-size: 10pt; font-weight: bold }");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("h1 { color : #000000; font-family: Verdana, Arial, Helvetica; font-size: 18pt; font-weight: bold }");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("h2 { color : #000000; font-family: Verdana, Arial, Helvetica; font-size: 16pt; font-weight: bold }");
        writer.write("h3 { margin-top: 12px;  margin-bottom: 0px; color : #000000; font-family: Verdana, Arial, Helvetica; font-size: 12pt; font-weight: bold }");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("</style>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("</head>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("<body>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("<h2>");
        writer.write("meta ontologizer");
        writer.write("</h2>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("<h2>");
        writer.write(string);
        writer.write("</h2>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("<table>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("<tr><th>");
        writer.write("ontolgizer output directory analysed:");
        writer.write("</th><td>");
        writer.write(string2);
        writer.write("</td></tr>");
        if (!ForesterUtil.isEmpty(string3)) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write("<tr><th>");
            writer.write("domain gain or loss file:");
            writer.write("</th><td>");
            writer.write(string3);
            writer.write("</td></tr>");
        }
        writer.write("</table>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("<table>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write("<tr>");
        writer.write("<th>");
        writer.write("GO term name");
        writer.write("</th><th>");
        writer.write("GO id");
        writer.write("</th><th>");
        writer.write("P adjusted");
        writer.write("</th><th>");
        writer.write("P");
        writer.write("</th><th>");
        writer.write("Pop total");
        writer.write("</th><th>");
        writer.write("Pop term");
        writer.write("</th><th>");
        writer.write("Study total");
        writer.write("</th><th>");
        writer.write("Study term");
        writer.write("</th><th>");
        writer.write("Domains");
        writer.write("</th><th>");
        writer.write("trivial?");
        writer.write("</th>");
        writer.write("</tr>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    private static void writeHtmlSpecies(Writer writer, String string) throws IOException {
        writer.write("<tr>");
        writer.write("<td><h3>");
        writer.write(string);
        SurfacingUtil.writeTaxonomyLinks(writer, string);
        writer.write("</h3></td>");
        writer.write("</tr>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    private static void writeLabelsToTabWriter(Writer writer) throws IOException {
        writer.write("#species");
        writer.write("\t");
        writer.write("GO name");
        writer.write("\t");
        writer.write("GO id");
        writer.write("\t");
        writer.write("P adjusted");
        writer.write("\t");
        writer.write("P");
        writer.write("\t");
        writer.write("Pop total");
        writer.write("\t");
        writer.write("Pop term");
        writer.write("\t");
        writer.write("Study total");
        writer.write("\t");
        writer.write("Study term");
        writer.write("\t");
        writer.write("is trivial");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    private static void writeValuesToHtmlWriter(OntologizerResult ontologizerResult, GoTerm goTerm, Writer writer, double d, String string, Map<GoId, GoTerm> map, SortedSet<DomainId> sortedSet, List<PfamToGoMapping> list, Set<DomainId> set) throws IOException {
        Color color = ForesterUtil.calcColor(ontologizerResult.getPAdjusted(), 0.0, d, MIN_COLOR, MAX_COLOR);
        Color color2 = ForesterUtil.calcColor(ontologizerResult.getP(), 0.0, d, MIN_COLOR, MAX_COLOR);
        writer.write("<tr>");
        writer.write("<td>");
        writer.write("<font color=\"#" + ForesterUtil.colorToHex(color) + "\">");
        writer.write(goTerm.getName());
        writer.write("</font>");
        writer.write("</td><td>");
        writer.write("<a href=\"http://amigo.geneontology.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&query=" + ontologizerResult.getGoId().getId() + "\" target=\"amigo_window\">" + ontologizerResult.getGoId().getId() + "</a>");
        writer.write("</td><td>");
        writer.write("<font color=\"#" + ForesterUtil.colorToHex(color) + "\">");
        writer.write(FORMATER.format(ontologizerResult.getPAdjusted()));
        writer.write("</font>");
        writer.write("</td><td>");
        writer.write("<font color=\"#" + ForesterUtil.colorToHex(color2) + "\">");
        writer.write(FORMATER.format(ontologizerResult.getP()));
        writer.write("</font>");
        writer.write("</td><td>");
        writer.write(String.valueOf(ontologizerResult.getPopTotal()));
        writer.write("</td><td>");
        writer.write(String.valueOf(ontologizerResult.getPopTerm()));
        writer.write("</td><td>");
        writer.write(String.valueOf(ontologizerResult.getStudyTotal()));
        writer.write("</td><td>");
        writer.write(String.valueOf(ontologizerResult.getStudyTerm()));
        writer.write("</td><td>");
        if (sortedSet != null) {
            StringBuilder stringBuilder = MetaOntologizer.obtainDomainsForGoId(list, sortedSet, map, goTerm.getGoId(), set);
            writer.write(stringBuilder.toString());
        } else {
            writer.write(" ");
        }
        writer.write("</td><td>");
        if (ontologizerResult.isTrivial()) {
            writer.write("trivial");
        } else {
            writer.write(" ");
        }
        writer.write("</td>");
        writer.write("</tr>");
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }

    private static void writeValuesToTabWriter(String string, OntologizerResult ontologizerResult, GoTerm goTerm, Writer writer) throws IOException {
        writer.write(string);
        writer.write("\t");
        writer.write(goTerm.getName());
        writer.write("\t");
        writer.write(ontologizerResult.getGoId().getId());
        writer.write("\t");
        writer.write(String.valueOf(ontologizerResult.getPAdjusted()));
        writer.write("\t");
        writer.write(String.valueOf(ontologizerResult.getP()));
        writer.write("\t");
        writer.write(String.valueOf(ontologizerResult.getPopTotal()));
        writer.write("\t");
        writer.write(String.valueOf(ontologizerResult.getPopTerm()));
        writer.write("\t");
        writer.write(String.valueOf(ontologizerResult.getStudyTotal()));
        writer.write("\t");
        writer.write(String.valueOf(ontologizerResult.getStudyTerm()));
        writer.write("\t");
        writer.write(String.valueOf(ontologizerResult.isTrivial()));
        writer.write(ForesterUtil.LINE_SEPARATOR);
    }
}

