/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go.etc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.forester.go.GoId;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologizerResult
implements Comparable<OntologizerResult> {
    private final GoId _goid;
    private final int _pop_total;
    private final int _pop_term;
    private final int _study_total;
    private final int _study_term;
    private final int _pop_family;
    private final int _study_family;
    private final int _nparents;
    private final boolean _is_trivial;
    private final double _p;
    private final double _p_adjusted;
    private final double _p_min;
    private final TYPE _type;

    private OntologizerResult(String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("result string is null or empty");
        }
        String[] stringArray = string.split("\t");
        if (stringArray.length != 9 && stringArray.length != 11 && stringArray.length != 12) {
            throw new IllegalArgumentException("result string [" + string + "] has unexpected format");
        }
        this._goid = new GoId(stringArray[0]);
        this._pop_total = Integer.parseInt(stringArray[1]);
        this._pop_term = Integer.parseInt(stringArray[2]);
        this._study_total = Integer.parseInt(stringArray[3]);
        this._study_term = Integer.parseInt(stringArray[4]);
        if (stringArray.length == 11) {
            this._type = TYPE.TOPOLOGY;
            this._pop_family = Integer.parseInt(stringArray[5]);
            this._study_family = Integer.parseInt(stringArray[6]);
            this._is_trivial = Boolean.parseBoolean(stringArray[7]);
            this._p = Double.parseDouble(stringArray[8]);
            this._p_adjusted = Double.parseDouble(stringArray[9]);
            this._p_min = Double.parseDouble(stringArray[10]);
            this._nparents = -1;
        } else if (stringArray.length == 9) {
            this._type = TYPE.TERM_FOR_TERM;
            this._pop_family = -1;
            this._study_family = -1;
            this._nparents = -1;
            this._is_trivial = false;
            this._p = Double.parseDouble(stringArray[5]);
            this._p_adjusted = Double.parseDouble(stringArray[6]);
            this._p_min = Double.parseDouble(stringArray[7]);
        } else {
            this._type = TYPE.PARENT_CHILD;
            this._pop_family = Integer.parseInt(stringArray[5]);
            this._study_family = Integer.parseInt(stringArray[6]);
            this._nparents = Integer.parseInt(stringArray[7]);
            this._is_trivial = Boolean.parseBoolean(stringArray[8]);
            this._p = Double.parseDouble(stringArray[9]);
            this._p_adjusted = Double.parseDouble(stringArray[10]);
            this._p_min = Double.parseDouble(stringArray[11]);
        }
    }

    @Override
    public int compareTo(OntologizerResult ontologizerResult) {
        if (this == ontologizerResult) {
            return 0;
        }
        if (this.getPAdjusted() < ontologizerResult.getPAdjusted()) {
            return -1;
        }
        if (this.getPAdjusted() > ontologizerResult.getPAdjusted()) {
            return 1;
        }
        return 0;
    }

    public GoId getGoId() {
        return this._goid;
    }

    public int getNParents() {
        return this._nparents;
    }

    public double getP() {
        return this._p;
    }

    public double getPAdjusted() {
        return this._p_adjusted;
    }

    public double getPMin() {
        return this._p_min;
    }

    public int getPopFamily() {
        return this._pop_family;
    }

    public int getPopTerm() {
        return this._pop_term;
    }

    public int getPopTotal() {
        return this._pop_total;
    }

    public int getStudyFamily() {
        return this._study_family;
    }

    public int getStudyTerm() {
        return this._study_term;
    }

    public int getStudyTotal() {
        return this._study_total;
    }

    public TYPE getType() {
        return this._type;
    }

    public boolean isTrivial() {
        return this._is_trivial;
    }

    public static List<OntologizerResult> parse(File file) throws IOException {
        String string = ForesterUtil.isReadableFile(file);
        if (!ForesterUtil.isEmpty(string)) {
            throw new IOException(string);
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        ArrayList<OntologizerResult> arrayList = new ArrayList<OntologizerResult>();
        int n = 0;
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                if (!(string2 = string2.trim()).startsWith("GO:")) continue;
                arrayList.add(new OntologizerResult(string2));
            }
        }
        catch (Exception exception) {
            throw new IOException("parsing problem [at line " + n + "] in [" + file + "]: " + exception.getMessage());
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        TOPOLOGY,
        TERM_FOR_TERM,
        PARENT_CHILD;

    }
}

