/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;

public final class ParserUtils {
    public static BufferedReader createReader(Object object) throws IOException, FileNotFoundException {
        BufferedReader bufferedReader = null;
        if (object instanceof File || object instanceof String) {
            File file = null;
            file = object instanceof File ? (File)object : new File((String)object);
            if (!file.exists()) {
                throw new IOException("[" + file.getAbsolutePath() + "] does not exist");
            }
            if (!file.isFile()) {
                throw new IOException("[" + file.getAbsolutePath() + "] is not a file");
            }
            if (!file.canRead()) {
                throw new IOException("[" + file.getAbsolutePath() + "] is not a readable");
            }
            bufferedReader = new BufferedReader(new FileReader(file));
        } else if (object instanceof InputStream) {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        } else if (object instanceof StringBuffer || object instanceof StringBuilder) {
            bufferedReader = new BufferedReader(new StringReader(object.toString()));
        } else {
            throw new IllegalArgumentException("attempt to parse object of type [" + object.getClass() + "] (can only parse objects of type File/String, InputStream, StringBuffer, or StringBuilder)");
        }
        return bufferedReader;
    }
}

