/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nexus;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.ParserUtils;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusPhylogeniesParser
implements PhylogenyParser {
    private static final String begin_trees = "Begin Trees;".toLowerCase();
    private static final String taxlabels = "TaxLabels".toLowerCase();
    private static final String translate = "Translate".toLowerCase();
    private static final String tree = "Tree".toLowerCase();
    private static final String utree = "UTREE".toLowerCase();
    private static final String end = "End;".toLowerCase();
    private static final String endblock = "endblock";
    private static final Pattern TREE_NAME_PATTERN = Pattern.compile("\\s*.?Tree\\s+(.+?)\\s*=.+", 2);
    private static final Pattern ROOTEDNESS_PATTERN = Pattern.compile(".+=\\s*\\[&([R|U])\\].*");
    private Object _nexus_source;
    private List<Phylogeny> _phylogenies;
    private List<String> _taxlabels;
    private Map<String, String> _translate_map;
    private boolean _replace_underscores = false;
    private boolean _ignore_quotes_in_nh_data = true;

    private void createPhylogeny(String string, StringBuffer stringBuffer, boolean bl, boolean bl2) throws IOException {
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        NHXParser nHXParser = new NHXParser();
        nHXParser.setTaxonomyExtraction(ForesterUtil.TAXONOMY_EXTRACTION.NO);
        nHXParser.setReplaceUnderscores(this.isReplaceUnderscores());
        nHXParser.setIgnoreQuotes(this.isIgnoreQuotes());
        if (bl) {
            nHXParser.setGuessRootedness(false);
        }
        Phylogeny phylogeny = phylogenyFactory.create(stringBuffer, nHXParser)[0];
        phylogeny.setName(string);
        if (bl) {
            phylogeny.setRooted(bl2);
        }
        if (this.getTaxlabels().size() > 0 || this.getTranslateMap().size() > 0) {
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
            while (phylogenyNodeIterator.hasNext()) {
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                if (this.getTranslateMap().size() > 0 && this.getTranslateMap().containsKey(phylogenyNode.getNodeName())) {
                    phylogenyNode.setName(this.getTranslateMap().get(phylogenyNode.getNodeName()).replaceAll("['\"]+", ""));
                    continue;
                }
                if (this.getTaxlabels().size() <= 0) continue;
                int n = -1;
                try {
                    n = Integer.parseInt(phylogenyNode.getNodeName());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n <= 0) continue;
                phylogenyNode.setName(this.getTaxlabels().get(n - 1).replaceAll("['\"]+", ""));
            }
        }
        this.getPhylogenies().add(phylogeny);
    }

    private Object getNexusSource() {
        return this._nexus_source;
    }

    private List<Phylogeny> getPhylogenies() {
        return this._phylogenies;
    }

    private Phylogeny[] getPhylogeniesAsArray() {
        Phylogeny[] phylogenyArray = new Phylogeny[this.getPhylogenies().size()];
        for (int i = 0; i < this.getPhylogenies().size(); ++i) {
            phylogenyArray[i] = this.getPhylogenies().get(i);
        }
        return phylogenyArray;
    }

    private List<String> getTaxlabels() {
        return this._taxlabels;
    }

    private Map<String, String> getTranslateMap() {
        return this._translate_map;
    }

    private boolean isIgnoreQuotes() {
        return this._ignore_quotes_in_nh_data;
    }

    private boolean isReplaceUnderscores() {
        return this._replace_underscores;
    }

    @Override
    public Phylogeny[] parse() throws IOException, NHXFormatException {
        String string;
        this.reset();
        BufferedReader bufferedReader = ParserUtils.createReader(this.getNexusSource());
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            Object object2;
            if ((string = string.trim()).length() <= 0 || string.startsWith("#") || string.startsWith(">")) continue;
            string = ForesterUtil.collapseWhiteSpace(string);
            String string3 = (string = NexusPhylogeniesParser.removeWhiteSpaceBeforeSemicolon(string)).toLowerCase();
            if (string3.startsWith(begin_trees)) {
                bl = true;
                bl2 = false;
                bl3 = false;
            } else if (string3.startsWith(taxlabels)) {
                bl = false;
                bl2 = true;
                bl3 = false;
            } else if (string3.startsWith(translate)) {
                bl2 = false;
                bl3 = true;
            } else if (bl) {
                if (!string3.startsWith("title") && !string3.startsWith("link")) {
                    if (string3.startsWith(end) || string3.startsWith(endblock)) {
                        bl = false;
                        bl4 = false;
                        bl3 = false;
                        if (stringBuffer.length() > 0) {
                            this.createPhylogeny(string2, stringBuffer, bl5, bl6);
                            stringBuffer = new StringBuffer();
                            string2 = "";
                            bl5 = false;
                            bl6 = false;
                        }
                    } else if (string3.startsWith(tree) || string3.startsWith(utree)) {
                        if (stringBuffer.length() > 0) {
                            this.createPhylogeny(string2, stringBuffer, bl5, bl6);
                            stringBuffer = new StringBuffer();
                            string2 = "";
                            bl5 = false;
                            bl6 = false;
                        }
                        bl4 = true;
                        stringBuffer.append(string.substring(string.indexOf(61)));
                        object2 = TREE_NAME_PATTERN.matcher(string);
                        if (((Matcher)object2).matches()) {
                            string2 = ((Matcher)object2).group(1);
                            string2 = string2.replaceAll("['\"]+", "");
                        }
                        if (((Matcher)(object = ROOTEDNESS_PATTERN.matcher(string))).matches()) {
                            String string4 = ((Matcher)object).group(1);
                            string = string.replaceAll("\\[\\&.\\]", "");
                            bl5 = true;
                            if (string4.toUpperCase().equals("R")) {
                                bl6 = true;
                            }
                        }
                    } else if (bl4 && !bl3) {
                        stringBuffer.append(string);
                    }
                }
                if (!(string3.startsWith("title") || string3.startsWith("link") || bl3 || string3.startsWith(end) || string3.startsWith(endblock) || !string3.endsWith(";"))) {
                    bl4 = false;
                    bl3 = false;
                    this.createPhylogeny(string2, stringBuffer, bl5, bl6);
                    stringBuffer = new StringBuffer();
                    string2 = "";
                    bl5 = false;
                    bl6 = false;
                }
            }
            if (bl2) {
                if (string3.startsWith(end) || string3.startsWith(endblock)) {
                    bl2 = false;
                } else {
                    object = object2 = string.split("\\s+");
                    int n = ((String[])object).length;
                    for (int i = 0; i < n; ++i) {
                        String string5 = object[i];
                        if (string5.toLowerCase().equals(taxlabels)) continue;
                        if (string5.endsWith(";")) {
                            bl2 = false;
                            string5 = string5.substring(0, string5.length() - 1);
                        }
                        if (string5.length() <= 0) continue;
                        this.getTaxlabels().add(string5);
                    }
                }
            }
            if (!bl3) continue;
            if (string3.startsWith(end) || string3.startsWith(endblock)) {
                bl3 = false;
                continue;
            }
            stringBuffer2.append(" ");
            stringBuffer2.append(string.trim());
            if (!string.endsWith(";")) continue;
            bl3 = false;
            this.setTranslateKeyValuePairs(stringBuffer2);
        }
        if (stringBuffer.length() > 0) {
            this.createPhylogeny(string2, stringBuffer, bl5, bl6);
        }
        return this.getPhylogeniesAsArray();
    }

    private void reset() {
        this.setPhylogenies(new ArrayList<Phylogeny>());
        this.setTaxlabels(new ArrayList<String>());
        this.setTranslateMap(new HashMap<String, String>());
    }

    public void setIgnoreQuotes(boolean bl) {
        this._ignore_quotes_in_nh_data = bl;
    }

    private void setPhylogenies(ArrayList<Phylogeny> arrayList) {
        this._phylogenies = arrayList;
    }

    public void setReplaceUnderscores(boolean bl) {
        this._replace_underscores = bl;
    }

    @Override
    public void setSource(Object object) throws PhylogenyParserException, IOException {
        if (object == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        this._nexus_source = object;
    }

    private void setTaxlabels(List<String> list) {
        this._taxlabels = list;
    }

    private void setTranslateKeyValuePairs(StringBuffer stringBuffer) throws IOException {
        String string = stringBuffer.toString().trim();
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1).trim();
        }
        for (String string2 : string.split(",")) {
            String[] stringArray = string2.trim().split("\\s+");
            if (stringArray.length < 2 || stringArray.length > 3) {
                throw new IOException("ill formatted translate values: " + stringBuffer);
            }
            if (stringArray.length == 3 && !stringArray[0].toLowerCase().trim().equals(translate)) {
                throw new IOException("ill formatted translate values: " + stringBuffer);
            }
            String string3 = "";
            String string4 = "";
            if (stringArray.length == 3) {
                string3 = stringArray[1];
                string4 = stringArray[2];
            } else {
                string3 = stringArray[0];
                string4 = stringArray[1];
            }
            if (string4.endsWith(";")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            this.getTranslateMap().put(string3, string4);
        }
    }

    private void setTranslateMap(Map<String, String> map) {
        this._translate_map = map;
    }

    private static String removeWhiteSpaceBeforeSemicolon(String string) {
        return string.replaceAll("\\s+;", ";");
    }
}

