/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.BinaryCharactersParser;
import org.forester.io.parsers.phyloxml.phylogenydata.BranchWidthParser;
import org.forester.io.parsers.phyloxml.phylogenydata.ColorParser;
import org.forester.io.parsers.phyloxml.phylogenydata.ConfidenceParser;
import org.forester.io.parsers.phyloxml.phylogenydata.DateParser;
import org.forester.io.parsers.phyloxml.phylogenydata.DistributionParser;
import org.forester.io.parsers.phyloxml.phylogenydata.EventParser;
import org.forester.io.parsers.phyloxml.phylogenydata.IdentifierParser;
import org.forester.io.parsers.phyloxml.phylogenydata.PropertyParser;
import org.forester.io.parsers.phyloxml.phylogenydata.ReferenceParser;
import org.forester.io.parsers.phyloxml.phylogenydata.SequenceParser;
import org.forester.io.parsers.phyloxml.phylogenydata.SequenceRelationParser;
import org.forester.io.parsers.phyloxml.phylogenydata.TaxonomyParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Date;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.PropertiesMap;
import org.forester.phylogeny.data.Property;
import org.forester.phylogeny.data.Reference;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.util.ForesterUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PhyloXmlHandler
extends DefaultHandler {
    private static final String PHYLOXML = "phyloxml";
    private String _current_element_name;
    private Phylogeny _current_phylogeny;
    private List<Phylogeny> _phylogenies;
    private XmlElement _current_xml_element;
    private PhylogenyNode _current_node;
    private static Map<Phylogeny, HashMap<String, Sequence>> phylogenySequencesById = new HashMap<Phylogeny, HashMap<String, Sequence>>();

    PhyloXmlHandler() {
    }

    private void addNode() {
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        this.getCurrentNode().addAsChild(phylogenyNode);
        this.setCurrentNode(phylogenyNode);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.getCurrentXmlElement() != null && this.getCurrentElementName() != null && !this.getCurrentElementName().equals("clade") && !this.getCurrentElementName().equals("phylogeny")) {
            if (!ForesterUtil.isEmpty(this.getCurrentXmlElement().getValueAsString())) {
                this.getCurrentXmlElement().appendValue(new String(cArray, n, n2));
            } else {
                this.getCurrentXmlElement().setValue(new String(cArray, n, n2));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void endElement(String var1_1, String var2_2, String var3_3) throws SAXException {
        if (ForesterUtil.isEmpty(var1_1) || var1_1.startsWith("http://www.phyloxml.org")) {
            if (var2_2.equals("clade")) {
                try {
                    this.mapElementToPhylogenyNode(this.getCurrentXmlElement(), this.getCurrentNode());
                    if (!this.getCurrentNode().isRoot()) {
                        this.setCurrentNode(this.getCurrentNode().getParent());
                    }
                    this.getCurrentXmlElement().setValue(null);
                    this.setCurrentXmlElement(this.getCurrentXmlElement().getParent());
                }
                catch (PhylogenyParserException var4_4) {
                    throw new SAXException(var4_4.getMessage());
                }
            }
            if (var2_2.equals("sequence_relation")) {
                try {
                    if (this.getCurrentPhylogeny() == null) ** GOTO lbl56
                    var4_5 = (SequenceRelation)SequenceRelationParser.getInstance(this.getCurrentPhylogeny()).parse(this.getCurrentXmlElement());
                    var5_8 = PhyloXmlHandler.getSequenceMapByIdForPhylogeny(this.getCurrentPhylogeny());
                    var6_9 = var5_8.get(var4_5.getRef0().getSourceId());
                    var7_10 = var5_8.get(var4_5.getRef1().getSourceId());
                    if (var6_9 != null) {
                        var8_11 = false;
                        for (SequenceRelation var10_14 : var6_9.getSequenceRelations()) {
                            if (!var10_14.getType().equals((Object)var4_5.getType()) || (!var10_14.getRef0().isEqual(var7_10) || !var10_14.getRef1().isEqual(var6_9)) && (!var10_14.getRef0().isEqual(var6_9) || !var10_14.getRef1().isEqual(var7_10))) continue;
                            var8_11 = true;
                            if (var10_14.getConfidence() != null || var4_5.getConfidence() == null) continue;
                            var10_14.setConfidence(var4_5.getConfidence());
                        }
                        if (!var8_11) {
                            var6_9.addSequenceRelation(var4_5);
                        }
                    }
                    if (var7_10 != null) {
                        var8_11 = false;
                        for (SequenceRelation var10_14 : var7_10.getSequenceRelations()) {
                            if (!var10_14.getType().equals((Object)var4_5.getType()) || (!var10_14.getRef0().isEqual(var7_10) || !var10_14.getRef1().isEqual(var6_9)) && (!var10_14.getRef0().isEqual(var6_9) || !var10_14.getRef1().isEqual(var7_10))) continue;
                            var8_11 = true;
                            if (var10_14.getConfidence() != null || var4_5.getConfidence() == null) continue;
                            var10_14.setConfidence(var4_5.getConfidence());
                        }
                        if (!var8_11) {
                            var7_10.addSequenceRelation(var4_5);
                        }
                    }
                    if ((var8_12 = this.getCurrentPhylogeny().getRelevantSequenceRelationTypes()).contains((Object)var4_5.getType())) ** GOTO lbl56
                    var8_12.add(var4_5.getType());
                }
                catch (PhylogenyParserException var4_6) {
                    throw new SAXException(var4_6.getMessage());
                }
            } else if (var2_2.equals("phylogeny")) {
                try {
                    PhyloXmlHandler.mapElementToPhylogeny(this.getCurrentXmlElement(), this.getCurrentPhylogeny());
                }
                catch (PhylogenyParserException var4_7) {
                    throw new SAXException(var4_7.getMessage());
                }
                this.finishPhylogeny();
                this.reset();
            } else if (!var2_2.equals("phyloxml") && this.getCurrentPhylogeny() != null && this.getCurrentXmlElement().getParent() != null) {
                this.setCurrentXmlElement(this.getCurrentXmlElement().getParent());
            }
lbl56:
            // 8 sources

            this.setCurrentElementName(null);
        }
    }

    private void finishPhylogeny() throws SAXException {
        this.getCurrentPhylogeny().recalculateNumberOfExternalDescendants(false);
        this.getPhylogenies().add(this.getCurrentPhylogeny());
        HashMap<String, Sequence> hashMap = phylogenySequencesById.get(this.getCurrentPhylogeny());
        if (hashMap != null) {
            this.getCurrentPhylogeny().setSequenceRelationQueries(hashMap.values());
            phylogenySequencesById.remove(this.getCurrentPhylogeny());
        }
    }

    private String getCurrentElementName() {
        return this._current_element_name;
    }

    private PhylogenyNode getCurrentNode() {
        return this._current_node;
    }

    private Phylogeny getCurrentPhylogeny() {
        return this._current_phylogeny;
    }

    private XmlElement getCurrentXmlElement() {
        return this._current_xml_element;
    }

    List<Phylogeny> getPhylogenies() {
        return this._phylogenies;
    }

    private void init() {
        this.reset();
        this.setPhylogenies(new ArrayList<Phylogeny>());
    }

    private void initCurrentNode() {
        if (this.getCurrentNode() != null) {
            throw new IllegalStateException("attempt to create new current node when current node already exists");
        }
        if (this.getCurrentPhylogeny() == null) {
            throw new IllegalStateException("attempt to create new current node for non-existing phylogeny");
        }
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        this.getCurrentPhylogeny().setRoot(phylogenyNode);
        this.setCurrentNode(this.getCurrentPhylogeny().getRoot());
    }

    private void mapElementToPhylogenyNode(XmlElement xmlElement, PhylogenyNode phylogenyNode) throws PhylogenyParserException {
        if (xmlElement.isHasAttribute("branch_length")) {
            double d = 0.0;
            try {
                d = Double.parseDouble(xmlElement.getAttribute("branch_length"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new PhylogenyParserException("ill formatted distance in clade attribute [" + xmlElement.getAttribute("branch_length") + "]: " + numberFormatException.getMessage());
            }
            phylogenyNode.setDistanceToParent(d);
        }
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            String string = xmlElement2.getQualifiedName();
            if (string.equals("branch_length")) {
                if (phylogenyNode.getDistanceToParent() != -1024.0) {
                    throw new PhylogenyParserException("ill advised attempt to set distance twice for the same clade (probably via element and via attribute)");
                }
                phylogenyNode.setDistanceToParent(xmlElement2.getValueAsDouble());
            }
            if (string.equals("name")) {
                phylogenyNode.setName(xmlElement2.getValueAsString());
                continue;
            }
            if (string.equals("taxonomy")) {
                phylogenyNode.getNodeData().addTaxonomy((Taxonomy)TaxonomyParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string.equals("sequence")) {
                Sequence sequence = (Sequence)SequenceParser.getInstance().parse(xmlElement2);
                phylogenyNode.getNodeData().addSequence(sequence);
                String string2 = sequence.getSourceId();
                if (this.getCurrentPhylogeny() == null || ForesterUtil.isEmpty(string2)) continue;
                PhyloXmlHandler.getSequenceMapByIdForPhylogeny(this.getCurrentPhylogeny()).put(string2, sequence);
                continue;
            }
            if (string.equals("distribution")) {
                phylogenyNode.getNodeData().addDistribution((Distribution)DistributionParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string.equals("date")) {
                phylogenyNode.getNodeData().setDate((Date)DateParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string.equals("reference")) {
                phylogenyNode.getNodeData().addReference((Reference)ReferenceParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string.equals("binary_characters")) {
                phylogenyNode.getNodeData().setBinaryCharacters((BinaryCharacters)BinaryCharactersParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string.equals("color")) {
                phylogenyNode.getBranchData().setBranchColor((BranchColor)ColorParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string.equals("confidence")) {
                phylogenyNode.getBranchData().addConfidence((Confidence)ConfidenceParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string.equals("width")) {
                phylogenyNode.getBranchData().setBranchWidth((BranchWidth)BranchWidthParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (string.equals("events")) {
                phylogenyNode.getNodeData().setEvent((Event)EventParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (!string.equals("property")) continue;
            if (!phylogenyNode.getNodeData().isHasProperties()) {
                phylogenyNode.getNodeData().setProperties(new PropertiesMap());
            }
            phylogenyNode.getNodeData().getProperties().addProperty((Property)PropertyParser.getInstance().parse(xmlElement2));
        }
    }

    private void newClade() {
        if (this.getCurrentNode() == null) {
            this.initCurrentNode();
        } else {
            this.addNode();
        }
    }

    private void newPhylogeny() {
        this.setCurrentPhylogeny(new Phylogeny());
    }

    private void reset() {
        this.setCurrentPhylogeny(null);
        this.setCurrentNode(null);
        this.setCurrentElementName(null);
        this.setCurrentXmlElement(null);
    }

    private void setCurrentElementName(String string) {
        this._current_element_name = string;
    }

    private void setCurrentNode(PhylogenyNode phylogenyNode) {
        this._current_node = phylogenyNode;
    }

    private void setCurrentPhylogeny(Phylogeny phylogeny) {
        this._current_phylogeny = phylogeny;
    }

    private void setCurrentXmlElement(XmlElement xmlElement) {
        this._current_xml_element = xmlElement;
    }

    private void setPhylogenies(List<Phylogeny> list) {
        this._phylogenies = list;
    }

    @Override
    public void startDocument() throws SAXException {
        this.init();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (ForesterUtil.isEmpty(string) || string.startsWith("http://www.phyloxml.org")) {
            this.setCurrentElementName(string2);
            if (string2.equals("clade")) {
                XmlElement xmlElement = new XmlElement(string, string2, string2, attributes);
                this.getCurrentXmlElement().addChildElement(xmlElement);
                this.setCurrentXmlElement(xmlElement);
                this.newClade();
            } else if (string2.equals("phylogeny")) {
                this.setCurrentXmlElement(new XmlElement("", "", "", null));
                this.newPhylogeny();
                XmlElement xmlElement = new XmlElement(string, string2, string2, attributes);
                if (xmlElement.isHasAttribute("rerootable")) {
                    this.getCurrentPhylogeny().setRerootable(Boolean.parseBoolean(xmlElement.getAttribute("rerootable")));
                }
                if (xmlElement.isHasAttribute("branch_length_unit")) {
                    this.getCurrentPhylogeny().setDistanceUnit(xmlElement.getAttribute("branch_length_unit"));
                }
                if (xmlElement.isHasAttribute("rooted")) {
                    this.getCurrentPhylogeny().setRooted(Boolean.parseBoolean(xmlElement.getAttribute("rooted")));
                }
                if (xmlElement.isHasAttribute("type")) {
                    this.getCurrentPhylogeny().setType(xmlElement.getAttribute("type"));
                }
            } else if (!string2.equals(PHYLOXML) && this.getCurrentPhylogeny() != null) {
                XmlElement xmlElement = new XmlElement(string, string2, string2, attributes);
                this.getCurrentXmlElement().addChildElement(xmlElement);
                this.setCurrentXmlElement(xmlElement);
            }
        }
    }

    public static boolean attributeEqualsValue(XmlElement xmlElement, String string, String string2) {
        String string3 = xmlElement.getAttribute(string);
        return string3 != null && string3.equals(string2);
    }

    public static String getAtttributeValue(XmlElement xmlElement, String string) {
        String string2 = xmlElement.getAttribute(string);
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    public static Map<String, Sequence> getSequenceMapByIdForPhylogeny(Phylogeny phylogeny) {
        HashMap<String, Sequence> hashMap = phylogenySequencesById.get(phylogeny);
        if (hashMap == null) {
            hashMap = new HashMap();
            phylogenySequencesById.put(phylogeny, hashMap);
        }
        return hashMap;
    }

    private static void mapElementToPhylogeny(XmlElement xmlElement, Phylogeny phylogeny) throws PhylogenyParserException {
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            String string = xmlElement2.getQualifiedName();
            if (string.equals("name")) {
                phylogeny.setName(xmlElement2.getValueAsString());
                continue;
            }
            if (string.equals("description")) {
                phylogeny.setDescription(xmlElement2.getValueAsString());
                continue;
            }
            if (string.equals("id")) {
                phylogeny.setIdentifier((Identifier)IdentifierParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (!string.equals("confidence")) continue;
            phylogeny.setConfidence((Confidence)ConfidenceParser.getInstance().parse(xmlElement2));
        }
    }
}

