/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.phylogenydata.ProteinDomainParser;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.ProteinDomain;

public class DomainArchitectureParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private DomainArchitectureParser() {
    }

    public DomainArchitecture parse(XmlElement xmlElement) throws PhylogenyParserException {
        DomainArchitecture domainArchitecture = new DomainArchitecture();
        if (!xmlElement.isHasAttribute("length")) {
            throw new PhylogenyParserException("length attribute is required for domain architecture");
        }
        String string = xmlElement.getAttribute("length");
        try {
            domainArchitecture.setTotalLength(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PhylogenyParserException("could not extract domain architecture length from [" + string + "]: " + numberFormatException.getMessage());
        }
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            if (!xmlElement2.getQualifiedName().equals("domain")) continue;
            domainArchitecture.addDomain((ProteinDomain)ProteinDomainParser.getInstance().parse(xmlElement2));
        }
        return domainArchitecture;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new DomainArchitectureParser();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }
}

