/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.ProteinDomain;

public class ProteinDomainParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private ProteinDomainParser() {
    }

    public ProteinDomain parse(XmlElement xmlElement) throws PhylogenyParserException {
        String string = "";
        int n = -1;
        int n2 = -1;
        double d = 0.0;
        String string2 = "";
        try {
            n = Integer.parseInt(xmlElement.getAttribute("from"));
            n2 = Integer.parseInt(xmlElement.getAttribute("to"));
            d = Double.parseDouble(xmlElement.getAttribute("confidence"));
            if (xmlElement.isHasAttribute("id")) {
                string2 = xmlElement.getAttribute("id");
            }
        }
        catch (Exception exception) {
            throw new PhylogenyParserException("failed to parse element [" + xmlElement + "]: " + exception.getMessage());
        }
        string = xmlElement.getValueAsString();
        if (n == -1 || n2 == -1 || d == 0.0) {
            throw new PhylogenyParserException("from, to, or confidence attribute not set in: " + xmlElement);
        }
        return new ProteinDomain(string, n, n2, string2, d);
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new ProteinDomainParser();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }
}

