/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.AccessionParser;
import org.forester.io.parsers.phyloxml.phylogenydata.AnnotationParser;
import org.forester.io.parsers.phyloxml.phylogenydata.DomainArchitectureParser;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.io.parsers.phyloxml.phylogenydata.UriParser;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Uri;

public class SequenceParser
implements PhylogenyDataPhyloXmlParser {
    private static final PhylogenyDataPhyloXmlParser _instance;

    private SequenceParser() {
    }

    public Sequence parse(XmlElement xmlElement) throws PhylogenyParserException {
        Sequence sequence = new Sequence();
        if (xmlElement.isHasAttribute("type")) {
            sequence.setType(xmlElement.getAttribute("type"));
        }
        if (xmlElement.isHasAttribute("id_source")) {
            sequence.setSourceId(xmlElement.getAttribute("id_source"));
        }
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            if (xmlElement2.getQualifiedName().equals("location")) {
                sequence.setLocation(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("name")) {
                sequence.setName(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("mol_seq")) {
                sequence.setMolecularSequence(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("accession")) {
                sequence.setAccession((Accession)AccessionParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("symbol")) {
                sequence.setSymbol(xmlElement2.getValueAsString());
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("annotation")) {
                sequence.addAnnotation((Annotation)AnnotationParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (xmlElement2.getQualifiedName().equals("domain_architecture")) {
                sequence.setDomainArchitecture((DomainArchitecture)DomainArchitectureParser.getInstance().parse(xmlElement2));
                continue;
            }
            if (!xmlElement2.getQualifiedName().equals("uri")) continue;
            sequence.setUri((Uri)UriParser.getInstance().parse(xmlElement2));
        }
        return sequence;
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new SequenceParser();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.getMessage());
        }
    }
}

