/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.phylogenydata;

import java.util.HashMap;
import java.util.Map;
import org.forester.io.parsers.PhylogenyParserException;
import org.forester.io.parsers.phyloxml.PhyloXmlHandler;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.phylogenydata.ConfidenceParser;
import org.forester.io.parsers.phyloxml.phylogenydata.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.SequenceRelation;

public class SequenceRelationParser
implements PhylogenyDataPhyloXmlParser {
    private static final Map<Phylogeny, SequenceRelationParser> _instances = new HashMap<Phylogeny, SequenceRelationParser>();
    private Phylogeny _phylogeny;

    private SequenceRelationParser() {
    }

    public SequenceRelation parse(XmlElement xmlElement) throws PhylogenyParserException {
        Object object;
        SequenceRelation sequenceRelation = new SequenceRelation();
        if (xmlElement.isHasAttribute("type")) {
            object = xmlElement.getAttribute("type");
            sequenceRelation.setType(SequenceRelation.SEQUENCE_RELATION_TYPE.valueOf((String)object));
        }
        if (xmlElement.isHasAttribute("id_ref_0") && this._phylogeny != null && (object = PhyloXmlHandler.getSequenceMapByIdForPhylogeny(this._phylogeny).get(xmlElement.getAttribute("id_ref_0"))) != null) {
            sequenceRelation.setRef0((Sequence)object);
        }
        if (xmlElement.isHasAttribute("id_ref_1") && this._phylogeny != null && (object = PhyloXmlHandler.getSequenceMapByIdForPhylogeny(this._phylogeny).get(xmlElement.getAttribute("id_ref_1"))) != null) {
            sequenceRelation.setRef1((Sequence)object);
        }
        if (xmlElement.isHasAttribute("distance")) {
            sequenceRelation.setDistance(Double.valueOf(xmlElement.getAttribute("distance")));
        }
        for (int i = 0; i < xmlElement.getNumberOfChildElements(); ++i) {
            XmlElement xmlElement2 = xmlElement.getChildElement(i);
            if (!xmlElement2.getQualifiedName().equals("confidence")) continue;
            sequenceRelation.setConfidence((Confidence)ConfidenceParser.getInstance().parse(xmlElement2));
        }
        return sequenceRelation;
    }

    public static PhylogenyDataPhyloXmlParser getInstance(Phylogeny phylogeny) {
        SequenceRelationParser sequenceRelationParser = _instances.get(phylogeny);
        if (sequenceRelationParser == null) {
            sequenceRelationParser = new SequenceRelationParser();
            sequenceRelationParser._phylogeny = phylogeny;
            _instances.put(phylogeny, sequenceRelationParser);
        }
        return sequenceRelationParser;
    }
}

